/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005U4A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u001d\u0001A\u0003%\u0011\u0005C\u0003;\u0001\u0011\u00051\bC\u0003M\u0001\u0011\u00051\bC\u0003R\u0001\u0011\u00051\bC\u0003W\u0001\u0011%q\u000bC\u0003n\u0001\u0011\u00051\bC\u0003p\u0001\u0011\u00051\bC\u0003r\u0001\u0011\u00051\bC\u0003t\u0001\u0011\u00051HA\u000eCe>\\WM]'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feR+7\u000f\u001e\u0006\u0003\u001d=\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003!E\taa]3sm\u0016\u0014(\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005i\u0011!D3ySR,\u0005pY3qi&|g.F\u0001\"!\r\u00113&L\u0007\u0002G)\u0011A%J\u0001\u0007CR|W.[2\u000b\u0005\u0019:\u0013AC2p]\u000e,(O]3oi*\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051\u001a#aD!u_6L7MU3gKJ,gnY3\u0011\u000592dBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u00114#\u0001\u0004=e>|GOP\u0005\u00021%\u0011QgF\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004HA\u0005UQJ|w/\u00192mK*\u0011QgF\u0001\u000fKbLG/\u0012=dKB$\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\u0005a\u0004C\u0001\f>\u0013\tqtC\u0001\u0003V]&$\bF\u0001\u0003A!\t\t%*D\u0001C\u0015\t\u0019E)A\u0002ba&T!!\u0012$\u0002\u000f),\b/\u001b;fe*\u0011q\tS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u0013%A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0006\u001dB\u0011\u0011iT\u0005\u0003!\n\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002#Q,7\u000f^$fiR{\u0007/[2EK2$\u0018\r\u000b\u0002\u0007'B\u0011\u0011\tV\u0005\u0003+\n\u0013A\u0001V3ti\u0006ib.Z<N_\u000e\\G)\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'\u000fF\u0002Y7\u0006\u0004\"AH-\n\u0005ik!A\u0006#z]\u0006l\u0017nY\"p]\u001aLw\rU;cY&\u001c\b.\u001a:\t\u000bq;\u0001\u0019A/\u0002\r\t\u0014xn[3s!\tqv,D\u0001\u0010\u0013\t\u0001wB\u0001\u0007Ce>\\WM]*feZ,'\u000fC\u0003c\u000f\u0001\u00071-\u0001\u0007feJ|'\u000fS1oI2,'\u000f\u0005\u0002eW6\tQM\u0003\u0002gO\u0006)a-Y;mi*\u0011\u0001\u0003\u001b\u0006\u0003%%T!A\u001b%\u0002\r\u0005\u0004\u0018m\u00195f\u0013\taWM\u0001\u0007GCVdG\u000fS1oI2,'/A\u0015uKN$(+\u001a7pC\u0012,\u0006\u000fZ1uK\u00124\u0015\u000e\\3t/&$\bn\\;u\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003\u0011M\u000b\u0001\u0005^3ti\u0016C8-\u001a9uS>t\u0017J\\+qI\u0006$XmQ8pe\u0012Lg.\u0019;pe\"\u0012\u0011bU\u0001%i\u0016\u001cHOT3x\u00136\fw-\u001a)vg\",G\rV8He>,\boQ8pe\u0012Lg.\u0019;pe\"\u0012!bU\u0001Ji\u0016\u001cH/T3uC\u0012\fG/\u0019,feNLwN\\+qI\u0006$X\rV8J\u0005B{6gX\u001c`\u0013Z\u0013tJ]!c_Z,GK]5hO\u0016\u00148O\u0011:pW\u0016\u0014(+\u001a*fO&\u001cHO]1uS>t\u0007FA\u0006T\u0001")
public class BrokerMetadataPublisherTest {
    private final AtomicReference<Throwable> exitException = new AtomicReference<Object>(null);

    public AtomicReference<Throwable> exitException() {
        return this.exitException;
    }

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((code, x$1) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Exit ").append(code).toString())));
        Exit.setHaltProcedure((code, x$2) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Halt ").append(code).toString())));
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        Throwable exception = this.exitException().get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable)() -> "Expected to see delta for changed topic");
    }

    private DynamicConfigPublisher newMockDynamicConfigPublisher(BrokerServer broker, FaultHandler errorHandler) {
        return (DynamicConfigPublisher)Mockito.spy((Object)new DynamicConfigPublisher(broker.config(), errorHandler, broker.dynamicConfigHandlers().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), "broker"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            DynamicConfigPublisher publisher = this.newMockDynamicConfigPublisher(broker, (FaultHandler)cluster.nonFatalFaultHandler());
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.brokerMetadataPublisher().dynamicConfigPublisher_$eq(publisher);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"numTimesConfigured never reached desired value");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)"numTimesConfigured never reached desired value");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExceptionInUpdateCoordinator() {
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV1).build()).build();
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$1(broker);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        Object var19_7 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var7_4 = null;
            Object var12_9 = null;
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)broker.brokerMetadataPublisher());
            ((BrokerMetadataPublisher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("injected failure")}).when((Object)publisher)).updateCoordinator((MetadataImage)ArgumentMatchers.any(), (MetadataDelta)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any());
            broker.sharedServer().loader().removeAndClosePublisher((MetadataPublisher)broker.brokerMetadataPublisher()).get(1L, TimeUnit.MINUTES);
            broker.metadataPublishers().remove(broker.brokerMetadataPublisher());
            broker.sharedServer().loader().installPublishers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)publisher, (List)Nil$.MODULE$)).asJava()).get(1L, TimeUnit.MINUTES);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)1))).all().get();
            }
            long l3 = 60000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            long l4 = 1L;
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$2(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                        Object var20_19 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l4);
                    l4 += package$.MODULE$.min(l4, 1000L);
                    continue;
                }
                break;
            }
            Object var13_14 = null;
            Object var18_18 = null;
        }
        finally {
            cluster.nonFatalFaultHandler().setIgnore(true);
            cluster.close();
        }
    }

    @Test
    public void testNewImagePushedToGroupCoordinator() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        FaultHandler faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        BrokerMetadataPublisher metadataPublisher = new BrokerMetadataPublisher(config, metadataCache, logManager, replicaManager, groupCoordinator, (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class), (DynamicConfigPublisher)Mockito.mock(DynamicConfigPublisher.class), (DynamicClientQuotaPublisher)Mockito.mock(DynamicClientQuotaPublisher.class), (ScramPublisher)Mockito.mock(ScramPublisher.class), (DelegationTokenPublisher)Mockito.mock(DelegationTokenPublisher.class), (AclPublisher)Mockito.mock(AclPublisher.class), faultHandler, faultHandler, (BrokerLifecycleManager)Mockito.mock(BrokerLifecycleManager.class));
        MetadataImage image = MetadataImage.EMPTY;
        MetadataDelta delta = new MetadataDelta.Builder().setImage(image).build();
        metadataPublisher.onMetadataUpdate(delta, image, (LoaderManifest)new LogDeltaManifest.Builder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(100L).numBytes(42L).build());
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).onNewMetadataImage(image, delta);
    }

    @Test
    public void testMetadataVersionUpdateToIBP_3_7_IV2OrAboveTriggersBrokerReRegistration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        FaultHandler faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        BrokerLifecycleManager brokerLifecycleManager = (BrokerLifecycleManager)Mockito.mock(BrokerLifecycleManager.class);
        BrokerMetadataPublisher metadataPublisher = new BrokerMetadataPublisher(config, metadataCache, logManager, replicaManager, groupCoordinator, (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class), (DynamicConfigPublisher)Mockito.mock(DynamicConfigPublisher.class), (DynamicClientQuotaPublisher)Mockito.mock(DynamicClientQuotaPublisher.class), (ScramPublisher)Mockito.mock(ScramPublisher.class), (DelegationTokenPublisher)Mockito.mock(DelegationTokenPublisher.class), (AclPublisher)Mockito.mock(AclPublisher.class), faultHandler, faultHandler, brokerLifecycleManager);
        MetadataImage image = MetadataImage.EMPTY;
        MetadataDelta delta = new MetadataDelta.Builder().setImage(image).build();
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_6_IV2.featureLevel()));
        MetadataImage newImage = delta.apply(new MetadataProvenance(100L, 4, 2000L));
        metadataPublisher.onMetadataUpdate(delta, newImage, (LoaderManifest)new LogDeltaManifest.Builder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(100L).numBytes(42L).build());
        Mockito.verifyNoInteractions((Object[])new Object[]{brokerLifecycleManager});
        image = newImage;
        delta = new MetadataDelta.Builder().setImage(image).build();
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV2.featureLevel()));
        newImage = delta.apply(new MetadataProvenance(100L, 4, 2000L));
        metadataPublisher.onMetadataUpdate(delta, newImage, (LoaderManifest)new LogDeltaManifest.Builder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(100L).numBytes(42L).build());
        ((BrokerLifecycleManager)Mockito.verify((Object)brokerLifecycleManager, (VerificationMode)Mockito.times((int)1))).handleKraftJBODMetadataVersionUpdate();
        Mockito.clearInvocations((Object[])new BrokerLifecycleManager[]{brokerLifecycleManager});
        image = newImage;
        delta = new MetadataDelta.Builder().setImage(image).build();
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_8_IV0.featureLevel()));
        newImage = delta.apply(new MetadataProvenance(200L, 4, 3000L));
        metadataPublisher.onMetadataUpdate(delta, newImage, (LoaderManifest)new LogDeltaManifest.Builder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(100L).numBytes(42L).build());
        ((BrokerLifecycleManager)Mockito.verify((Object)brokerLifecycleManager, (VerificationMode)Mockito.times((int)0))).handleKraftJBODMetadataVersionUpdate();
        metadataPublisher.close();
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$1(BrokerServer broker$1) {
        Assertions.assertNotNull((Object)broker$1.brokerMetadataPublisher());
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$2(KafkaClusterTestKit cluster$1) {
        Assertions.assertTrue((boolean)((String)Option$.MODULE$.apply((Object)cluster$1.nonFatalFaultHandler().firstException()).flatMap((Function1 & Serializable)e -> Option$.MODULE$.apply((Object)e.getMessage())).getOrElse((Function0 & Serializable)() -> "(none)")).contains("injected failure"));
    }
}

