/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\b\u0011\u0001UAQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\nW\u0001\u0001\r\u00111A\u0005\u00021B\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001e\t\u0013\r\u0003\u0001\u0019!A!B\u0013i\u0003\"\u0002#\u0001\t\u0003*\u0005\"\u0002,\u0001\t\u0003:\u0006\"\u0002/\u0001\t\u0003i\u0006bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aa!!\u000f\u0001\t\u00039\u0006bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0002\u001b\u0019&\u001cHo\u00144gg\u0016$8/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003#I\tQ!\u00193nS:T\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a%\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\tY\u0002D\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001#A\u0005u_BL7MT1nKV\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!A.\u00198h\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\rM#(/\u001b8h\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/F\u0001.!\tqs'D\u00010\u0015\t\t\u0002G\u0003\u00022e\u000591\r\\5f]R\u001c(BA\n4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005az#!B!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$\u0001B+oSRDqAQ\u0003\u0002\u0002\u0003\u0007Q&A\u0002yIE\nA\"\u00193nS:\u001cE.[3oi\u0002\nQa]3u+B$\"a\u000f$\t\u000b\u001d;\u0001\u0019\u0001%\u0002\u0011Q,7\u000f^%oM>\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0007\u0005\u0004\u0018N\u0003\u0002N\u001d\u00069!.\u001e9ji\u0016\u0014(BA(6\u0003\u0015QWO\\5u\u0013\t\t&J\u0001\u0005UKN$\u0018J\u001c4pQ\t91\u000b\u0005\u0002J)&\u0011QK\u0013\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003mB#\u0001C-\u0011\u0005%S\u0016BA.K\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nuKN$X)\u0019:mS\u0016\u001cHo\u00144gg\u0016$HCA\u001e_\u0011\u0015y\u0016\u00021\u0001a\u0003\u0019\tXo\u001c:v[B\u0011\u0011\r\u001b\b\u0003E\u001a\u0004\"aY\u001f\u000e\u0003\u0011T!!\u001a\u000b\u0002\rq\u0012xn\u001c;?\u0013\t9W(\u0001\u0004Qe\u0016$WMZ\u0005\u0003S%T!aZ\u001f)\t%Y\u0017O\u001d\t\u0003Y>l\u0011!\u001c\u0006\u0003]2\u000ba\u0001]1sC6\u001c\u0018B\u00019n\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001t\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\"\"\u0011\"^>}!\t1\u00180D\u0001x\u0015\tAX.\u0001\u0005qe>4\u0018\u000eZ3s\u0013\tQxOA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003{~\f\u0013A`\u0001\u0003u.\f#!!\u0001\u0002\u000b-\u0014\u0018M\u001a;\u0002!Q,7\u000f\u001e'bi\u0016\u001cHo\u00144gg\u0016$HcA\u001e\u0002\b!)qL\u0003a\u0001A\"\"!b[9sQ\u0015QQo_A\u0007Y\tix0\u0001\fuKN$X*\u0019=US6,7\u000f^1na>3gm]3u)\rY\u00141\u0003\u0005\u0006?.\u0001\r\u0001\u0019\u0015\u0005\u0017-\f(\u000fK\u0003\fkn\fI\u0002\f\u0002~\u007f\u0006y!/\u001e8GKR\u001c\u0007n\u00144gg\u0016$8\u000f\u0006\u0004\u0002 \u00055\u0012q\u0006\t\u0005\u0003C\t9CD\u0002/\u0003GI1!!\n0\u0003Ea\u0015n\u001d;PM\u001a\u001cX\r^:SKN,H\u000e^\u0005\u0005\u0003S\tYCA\u000bMSN$xJ\u001a4tKR\u001c(+Z:vYRLeNZ8\u000b\u0007\u0005\u0015r\u0006C\u0003,\u0019\u0001\u0007Q\u0006C\u0004\u000221\u0001\r!a\r\u0002\u0015=4gm]3u'B,7\rE\u0002/\u0003kI1!a\u000e0\u0005)yeMZ:fiN\u0003XmY\u0001\u0010aJ|G-^2f\u001b\u0016\u001c8/Y4fg\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0002@A1\u0011\u0011IA$\u0003\u0017j!!a\u0011\u000b\u0007\u0005\u0015S(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0013\u0002D\t\u00191+Z9\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015\u0013\u0003\u0019\u0019XM\u001d<fe&!\u0011QKA(\u0005-Y\u0015MZ6b\u0007>tg-[4")
public class ListOffsetsIntegrationTest
extends KafkaServerTestHarness {
    private final String topicName;
    private Admin adminClient;

    public String topicName() {
        return this.topicName;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topicName(), 1, (short)1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.produceMessages();
        this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEarliestOffset(String quorum) {
        ListOffsetsResult.ListOffsetsResultInfo earliestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.EarliestSpec());
        Assertions.assertEquals((long)0L, (long)earliestOffset.offset());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLatestOffset(String quorum) {
        ListOffsetsResult.ListOffsetsResultInfo latestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.LatestSpec());
        Assertions.assertEquals((long)3L, (long)latestOffset.offset());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMaxTimestampOffset(String quorum) {
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.MaxTimestampSpec());
        Assertions.assertEquals((long)1L, (long)maxTimestampOffset.offset());
    }

    private ListOffsetsResult.ListOffsetsResultInfo runFetchOffsets(Admin adminClient, OffsetSpec offsetSpec) {
        TopicPartition tp = new TopicPartition(this.topicName(), 0);
        return (ListOffsetsResult.ListOffsetsResultInfo)((java.util.Map)adminClient.listOffsets(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetSpec)}))).asJava(), new ListOffsetsOptions()).all().get()).get(tp);
    }

    public void produceMessages() {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10000]), (List)new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10000]), (List)new .colon.colon((Object)new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10000]), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.produceMessages(this.brokers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    public ListOffsetsIntegrationTest() {
        this.topicName = "foo";
    }
}

