/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FinalizedFeatureChangeListener;
import kafka.server.FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$;
import kafka.server.QuorumTestHarness;
import kafka.server.metadata.ZkMetadataCache;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UB\u0011b\u000e\u0001A\u0002\u0003\u0007I\u0011\u0001\u001d\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0003i\u0004\"\u0003$\u0001\u0001\u0004\u0005\t\u0015)\u0003:\r\u00119\u0005\u0001\u0011%\t\u0011m+!Q3A\u0005\u0002qC\u0001b[\u0003\u0003\u0012\u0003\u0006I!\u0018\u0005\tY\u0016\u0011)\u001a!C\u0001[\"A\u0011/\u0002B\tB\u0003%a\u000eC\u00035\u000b\u0011\u0005!\u000fC\u0003x\u000b\u0011\u0005\u0003\u0010C\u0004z\u000b\u0005\u0005I\u0011\u0001>\t\u000fu,\u0011\u0013!C\u0001}\"I\u00111C\u0003\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u00033)\u0011\u0011!C!\u00037A\u0011\"a\u000b\u0006\u0003\u0003%\t!!\f\t\u0013\u0005UR!!A\u0005\u0002\u0005]\u0002\"CA!\u000b\u0005\u0005I\u0011IA\"\u0011%\t\t&BA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002^\u0015\t\t\u0011\"\u0011\u0002`!I\u00111M\u0003\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003O*\u0011\u0011!C!\u0003S:\u0011\"!\u001c\u0001\u0003\u0003E\t!a\u001c\u0007\u0011\u001d\u0003\u0011\u0011!E\u0001\u0003cBa\u0001\u000e\r\u0005\u0002\u0005%\u0005\u0002C<\u0019\u0003\u0003%)%a#\t\u0013\u00055\u0005$!A\u0005\u0002\u0006=\u0005\"CAK1\u0005\u0005I\u0011QAL\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a0\u0001\t\u0013\t\t\rC\u0004\u0002J\u0002!I!a3\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bb\u0002B\u0003\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u001f\u0001A\u0011AAu\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003SDqAa\u0006\u0001\t\u0003\tI\u000fC\u0004\u0003\u001c\u0001!\t!!;\t\u000f\t}\u0001\u0001\"\u0001\u0002j\"9!1\u0005\u0001\u0005\u0002\u0005%(A\t$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:f\u0007\"\fgnZ3MSN$XM\\3s)\u0016\u001cHO\u0003\u0002,Y\u000511/\u001a:wKJT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022e5\t!&\u0003\u00024U\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00051\u0004CA\u0019\u0001\u0003!a\u0017n\u001d;f]\u0016\u0014X#A\u001d\u0011\u0005ER\u0014BA\u001e+\u0005y1\u0015N\\1mSj,GMR3biV\u0014Xm\u00115b]\u001e,G*[:uK:,'/\u0001\u0007mSN$XM\\3s?\u0012*\u0017\u000f\u0006\u0002?\tB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n!QK\\5u\u0011\u001d)5!!AA\u0002e\n1\u0001\u001f\u00132\u0003%a\u0017n\u001d;f]\u0016\u0014\bEA\rGS:\fG.\u001b>fI\u001a+\u0017\r^;sKN\fe\u000eZ#q_\u000eD7\u0003B\u0003J\u0019>\u0003\"a\u0010&\n\u0005-\u0003%AB!osJ+g\r\u0005\u0002@\u001b&\u0011a\n\u0011\u0002\b!J|G-^2u!\t\u0001\u0006L\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011AKL\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!a\u0016!\u0002\u000fA\f7m[1hK&\u0011\u0011L\u0017\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003/\u0002\u000b\u0001BZ3biV\u0014Xm]\u000b\u0002;B!aLY3i\u001d\ty\u0006\r\u0005\u0002S\u0001&\u0011\u0011\rQ\u0001\u0007!J,G-\u001a4\n\u0005\r$'aA'ba*\u0011\u0011\r\u0011\t\u0003=\u001aL!a\u001a3\u0003\rM#(/\u001b8h!\ty\u0014.\u0003\u0002k\u0001\n)1\u000b[8si\u0006Ia-Z1ukJ,7\u000fI\u0001\u0006KB|7\r[\u000b\u0002]B\u0011qh\\\u0005\u0003a\u0002\u0013A\u0001T8oO\u00061Q\r]8dQ\u0002\"2a];w!\t!X!D\u0001\u0001\u0011\u0015Y&\u00021\u0001^\u0011\u0015a'\u00021\u0001o\u0003!!xn\u0015;sS:<G#A3\u0002\t\r|\u0007/\u001f\u000b\u0004gnd\bbB.\r!\u0003\u0005\r!\u0018\u0005\bY2\u0001\n\u00111\u0001o\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a \u0016\u0004;\u0006\u00051FAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055\u0001)\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0003\u0016\u0004]\u0006\u0005\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00027b]\u001eT!!a\n\u0002\t)\fg/Y\u0005\u0004O\u0006\u0005\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0018!\ry\u0014\u0011G\u0005\u0004\u0003g\u0001%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001d\u0003\u007f\u00012aPA\u001e\u0013\r\ti\u0004\u0011\u0002\u0004\u0003:L\b\u0002C#\u0012\u0003\u0003\u0005\r!a\f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0012\u0011\r\u0005\u001d\u0013QJA\u001d\u001b\t\tIEC\u0002\u0002L\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty%!\u0013\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\nY\u0006E\u0002@\u0003/J1!!\u0017A\u0005\u001d\u0011un\u001c7fC:D\u0001\"R\n\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001e\u0005\u0005\u0004\u0002C#\u0015\u0003\u0003\u0005\r!a\f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\f\u0002\r\u0015\fX/\u00197t)\u0011\t)&a\u001b\t\u0011\u00153\u0012\u0011!a\u0001\u0003s\t\u0011DR5oC2L'0\u001a3GK\u0006$XO]3t\u0003:$W\t]8dQB\u0011A\u000fG\n\u00061\u0005M\u0014q\u0010\t\b\u0003k\nY(\u00188t\u001b\t\t9HC\u0002\u0002z\u0001\u000bqA];oi&lW-\u0003\u0003\u0002~\u0005]$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011QAD\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u0015\u0012AA5p\u0013\rI\u00161\u0011\u000b\u0003\u0003_\"\"!!\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bM\f\t*a%\t\u000bm[\u0002\u0019A/\t\u000b1\\\u0002\u0019\u00018\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011TAS!\u0015y\u00141TAP\u0013\r\ti\n\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b}\n\t+\u00188\n\u0007\u0005\r\u0006I\u0001\u0004UkBdWM\r\u0005\t\u0003Oc\u0012\u0011!a\u0001g\u0006\u0019\u0001\u0010\n\u0019\u0002\r\u0005\u001c(*\u0019<b)\u0011\ti+a/\u0011\u000f\u0005=\u0016QW3\u000286\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b)#\u0001\u0003vi&d\u0017bA2\u00022B!\u0011qDA]\u0013\rQ\u0017\u0011\u0005\u0005\u0007\u0003{k\u0002\u0019A/\u0002\u000b%t\u0007/\u001e;\u0002)\r\u0014X-\u0019;f\u0005J|7.\u001a:GK\u0006$XO]3t)\t\t\u0019\rE\u00022\u0003\u000bL1!a2+\u00059\u0011%o\\6fe\u001a+\u0017\r^;sKN\fqc\u0019:fCR,g)\u001b8bY&TX\r\u001a$fCR,(/Z:\u0015\u0003M\fab\u0019:fCR,G*[:uK:,'\u000fF\u0003:\u0003#\f\t\u000fC\u0004\u0002T\u0002\u0002\r!!6\u0002\u000b\r\f7\r[3\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7+\u0003!iW\r^1eCR\f\u0017\u0002BAp\u00033\u0014qBW6NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\b\u0003G\u0004\u0003\u0019AAs\u0003Q)\u0007\u0010]3di\u0016$7)Y2iK\u000e{g\u000e^3oiB!q(a't\u00031!Xm\u001d;UK\u0006\u0014Hi\\<o)\u0005q\u0004fA\u0011\u0002nB!\u0011q\u001eB\u0001\u001b\t\t\tP\u0003\u0003\u0002t\u0006U\u0018aA1qS*!\u0011q_A}\u0003\u001dQW\u000f]5uKJTA!a?\u0002~\u0006)!.\u001e8ji*\u0011\u0011q`\u0001\u0004_J<\u0017\u0002\u0002B\u0002\u0003c\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002KQ,7\u000f^%oSR\u001cVoY2fgN\fe\u000e\u001a(pi&4\u0017nY1uS>t7+^2dKN\u001c\bf\u0001\u0012\u0003\nA!\u0011q\u001eB\u0006\u0013\u0011\u0011i!!=\u0003\tQ+7\u000f^\u0001-i\u0016\u001cHOR3biV\u0014XM\u0017(pI\u0016$U\r\\3uK:{G/\u001b4jG\u0006$\u0018n\u001c8Qe>\u001cWm]:j]\u001eD3a\tB\u0005\u0003=\"Xm\u001d;GK\u0006$XO]3[\u001d>$W\rR5tC\nd\u0017N\\4O_RLg-[2bi&|g\u000e\u0015:pG\u0016\u001c8/\u001b8hQ\r!#\u0011B\u0001.i\u0016\u001cHoQ1dQ\u0016,\u0006\u000fZ1uK^\u000b\u0017\u000e\u001e$bS2\u001chi\u001c:V]J,\u0017m\u00195bE2,g+\u001a:tS>t\u0007fA\u0013\u0003\n\u0005QC/Z:u\u0013:LGOR1jYV\u0014X\rR;f)>4U-\u0019;ve\u0016LenY8na\u0006$\u0018NY5mSRL\bf\u0001\u0014\u0003\n\u0005\u0019C/Z:u\u0013:LGOR1jYV\u0014X\rR;f)>LeN^1mS\u0012<\u0016-\u001b;US6,\u0007fA\u0014\u0003\n\u0005\u0011D/Z:u\u001d>$\u0018NZ5dCRLwN\u001c$bS2,(/\u001a#vKR{g)Z1ukJ,\u0017J\\2p[B\fG/\u001b2jY&$\u0018\u0010K\u0002)\u0005\u0013\u0001")
public class FinalizedFeatureChangeListenerTest
extends QuorumTestHarness {
    private volatile FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$ FinalizedFeaturesAndEpoch$module;
    private FinalizedFeatureChangeListener listener;

    public FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$ FinalizedFeaturesAndEpoch() {
        if (this.FinalizedFeaturesAndEpoch$module == null) {
            this.FinalizedFeaturesAndEpoch$lzycompute$1();
        }
        return this.FinalizedFeaturesAndEpoch$module;
    }

    public FinalizedFeatureChangeListener listener() {
        return this.listener;
    }

    public void listener_$eq(FinalizedFeatureChangeListener x$1) {
        this.listener = x$1;
    }

    public java.util.Map<String, Short> asJava(scala.collection.immutable.Map<String, Object> input) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)input.map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)((Short)kv._2())))).asJava();
    }

    private BrokerFeatures createBrokerFeatures() {
        scala.collection.immutable.Map supportedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)new SupportedVersionRange(1, 3))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault(true);
        brokerFeatures.setSupportedFeatures(org.apache.kafka.common.feature.Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)supportedFeaturesMap).asJava()));
        return brokerFeatures;
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeaturesAndEpoch createFinalizedFeatures() {
        void var3_3;
        scala.collection.immutable.Map finalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)3))}));
        this.zkClient().createFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)finalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var3_3.isEmpty());
        return new FinalizedFeaturesAndEpoch(this, (scala.collection.immutable.Map<String, Object>)finalizedFeaturesMap, n);
    }

    private FinalizedFeatureChangeListener createListener(ZkMetadataCache cache, Option<FinalizedFeaturesAndEpoch> expectedCacheContent) {
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assertions.assertFalse((boolean)listener.isListenerInitiated());
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        listener.initOrThrow(15000L);
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
        if (expectedCacheContent.isDefined()) {
            Option mayBeNewCacheContent = cache.getFeatureOption();
            Assertions.assertFalse((boolean)mayBeNewCacheContent.isEmpty());
            Features newCacheContent = (Features)mayBeNewCacheContent.get();
            Assertions.assertEquals(this.asJava(((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).features()), (Object)newCacheContent.finalizedFeatures());
            Assertions.assertEquals((long)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).epoch(), (long)newCacheContent.finalizedFeaturesEpoch());
        } else {
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        }
        return listener;
    }

    @AfterEach
    public void testTearDown() {
        if (this.listener() != null) {
            this.listener().close();
            return;
        }
    }

    @Test
    public void testInitSuccessAndNotificationSuccess() {
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false);
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        this.updateAndCheckCache$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4))})), initialFinalizedFeatures, cache);
        this.updateAndCheckCache$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)BoxesRunTime.boxToShort((short)3))})), initialFinalizedFeatures, cache);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDeleteNotificationProcessing() {
        void var5_5;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        this.zkClient().deleteFeatureZNode();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeDeletedBytes = (Option)tuple2._1();
        Assertions.assertEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertTrue((boolean)var5_5.isEmpty());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FinalizedFeatureChangeListenerTest.$anonfun$testFeatureZNodeDeleteNotificationProcessing$1(cache)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for FinalizedFeatureCache to become empty");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.listener().isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDisablingNotificationProcessing() {
        void var6_6;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, (Map)updatedFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheUpdateWaitFailsForUnreachableVersion() {
        void var5_5;
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, this.createBrokerFeatures(), (Seq)Seq$.MODULE$.empty(), false);
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilFeatureEpochOrThrow(initialFinalizedFeatures.epoch() + 1L, 15000L));
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, (Map)updatedFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilFeatureEpochOrThrow((long)n, 15000L));
        Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        Assertions.assertTrue((boolean)this.listener().isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitFailureDueToFeatureIncompatibility() {
        void var5_5;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false);
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)5))}));
        this.zkClient().createFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)incompatibleFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        Assertions.assertNotEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$8, x$9) -> exitLatch.countDown());
        try {
            this.listener_$eq(new FinalizedFeatureChangeListener(cache, this.zkClient()));
            Assertions.assertFalse((boolean)this.listener().isListenerInitiated());
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
            Assertions.assertThrows(TimeoutException.class, () -> this.listener().initOrThrow(5000L));
            exitLatch.await();
            Assertions.assertFalse((boolean)this.listener().isListenerInitiated());
            Assertions.assertTrue((boolean)this.listener().isListenerDead());
            Assertions.assertTrue((boolean)cache.getFeatureOption().isEmpty());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testInitFailureDueToInvalidWaitTime() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false);
        this.listener_$eq(new FinalizedFeatureChangeListener(cache, this.zkClient()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.listener().initOrThrow(0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.listener().initOrThrow(-1L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotificationFailureDueToFeatureIncompatibility() {
        void var7_7;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        ZkMetadataCache cache = new ZkMetadataCache(1, MetadataVersion.IBP_2_8_IV1, brokerFeatures, (Seq)Seq$.MODULE$.empty(), false);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        this.listener_$eq(this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures)));
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$10, x$11) -> exitLatch.countDown());
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)BoxesRunTime.boxToShort((short)((short)(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).max() + 1))))}));
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)incompatibleFinalizedFeaturesMap));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeIncompatibleBytes = (Option)tuple2._1();
        Assertions.assertNotEquals((int)tuple2._2$mcI$sp(), (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var7_7.isEmpty());
        try {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$2(this, exitLatch, cache, initialFinalizedFeatures)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for listener death and FinalizedFeatureCache to be updated");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private final void FinalizedFeaturesAndEpoch$lzycompute$1() {
        synchronized (this) {
            if (this.FinalizedFeaturesAndEpoch$module == null) {
                this.FinalizedFeaturesAndEpoch$module = new FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAndCheckCache$1(scala.collection.immutable.Map finalizedFeatures, FinalizedFeaturesAndEpoch initialFinalizedFeatures$1, ZkMetadataCache cache$1) {
        void var5_5;
        this.zkClient().updateFeatureZNode(FeatureZNode$.MODULE$.apply(MetadataVersion.IBP_3_2_IV0, (FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, (Map)finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var5_5.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures$1.epoch() ? 1 : 0) != 0);
        cache$1.waitUntilFeatureEpochOrThrow((long)n, 15000L);
        Assertions.assertEquals((Object)new Features(MetadataVersion.IBP_2_8_IV1, this.asJava((scala.collection.immutable.Map<String, Object>)finalizedFeatures), (long)n, false), (Object)cache$1.getFeatureOption().get());
        Assertions.assertTrue((boolean)this.listener().isListenerInitiated());
    }

    public static final /* synthetic */ boolean $anonfun$testFeatureZNodeDeleteNotificationProcessing$1(ZkMetadataCache cache$2) {
        return cache$2.getFeatureOption().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testFeatureZNodeDeleteNotificationProcessing$2() {
        return "Timed out waiting for FinalizedFeatureCache to become empty";
    }

    public static final /* synthetic */ boolean $anonfun$testNotificationFailureDueToFeatureIncompatibility$2(FinalizedFeatureChangeListenerTest $this, CountDownLatch exitLatch$2, ZkMetadataCache cache$4, FinalizedFeaturesAndEpoch initialFinalizedFeatures$3) {
        return exitLatch$2.getCount() == 0L && !$this.listener().isListenerInitiated() && $this.listener().isListenerDead() && ((Features)cache$4.getFeatureOption().get()).equals((Object)new Features(MetadataVersion.IBP_2_8_IV1, $this.asJava(initialFinalizedFeatures$3.features()), initialFinalizedFeatures$3.epoch(), false));
    }

    public static final /* synthetic */ String $anonfun$testNotificationFailureDueToFeatureIncompatibility$3() {
        return "Timed out waiting for listener death and FinalizedFeatureCache to be updated";
    }

    public class FinalizedFeaturesAndEpoch
    implements Product,
    Serializable {
        private final scala.collection.immutable.Map<String, Object> features;
        private final long epoch;
        public final /* synthetic */ FinalizedFeatureChangeListenerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Map<String, Object> features() {
            return this.features;
        }

        public long epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(44).append("FinalizedFeaturesAndEpoch(features=").append(this.features()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FinalizedFeaturesAndEpoch copy(scala.collection.immutable.Map<String, Object> features, long epoch) {
            return new FinalizedFeaturesAndEpoch(this.kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer(), features, epoch);
        }

        public scala.collection.immutable.Map<String, Object> copy$default$1() {
            return this.features();
        }

        public long copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FinalizedFeaturesAndEpoch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.features();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FinalizedFeaturesAndEpoch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "features";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash(this.features())), (int)Statics.longHash((long)this.epoch())), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FinalizedFeaturesAndEpoch && ((FinalizedFeaturesAndEpoch)x$1).kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer() == this.kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer())) break block3;
                    FinalizedFeaturesAndEpoch finalizedFeaturesAndEpoch = (FinalizedFeaturesAndEpoch)x$1;
                    if (this.epoch() != finalizedFeaturesAndEpoch.epoch()) break block3;
                    scala.collection.immutable.Map<String, Object> map = this.features();
                    scala.collection.immutable.Map<String, Object> map2 = finalizedFeaturesAndEpoch.features();
                    if ((map != null ? !map.equals(map2) : map2 != null) || !finalizedFeaturesAndEpoch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ FinalizedFeatureChangeListenerTest kafka$server$FinalizedFeatureChangeListenerTest$FinalizedFeaturesAndEpoch$$$outer() {
            return this.$outer;
        }

        public FinalizedFeaturesAndEpoch(FinalizedFeatureChangeListenerTest $outer, scala.collection.immutable.Map<String, Object> features, long epoch) {
            this.features = features;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

