/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t-h!B\u001f?\u0003\u0003\u0019\u0005\"\u0002)\u0001\t\u0003\t\u0006b\u0002+\u0001\u0005\u0004%\t!\u0016\u0005\u00073\u0002\u0001\u000b\u0011\u0002,\t\u000fi\u0003!\u0019!C\u0001+\"11\f\u0001Q\u0001\nYCq\u0001\u0018\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004^\u0001\u0001\u0006IA\u0016\u0005\u0006=\u0002!\tb\u0018\u0005\bM\u0002\u0011\r\u0011\"\u0005h\u0011\u00199\b\u0001)A\u0005Q\")\u0001\u0010\u0001C\ts\"9\u0011\u0011\u0003\u0001\u0005\u0012\u0005M\u0001bCA\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0003GA1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<!Y\u0011q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0013\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\ti\u0005C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0001\u0002^!A\u0011\u0011\u000f\u0001!\u0002\u0013\ty\u0006C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005]\u0004\u0001\"\u0001\u0002v!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005U\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\t9\n\u0001C\u0001\u0003+Cq!!'\u0001\t\u0013\tY\nC\u0004\u0002$\u0002!I!!*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAd\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u0019\t\u0019\u000e\u0001C\u0001+\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAx\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003c\u0004A\u0011AAz\u0011\u001d\tY\u0010\u0001C\u0001\u0003{D\u0011B!\u0001\u0001\u0005\u0004%\tAa\u0001\t\u0011\t-\u0001\u0001)A\u0005\u0005\u000bA\u0011B!\u0004\u0001\u0005\u0004%\tAa\u0004\t\u0011\tu\u0001\u0001)A\u0005\u0005#AqAa\b\u0001\t\u0003\u0011\t\u0003C\u0004\u0003.\u0001!\tAa\f\t\u0013\te\u0003!%A\u0005\u0002\tm\u0003\"\u0003B9\u0001E\u0005I\u0011\u0001B:\u0011%\u00119\bAI\u0001\n\u0003\u0011I\bC\u0004\u0003~\u0001!\t!!&\t\u000f\t}\u0004\u0001\"\u0001\u0002\u0016\"9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BG\u0001\u0011%!q\u0012\u0005\b\u0005'\u0003A\u0011BAN\u0011\u001d\u0011)\n\u0001C\u0001\u0003+CqAa(\u0001\t\u0003\u0011\tkB\u0004\u0003@zB\tA!1\u0007\rur\u0004\u0012\u0001Bb\u0011\u0019\u0001v\u0007\"\u0001\u0003F\"I!qY\u001cC\u0002\u0013\u0005!\u0011\u001a\u0005\t\u0005+<\u0004\u0015!\u0003\u0003L\"9!q[\u001c\u0005\u0002\u0005U\u0005b\u0002Bqo\u0011\u0005\u0011Q\u0013\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c(BA A\u0003\u0019\u0019XM\u001d<fe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001!%\n\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u0002\u000bQ!\u001e;jYNL!a\u0014'\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u0015\t\u0003'\u0002i\u0011AP\u0001\u0014u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^\u000b\u0002-B\u0011QiV\u0005\u00031\u001a\u00131!\u00138u\u0003QQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;uA\u0005\u0001\"p[*fgNLwN\u001c+j[\u0016|W\u000f^\u0001\u0012u.\u001cVm]:j_:$\u0016.\\3pkR\u0004\u0013!\u0006>l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo]\u0001\u0017u.l\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;tA\u0005i!p[!dYN,e.\u00192mK\u0012,\u0012\u0001\u0019\t\u0004\u000b\u0006\u001c\u0017B\u00012G\u0005\u0019y\u0005\u000f^5p]B\u0011Q\tZ\u0005\u0003K\u001a\u0013qAQ8pY\u0016\fg.\u0001\u0012d_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002QB\u0011\u0011.^\u0007\u0002U*\u00111\u000e\\\u0001\u0005CV$\bN\u0003\u0002n]\u0006A1/Z2ve&$\u0018P\u0003\u0002pa\u000611m\\7n_:T!!Q9\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m*\u0014\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002G\r|g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM]*fGV\u0014\u0018\u000e^=Qe>$xnY8mA\u000512N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000fF\u0001{!\u0011Yh0!\u0001\u000e\u0003qT!! $\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\u0000y\n\u00191+Z9\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!Q\u000f^5m\u0015\t\tY!\u0001\u0003kCZ\f\u0017\u0002BA\b\u0003\u000b\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003=iW\r^1eCR\fg+\u001a:tS>tWCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bA8\u0002\u001c)\u0011q\b]\u0005\u0005\u0003?\tIBA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003!!Xm\u001d;J]\u001a|WCAA\u0013!\u0011\t9#!\u000e\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t1!\u00199j\u0015\u0011\ty#!\r\u0002\u000f),\b/\u001b;fe*\u0019\u00111G:\u0002\u000b),h.\u001b;\n\t\u0005]\u0012\u0011\u0006\u0002\t)\u0016\u001cH/\u00138g_\u0006aA/Z:u\u0013:4wn\u0018\u0013fcR!\u0011QHA\"!\r)\u0015qH\u0005\u0004\u0003\u00032%\u0001B+oSRD\u0011\"!\u0012\u000f\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013'A\u0005uKN$\u0018J\u001c4pA\u0005q\u0011.\u001c9mK6,g\u000e^1uS>tWCAA'!\r\u0019\u0016qJ\u0005\u0004\u0003#r$\u0001F)v_J,X.S7qY\u0016lWM\u001c;bi&|g.\u0001\nj[BdW-\\3oi\u0006$\u0018n\u001c8`I\u0015\fH\u0003BA\u001f\u0003/B\u0011\"!\u0012\u0012\u0003\u0003\u0005\r!!\u0014\u0002\u001f%l\u0007\u000f\\3nK:$\u0018\r^5p]\u0002\n\u0001CY8piN$(/\u00199SK\u000e|'\u000fZ:\u0016\u0005\u0005}\u0003CBA1\u0003O\nY'\u0004\u0002\u0002d)\u0019\u0011Q\r?\u0002\u000f5,H/\u00192mK&!\u0011\u0011NA2\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0005\u0003/\ti'\u0003\u0003\u0002p\u0005e!\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.A\tc_>$8\u000f\u001e:baJ+7m\u001c:eg\u0002\n1\"[:L%\u00064G\u000fV3tiR\t1-A\tjgj[W*[4sCRLwN\u001c+fgR\fA$[:OK^<%o\\;q\u0007>|'\u000fZ5oCR|'/\u00128bE2,G-A\u000enCf\u0014Wm\u0012:pkB\u0004&o\u001c;pG>d7\u000b]3dS\u001aLW\r\u001a\u000b\u0005\u0003\u007f\n\t\n\u0005\u0003FC\u0006\u0005\u0005\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\tG>t7/^7fe*\u0019\u00111\u00129\u0002\u000f\rd\u0017.\u001a8ug&!\u0011qRAC\u000559%o\\;q!J|Go\\2pY\"9\u0011\u0011\u0005\rA\u0002\u0005\u0015\u0012!D2iK\u000e\\\u0017j\u001d.L)\u0016\u001cH\u000f\u0006\u0002\u0002>\u0005\u00012\r[3dW&\u001b8JU1giR+7\u000f^\u0001\u0005CNT6\u000e\u0006\u0002\u0002\u001eB\u00191+a(\n\u0007\u0005\u0005fHA\u000f[_>\\U-\u001a9feF+xN];n\u00136\u0004H.Z7f]R\fG/[8o\u0003\u001d\t7o\u0013*bMR$\"!a*\u0011\u0007M\u000bI+C\u0002\u0002,z\u0012\u0011d\u0013*bMR\fVo\u001c:v[&k\u0007\u000f\\3nK:$\u0018\r^5p]\u0006I!p\\8lK\u0016\u0004XM]\u000b\u0003\u0003c\u0003B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003o\u0003\u0015A\u0001>l\u0013\u0011\tY,!.\u0003#\u0015k'-\u001a3eK\u0012Tvn\\6fKB,'/\u0001\u0005{W\u000ec\u0017.\u001a8u+\t\t\t\r\u0005\u0003\u00024\u0006\r\u0017\u0002BAc\u0003k\u0013QbS1gW\u0006T6n\u00117jK:$\u0018A\u0004>l\u00072LWM\u001c;Pe:+H\u000e\\\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0016\u0005\u00055\u0007\u0003BAZ\u0003\u001fLA!!5\u00026\ni\u0011\tZ7j]j[7\t\\5f]R\faA_6Q_J$\u0018!\u0003>l\u0007>tg.Z2u+\t\tI\u000e\u0005\u0003\u0002\\\u0006%h\u0002BAo\u0003K\u00042!a8G\u001b\t\t\tOC\u0002\u0002d\n\u000ba\u0001\u0010:p_Rt\u0014bAAt\r\u00061\u0001K]3eK\u001aLA!a;\u0002n\n11\u000b\u001e:j]\u001eT1!a:G\u0003=Q8nQ8o]\u0016\u001cGo\u0014:Ok2d\u0017\u0001E2p]R\u0014x\u000e\u001c7feN+'O^3s+\t\t)\u0010E\u0002T\u0003oL1!!??\u0005A\u0019uN\u001c;s_2dWM]*feZ,'/A\td_:$(o\u001c7mKJ\u001cVM\u001d<feN,\"!a@\u0011\tmt\u0018Q_\u0001\u0014M\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/_\u000b\u0003\u0005\u000b\u00012a\u0015B\u0004\u0013\r\u0011IA\u0010\u0002%#V|'/^7UKN$\b*\u0019:oKN\u001ch)Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0006!b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss\u0002\nABZ1vYRD\u0015M\u001c3mKJ,\"A!\u0005\u0011\t\tM!\u0011D\u0007\u0003\u0005+QAAa\u0006\u0002\u001c\u0005)a-Y;mi&!!1\u0004B\u000b\u0005AiunY6GCVdG\u000fS1oI2,'/A\u0007gCVdG\u000fS1oI2,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003{\u0011\u0019\u0003C\u0004\u0002\")\u0002\r!!\n)\u0007)\u00129\u0003\u0005\u0003\u0002(\t%\u0012\u0002\u0002B\u0016\u0003S\u0011!BQ3g_J,W)Y2i\u00031\u0019'/Z1uK\n\u0013xn[3s))\u0011\tDa\u000e\u0003B\t=#1\u000b\t\u0004'\nM\u0012b\u0001B\u001b}\tY1*\u00194lC\n\u0013xn[3s\u0011\u001d\u0011Id\u000ba\u0001\u0005w\taaY8oM&<\u0007cA*\u0003>%\u0019!q\b \u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u0005\u0007Z\u0003\u0013!a\u0001\u0005\u000b\nA\u0001^5nKB!!q\tB&\u001b\t\u0011IE\u0003\u0002N]&!!Q\nB%\u0005\u0011!\u0016.\\3\t\u0011\tE3\u0006%AA\u0002\r\fqa\u001d;beR,\b\u000fC\u0005\u0003V-\u0002\n\u00111\u0001\u0003X\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0005\u000b\u0006\fI.\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iF\u000b\u0003\u0003F\t}3F\u0001B1!\u0011\u0011\u0019G!\u001c\u000e\u0005\t\u0015$\u0002\u0002B4\u0005S\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-d)\u0001\u0006b]:|G/\u0019;j_:LAAa\u001c\u0003f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uIM*\"A!\u001e+\u0007\r\u0014y&\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YH\u000b\u0003\u0003X\t}\u0013!E:ikR$wn\u001e8[_>\\U-\u001a9fe\u000692\u000f[;uI><hn\u0013*bMR\u001cuN\u001c;s_2dWM]\u0001\u0018_B$\u0018n\u001c8bY6+G/\u00193bi\u0006\u0014VmY8sIN,\"A!\"\u0011\t\u0015\u000b'q\u0011\t\u0007\u0003C\u0012I)a\u001b\n\t\t-\u00151\r\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/\u0001\boK^\\%+\u00194u#V|'/^7\u0015\t\u0005\u001d&\u0011\u0013\u0005\b\u0003C\u0011\u0004\u0019AA\u0013\u0003IqWm\u001e.p_.+W\r]3s#V|'/^7\u0002\u0011Q,\u0017M\u001d#po:D3\u0001\u000eBM!\u0011\t9Ca'\n\t\tu\u0015\u0011\u0006\u0002\n\u0003\u001a$XM]#bG\"\f1f\u0019:fCR,'l\\8LK\u0016\u0004XM]\"mS\u0016tG\u000fV8Ue&<w-\u001a:TKN\u001c\u0018n\u001c8FqBL'/\u001f\u000b\u0005\u0005G\u0013i\u000b\u0005\u0003\u0003&\n%VB\u0001BT\u0015\r\ti+]\u0005\u0005\u0005W\u00139KA\u0005[_>\\U-\u001a9fe\"9!qV\u001bA\u0002\t\r\u0016!\u0003>p_.+W\r]3sQ\u001d\u0001!1\u0017B]\u0005w\u0003B!a\n\u00036&!!qWA\u0015\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005{\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0006\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0011\u0005M;4CA\u001cE)\t\u0011\t-A\r[W\u000ec\u0017.\u001a8u\u000bZ,g\u000e\u001e+ie\u0016\fGmU;gM&DXC\u0001Bf!\u0011\u0011iMa5\u000e\u0005\t='\u0002\u0002Bi\u0003\u0013\tA\u0001\\1oO&!\u00111\u001eBh\u0003iQ6n\u00117jK:$XI^3oiRC'/Z1e'V4g-\u001b=!\u0003)\u0019X\r^+q\u00072\f7o\u001d\u0015\u0004w\tm\u0007\u0003BA\u0014\u0005;LAAa8\u0002*\tI!)\u001a4pe\u0016\fE\u000e\\\u0001\u000ei\u0016\f'\u000fR8x]\u000ec\u0017m]:)\u0007q\u0012)\u000f\u0005\u0003\u0002(\t\u001d\u0018\u0002\u0002Bu\u0003S\u0011\u0001\"\u00114uKJ\fE\u000e\u001c")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests = Integer.MAX_VALUE;
    private final SecurityProtocol controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
    private final MockFaultHandler faultHandler = this.faultHandlerFactory().faultHandler();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterAll");
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public boolean isNewGroupCoordinatorEnabled() {
        return TestInfoUtils$.MODULE$.isNewGroupCoordinatorEnabled(this.testInfo());
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified(TestInfo testInfo) {
        return TestInfoUtils$.MODULE$.maybeGroupProtocolSpecified(testInfo);
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable)x$6 -> x$6.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    public Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords() {
        return None$.MODULE$;
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ServerMaxStartupTimeMsProp(), Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.setProperty(KafkaConfig$.MODULE$.UnstableMetadataVersionsEnableProp(), "true");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils.tempDirectory(null, null);
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId).build();
        TestUtils$.MODULE$.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties, this.metadataVersion(), this.optionalMetadataRecords());
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(this.metadataVersion().featureLevel()), (short)0));
        this.optionalMetadataRecords().foreach((Function1 & Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$1.add(record)));
            return BoxedUnit.UNIT;
        });
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromRecords(metadataRecords, (String)"test harness");
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        props.setProperty(ServerTopicConfigSynonyms.serverSynonym((String)"file.delete.delay.ms"), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        MetaPropertiesEnsemble metaPropertiesEnsemble = new MetaPropertiesEnsemble.Loader().addMetadataLogDir(metadataDir.getAbsolutePath()).load();
        metaPropertiesEnsemble.verify(Optional.of(metaProperties.clusterId().get()), OptionalInt.of(nodeId), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, (FaultHandlerFactory)this.faultHandlerFactory());
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForController(), (Logging)this, Level.WARN);
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, (String)metaProperties.clusterId().get(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            boolean x$2 = BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> JaasUtils.isZkSaslEnabled()));
            int x$3 = this.zkSessionTimeout();
            int x$4 = this.zkConnectionTimeout();
            int x$5 = this.zkMaxInFlightRequests();
            Time x$6 = Time.SYSTEM;
            ZKClientConfig x$8 = new ZKClientConfig();
            String x$10 = "kafka.server";
            String x$11 = "SessionExpireListener";
            boolean x$12 = false;
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, x$2, x$3, x$4, x$5, x$6, "ZooKeeperTestHarness", x$8, x$10, x$11, x$12, false);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem, (Option)None$.MODULE$);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> zookeeper.shutdown(), (Logging)this, Level.WARN);
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, Level.WARN);
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return anotherZkClient;
    }

    public QuorumTestHarness() {
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
    }
}

