/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005]4QAC\u0006\u0002\u0002AA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\u0006=\u0001!\ta\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b-\u0002\t\n\u0011\"\u0001X\u0011\u001d\u0011\u0007!%A\u0005\u0002\rDq!\u001a\u0001\u0012\u0002\u0013\u00051\rC\u0004g\u0001E\u0005I\u0011A4\u0003=\u0005\u00137\u000f\u001e:bGR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;UKN$(B\u0001\u0007\u000e\u0003\u0019\u0019XM\u001d<fe*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mi\u0011\u0001\u0002;fgRL!!\b\u000e\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDC\u0001\u0011#!\t\t\u0003!D\u0001\f\u0011\u00159\"\u00011\u0001\u0019\u0003Y\u0019XM\u001c3Ba&4VM]:j_:\u001c(+Z9vKN$HcA\u00133oA\u0011a\u0005M\u0007\u0002O)\u0011\u0001&K\u0001\te\u0016\fX/Z:ug*\u0011!fK\u0001\u0007G>lWn\u001c8\u000b\u00059a#BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001eL!!M\u0014\u0003'\u0005\u0003\u0018NV3sg&|gn\u001d*fgB|gn]3\t\u000bM\u001a\u0001\u0019\u0001\u001b\u0002\u000fI,\u0017/^3tiB\u0011a%N\u0005\u0003m\u001d\u0012!#\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\")\u0001h\u0001a\u0001s\u0005aA.[:uK:,'OT1nKB\u0011!(P\u0007\u0002w)\u0011A(K\u0001\b]\u0016$xo\u001c:l\u0013\tq4H\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u0011tK:$WK\\:vaB|'\u000f^3e\u0003BLg+\u001a:tS>t'+Z9vKN$HCA\u0013B\u0011\u0015\u0019D\u00011\u00015\u0003m1\u0018\r\\5eCR,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tKR1AiR%K\u001fF\u0003\"AE#\n\u0005\u0019\u001b\"\u0001B+oSRDQ\u0001S\u0003A\u0002\u0015\n1#\u00199j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016Dq\u0001O\u0003\u0011\u0002\u0003\u0007\u0011\bC\u0004L\u000bA\u0005\t\u0019\u0001'\u00023\u0015t\u0017M\u00197f+:\u001cH/\u00192mK2\u000b7\u000f\u001e,feNLwN\u001c\t\u0003%5K!AT\n\u0003\u000f\t{w\u000e\\3b]\"9\u0001+\u0002I\u0001\u0002\u0004a\u0015AF2mS\u0016tG\u000fV3mK6,GO]=F]\u0006\u0014G.\u001a3\t\u000fI+\u0001\u0013!a\u0001'\u0006Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0011\u0005I!\u0016BA+\u0014\u0005\u0015\u0019\u0006n\u001c:u\u0003\u00152\u0018\r\\5eCR,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'F\u0001YU\tI\u0014lK\u0001[!\tY\u0006-D\u0001]\u0015\tif,A\u0005v]\u000eDWmY6fI*\u0011qlE\u0001\u000bC:tw\u000e^1uS>t\u0017BA1]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001&m\u0006d\u0017\u000eZ1uK\u0006\u0003\u0018NV3sg&|gn\u001d*fgB|gn]3%I\u00164\u0017-\u001e7uIM*\u0012\u0001\u001a\u0016\u0003\u0019f\u000bQE^1mS\u0012\fG/Z!qSZ+'o]5p]N\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001b\u0002KY\fG.\u001b3bi\u0016\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012*T#\u00015+\u0005MK\u0006\u0006\u0002\u0001kiV\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u0007\u0005\u0004\u0018N\u0003\u0002pa\u00069!.\u001e9ji\u0016\u0014(BA9/\u0003\u0015QWO\\5u\u0013\t\u0019HNA\u0002UC\u001e\fQA^1mk\u0016\f\u0013A^\u0001\fS:$Xm\u001a:bi&|g\u000e")
public abstract class AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, ListenerName listenerName) {
        SocketServer socket = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? (SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllerSocketServers()).asScala().head() : (SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head();
        return (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socket, listenerName, ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
    }

    public ApiVersionsResponse sendUnsupportedApiVersionRequest(ApiVersionsRequest request) {
        ApiVersionsResponse apiVersionsResponse;
        RequestHeader overrideHeader = IntegrationTestUtils$.MODULE$.nextRequestHeader(ApiKeys.API_VERSIONS, (short)Short.MAX_VALUE, "client-id", (Option<Object>)None$.MODULE$);
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            byte[] serializedBytes = Utils.toArray((ByteBuffer)RequestUtils.serialize((Message)overrideHeader.data(), (short)overrideHeader.headerVersion(), (Message)request.data(), (short)request.version()));
            IntegrationTestUtils$.MODULE$.sendRequest(socket, serializedBytes);
            apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.receive(socket, ApiKeys.API_VERSIONS, (short)0, ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
        }
        return apiVersionsResponse;
    }

    public void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse, ListenerName listenerName, boolean enableUnstableLastVersion, boolean clientTelemetryEnabled, short apiVersion) {
        if (this.cluster.isKRaftTest() && apiVersion >= 3) {
            Assertions.assertEquals((int)1, (int)apiVersionsResponse.data().finalizedFeatures().size());
            Assertions.assertEquals((short)MetadataVersion.latestTesting().featureLevel(), (short)apiVersionsResponse.data().finalizedFeatures().find("metadata.version").minVersionLevel());
            Assertions.assertEquals((short)MetadataVersion.latestTesting().featureLevel(), (short)apiVersionsResponse.data().finalizedFeatures().find("metadata.version").maxVersionLevel());
            Assertions.assertEquals((int)3, (int)apiVersionsResponse.data().supportedFeatures().size());
            Assertions.assertEquals((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("metadata.version").minVersion());
            if (apiVersion < 4) {
                Assertions.assertEquals((int)1, (int)apiVersionsResponse.data().supportedFeatures().find("kraft.version").minVersion());
            } else {
                Assertions.assertEquals((int)0, (int)apiVersionsResponse.data().supportedFeatures().find("kraft.version").minVersion());
            }
            Assertions.assertEquals((short)MetadataVersion.latestTesting().featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("metadata.version").maxVersion());
            Assertions.assertEquals((int)0, (int)apiVersionsResponse.data().supportedFeatures().find("transaction.version").minVersion());
            Assertions.assertEquals((short)TransactionVersion.TV_2.featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("transaction.version").maxVersion());
        }
        ApiVersionsResponseData.ApiVersionCollection expectedApis = !this.cluster.isKRaftTest() ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER), (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER), (boolean)enableUnstableLastVersion) : ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (RecordVersion)RecordVersion.current(), (Map)NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER)).asScala().map((Function1 & Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1))).asJava()).allSupportedApiVersions(), (boolean)enableUnstableLastVersion, (boolean)clientTelemetryEnabled));
        Assertions.assertEquals((int)expectedApis.size(), (int)apiVersionsResponse.data().apiKeys().size(), (String)"API keys in ApiVersionsResponse must match API keys supported by broker.");
        ApiVersionsResponse defaultApiVersionsResponse = !this.cluster.isKRaftTest() ? TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER, (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER, (boolean)enableUnstableLastVersion) : TestUtils.createApiVersionsResponse((int)0, (ApiVersionsResponseData.ApiVersionCollection)expectedApis));
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)defaultApiVersionsResponse.data().apiKeys()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$2(check$ifrefutable$1))).foreach((Function1 & Serializable)expectedApiVersion -> {
            AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$3(apiVersionsResponse, expectedApiVersion);
            return BoxedUnit.UNIT;
        });
    }

    public ListenerName validateApiVersionsResponse$default$2() {
        return this.cluster.clientListener();
    }

    public boolean validateApiVersionsResponse$default$3() {
        return false;
    }

    public boolean validateApiVersionsResponse$default$4() {
        return false;
    }

    public short validateApiVersionsResponse$default$5() {
        return ApiKeys.API_VERSIONS.latestVersion();
    }

    public static final /* synthetic */ boolean $anonfun$validateApiVersionsResponse$2(ApiVersionsResponseData.ApiVersion check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$validateApiVersionsResponse$3(ApiVersionsResponse apiVersionsResponse$1, ApiVersionsResponseData.ApiVersion expectedApiVersion) {
        ApiVersionsResponseData.ApiVersion actualApiVersion = apiVersionsResponse$1.apiVersion(expectedApiVersion.apiKey());
        Assertions.assertNotNull((Object)actualApiVersion, (String)new StringBuilder(73).append("API key ").append(expectedApiVersion.apiKey()).append(" is supported by broker, but not received in ApiVersionsResponse.").toString());
        Assertions.assertEquals((short)expectedApiVersion.apiKey(), (short)actualApiVersion.apiKey(), (String)"API key must be supported by the broker.");
        Assertions.assertEquals((short)expectedApiVersion.minVersion(), (short)actualApiVersion.minVersion(), (String)new StringBuilder(45).append("Received unexpected min version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
        Assertions.assertEquals((short)expectedApiVersion.maxVersion(), (short)actualApiVersion.maxVersion(), (String)new StringBuilder(45).append("Received unexpected max version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
    }

    public AbstractApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

