/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.List;
import kafka.server.AbstractApiVersionsRequestTest;
import kafka.server.ApiVersionsRequestTest$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u001du!\u0002\u000b\u0016\u0011\u0003Qb!\u0002\u000f\u0016\u0011\u0003i\u0002\"\u0002\u0013\u0002\t\u0003)\u0003\"\u0002\u0014\u0002\t\u00039\u0003\"B\u001e\u0002\t\u0003a\u0004\"\u0002$\u0002\t\u0003a\u0004\"B$\u0002\t\u0003a\u0004\"\u0002%\u0002\t\u0003ad\u0001\u0002\u000f\u0016\u0001%C\u0001\"\u0014\u0005\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006I!!\t!\u0015\u0005\u0006)\"!\t!\u0016\u0005\u0007\u0003\u0003AA\u0011A+\t\r\u0005=\u0001\u0002\"\u0001V\u0011\u0019\t)\u0002\u0003C\u0001+\"1\u00111\u0004\u0005\u0005\u0002UCa!a\t\t\t\u0003)\u0006BBA'\u0011\u0011\u0005Q\u000b\u0003\u0004\u0002R!!\t!\u0016\u0005\u0007\u0003/BA\u0011A+\u0002-\u0005\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001\u0001\t\u00037\u0005i\u0011!\u0006\u0002\u0017\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3tiN\u0011\u0011A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0012AH2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'\u000f\u0015:pa\u0016\u0014H/[3t)\u0005A\u0003\u0003B\u0015/aAj\u0011A\u000b\u0006\u0003W1\nA!\u001e;jY*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018+\u0005\u001dA\u0015m\u001d5NCB\u0004\"!\r\u001d\u000f\u0005I2\u0004CA\u001a!\u001b\u0005!$BA\u001b\u001a\u0003\u0019a$o\\8u}%\u0011q\u0007I\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028A\u0005qB/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3na2\fG/\u001a\u000b\u0002{A\u0019\u0011F\u0010!\n\u0005}R#\u0001\u0002'jgR\u0004\"!\u0011#\u000e\u0003\tS!aQ\f\u0002\tQ,7\u000f^\u0005\u0003\u000b\n\u0013Qb\u00117vgR,'oQ8oM&<\u0017\u0001\u000e;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;J]\u000edW\u000fZ3t+:\u0014X\r\\3bg\u0016$\u0017\t]5t)\u0016l\u0007\u000f\\1uK\u0006QC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHOV1mS\u0012\fG/[8o-B\"V-\u001c9mCR,\u0017\u0001\u0006>l\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHo\u0005\u0002\t\u0015B\u00111dS\u0005\u0003\u0019V\u0011a$\u00112tiJ\f7\r^!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u0002\u000f\rdWo\u001d;feB\u0011\u0011iT\u0005\u0003!\n\u0013qb\u00117vgR,'/\u00138ti\u0006t7-\u001a\u000b\u0003%N\u0003\"a\u0007\u0005\t\u000b5S\u0001\u0019\u0001(\u0002-Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0012A\u0016\t\u0003?]K!\u0001\u0017\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0017i\u0003\u0017\r\u0005\u0002\\=6\tAL\u0003\u0002^\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005}c&aD\"mkN$XM\u001d+f[Bd\u0017\r^3\u0002\u000bY\fG.^3\"\u0003mBcaC2gOB\f\bCA.e\u0013\t)GLA\u0006DYV\u001cH/\u001a:UKN$\u0018!\u0002;za\u0016\u001cHF\u00015nI\u0005I\u0017B\u00016l\u0003\u0015Y%+\u0011$U\u0015\taG,\u0001\u0003UsB,G%\u00018\n\u0005=\\\u0017\u0001C\"P?.\u0013\u0016I\u0012+\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cHF\u0001:|W\u0015\u0019ho\u001e1z!\tYF/\u0003\u0002v9\n)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\n\u00010\u0001\u000fv]N$\u0018M\u00197f]\u0005\u0004\u0018N\f<feNLwN\\:/K:\f'\r\\3\"\u0003i\fQAZ1mg\u0016\\Sa\u001d<}Az\f\u0013!`\u0001!k:\u001cH/\u00192mK:2W-\u0019;ve\u0016tc/\u001a:tS>t7OL3oC\ndW-I\u0001\u0000\u0003\u0011!(/^3\u0002YQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgRLen\u00197vI\u0016\u001cXK\u001c:fY\u0016\f7/\u001a3Ba&\u001c\b&\u0002\u0007[A\u0006\u0015\u0011%\u0001$)\u00111\u0019g-!\u0003q\u0003\u0017a#\u0001[7-\u0007\u000551pK\u0003tm^\u0004g0A\u0019uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\"\u0014x.^4i\u0007>tGO]8m!2\fg.\u001a'jgR,g.\u001a:)\u000b5Q\u0006-a\u0005\"\u0003!\u000bq\u0006^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+ie>,x\r[\"p]R\u0014x\u000e\u001c7fe2K7\u000f^3oKJDSAD2g\u00033a\u0013\u0001[\u0001-i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124VM]:j_:DSa\u0004.a\u0003'ASaD2g\u0003Ca#\u0001[7\u0002EQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,1Q\u0015\u0001\"\fYA\u0014C\u00059\u0005\u0006\u0004\tdM\u0006-\u0012QFA\u0018a\u0006%CF\u00015n\u0003=iW\r^1eCR\fg+\u001a:tS>tGEAA\u0019\u0013\u0011\t\u0019$!\u000e\u0002\u0017%\u0013\u0005kX\u001a`q}Ke\u000b\r\u0006\u0005\u0003o\tI$A\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0015\u0011\tY$!\u0010\u0002\r\r|W.\\8o\u0015\r1\u0012q\b\u0006\u00041\u0005\u0005#\u0002BA\"\u0003\u000b\na!\u00199bG\",'BAA$\u0003\ry'o\u001a\u0017\u0004e\u0006-3&B:wy\u0002L\u0018!\u0010;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;WC2LG-\u0019;j_:4\u0006\u0007\u00165s_V<\u0007nQ8oiJ|G\u000e\u00157b]\u0016d\u0015n\u001d;f]\u0016\u0014\b&B\t[A\u0006M\u0011a\u000f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;WC2LG-\u0019;j_:4\u0006\u0007\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8fe\"*!c\u00194\u0002V1\n\u0001.\u0001\u0012uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tgk\r\u0015\u0006'i\u0003\u00171\u0003\u0015\u0006'\r4\u0017Q\f\u0017\u0003Q6Dc\u0001CA1A\u0006e\u0004\u0003BA2\u0003kj!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\nKb$XM\\:j_:TA!a\u001b\u0002n\u0005\u0019\u0011\r]5\u000b\t\u0005=\u0014\u0011O\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t\u0019(!\u0012\u0002\u000b),h.\u001b;\n\t\u0005]\u0014Q\r\u0002\u000b\u000bb$XM\u001c3XSRDGFAA>G\t\ti\b\u0005\u0003\u0002\u0000\u0005\rUBAAA\u0015\r\t\u0019HQ\u0005\u0005\u0003\u000b\u000b\tIA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public static List<ClusterConfig> zkApiVersionsRequest() {
        return ApiVersionsRequestTest$.MODULE$.zkApiVersionsRequest();
    }

    public static List<ClusterConfig> testApiVersionsRequestValidationV0Template() {
        return ApiVersionsRequestTest$.MODULE$.testApiVersionsRequestValidationV0Template();
    }

    public static List<ClusterConfig> testApiVersionsRequestIncludesUnreleasedApisTemplate() {
        return ApiVersionsRequestTest$.MODULE$.testApiVersionsRequestIncludesUnreleasedApisTemplate();
    }

    public static List<ClusterConfig> testApiVersionsRequestTemplate() {
        return ApiVersionsRequestTest$.MODULE$.testApiVersionsRequestTemplate();
    }

    public static HashMap<String, String> controlPlaneListenerProperties() {
        return ApiVersionsRequestTest$.MODULE$.controlPlaneListenerProperties();
    }

    @ClusterTemplate(value="testApiVersionsRequestTemplate")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="true")})
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTemplate(value="testApiVersionsRequestIncludesUnreleasedApisTemplate")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="true")})
    public void testApiVersionsRequestIncludesUnreleasedApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        boolean x$4 = this.validateApiVersionsResponse$default$4();
        short x$5 = this.validateApiVersionsResponse$default$5();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, true, x$4, x$5);
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), true, this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(types={Type.KRAFT})
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), true, this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTemplate(value="testApiVersionsRequestValidationV0Template")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, metadataVersion=MetadataVersion.IBP_3_8_IV0, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="false")})
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        boolean x$3 = !"false".equals(this.cluster.config().serverProperties().get("unstable.api.versions.enable"));
        ListenerName x$4 = this.validateApiVersionsResponse$default$2();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$4, x$3, x$5, (short)0);
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), true, this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(types={Type.KRAFT})
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controllerListenerName().get());
        ListenerName x$2 = this.cluster.controllerListenerName().get();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$2, true, x$5, (short)0);
    }

    @ClusterTemplate(value="zkApiVersionsRequest")
    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

