/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001B\u0005\u000b\u0001=AQ\u0001\u0006\u0001\u0005\u0002UAQa\u0006\u0001\u0005BaAQa\b\u0001\u0005B\u0001BQA\f\u0001\u0005\n=BQA\u0011\u0001\u0005\u0002\rCQ!\u001b\u0001\u0005\u0002)DQa\u001c\u0001\u0005\u0002ADq!!\u0006\u0001\t\u0013\t9B\u0001\u0012Ba&4VM]:j_:\u001c(+Z:q_:\u001cX-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u00171\taa]3sm\u0016\u0014(\"A\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011AC\u0005\u0003')\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"!\u0005\u0001\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u00023A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t\u0019\u0011J\u001c;\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHCA\u0011%!\tQ\"%\u0003\u0002$7\t!QK\\5u\u0011\u0015)3\u00011\u0001'\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nA!\u001e;jY*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005)\u0001&o\u001c9feRLWm]\u0001\u0017g\u0016tG-\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR\u0011\u0001'\u0010\t\u0003cmj\u0011A\r\u0006\u0003gQ\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003kY\naaY8n[>t'BA\u00078\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\n\u0005q\u0012$aE!qSZ+'o]5p]N\u0014Vm\u001d9p]N,\u0007\"\u0002 \u0005\u0001\u0004y\u0014a\u0002<feNLwN\u001c\t\u00035\u0001K!!Q\u000e\u0003\u000bMCwN\u001d;\u00029Q,7\u000f^*f]\u001246'\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR\u0011\u0011\u0005\u0012\u0005\u0006\u000b\u0016\u0001\rAR\u0001\u0007cV|'/^7\u0011\u0005\u001dseB\u0001%M!\tI5$D\u0001K\u0015\tYe\"\u0001\u0004=e>|GOP\u0005\u0003\u001bn\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011Qj\u0007\u0015\u0003\u000bI\u0003\"a\u0015.\u000e\u0003QS!!\u0016,\u0002\rA\f'/Y7t\u0015\t9\u0006,A\u0004kkBLG/\u001a:\u000b\u0005eK\u0014!\u00026v]&$\u0018BA.U\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\u0005\u000bu\u001bG\r\u0005\u0002_C6\tqL\u0003\u0002a)\u0006A\u0001O]8wS\u0012,'/\u0003\u0002c?\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#!Z4\"\u0003\u0019\f!A_6\"\u0003!\fQa\u001b:bMR\fA\u0004^3tiN+g\u000e\u001a,5\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u0006\u0002\"W\")QI\u0002a\u0001\r\"\u0012aA\u0015\u0015\u0005\ru\u001bg\u000e\f\u0002fO\u0006Q\u0012m]:feR4U-\u0019;ve\u0016D\u0015m]'j]Z+'o]5p]R)\u0011%]:\u0002\u0012!)!o\u0002a\u0001\r\u0006!a.Y7f\u0011\u0015!x\u00011\u0001v\u0003\u0011\u0019w\u000e\u001c7\u0011\u0007Y\fYAD\u0002x\u0003\u000bq1\u0001_A\u0001\u001d\tIxP\u0004\u0002{}:\u001110 \b\u0003\u0013rL\u0011AO\u0005\u0003qeJ!!D\u001c\n\u0005U2\u0014bAA\u0002i\u00059Q.Z:tC\u001e,\u0017\u0002BA\u0004\u0003\u0013\tq#\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\u000b\u0007\u0005\rA'\u0003\u0003\u0002\u000e\u0005=!!H*vaB|'\u000f^3e\r\u0016\fG/\u001e:f\u0017\u0016L8i\u001c7mK\u000e$\u0018n\u001c8\u000b\t\u0005\u001d\u0011\u0011\u0002\u0005\u0007\u0003'9\u0001\u0019A \u0002%\u0015D\b/Z2uK\u0012l\u0015N\u001c,feNLwN\\\u0001\u0015CN\u001cXM\u001d;GK\u0006$XO]3NSN\u001c\u0018N\\4\u0015\u000b\u0005\nI\"a\u0007\t\u000bID\u0001\u0019\u0001$\t\u000bQD\u0001\u0019A;")
public class ApiVersionsResponseIntegrationTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("controlled.shutdown.enable", "false");
        properties.put("offsets.topic.replication.factor", "1");
        properties.put("offsets.topic.num.partitions", "1");
    }

    private ApiVersionsResponse sendApiVersionsRequest(short version) {
        ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
        return (ApiVersionsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ApiVersionsResponse.class));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendV3ApiVersionsRequest(String quorum) {
        ApiVersionsResponse response = this.sendApiVersionsRequest((short)3);
        if (quorum.equals("kraft")) {
            this.assertFeatureHasMinVersion("metadata.version", response.data().supportedFeatures(), (short)1);
            this.assertFeatureMissing("kraft.version", response.data().supportedFeatures());
            return;
        }
        Assertions.assertEquals((int)0, (int)response.data().supportedFeatures().size());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testSendV4ApiVersionsRequest(String quorum) {
        ApiVersionsResponse response = this.sendApiVersionsRequest((short)4);
        if (quorum.equals("kraft")) {
            this.assertFeatureHasMinVersion("metadata.version", response.data().supportedFeatures(), (short)1);
            this.assertFeatureHasMinVersion("kraft.version", response.data().supportedFeatures(), (short)0);
            return;
        }
        Assertions.assertEquals((int)0, (int)response.data().supportedFeatures().size());
    }

    public void assertFeatureHasMinVersion(String name, ApiVersionsResponseData.SupportedFeatureKeyCollection coll, short expectedMinVersion) {
        ApiVersionsResponseData.SupportedFeatureKey key = coll.find(name);
        Assertions.assertNotNull((Object)key);
        Assertions.assertEquals((Object)name, (Object)key.name());
        Assertions.assertEquals((short)expectedMinVersion, (short)key.minVersion());
    }

    private void assertFeatureMissing(String name, ApiVersionsResponseData.SupportedFeatureKeyCollection coll) {
        Assertions.assertNull((Object)coll.find(name));
    }
}

