/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0013q\u0002B\u0002\u0017\u0001A\u0003%q\u0004C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rQ\u0002\u0001\u0015!\u00030\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015)\u0005\u0001\"\u00017\u0011\u0015Q\u0005\u0001\"\u00017\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\u0011\u0006\u0001\"\u00017\u0011\u0015!\u0006\u0001\"\u0003V\u0005m\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'\u000fV3ti*\u0011abD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0007\u0002\tQLW.Z\u000b\u0002?A\u0011\u0001EK\u0007\u0002C)\u0011!eI\u0001\u0006kRLGn\u001d\u0006\u0003I\u0015\naaY8n[>t'B\u0001\t'\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\n\u0005-\n#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\tq\u0006\u0005\u00021e5\t\u0011G\u0003\u0002.G%\u00111'\r\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003]\u0002\"\u0001\u0006\u001d\n\u0005e*\"\u0001B+oSRD#AB\u001e\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014aA1qS*\u0011\u0001)Q\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011\u0005&A\u0003kk:LG/\u0003\u0002E{\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\"g\"|W\u000f\u001c3UQJ|G\u000f\u001e7f\u001f:d\u0017\u0010R3gS:,GMU3qY&\u001c\u0017m\u001d\u0015\u0003\u000f\u001d\u0003\"\u0001\u0010%\n\u0005%k$\u0001\u0002+fgR\fQg\u001d5pk2$W\t_2fK\u0012\fVo\u001c;b)\",gNU3ukJt')Y2l\u0005\u0016dwn\u001e\"pk:$\u0017i\u001d+j[\u0016\u0004\u0016m]:fg\"\u0012\u0001bR\u0001\u0005e\u0006$X\r\u0006\u0002O#B\u0011AcT\u0005\u0003!V\u0011a\u0001R8vE2,\u0007\"B\u0017\n\u0001\u0004y\u0013AJ:i_VdGmU;qa>\u0014HoV5mI\u000e\f'\u000f\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\"\u0012!bR\u0001\u0004iB\fDC\u0001,[!\t9\u0006,D\u0001$\u0013\tI6E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000bm[\u0001\u0019\u0001/\u0002\u0005%$\u0007C\u0001\u000b^\u0013\tqVCA\u0002J]R\u0004")
public class ReplicationQuotaManagerTest {
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void shouldThrottleOnlyDefinedReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time());
        quota.markThrottled("topic1", (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        int tp1_id = 1;
        Assertions.assertTrue((boolean)quota.isThrottled(new TopicPartition("topic1", tp1_id)));
        int tp1_id2 = 2;
        Assertions.assertTrue((boolean)quota.isThrottled(new TopicPartition("topic1", tp1_id2)));
        int tp1_id3 = 3;
        Assertions.assertTrue((boolean)quota.isThrottled(new TopicPartition("topic1", tp1_id3)));
        int tp1_id4 = 4;
        Assertions.assertFalse((boolean)quota.isThrottled(new TopicPartition("topic1", tp1_id4)));
    }

    @Test
    public void shouldExceedQuotaThenReturnBackBelowBoundAsTimePasses() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(10, 1), this.metrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.updateQuota(new Quota(100.0, true));
        Assertions.assertFalse((boolean)quota.isQuotaExceeded());
        this.time().sleep(1000L);
        this.time().sleep(500L);
        quota.record(1L);
        Assertions.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(149L);
        Assertions.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assertions.assertEquals((double)100.66666666666667, (double)this.rate(this.metrics()), (double)0.0);
        Assertions.assertTrue((boolean)quota.isQuotaExceeded());
        this.time().sleep(500L);
        Assertions.assertFalse((boolean)quota.isQuotaExceeded());
        Assertions.assertEquals((double)75.5, (double)this.rate(this.metrics()), (double)0.1);
        this.time().sleep(500L);
        quota.record(99L);
        Assertions.assertEquals((double)100.0, (double)this.rate(this.metrics()), (double)0.0);
        Assertions.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assertions.assertTrue((boolean)quota.isQuotaExceeded());
        Assertions.assertEquals((double)100.4, (double)this.rate(this.metrics()), (double)0.0);
        this.time().sleep(2000L);
        Assertions.assertFalse((boolean)quota.isQuotaExceeded());
        Assertions.assertEquals((double)55.77777777777778, (double)this.rate(this.metrics()), (double)0.0);
    }

    public double rate(Metrics metrics) {
        MetricName metricName = metrics.metricName("byte-rate", "LeaderReplication", new StringBuilder(23).append("Tracking byte-rate for ").append(QuotaType.LeaderReplication$.MODULE$).toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(metrics.metrics()).asScala().apply((Object)metricName)).metricValue());
    }

    @Test
    public void shouldSupportWildcardThrottledReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.markThrottled("MyTopic");
        Assertions.assertTrue((boolean)quota.isThrottled(new TopicPartition("MyTopic", 0)));
        Assertions.assertFalse((boolean)quota.isThrottled(new TopicPartition("MyOtherTopic", 0)));
    }

    private TopicPartition tp1(int id) {
        return new TopicPartition("topic1", id);
    }
}

