/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.test.ClusterConfig;
import kafka.test.annotation.Type;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterConfigTest {
    private static Map<String, Object> fields(ClusterConfig config) {
        return Arrays.stream(config.getClass().getDeclaredFields()).collect(Collectors.toMap(Field::getName, f -> {
            f.setAccessible(true);
            return Assertions.assertDoesNotThrow(() -> f.get(config));
        }));
    }

    @Test
    public void testCopy() throws IOException {
        File trustStoreFile = TestUtils.tempFile();
        ClusterConfig clusterConfig = ClusterConfig.builder().setTypes(Collections.singleton(Type.KRAFT)).setBrokers(3).setControllers(2).setDisksPerBroker(1).setAutoStart(true).setTags(Arrays.asList("name", "Generated Test")).setSecurityProtocol(SecurityProtocol.PLAINTEXT).setListenerName("EXTERNAL").setTrustStoreFile(trustStoreFile).setMetadataVersion(MetadataVersion.IBP_0_8_0).setServerProperties(Collections.singletonMap("broker", "broker_value")).setConsumerProperties(Collections.singletonMap("consumer", "consumer_value")).setProducerProperties(Collections.singletonMap("producer", "producer_value")).setAdminClientProperties(Collections.singletonMap("admin_client", "admin_client_value")).setSaslClientProperties(Collections.singletonMap("sasl_client", "sasl_client_value")).setSaslServerProperties(Collections.singletonMap("sasl_server", "sasl_server_value")).setPerServerProperties(Collections.singletonMap(0, Collections.singletonMap("broker_0", "broker_0_value"))).build();
        Map<String, Object> clusterConfigFields = ClusterConfigTest.fields(clusterConfig);
        Map<String, Object> copyFields = ClusterConfigTest.fields(clusterConfig);
        Assertions.assertEquals(clusterConfigFields, copyFields);
    }

    @Test
    public void testBrokerLessThanZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterConfig.builder().setBrokers(-1).setControllers(1).setDisksPerBroker(1).build());
    }

    @Test
    public void testControllersLessThanZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterConfig.builder().setBrokers(1).setControllers(-1).setDisksPerBroker(1).build());
    }

    @Test
    public void testDisksPerBrokerIsZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClusterConfig.builder().setBrokers(1).setControllers(1).setDisksPerBroker(0).build());
    }

    @Test
    public void testDisplayTags() {
        List<String> tags = Arrays.asList("tag 1", "tag 2", "tag 3");
        ClusterConfig clusterConfig = ClusterConfig.defaultBuilder().setTags(tags).build();
        Set<String> expectedDisplayTags = clusterConfig.displayTags();
        Assertions.assertTrue((boolean)expectedDisplayTags.contains("tag 1"));
        Assertions.assertTrue((boolean)expectedDisplayTags.contains("tag 2"));
        Assertions.assertTrue((boolean)expectedDisplayTags.contains("tag 3"));
        Assertions.assertTrue((boolean)expectedDisplayTags.contains("MetadataVersion=" + MetadataVersion.latestTesting()));
        Assertions.assertTrue((boolean)expectedDisplayTags.contains("Security=" + SecurityProtocol.PLAINTEXT));
    }
}

