/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.test.ClusterConfig;
import kafka.test.annotation.Type;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.test.TestUtils;

public interface ClusterInstance {
    public Type type();

    default public boolean isKRaftTest() {
        return this.type() == Type.KRAFT || this.type() == Type.CO_KRAFT;
    }

    public Map<Integer, KafkaBroker> brokers();

    default public Map<Integer, KafkaBroker> aliveBrokers() {
        return this.brokers().entrySet().stream().filter(entry -> !((KafkaBroker)entry.getValue()).isShutdown()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<Integer, ControllerServer> controllers();

    public ClusterConfig config();

    public Set<Integer> controllerIds();

    default public Set<Integer> brokerIds() {
        return this.brokers().keySet();
    }

    public ListenerName clientListener();

    default public Optional<ListenerName> controllerListenerName() {
        return Optional.empty();
    }

    default public Optional<ListenerName> controlPlaneListenerName() {
        return Optional.empty();
    }

    public String bootstrapServers();

    public String bootstrapControllers();

    default public Collection<SocketServer> brokerSocketServers() {
        return this.brokers().values().stream().map(KafkaBroker::socketServer).collect(Collectors.toList());
    }

    public Collection<SocketServer> controllerSocketServers();

    default public SocketServer anyBrokerSocketServer() {
        return this.brokerSocketServers().stream().findFirst().orElseThrow(() -> new RuntimeException("No broker SocketServers found"));
    }

    default public SocketServer anyControllerSocketServer() {
        return this.controllerSocketServers().stream().findFirst().orElseThrow(() -> new RuntimeException("No controller SocketServers found"));
    }

    public String clusterId();

    public Object getUnderlying();

    default public <T> T getUnderlying(Class<T> asClass) {
        return asClass.cast(this.getUnderlying());
    }

    public Admin createAdminClient(Properties var1);

    default public Admin createAdminClient() {
        return this.createAdminClient(new Properties());
    }

    default public Set<GroupProtocol> supportedGroupProtocols() {
        Map<String, String> serverProperties = this.config().serverProperties();
        HashSet<GroupProtocol> supportedGroupProtocols = new HashSet<GroupProtocol>();
        supportedGroupProtocols.add(GroupProtocol.CLASSIC);
        if (serverProperties.getOrDefault("group.coordinator.rebalance.protocols", "").contains("consumer")) {
            supportedGroupProtocols.add(GroupProtocol.CONSUMER);
        }
        return Collections.unmodifiableSet(supportedGroupProtocols);
    }

    public void start();

    public void stop();

    public void shutdownBroker(int var1);

    public void startBroker(int var1);

    public void waitForReadyBrokers() throws InterruptedException;

    default public void waitForTopic(String topic, int partitions) throws InterruptedException {
        TestUtils.waitForCondition(() -> this.brokers().values().stream().allMatch(broker -> partitions == 0 ? broker.metadataCache().numPartitions(topic).isEmpty() : broker.metadataCache().numPartitions(topic).contains((Object)partitions)), (long)60000L, (String)(topic + " metadata not propagated after 60000 ms"));
        for (ControllerServer controller : this.controllers().values()) {
            long controllerOffset = controller.raftManager().replicatedLog().endOffset().offset() - 1L;
            TestUtils.waitForCondition(() -> this.brokers().values().stream().allMatch(broker -> ((BrokerServer)broker).sharedServer().loader().lastAppliedOffset() >= controllerOffset), (long)60000L, (String)"Timeout waiting for controller metadata propagating to brokers");
        }
    }
}

