/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;

@ClusterTestDefaults(types={Type.ZK}, serverProperties={@ClusterConfigProperty(key="default.key", value="default.value"), @ClusterConfigProperty(id=0, key="queued.max.requests", value="100")})
@ExtendWith(value={ClusterTestExtensions.class})
public class ClusterTestExtensionsTest {
    private final ClusterInstance clusterInstance;

    ClusterTestExtensionsTest(ClusterInstance clusterInstance) {
        this.clusterInstance = clusterInstance;
    }

    static List<ClusterConfig> generate1() {
        HashMap<String, String> serverProperties = new HashMap<String, String>();
        serverProperties.put("foo", "bar");
        return Collections.singletonList(ClusterConfig.defaultBuilder().setTypes(Collections.singleton(Type.ZK)).setServerProperties(serverProperties).setTags(Collections.singletonList("Generated Test")).build());
    }

    @ClusterTest
    public void testClusterTest(ClusterInstance clusterInstance) {
        Assertions.assertSame((Object)this.clusterInstance, (Object)clusterInstance, (String)"Injected objects should be the same");
        Assertions.assertEquals((Object)((Object)Type.ZK), (Object)((Object)clusterInstance.type()));
        Assertions.assertEquals((Object)"default.value", (Object)clusterInstance.config().serverProperties().get("default.key"));
    }

    @ClusterTemplate(value="generate1")
    public void testClusterTemplate() {
        Assertions.assertEquals((Object)((Object)Type.ZK), (Object)((Object)this.clusterInstance.type()), (String)"generate1 provided a Zk cluster, so we should see that here");
        Assertions.assertEquals((Object)"bar", (Object)this.clusterInstance.config().serverProperties().get("foo"));
        Assertions.assertEquals(Collections.singletonList("Generated Test"), this.clusterInstance.config().tags());
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK}, serverProperties={@ClusterConfigProperty(key="foo", value="bar"), @ClusterConfigProperty(key="spam", value="eggs"), @ClusterConfigProperty(id=86400, key="baz", value="qux"), @ClusterConfigProperty(key="spam", value="eggs")}, tags={"default.display.key1", "default.display.key2"}), @ClusterTest(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="foo", value="baz"), @ClusterConfigProperty(key="spam", value="eggz"), @ClusterConfigProperty(key="default.key", value="overwrite.value"), @ClusterConfigProperty(id=0, key="queued.max.requests", value="200"), @ClusterConfigProperty(id=3000, key="queued.max.requests", value="300"), @ClusterConfigProperty(key="spam", value="eggs"), @ClusterConfigProperty(key="default.key", value="overwrite.value")}, tags={"default.display.key1", "default.display.key2"}), @ClusterTest(types={Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="foo", value="baz"), @ClusterConfigProperty(key="spam", value="eggz"), @ClusterConfigProperty(key="default.key", value="overwrite.value"), @ClusterConfigProperty(id=0, key="queued.max.requests", value="200"), @ClusterConfigProperty(key="spam", value="eggs"), @ClusterConfigProperty(key="default.key", value="overwrite.value")}, tags={"default.display.key1", "default.display.key2"})})
    public void testClusterTests() throws ExecutionException, InterruptedException {
        Map configs;
        ConfigResource configResource;
        if (!this.clusterInstance.isKRaftTest()) {
            Assertions.assertEquals((Object)"bar", (Object)this.clusterInstance.config().serverProperties().get("foo"));
            Assertions.assertEquals((Object)"eggs", (Object)this.clusterInstance.config().serverProperties().get("spam"));
            Assertions.assertEquals((Object)"default.value", (Object)this.clusterInstance.config().serverProperties().get("default.key"));
            Assertions.assertEquals(Arrays.asList("default.display.key1", "default.display.key2"), this.clusterInstance.config().tags());
            try (Admin admin = this.clusterInstance.createAdminClient();){
                ConfigResource configResource2 = new ConfigResource(ConfigResource.Type.BROKER, "0");
                Map configs2 = (Map)admin.describeConfigs(Collections.singletonList(configResource2)).all().get();
                Assertions.assertEquals((int)1, (int)configs2.size());
                Assertions.assertEquals((Object)"100", (Object)((Config)configs2.get(configResource2)).get("queued.max.requests").value());
            }
        }
        Assertions.assertEquals((Object)"baz", (Object)this.clusterInstance.config().serverProperties().get("foo"));
        Assertions.assertEquals((Object)"eggs", (Object)this.clusterInstance.config().serverProperties().get("spam"));
        Assertions.assertEquals((Object)"overwrite.value", (Object)this.clusterInstance.config().serverProperties().get("default.key"));
        Assertions.assertEquals(Arrays.asList("default.display.key1", "default.display.key2"), this.clusterInstance.config().tags());
        try (Admin admin = this.clusterInstance.createAdminClient();){
            configResource = new ConfigResource(ConfigResource.Type.BROKER, "0");
            configs = (Map)admin.describeConfigs(Collections.singletonList(configResource)).all().get();
            Assertions.assertEquals((int)1, (int)configs.size());
            Assertions.assertEquals((Object)"200", (Object)((Config)configs.get(configResource)).get("queued.max.requests").value());
        }
        if (this.clusterInstance.type() == Type.KRAFT) {
            admin = Admin.create(Collections.singletonMap("bootstrap.controllers", this.clusterInstance.bootstrapControllers()));
            var2_4 = null;
            try {
                configResource = new ConfigResource(ConfigResource.Type.BROKER, "3000");
                configs = (Map)admin.describeConfigs(Collections.singletonList(configResource)).all().get();
                Assertions.assertEquals((int)1, (int)configs.size());
                Assertions.assertEquals((Object)"300", (Object)((Config)configs.get(configResource)).get("queued.max.requests").value());
            }
            catch (Throwable throwable) {
                var2_4 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_4 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_4.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}), @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, disksPerBroker=2)})
    public void testClusterTestWithDisksPerBroker() throws ExecutionException, InterruptedException {
        Admin admin = this.clusterInstance.createAdminClient();
        DescribeLogDirsResult result = admin.describeLogDirs(this.clusterInstance.brokerIds());
        ((Map)result.allDescriptions().get()).forEach((brokerId, logDirDescriptionMap) -> Assertions.assertEquals((int)this.clusterInstance.config().numDisksPerBroker(), (int)logDirDescriptionMap.size()));
    }

    @ClusterTest(autoStart=AutoStart.NO)
    public void testNoAutoStart() {
        Assertions.assertThrows(RuntimeException.class, this.clusterInstance::anyBrokerSocketServer);
        this.clusterInstance.start();
        Assertions.assertNotNull((Object)this.clusterInstance.anyBrokerSocketServer());
    }

    @ClusterTest
    public void testDefaults(ClusterInstance clusterInstance) {
        Assertions.assertEquals((Object)MetadataVersion.latestTesting(), (Object)clusterInstance.config().metadataVersion());
    }

    @ClusterTests(value={@ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer")}), @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer")}), @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer")}, tags={"disable-new-coordinator-and-enable-new-consumer-rebalance-coordinator"})})
    public void testSupportedNewGroupProtocols(ClusterInstance clusterInstance) {
        HashSet<GroupProtocol> supportedGroupProtocols = new HashSet<GroupProtocol>();
        supportedGroupProtocols.add(GroupProtocol.CLASSIC);
        supportedGroupProtocols.add(GroupProtocol.CONSUMER);
        Assertions.assertTrue((boolean)clusterInstance.supportedGroupProtocols().containsAll(supportedGroupProtocols));
        Assertions.assertEquals((int)2, (int)clusterInstance.supportedGroupProtocols().size());
    }

    @ClusterTests(value={@ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true")}), @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false")}), @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic")}), @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="true"), @ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic")}), @ClusterTest(types={Type.ZK, Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="group.coordinator.new.enable", value="false"), @ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic")}, tags={"disable-new-coordinator-and-disable-new-consumer-rebalance-coordinator"})})
    public void testNotSupportedNewGroupProtocols(ClusterInstance clusterInstance) {
        Assertions.assertTrue((boolean)clusterInstance.supportedGroupProtocols().contains(GroupProtocol.CLASSIC));
        Assertions.assertEquals((int)1, (int)clusterInstance.supportedGroupProtocols().size());
    }

    @ClusterTest(types={Type.ZK, Type.CO_KRAFT, Type.KRAFT}, brokers=4)
    public void testClusterAliveBrokers(ClusterInstance clusterInstance) throws Exception {
        clusterInstance.waitForReadyBrokers();
        clusterInstance.shutdownBroker(0);
        Assertions.assertFalse((boolean)clusterInstance.aliveBrokers().containsKey(0));
        Assertions.assertTrue((boolean)clusterInstance.brokers().containsKey(0));
        clusterInstance.startBroker(0);
        Assertions.assertTrue((boolean)clusterInstance.aliveBrokers().containsKey(0));
        Assertions.assertTrue((boolean)clusterInstance.brokers().containsKey(0));
    }
}

