/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005\n\u0001Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004a\u0001\u0001\u0006Ia\u0013\u0005\u0006C\u0002!\tA\u0019\u0005\u0006c\u0002!\tA\u0019\u0005\u0006g\u0002!\tA\u0019\u0005\u0006k\u0002!\tA\u0019\u0005\u0006o\u0002!\tA\u0019\u0005\u0006s\u0002!\tA\u0019\u0005\u0006w\u0002!\tA\u0019\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u0019y\b\u0001)A\u0005\u0003\"A\u0011\u0011\u0001\u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011B!\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b!I\u0011\u0011\f\u0001\u0012\u0002\u0013%\u00111\f\u0005\n\u0003c\u0002\u0011\u0013!C\u0005\u0003gBa!a\u001e\u0001\t\u0003\u0011\u0007BBA>\u0001\u0011\u0005!\r\u0003\u0004\u0002\u0000\u0001!\tA\u0019\u0005\u0007\u0003\u0007\u0003A\u0011\u00012\t\r\u0005\u001d\u0005\u0001\"\u0001c\u0011\u0019\tY\t\u0001C\u0001E\"1\u0011q\u0012\u0001\u0005\u0002\tDa!a%\u0001\t\u0003\u0011\u0007BBAL\u0001\u0011\u0005!\r\u0003\u0004\u0002\u001c\u0002!\tA\u0019\u0005\u0007\u0003?\u0003A\u0011\u00012\t\r\u0005\r\u0006\u0001\"\u0001c\u0011\u0019\t9\u000b\u0001C\u0001E\"1\u00111\u0016\u0001\u0005\u0002\tDq!a,\u0001\t\u0003\t\t\f\u0003\u0004\u0002\\\u0002!\tA\u0019\u0005\b\u0003?\u0004A\u0011AAq\u0011\u001d\tY\u000f\u0001C\u0001\u0003[DqAa\u0001\u0001\t\u0003\u0011)\u0001\u0003\u0004\u0003\u0010\u0001!\tA\u0019\u0005\u0007\u0005'\u0001A\u0011\u00012\t\r\t]\u0001\u0001\"\u0001c\u0011\u0019\u0011Y\u0002\u0001C\u0001E\"1!q\u0004\u0001\u0005\u0002\tDaAa\t\u0001\t\u0003\u0011\u0007B\u0002B\u0014\u0001\u0011\u0005!\r\u0003\u0004\u0003,\u0001!\tA\u0019\u0002\u0010'R|'/Y4f)>|G\u000eV3ti*\u0011\u0001'M\u0001\u0006i>|Gn\u001d\u0006\u0002e\u0005)1.\u00194lC\u000e\u00011C\u0001\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0010\t\u0003}\u0001i\u0011aL\u0001\u0019]\u0016<8+\u001a7g\u001b\u0006t\u0017mZ3e!J|\u0007/\u001a:uS\u0016\u001cH#A!\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015\u0001B;uS2T\u0011AR\u0001\u0005U\u00064\u0018-\u0003\u0002I\u0007\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u0017\u0005dGNR3biV\u0014Xm]\u000b\u0002\u0017B\u0019A*U*\u000e\u00035S!AT(\u0002\u0013%lW.\u001e;bE2,'B\u0001)8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003%6\u0013A\u0001T5tiB\u0011AKX\u0007\u0002+*\u0011akV\u0001\u0007G>lWn\u001c8\u000b\u0005aK\u0016AB:feZ,'O\u0003\u000235*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyVK\u0001\u0005GK\u0006$XO]3t\u00031\tG\u000e\u001c$fCR,(/Z:!\u0003i!Xm\u001d;D_:4\u0017n\u001a+p\u0019><G)\u001b:fGR|'/[3t)\u0005\u0019\u0007C\u0001\u001ce\u0013\t)wG\u0001\u0003V]&$\bFA\u0003h!\tAw.D\u0001j\u0015\tQ7.A\u0002ba&T!\u0001\\7\u0002\u000f),\b/\u001b;fe*\u0011a\u000eX\u0001\u0006UVt\u0017\u000e^\u0005\u0003a&\u0014A\u0001V3ti\u0006AC/Z:u\u0007>tg-[4U_2{w\rR5sK\u000e$xN]5fg^KG\u000f['fi\u0006dun\u001a#je\"\u0012aaZ\u0001 i\u0016\u001cH/\u00138g_\u000e{W.\\1oI>sW)\u001c9us\u0012K'/Z2u_JL\bFA\u0004h\u0003\u0005\"Xm\u001d;J]\u001a|7i\\7nC:$wJ\\'jgNLgn\u001a#je\u0016\u001cGo\u001c:zQ\tAq-\u0001\u0011uKN$\u0018J\u001c4p\u0007>lW.\u00198e\u001f:$\u0015N]3di>\u0014\u00180Q:GS2,\u0007FA\u0005h\u0003\u001d\"Xm\u001d;J]\u001a|w+\u001b;i\u001b&\u001cX.\u0019;dQ\u0016$G*Z4bGf\\\u0015MZ6b\u0007>tg-[4)\u0005)9\u0017!\t;fgRLeNZ8XSRDW*[:nCR\u001c\u0007.\u001a3L%\u00064GoQ8oM&<\u0007FA\u0006h\u0003u!WMZ1vYR\u001cF/\u0019;jGF+xN];n!J|\u0007/\u001a:uS\u0016\u001cX#A!\u0002=\u0011,g-Y;miN#\u0018\r^5d#V|'/^7Qe>\u0004XM\u001d;jKN\u0004\u0013A\b3fM\u0006,H\u000e\u001e#z]\u0006l\u0017nY)v_J,X\u000e\u0015:pa\u0016\u0014H/[3t\u0003}!WMZ1vYR$\u0015P\\1nS\u000e\fVo\u001c:v[B\u0013x\u000e]3si&,7\u000fI\u0001\u0011eVtgi\u001c:nCR\u001cu.\\7b]\u0012$\"\"!\u0003\u0002\u0010\u0005}\u00111EA(!\r1\u00141B\u0005\u0004\u0003\u001b9$aA%oi\"9\u0011\u0011\u0003\tA\u0002\u0005M\u0011AB:ue\u0016\fW\u000e\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"R\u0001\u0003S>LA!!\b\u0002\u0018\t)\")\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l\u0007BBA\u0011!\u0001\u0007\u0011)\u0001\u0006qe>\u0004XM\u001d;jKND\u0011\"!\n\u0011!\u0003\u0005\r!a\n\u0002\u001d\u0015DHO]1Be\u001e,X.\u001a8ugB1\u0011\u0011FA\u001d\u0003\u007fqA!a\u000b\u000269!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022M\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0007\u0005]r'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0012Q\b\u0002\u0004'\u0016\f(bAA\u001coA!\u0011\u0011IA%\u001d\u0011\t\u0019%!\u0012\u0011\u0007\u00055r'C\u0002\u0002H]\na\u0001\u0015:fI\u00164\u0017\u0002BA&\u0003\u001b\u0012aa\u0015;sS:<'bAA$o!I\u0011\u0011\u000b\t\u0011\u0002\u0003\u0007\u00111K\u0001\u0010S\u001etwN]3G_Jl\u0017\r\u001e;fIB\u0019a'!\u0016\n\u0007\u0005]sGA\u0004C_>dW-\u00198\u00025I,hNR8s[\u0006$8i\\7nC:$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u#\u0006BA\u0014\u0003?Z#!!\u0019\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003W:\u0014AC1o]>$\u0018\r^5p]&!\u0011qNA3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001beVtgi\u001c:nCR\u001cu.\\7b]\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003kRC!a\u0015\u0002`\u0005qC/Z:u\r>\u0014X.\u0019;Tk\u000e\u001cW-\u001a3t\u0013\u001a\fE\u000e\u001c#je\u0016\u001cGo\u001c:jKN\f%/Z!wC&d\u0017M\u00197fQ\t\u0019r-\u0001\u001auKN$hi\u001c:nCR\u001cVoY2fK\u0012\u001c\u0018JZ!u\u0019\u0016\f7\u000f^(oK\u0012K'/Z2u_JL\u0018j]!wC&d\u0017M\u00197fQ\t!r-A\u0011uKN$hi\u001c:nCR4\u0015-\u001b7t\u001f:\fEN]3bIf4uN]7biR,G\r\u000b\u0002\u0016O\u0006\u0019B/Z:u\u0013\u001etwN]3G_Jl\u0017\r\u001e;fI\"\u0012acZ\u0001.i\u0016\u001cHOR8s[\u0006$h)Y5mg&3\u0017\t\u001c7ESJ,7\r^8sS\u0016\u001c\u0018I]3V]\u00064\u0018-\u001b7bE2,\u0007FA\fh\u0003]!Xm\u001d;G_Jl\u0017\r\u001e$bS2\u001c\u0018J\u001c.l\u001b>$W\r\u000b\u0002\u0019O\u0006aB/Z:u\r>\u0014X.\u0019;XSRD'+\u001a7fCN,g+\u001a:tS>t\u0007FA\rh\u0003\u0015\"Xm\u001d;G_Jl\u0017\r^,ji\"\u0014V\r\\3bg\u00164VM]:j_:\f5OR3biV\u0014X\r\u000b\u0002\u001bO\u0006aB/Z:u\r>\u0014X.\u0019;XSRD\u0017J\u001c<bY&$g)Z1ukJ,\u0007FA\u000eh\u0003\u0019\"Xm\u001d;G_Jl\u0017\r^,ji\"LeN^1mS\u0012\\%+\u00194u-\u0016\u00148/[8o\u0019\u00164X\r\u001c\u0015\u00039\u001d\f1\u0006^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g.\u00118e\u0017J\u000bg\r\u001e,feNLwN\u001c\u0015\u0003;\u001d\f1\u0005^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g\u000eR3gCVdG\u000f\u000b\u0002\u001fO\u0006!D/Z:u\r>\u0014X.\u0019;XSRD'+\u001a7fCN,g+\u001a:tS>tG)\u001a4bk2$\u0018I\u001c3SK2,\u0017m]3WKJ\u001c\u0018n\u001c8)\u0005}9\u0017!\u000b;fgR4uN]7bi^KG\u000f[*uC:$\u0017\r\\8oK\u001ac\u0017mZ(o\u0005J|7.\u001a:GC&d7\u000f\u000b\u0002!O\u0006aB/Z:u\r>\u0014X.\u0019;XSRD7\u000b^1oI\u0006dwN\\3GY\u0006<GcA2\u00024\"9\u0011QW\u0011A\u0002\u0005M\u0013AF:fi.\u0013\u0018M\u001a;WKJ\u001c\u0018n\u001c8GK\u0006$XO]3)\u0007\u0005\nI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\tyl[\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005\r\u0017Q\u0018\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bfB\u0011\u0002H\u0006M\u0017Q\u001b\t\u0005\u0003\u0013\fy-\u0004\u0002\u0002L*!\u0011QZA_\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BAi\u0003\u0017\u00141BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002X\u0006e\u0017$\u0001\u0001\u001a\u0003\u0005\t!\b^3ti\u001a{'/\\1u/&$\bn\u0015;b]\u0012\fGn\u001c8f\r2\fw-\u00118e\u0013:LG/[1m\u0007>tGO]8mY\u0016\u00148O\u00127bO\u001a\u000b\u0017\u000e\\:)\u0005\t:\u0017\u0001\n;fgR4uN]7bi^KG\u000f[%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7feN4E.Y4\u0015\u0007\r\f\u0019\u000fC\u0004\u00026\u000e\u0002\r!a\u0015)\u0007\r\nI\fK\u0004$\u0003\u000f\f\u0019.!;-\t\u0005]\u0017\u0011\\\u0001Hi\u0016\u001cHOR8s[\u0006$x+\u001b;i_V$8\u000b^1uS\u000e\fVo\u001c:v[\u001a\u000b\u0017\u000e\\:XSRDw.\u001e;J]&$\u0018.\u00197D_:$(o\u001c7mKJ\u001cxJ\\\"p]R\u0014x\u000e\u001c7feR\u00191-a<\t\u000f\u0005EH\u00051\u0001\u0002@\u0005a\u0001O]8dKN\u001c(k\u001c7fg\"\u001aA%!/)\u000f\u0011\n9-a>\u0002z\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA~\u0003\u007f\f#!!@\u0002\u0015\r|g\u000e\u001e:pY2,'/\t\u0002\u0003\u0002\u0005\t\"M]8lKJd3m\u001c8ue>dG.\u001a:\u0002mQ,7\u000f\u001e$pe6\fGoV5uQ:{\u0017J\\5uS\u0006d7i\u001c8ue>dG.\u001a:t'V\u001c7-Z3eg>s7i\u001c8ue>dG.\u001a:\u0015\u0007\r\u00149\u0001C\u0004\u00026\u0016\u0002\r!a\u0015)\u0007\u0015\nI\fK\u0004&\u0003\u000f\f\u0019N!\u0004-\t\u0005]\u0017\u0011\\\u0001=i\u0016\u001cHOR8s[\u0006$x+\u001b;i\u001d>Le.\u001b;jC2\u001cuN\u001c;s_2dWM]:GY\u0006<\u0017I\u001c3Ti\u0006tG-\u00197p]\u00164E.Y4GC&d7\u000f\u000b\u0002'O\u0006!E/Z:u\r>\u0014X.\u0019;XSRDgj\\%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7feN4E.Y4B]\u0012Le.\u001b;jC2\u001cuN\u001c;s_2dWM]:GY\u0006<g)Y5mg\"\u0012qeZ\u0001Gi\u0016\u001cHOR8s[\u0006$x+\u001b;i_V$8\u000b^1uS\u000e\fVo\u001c:v[N+8mY3fIN<\u0016\u000e\u001e5pkRLe.\u001b;jC2\u001cuN\u001c;s_2dWM]:P]\n\u0013xn[3sQ\tAs-A\ruKN$(i\\8ugR\u0014\u0018\r]*de\u0006l'+Z2pe\u0012\u001c\bFA\u0015h\u0003\u0005\"Xm\u001d;TGJ\fWNU3d_J$7o\u00147e%\u0016dW-Y:f-\u0016\u00148/[8oQ\tQs-A\u000buKN$\b+\u0019:tK:\u000bW.Z!oI2+g/\u001a7)\u0005-:\u0017!\t;fgR\u0004\u0016M]:f\u001d\u0006lW-\u00118e\u0019\u00164X\r\\,ji\"tu.R9vC2\u001c\bF\u0001\u0017h\u0003\u0005\"Xm\u001d;QCJ\u001cXMT1nK\u0006sG\rT3wK2<\u0016\u000e\u001e5O_:+XNY3sQ\tis\rK\u0004\u0001\u0005c\u00119D!\u000f\u0011\u0007!\u0014\u0019$C\u0002\u00036%\u0014q\u0001V5nK>,H/A\u0003wC2,XMH\u0001)\u0001")
public class StorageToolTest {
    private final List<Features> allFeatures = Predef$.MODULE$.wrapRefArray((Object[])Features.FEATURES).toList();
    private final Properties defaultStaticQuorumProperties = new Properties();
    private final Properties defaultDynamicQuorumProperties;

    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo,/tmp/bar");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("node.id", "2");
        properties.setProperty("controller.quorum.voters", "2@localhost:9092");
        properties.setProperty("controller.listener.names", "PLAINTEXT");
        return properties;
    }

    public List<Features> allFeatures() {
        return this.allFeatures;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty("metadata.log.dir", "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(246).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedKRaftConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    public Properties defaultStaticQuorumProperties() {
        return this.defaultStaticQuorumProperties;
    }

    public Properties defaultDynamicQuorumProperties() {
        return this.defaultDynamicQuorumProperties;
    }

    private int runFormatCommand(ByteArrayOutputStream stream, Properties properties, Seq<String> extraArguments, boolean ignoreFormatted) {
        int n;
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            String configPathString = new File(tempDir.getAbsolutePath(), "format.props").toString();
            PropertiesUtils.writePropertiesFile((Properties)properties, (String)configPathString, (boolean)true);
            ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ"}));
            if (ignoreFormatted) {
                arguments.$plus$eq((Object)"--ignore-formatted");
            }
            arguments.$plus$eq((Object)"--config");
            arguments.$plus$eq((Object)configPathString);
            extraArguments.foreach((Function1 & Serializable)x$1 -> (ListBuffer)arguments.$plus$eq(x$1));
            n = StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
        }
        finally {
            Utils.delete((File)tempDir);
        }
        return n;
    }

    private Seq<String> runFormatCommand$default$3() {
        return Nil$.MODULE$;
    }

    private boolean runFormatCommand$default$4() {
        return false;
    }

    @Test
    public void testFormatSucceedsIfAllDirectoriesAreAvailable() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        ((IterableOnceOps)availableDirs.tail()).foreach((Function1 & Serializable)dir -> {
            StorageToolTest.$anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(stream, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneDirectoryIsAvailable() {
        File availableDir1 = TestUtils.tempDirectory(null, null);
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", new StringBuilder(1).append(availableDir1).append(",").append(unavailableDir1).toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertFalse((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting log directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatFailsOnAlreadyFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertTrue((boolean)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream2, properties, (Seq<String>)Nil$.MODULE$, false)).getMessage().contains("already formatted. Use --ignore-formatted to ignore this directory and format the others"));
    }

    @Test
    public void testIgnoreFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream2, properties, (Seq<String>)Nil$.MODULE$, true));
    }

    @Test
    public void testFormatFailsIfAllDirectoriesAreUnavailable() {
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        File unavailableDir2 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", new StringBuilder(1).append(unavailableDir1).append(",").append(unavailableDir2).toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"No available log directories to format.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false)).getMessage());
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir2}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatFailsInZkMode() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("zookeeper.connect", "localhost:2181");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false)).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.8-IV0", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionAsFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"metadata.version=20", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithInvalidFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Unsupported feature: non.existent.feature. Supported features are: kraft.version, transaction.version", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"non.existent.feature=20", (List)Nil$.MODULE$)), false)).getMessage());
    }

    @Test
    public void testFormatWithInvalidKRaftVersionLevel() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"No feature:kraft.version with feature level 999", (Object)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=999", (List)new .colon.colon((Object)"--standalone", (List)Nil$.MODULE$))), false)).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersionAndKRaftVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.7-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionDefault() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("inter.broker.protocol.version", "3.7");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)Nil$.MODULE$, false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV4"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionDefaultAndReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("inter.broker.protocol.version", "3.7");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.6-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), false));
        Assertions.assertTrue((boolean)stream.toString().contains("3.6-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithStandaloneFlagOnBrokerFails() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        Assertions.assertEquals((Object)"You can only use --standalone on a controller.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), false)).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithStandaloneFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithStandaloneFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithInitialControllersFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"controller", "broker,controller"})
    public void testFormatWithoutStaticQuorumFailsWithoutInitialControllersOnController(String processRoles) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        if (processRoles.contains("broker")) {
            properties.setProperty("listeners", "PLAINTEXT://:9092,CONTROLLER://:9093");
            properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092,CONTROLLER://127.0.0.1:9093");
        }
        properties.setProperty("process.roles", processRoles);
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), false)).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithNoInitialControllersSucceedsOnController(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--no-initial-controllers"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndStandaloneFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--standalone"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --standalone/-s: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --initial-controllers/-I: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithoutStaticQuorumSucceedsWithoutInitialControllersOnBroker() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("listeners", "PLAINTEXT://:9092");
        properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting metadata directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testBootstrapScramRecords() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), false));
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(((File)availableDirs.head()).toString(), Optional.empty()).read();
        List scramRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(bootstrapMetadata.records()).asScala().filter((Function1 & Serializable)apiMessageAndVersion -> BoxesRunTime.boxToBoolean((boolean)StorageToolTest.$anonfun$testBootstrapScramRecords$1(apiMessageAndVersion)))).map((Function1 & Serializable)apiMessageAndVersion -> (UserScramCredentialRecord)apiMessageAndVersion.message())).toList();
        Assertions.assertEquals((int)2, (int)scramRecords.size());
        Assertions.assertEquals((Object)"alice", (Object)((UserScramCredentialRecord)scramRecords.head()).name());
        Assertions.assertEquals((Object)"bob", (Object)((UserScramCredentialRecord)scramRecords.last()).name());
    }

    @Test
    public void testScramRecordsOldReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.4", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((Object)"SCRAM is only supported in metadata.version 3.5-IV2 or later.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), false)).getMessage());
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertEquals((Object)new Tuple2((Object)"foo.bar", (Object)BoxesRunTime.boxToShort((short)((short)56))), (Object)StorageTool$.MODULE$.parseNameAndLevel("foo.bar=56"));
    }

    @Test
    public void testParseNameAndLevelWithNoEquals() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version5: equals sign not found.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version5")).getMessage());
    }

    @Test
    public void testParseNameAndLevelWithNoNumber() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version=foo: unable to parse foo as a short.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version=foo")).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(ByteArrayOutputStream stream$1, File dir) {
        Assertions.assertTrue((boolean)stream$1.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting data directory %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dir}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream$1.toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testBootstrapScramRecords$1(ApiMessageAndVersion apiMessageAndVersion) {
        return apiMessageAndVersion.message() instanceof UserScramCredentialRecord;
    }

    public StorageToolTest() {
        this.defaultStaticQuorumProperties().setProperty("process.roles", "broker");
        this.defaultStaticQuorumProperties().setProperty("node.id", "0");
        this.defaultStaticQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultStaticQuorumProperties().setProperty("controller.quorum.voters", "100@localhost:9093");
        this.defaultDynamicQuorumProperties = new Properties();
        this.defaultDynamicQuorumProperties().setProperty("process.roles", "controller");
        this.defaultDynamicQuorumProperties().setProperty("node.id", "0");
        this.defaultDynamicQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultDynamicQuorumProperties().setProperty("controller.quorum.bootstrap.servers", "localhost:9093");
        this.defaultDynamicQuorumProperties().setProperty("listeners", "CONTROLLER://:9093");
        this.defaultDynamicQuorumProperties().setProperty("advertised.listeners", "CONTROLLER://127.0.0.1:9093");
        this.defaultDynamicQuorumProperties().setProperty("unstable.api.versions.enable", "true");
        this.defaultDynamicQuorumProperties().setProperty("unstable.feature.versions.enable", "true");
    }
}

