/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.KafkaConfig;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;

public class MetadataVersionConfigValidator
implements MetadataPublisher {
    private final String name;
    private final KafkaConfig config;
    private final FaultHandler faultHandler;

    public MetadataVersionConfigValidator(KafkaConfig config, FaultHandler faultHandler) {
        int id = config.brokerId();
        this.name = "MetadataVersionPublisher(id=" + id + ")";
        this.config = config;
        this.faultHandler = faultHandler;
    }

    public String name() {
        return this.name;
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null && delta.metadataVersionChanged().isPresent()) {
            this.onMetadataVersionChanged(newImage.features().metadataVersion());
        }
    }

    private void onMetadataVersionChanged(MetadataVersion metadataVersion) {
        try {
            this.config.validateWithMetadataVersion(metadataVersion);
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Broker configuration does not support the cluster MetadataVersion", t);
        }
    }
}

