/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r]h\u0001B8q\u0001UD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\r\u0003#\u0001!\u0011!Q\u0001\n\u0005M\u0011\u0011\u0004\u0005\u000b\u00037\u0001!\u0011!Q\u0001\n\u0005u\u0001BCA\u0012\u0001\t\u0005\t\u0015!\u0003\u0002&!Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0019\u0005M\u0002A!A!\u0002\u0013\t)$a\u000f\t\u0015\u0005u\u0002A!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013Bq!!\u0019\u0001\t\u0003\t\u0019\u0007\u0003\u0006\u0002x\u0001\u0011\r\u0011\"\u0001q\u0003sB\u0001b!\u000b\u0001A\u0003%\u00111\u0010\u0005\b\u0007W\u0001A\u0011KB\u0017\u0011\u001d\u0019)\u0004\u0001C)\u0007oAqa!\u0011\u0001\t#\u001a\u0019\u0005C\u0004\u0004H\u0001!\tf!\u0013\t\u000f\re\u0003\u0001\"\u0011\u0004\\!91\u0011\u0012\u0001\u0005B\r-\u0005bBAh\u0001\u0011%11\u0015\u0005\t\u0007S\u0003A\u0011\u00019\u0004,\"911\u0017\u0001\u0005\n\rU\u0006bBBe\u0001\u0011\u000531\u001a\u0005\n\u00073\u0004!\u0019!C)\u0003OD\u0001ba7\u0001A\u0003%\u0011\u0011\u001e\u0005\b\u0007;\u0004A\u0011IBp\u0011\u001d\u0019i\u000f\u0001C)\u0007_<q!!*q\u0011\u0003\t9K\u0002\u0004pa\"\u0005\u0011\u0011\u0016\u0005\b\u0003CZB\u0011AAY\r\u0019\t\u0019l\u0007!\u00026\"Q\u0011qZ\u000f\u0003\u0016\u0004%\t!!5\t\u0015\t\u0005UD!E!\u0002\u0013\t\u0019\u000e\u0003\u0006\u0003\u0004v\u0011)\u001a!C\u0001\u0005\u000bC!Ba%\u001e\u0005#\u0005\u000b\u0011\u0002BD\u0011)\u0011)*\bBK\u0002\u0013\u0005!Q\u0011\u0005\u000b\u0005/k\"\u0011#Q\u0001\n\t\u001d\u0005bBA1;\u0011\u0005!\u0011\u0014\u0005\b\u0005GkB\u0011\u0001BS\u0011%\u0011Y+HA\u0001\n\u0003\u0011i\u000bC\u0005\u00036v\t\n\u0011\"\u0001\u00038\"I!QZ\u000f\u0012\u0002\u0013\u0005!q\u001a\u0005\n\u0005'l\u0012\u0013!C\u0001\u0005\u001fD\u0011B!\u0002\u001e\u0003\u0003%\tEa\u0002\t\u0013\tMQ$!A\u0005\u0002\tU\u0001\"\u0003B\f;\u0005\u0005I\u0011\u0001Bk\u0011%\u0011)#HA\u0001\n\u0003\u00129\u0003C\u0005\u00036u\t\t\u0011\"\u0001\u0003Z\"I!Q\\\u000f\u0002\u0002\u0013\u0005#q\u001c\u0005\n\u0005wi\u0012\u0011!C!\u0005{A\u0011Ba\u0010\u001e\u0003\u0003%\tE!\u0011\t\u0013\t\rX$!A\u0005B\t\u0015x!\u0003Bu7\u0005\u0005\t\u0012\u0001Bv\r%\t\u0019lGA\u0001\u0012\u0003\u0011i\u000fC\u0004\u0002bQ\"\ta!\u0002\t\u0013\t}B'!A\u0005F\t\u0005\u0003\"CB\u0004i\u0005\u0005I\u0011QB\u0005\u0011%\u0019\t\u0002NA\u0001\n\u0003\u001b\u0019\u0002C\u0005\u0003DQ\n\t\u0011\"\u0003\u0003F\u0019I\u0011q[\u000e\u0011\u0002\u0007\u0005\u0012\u0011\u001c\u0005\b\u00037TD\u0011AAo\u0011\u001d\t)O\u000fC\u0001\u0003O<qa!\t\u001c\u0011\u0003\t9PB\u0004\u0002XnA\t!a=\t\u000f\u0005\u0005d\b\"\u0001\u0002v\u001e9\u0011\u0011  \t\u0002\u0006mhaBA\u0000}!\u0005%\u0011\u0001\u0005\b\u0003C\nE\u0011\u0001B\u0002\u0011%\u0011)!QA\u0001\n\u0003\u00129\u0001C\u0005\u0003\u0014\u0005\u000b\t\u0011\"\u0001\u0003\u0016!I!qC!\u0002\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005K\t\u0015\u0011!C!\u0005OA\u0011B!\u000eB\u0003\u0003%\tAa\u000e\t\u0013\tm\u0012)!A\u0005B\tu\u0002\"\u0003B \u0003\u0006\u0005I\u0011\tB!\u0011%\u0011\u0019%QA\u0001\n\u0013\u0011)eB\u0004\u0003NyB\tIa\u0014\u0007\u000f\tEc\b#!\u0003T!9\u0011\u0011\r'\u0005\u0002\tU\u0003bBAs\u0019\u0012\u0005\u0013q\u001d\u0005\n\u0005\u000ba\u0015\u0011!C!\u0005\u000fA\u0011Ba\u0005M\u0003\u0003%\tA!\u0006\t\u0013\t]A*!A\u0005\u0002\t]\u0003\"\u0003B\u0013\u0019\u0006\u0005I\u0011\tB\u0014\u0011%\u0011)\u0004TA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003<1\u000b\t\u0011\"\u0011\u0003>!I!q\b'\u0002\u0002\u0013\u0005#\u0011\t\u0005\n\u0005\u0007b\u0015\u0011!C\u0005\u0005\u000b:qAa\u0018?\u0011\u0003\u0013\tGB\u0004\u0002rzB\tI!\u001e\t\u000f\u0005\u0005\u0004\f\"\u0001\u0003x!9\u0011Q\u001d-\u0005B\u0005\u001d\b\"\u0003B\u00031\u0006\u0005I\u0011\tB\u0004\u0011%\u0011\u0019\u0002WA\u0001\n\u0003\u0011)\u0002C\u0005\u0003\u0018a\u000b\t\u0011\"\u0001\u0003z!I!Q\u0005-\u0002\u0002\u0013\u0005#q\u0005\u0005\n\u0005kA\u0016\u0011!C\u0001\u0005{B\u0011Ba\u000fY\u0003\u0003%\tE!\u0010\t\u0013\t}\u0002,!A\u0005B\t\u0005\u0003\"\u0003B\"1\u0006\u0005I\u0011\u0002B#\u000f\u001d\u0011\u0019G\u0010EA\u0005K2qAa\u001a?\u0011\u0003\u0013I\u0007C\u0004\u0002b\u0011$\tAa\u001b\t\u0013\t\u0015A-!A\u0005B\t\u001d\u0001\"\u0003B\nI\u0006\u0005I\u0011\u0001B\u000b\u0011%\u00119\u0002ZA\u0001\n\u0003\u0011i\u0007C\u0005\u0003&\u0011\f\t\u0011\"\u0011\u0003(!I!Q\u00073\u0002\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005w!\u0017\u0011!C!\u0005{A\u0011Ba\u0010e\u0003\u0003%\tE!\u0011\t\u0013\t\rC-!A\u0005\n\t\u0015\u0003\"CB\u00127E\u0005I\u0011AB\u0013\u0005e\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014X-\u00193\u000b\u0005E\u0014\u0018AB:feZ,'OC\u0001t\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001<\u0011\u0005]DX\"\u00019\n\u0005e\u0004(!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\rE\u0002}\u0003\u0017q1!`A\u0004!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001;\u0002\rq\u0012xn\u001c;?\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twM\u0003\u0003\u0002\n\u0005\r\u0011A\u00027fC\u0012,'\u000fE\u0002x\u0003+I1!a\u0006q\u00059aU-\u00193fe\u0016sG\rU8j]RL1!!\u0005y\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002x\u0003?I1!!\tq\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0006sKBd\u0017nY1NOJ\u00042a^A\u0014\u0013\r\tI\u0003\u001d\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\r9\u0018qF\u0005\u0004\u0003c\u0001(a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fE\u0002x\u0003oI1!!\u000fq\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/C\u0002\u00024a\faBZ3uG\"\u0014\u0015mY6PM\u001al5\u000f\u0005\u0003\u0002B\u0005\rSBAA\u0002\u0013\u0011\t)%a\u0001\u0003\u0007%sG/A\u000beSJ,7\r^8ss\u00163XM\u001c;IC:$G.\u001a:\u0011\t\u0005-\u0013QL\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u000511m\\7n_:T1!]A*\u0015\r\u0019\u0018Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u00037\n1a\u001c:h\u0013\u0011\ty&!\u0014\u0003+\u0011K'/Z2u_JLXI^3oi\"\u000bg\u000e\u001a7fe\u00061A(\u001b8jiz\"\"#!\u001a\u0002h\u0005%\u00141NA7\u0003_\n\t(a\u001d\u0002vA\u0011q\u000f\u0001\u0005\u0006u&\u0001\ra\u001f\u0005\b\u0003#I\u0001\u0019AA\n\u0011\u001d\tY\"\u0003a\u0001\u0003;Aq!a\t\n\u0001\u0004\t)\u0003C\u0004\u0002,%\u0001\r!!\f\t\u000f\u0005M\u0012\u00021\u0001\u00026!9\u0011QH\u0005A\u0002\u0005}\u0002\"CA$\u0013A\u0005\t\u0019AA%\u0003=\u0001(o\\7pi&|gn\u0015;bi\u0016\u001cXCAA>!!\ti(a#\u0002\u0010\u0006eUBAA@\u0015\u0011\t\t)a!\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001B;uS2T!!!#\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\u000byHA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!!%\u0002\u00166\u0011\u00111\u0013\u0006\u0005\u0003\u001f\n\u0019&\u0003\u0003\u0002\u0018\u0006M%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004\u00037kbbAAO59!\u0011qTAR\u001d\rq\u0018\u0011U\u0005\u0002g&\u0011\u0011O]\u0001\u001a%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG\r\u0005\u0002x7M\u00191$a+\u0011\t\u0005\u0005\u0013QV\u0005\u0005\u0003_\u000b\u0019A\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003O\u0013a\u0002\u0015:p[>$\u0018n\u001c8Ti\u0006$XmE\u0004\u001e\u0003W\u000b9,!0\u0011\t\u0005\u0005\u0013\u0011X\u0005\u0005\u0003w\u000b\u0019AA\u0004Qe>$Wo\u0019;\u0011\t\u0005}\u0016\u0011\u001a\b\u0005\u0003\u0003\f)MD\u0002\u007f\u0003\u0007L!!!\u0002\n\t\u0005\u001d\u00171A\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY-!4\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\t\u0005\u001d\u00171A\u0001\u0012e\u0016\f7o]5h]6,g\u000e^*uCR,WCAAj!\r\t)NO\u0007\u00027\t\t\"+Z1tg&<g.\\3oiN#\u0018\r^3\u0014\u0007i\nY+\u0001\u0004%S:LG\u000f\n\u000b\u0003\u0003?\u0004B!!\u0011\u0002b&!\u00111]A\u0002\u0005\u0011)f.\u001b;\u000235\f\u0017PY3J]\u000e|gn]5ti\u0016tG/T3uC\u0012\fG/Y\u000b\u0003\u0003S\u0004B!!\u0011\u0002l&!\u0011Q^A\u0002\u0005\u001d\u0011un\u001c7fC:LSA\u000f-e\u00032\u0013\u0001\"Q2dKB$X\rZ\n\u0004}\u0005-FCAA|!\r\t)NP\u0001\u0005\u001d>tW\rE\u0002\u0002~\u0006k\u0011A\u0010\u0002\u0005\u001d>tWmE\u0005B\u0003W\u000b\u0019.a.\u0002>R\u0011\u00111`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t%\u0001\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u0011qQ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u000e\t5\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA \u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0007\u0003\"A!\u0011\u0011\tB\u000f\u0013\u0011\u0011y\"a\u0001\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003$\u0015\u000b\t\u00111\u0001\u0002@\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u000b\u0011\r\t-\"\u0011\u0007B\u000e\u001b\t\u0011iC\u0003\u0003\u00030\u0005\r\u0011AC2pY2,7\r^5p]&!!1\u0007B\u0017\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005%(\u0011\b\u0005\n\u0005G9\u0015\u0011!a\u0001\u00057\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0012\u0011\t\t-!\u0011J\u0005\u0005\u0005\u0017\u0012iA\u0001\u0004PE*,7\r^\u0001\u0007#V,W/\u001a3\u0011\u0007\u0005uHJ\u0001\u0004Rk\u0016,X\rZ\n\n\u0019\u0006-\u00161[A\\\u0003{#\"Aa\u0014\u0015\t\tm!\u0011\f\u0005\n\u0005G\t\u0016\u0011!a\u0001\u0003\u007f!B!!;\u0003^!I!1E*\u0002\u0002\u0003\u0007!1D\u0001\t\u0003\u000e\u001cW\r\u001d;fIB\u0019\u0011Q -\u0002\u0013\u00153g-Z2uSZ,\u0007cAA\u007fI\nIQI\u001a4fGRLg/Z\n\nI\u0006-\u00161[A\\\u0003{#\"A!\u001a\u0015\t\tm!q\u000e\u0005\n\u0005GA\u0017\u0011!a\u0001\u0003\u007f!B!!;\u0003t!I!1\u00056\u0002\u0002\u0003\u0007!1D\n\n1\u0006-\u00161[A\\\u0003{#\"A!\u0019\u0015\t\tm!1\u0010\u0005\n\u0005Gi\u0016\u0011!a\u0001\u0003\u007f!B!!;\u0003\u0000!I!1E0\u0002\u0002\u0003\u0007!1D\u0001\u0013e\u0016\f7o]5h]6,g\u000e^*uCR,\u0007%A\u0004u_BL7-\u00133\u0016\u0005\t\u001d\u0005CBA!\u0005\u0013\u0013i)\u0003\u0003\u0003\f\u0006\r!AB(qi&|g\u000e\u0005\u0003\u0002\u0012\n=\u0015\u0002\u0002BI\u0003'\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%\u0001\u0006dkJ\u0014XM\u001c;ESJ\f1bY;se\u0016tG\u000fR5sAQA!1\u0014BO\u0005?\u0013\t\u000bE\u0002\u0002VvAq!a4%\u0001\u0004\t\u0019\u000eC\u0004\u0003\u0004\u0012\u0002\rAa\"\t\u000f\tUE\u00051\u0001\u0003\b\u0006qq/\u001b;i\u0003N\u001c\u0018n\u001a8nK:$H\u0003\u0002BN\u0005OCqA!+&\u0001\u0004\t\u0019.A\foK^$\u0015N\u001d*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uK\u0006!1m\u001c9z)!\u0011YJa,\u00032\nM\u0006\"CAhMA\u0005\t\u0019AAj\u0011%\u0011\u0019I\nI\u0001\u0002\u0004\u00119\tC\u0005\u0003\u0016\u001a\u0002\n\u00111\u0001\u0003\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B]U\u0011\t\u0019Na/,\u0005\tu\u0006\u0003\u0002B`\u0005\u0013l!A!1\u000b\t\t\r'QY\u0001\nk:\u001c\u0007.Z2lK\u0012TAAa2\u0002\u0004\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-'\u0011\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005#TCAa\"\u0003<\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aD\u0003\u0002B\u000e\u0005/D\u0011Ba\t-\u0003\u0003\u0005\r!a\u0010\u0015\t\u0005%(1\u001c\u0005\n\u0005Gq\u0013\u0011!a\u0001\u00057\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u0002Bq\u0011%\u0011\u0019cLA\u0001\u0002\u0004\ty$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\u00149\u000fC\u0005\u0003$I\n\t\u00111\u0001\u0003\u001c\u0005q\u0001K]8n_RLwN\\*uCR,\u0007cAAkiM)AGa<\u0003|Ba!\u0011\u001fB|\u0003'\u00149Ia\"\u0003\u001c6\u0011!1\u001f\u0006\u0005\u0005k\f\u0019!A\u0004sk:$\u0018.\\3\n\t\te(1\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u007f\u0007\u0007i!Aa@\u000b\t\r\u0005\u0011qQ\u0001\u0003S>LA!a3\u0003\u0000R\u0011!1^\u0001\u0006CB\u0004H.\u001f\u000b\t\u00057\u001bYa!\u0004\u0004\u0010!9\u0011qZ\u001cA\u0002\u0005M\u0007b\u0002BBo\u0001\u0007!q\u0011\u0005\b\u0005+;\u0004\u0019\u0001BD\u0003\u001d)h.\u00199qYf$Ba!\u0006\u0004\u001eA1\u0011\u0011\tBE\u0007/\u0001\"\"!\u0011\u0004\u001a\u0005M'q\u0011BD\u0013\u0011\u0019Y\"a\u0001\u0003\rQ+\b\u000f\\34\u0011%\u0019y\u0002OA\u0001\u0002\u0004\u0011Y*A\u0002yIA\n\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u00111q\u0005\u0016\u0005\u0003\u0013\u0012Y,\u0001\tqe>lw\u000e^5p]N#\u0018\r^3tA\u0005YA.\u0019;fgR,\u0005o\\2i)\u0011\u0019yc!\r\u0011\r\u0005\u0005#\u0011RA \u0011\u001d\u0019\u0019\u0004\u0004a\u0001\u0003\u001f\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\t\re2q\b\t\u0005\u0003\u0003\u001aY$\u0003\u0003\u0004>\u0005\r!\u0001\u0002'p]\u001eDqaa\r\u000e\u0001\u0004\ty)\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0004:\r\u0015\u0003bBB\u001a\u001d\u0001\u0007\u0011qR\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBB&\u0007'\u001a)\u0006\u0005\u0004\u0002B\t%5Q\n\t\u0005\u0003\u0017\u001ay%\u0003\u0003\u0004R\u00055#AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0007gy\u0001\u0019AAH\u0011\u001d\u00199f\u0004a\u0001\u0003\u007f\tQ!\u001a9pG\"\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fGCCB/\u0007g\u001a)h!\u001f\u0004~A1\u0011\u0011\tBE\u0007?\u0002Ba!\u0019\u0004p5\u001111\r\u0006\u0005\u0007K\u001a9'A\u0002m_\u001eTAa!\u001b\u0004l\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0007[\n\u0019&A\u0004ti>\u0014\u0018mZ3\n\t\rE41\r\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\rM\u0002\u00031\u0001\u0002\u0010\"91q\u000f\tA\u0002\re\u0012a\u00034fi\u000eDwJ\u001a4tKRDqaa\u001f\u0011\u0001\u0004\ty$\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0007\u007f\u0002\u0002\u0019ABA\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!11QBC\u001b\u0005\u0001\u0011bABDq\nIa)\u001a;dQ\u0012\u000bG/Y\u0001\u0011e\u0016lwN^3QCJ$\u0018\u000e^5p]N$Ba!$\u0004\u001aBA!1FBH\u0003\u001f\u001b\u0019*\u0003\u0003\u0004\u0012\n5\"aA'baB\u0019qo!&\n\u0007\r]\u0005OA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0004\u001cF\u0001\ra!(\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bAa\u000b\u0004 \u0006=\u0015\u0002BBQ\u0005[\u00111aU3u)\u0011\u0019)ka*\u0011\u0007\u0005m%\bC\u0004\u00044I\u0001\r!a$\u0002/U\u0004H-\u0019;f%\u0016\f7o]5h]6,g\u000e^*uCR,GCBAp\u0007[\u001by\u000bC\u0004\u00044M\u0001\r!a$\t\u000f\rE6\u00031\u0001\u0004&\u0006)1\u000f^1uK\u0006IR.Y=cKB\u0013x.\\8uK\u001a+H/\u001e:f%\u0016\u0004H.[2b)\u0019\u0011Yba.\u0004:\"911\u0007\u000bA\u0002\u0005=\u0005bBB^)\u0001\u00071QX\u0001\na\u0006\u0014H/\u001b;j_:\u0004Baa0\u0004F6\u00111\u0011\u0019\u0006\u0004\u0007\u0007\u0014\u0018aB2mkN$XM]\u0005\u0005\u0007\u000f\u001c\tMA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$Ba!(\u0004N\"91qZ\u000bA\u0002\rE\u0017AE5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uKN\u0004\u0002Ba\u000b\u0004\u0010\u0006=51\u001b\t\u0004o\u000eU\u0017bABla\n\t\u0012J\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005}7\u0011]Br\u0011\u001d\u0019\u0019\u0004\u0007a\u0001\u0003\u001fCqa!:\u0019\u0001\u0004\u00199/A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\r98\u0011^\u0005\u0004\u0007W\u0004(!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!a8\u0004r\u000eM\bbBB\u001a3\u0001\u0007\u0011q\u0012\u0005\b\u0007kL\u0002\u0019AB\u001d\u0003\u0019ygMZ:fi\u0002")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;
    private final boolean isOffsetForLeaderEpochSupported;

    public static DirectoryEventHandler $lessinit$greater$default$8() {
        return DirectoryEventHandler.NOOP;
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true, partitionLeaderEpoch) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler) : directoryEventHandler != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                void var3_3;
                void var4_4;
                void var5_5;
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(null);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                if (var5_5.isDefined() && var4_4.isDefined() && var3_3.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition((Uuid)var4_4.get(), topicPartition.partition()), (Uuid)var5_5.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.log.debug(new StringBuilder(47).append("Updating future replica ").append(topicPartition).append(" reassignment state to ").append(state).toString());
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(27).append("Topic ").append(topicPartition.topic()).append(" does not have an ID.").toString());
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1<UnifiedLog, BoxedUnit>)(Function1 & Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.log.trace("Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError((Object)reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    Option<Uuid> topicId = ((InitialFetchState)x0$2._2()).topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(null);
            });
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$1, UnifiedLog x$2) {
        Uuid targetDir = (Uuid)partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$1.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, int fetchBackOffMs, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        super(name, name, leader, failedPartitions, new TierStateMachine(leader, replicaMgr, true), fetchBackOffMs, false, brokerTopicStats);
        this.promotionStates = new ConcurrentHashMap();
        this.isOffsetForLeaderEpochSupported = true;
    }

    public static class PromotionState
    implements Product,
    Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        public String productPrefix() {
            return "PromotionState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "reassignmentState";
                }
                case 1: {
                    return "topicId";
                }
                case 2: {
                    return "currentDir";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PromotionState)) break block3;
                    PromotionState promotionState = (PromotionState)x$1;
                    ReassignmentState reassignmentState = this.reassignmentState();
                    ReassignmentState reassignmentState2 = promotionState.reassignmentState();
                    if (reassignmentState != null ? !reassignmentState.equals(reassignmentState2) : reassignmentState2 != null) break block3;
                    Option<Uuid> option = this.topicId();
                    Option<Uuid> option2 = promotionState.topicId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<Uuid> option3 = this.currentDir();
                    Option<Uuid> option4 = promotionState.currentDir();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !promotionState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$((Product)this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

