/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function2;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\u0007\u000f\u0001UAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005\u0002\u0005BQA\u0015\u0001\u0005\u0002MCQ!\u0017\u0001\u0005\u0002iCQ\u0001\u0019\u0001\u0005\u0002\u0005DQa\u001a\u0001\u0005\u0002!DQA\u001c\u0001\u0005\u0002=DQ!\u001e\u0001\u0005\u0002YDQ\u0001 \u0001\u0005\u0002uDq!a\u0002\u0001\t\u0013\tI\u0001C\u0004\u0002\b\u0001!I!a\u0016\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b\ti\u0002\u000b\\1j]R,\u0007\u0010^\"p]N,X.\u001a:DC2d'-Y2l)\u0016\u001cHO\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012!B6bM.\f'\"A\n\u0002\u0017%tG/Z4sCRLwN\\\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u00103)\t\u0011#\u0003\u0002\u001c1\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\b\u0002oQ,7\u000f^\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJ\f5o]5h]>s\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\r\u0011\u0003&\u000e\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0003*\u0005\u0001\u0007!&\u0001\u0004rk>\u0014X/\u001c\t\u0003WIr!\u0001\f\u0019\u0011\u00055\"S\"\u0001\u0018\u000b\u0005=\"\u0012A\u0002\u001fs_>$h(\u0003\u00022I\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\tD\u0005C\u00037\u0005\u0001\u0007!&A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0005\u0005a\"U\t\u0005\u0002:\u00056\t!H\u0003\u0002<y\u00051\u0001/\u0019:b[NT!!\u0010 \u0002\u000f),\b/\u001b;fe*\u0011q\bQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rS$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u00051\u0015AK>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{::'o\\;q!J|Go\\2pYvZ\u0018' \u0015\u0005\u0005!su\n\u0005\u0002J\u00196\t!J\u0003\u0002Lu\u0005A\u0001O]8wS\u0012,'/\u0003\u0002N\u0015\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\n\u0001+I\u0001R\u0003):W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f1\b^3ti\u000e{gn];nKJ\u0014VMY1mC:\u001cW\rT5ti\u0016tWM]!tg&<g.\\3oi>s\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\r\u0011C+\u0016\u0005\u0006S\r\u0001\rA\u000b\u0005\u0006m\r\u0001\rA\u000b\u0015\u0005\u0007a\"U\t\u000b\u0003\u0004\u0011:CF&\u0001)\u0002\u0003R,7\u000f^\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJ\u0014UmZ5o]&twm\u00144gg\u0016$8o\u00148QCJ$\u0018\u000e^5p]N\f5o]5h]\u0016$Gc\u0001\u0012\\9\")\u0011\u0006\u0002a\u0001U!)a\u0007\u0002a\u0001U!\"A\u0001\u000f#FQ\u0011!\u0001JT0-\u0003A\u000ba\u0007^3ti\u000e{gn];nKJ\u0014VMY1mC:\u001cW\rT5ti\u0016tWM]!tg&<gn\u00148QCJ$\u0018\u000e^5p]N\u0014VM^8lK\u0012$2A\t2d\u0011\u0015IS\u00011\u0001+\u0011\u00151T\u00011\u0001+Q\u0011)\u0001\bR#)\t\u0015AeJ\u001a\u0017\u0002!\u0006QD/Z:u\u0007>t7/^7feJ+'-\u00197b]\u000e,G*[:uK:,'/Q:tS\u001etW.\u001a8u\u001f:\u0004\u0016M\u001d;ji&|gn\u001d*fm>\\W\r\u001a\u000b\u0004E%T\u0007\"B\u0015\u0007\u0001\u0004Q\u0003\"\u0002\u001c\u0007\u0001\u0004Q\u0003\u0006\u0002\u00049\t\u0016CCA\u0002%O[2\n\u0001+\u0001!uKN$8i\u001c8tk6,'OU3cC2\fgnY3MSN$XM\\3s\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fiN|e\u000eU1si&$\u0018n\u001c8t%\u00164xn[3e)\r\u0011\u0003/\u001d\u0005\u0006S\u001d\u0001\rA\u000b\u0005\u0006m\u001d\u0001\rA\u000b\u0015\u0005\u000fa\"U\t\u000b\u0003\b\u0011:#H&\u0001)\u0002\u0007R,7\u000f^$fiB{7/\u001b;j_:|eMT3xYf\f5o]5h]\u0016$\u0007+\u0019:uSRLwN\\(o!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,GmQ1mY\n\f7m\u001b\u000b\u0004E]D\b\"B\u0015\t\u0001\u0004Q\u0003\"\u0002\u001c\t\u0001\u0004Q\u0003\u0006\u0002\u00059\t\u0016CC\u0001\u0003%Ow2\n\u0001+\u0001&uKN$8+Z3l!>\u001c\u0018\u000e^5p]\u0006sG\rU1vg\u0016tUm\u001e7z\u0003N\u001c\u0018n\u001a8fIB\u000b'\u000f^5uS>twJ\u001c)beRLG/[8og\u0006\u001b8/[4oK\u0012\u001c\u0015\r\u001c7cC\u000e\\Gc\u0001\u0012\u007f\u007f\")\u0011&\u0003a\u0001U!)a'\u0003a\u0001U!\"\u0011\u0002\u000f#FQ\u0015I\u0001JTA\u0003Y\u0005\u0001\u0016a\u0007;sS\u001e<WM](o!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rF\u0003#\u0003\u0017\t\t\u0003C\u0004\u0002\u000e)\u0001\r!a\u0004\u0002\u0005Q\u0004\b\u0003BA\t\u0003;i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007G>lWn\u001c8\u000b\u0007E\tIBC\u0002\u0002\u001c\u0001\u000ba!\u00199bG\",\u0017\u0002BA\u0010\u0003'\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002$)\u0001\r!!\n\u0002\u000f\u0015DXmY;uKBA1%a\n\u0002,\u0005\u001d#%C\u0002\u0002*\u0011\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0011\u00055\u0012qGA\u001e\u0003wi!!a\f\u000b\t\u0005E\u00121G\u0001\tG>t7/^7fe*!\u0011QGA\f\u0003\u001d\u0019G.[3oiNLA!!\u000f\u00020\tA1i\u001c8tk6,'\u000fE\u0003$\u0003{\t\t%C\u0002\u0002@\u0011\u0012Q!\u0011:sCf\u00042aIA\"\u0013\r\t)\u0005\n\u0002\u0005\u0005f$X\r\u0005\u0004\u0002J\u0005M\u0013qB\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005!Q\u000f^5m\u0015\t\t\t&\u0001\u0003kCZ\f\u0017\u0002BA+\u0003\u0017\u0012!bQ8mY\u0016\u001cG/[8o)\u001d\u0011\u0013\u0011LA.\u0003;Bq!!\u0004\f\u0001\u0004\ty\u0001C\u0004\u00022-\u0001\r!a\u000b\t\u000f\u0005\r2\u00021\u0001\u0002&\u0005QBO]5hO\u0016\u0014xJ\u001c)beRLG/[8ogJ+go\\6fIR)!%a\u0019\u0002f!9\u0011Q\u0002\u0007A\u0002\u0005=\u0001bBA\u0012\u0019\u0001\u0007\u0011Q\u0005")
public class PlaintextConsumerCallbackTest
extends AbstractConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerRebalanceListenerAssignOnPartitionsAssigned(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsAssigned(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$1) -> {
            PlaintextConsumerCallbackTest.$anonfun$testConsumerRebalanceListenerAssignOnPartitionsAssigned$1(tp, consumer, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerRebalanceListenerAssignmentOnPartitionsAssigned(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsAssigned(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$2) -> {
            PlaintextConsumerCallbackTest.$anonfun$testConsumerRebalanceListenerAssignmentOnPartitionsAssigned$1(tp, consumer, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerRebalanceListenerBeginningOffsetsOnPartitionsAssigned(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsAssigned(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$3) -> {
            PlaintextConsumerCallbackTest.$anonfun$testConsumerRebalanceListenerBeginningOffsetsOnPartitionsAssigned$1(tp, consumer, x$3);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerRebalanceListenerAssignOnPartitionsRevoked(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsRevoked(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$4) -> {
            PlaintextConsumerCallbackTest.$anonfun$testConsumerRebalanceListenerAssignOnPartitionsRevoked$1(tp, consumer, x$4);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerRebalanceListenerAssignmentOnPartitionsRevoked(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsRevoked(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$5) -> {
            PlaintextConsumerCallbackTest.$anonfun$testConsumerRebalanceListenerAssignmentOnPartitionsRevoked$1(tp, consumer, x$5);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerRebalanceListenerBeginningOffsetsOnPartitionsRevoked(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsRevoked(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$6) -> {
            PlaintextConsumerCallbackTest.$anonfun$testConsumerRebalanceListenerBeginningOffsetsOnPartitionsRevoked$1(tp, consumer, x$6);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testGetPositionOfNewlyAssignedPartitionOnPartitionsAssignedCallback(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.triggerOnPartitionsAssigned(tp, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$7) -> {
            PlaintextConsumerCallbackTest.$anonfun$testGetPositionOfNewlyAssignedPartitionOnPartitionsAssignedCallback$1(tp, consumer, x$7);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSeekPositionAndPauseNewlyAssignedPartitionOnPartitionsAssignedCallback(String quorum, String groupProtocol) {
        Consumer consumer2 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long startingOffset = 100L;
        long totalRecords = 120L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        this.triggerOnPartitionsAssigned(this.tp(), consumer2, (Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit>)(Function2 & Serializable)(consumer, x$8) -> {
            PlaintextConsumerCallbackTest.$anonfun$testSeekPositionAndPauseNewlyAssignedPartitionOnPartitionsAssignedCallback$1(this, startingOffset, consumer, x$8);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)consumer2.paused().contains(this.tp()));
        consumer2.resume(Arrays.asList(this.tp()));
        this.consumeAndVerifyRecords(consumer2, (int)(totalRecords - startingOffset), (int)startingOffset, (int)startingOffset, startingOffset, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
    }

    private void triggerOnPartitionsAssigned(TopicPartition tp, Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit> execute) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.triggerOnPartitionsAssigned(tp, consumer, execute);
    }

    private void triggerOnPartitionsAssigned(TopicPartition tp, Consumer<byte[], byte[]> consumer, Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit> execute) {
        AtomicBoolean partitionsAssigned = new AtomicBoolean(false);
        consumer.subscribe(Arrays.asList(this.topic()), new ConsumerRebalanceListener(null, tp, execute, consumer, partitionsAssigned){
            private final TopicPartition tp$8;
            private final Function2 execute$1;
            private final Consumer consumer$4;
            private final AtomicBoolean partitionsAssigned$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (partitions.contains(this.tp$8)) {
                    this.execute$1.apply((Object)this.consumer$4, partitions);
                    this.partitionsAssigned$1.set(true);
                    return;
                }
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.tp$8 = tp$8;
                this.execute$1 = execute$1;
                this.consumer$4 = consumer$4;
                this.partitionsAssigned$1 = partitionsAssigned$1;
            }
        });
        long pollUntilTrue_waitTimeMs = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (partitionsAssigned.get()) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerCallbackTest.$anonfun$triggerOnPartitionsAssigned$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    private void triggerOnPartitionsRevoked(TopicPartition tp, Function2<Consumer<byte[], byte[]>, Collection<TopicPartition>, BoxedUnit> execute) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AtomicBoolean partitionsAssigned = new AtomicBoolean(false);
        AtomicBoolean partitionsRevoked = new AtomicBoolean(false);
        consumer.subscribe(Arrays.asList(this.topic()), new ConsumerRebalanceListener(null, tp, partitionsAssigned, execute, consumer, partitionsRevoked){
            private final TopicPartition tp$9;
            private final AtomicBoolean partitionsAssigned$2;
            private final Function2 execute$2;
            private final Consumer consumer$5;
            private final AtomicBoolean partitionsRevoked$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (partitions.contains(this.tp$9)) {
                    this.partitionsAssigned$2.set(true);
                    return;
                }
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (partitions.contains(this.tp$9)) {
                    this.execute$2.apply((Object)this.consumer$5, partitions);
                    this.partitionsRevoked$1.set(true);
                    return;
                }
            }
            {
                this.tp$9 = tp$9;
                this.partitionsAssigned$2 = partitionsAssigned$2;
                this.execute$2 = execute$2;
                this.consumer$5 = consumer$5;
                this.partitionsRevoked$1 = partitionsRevoked$1;
            }
        });
        long pollUntilTrue_waitTimeMs = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (partitionsAssigned.get()) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerCallbackTest.$anonfun$triggerOnPartitionsRevoked$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        consumer.close();
        Assertions.assertTrue((boolean)partitionsRevoked.get());
    }

    public static final /* synthetic */ void $anonfun$testConsumerRebalanceListenerAssignOnPartitionsAssigned$1(TopicPartition tp$1, Consumer consumer, Collection x$1) {
        Assertions.assertEquals((Object)((Exception)Assertions.assertThrows(IllegalStateException.class, () -> consumer.assign(Collections.singletonList(tp$1)))).getMessage(), (Object)"Subscription to topics, partitions and pattern are mutually exclusive");
    }

    public static final /* synthetic */ void $anonfun$testConsumerRebalanceListenerAssignmentOnPartitionsAssigned$1(TopicPartition tp$2, Consumer consumer, Collection x$2) {
        Assertions.assertTrue((boolean)consumer.assignment().contains(tp$2));
    }

    public static final /* synthetic */ void $anonfun$testConsumerRebalanceListenerBeginningOffsetsOnPartitionsAssigned$1(TopicPartition tp$3, Consumer consumer, Collection x$3) {
        Map map = consumer.beginningOffsets(Collections.singletonList(tp$3));
        Assertions.assertTrue((boolean)map.containsKey(tp$3));
        Assertions.assertEquals((long)0L, (Long)((Long)map.get(tp$3)));
    }

    public static final /* synthetic */ void $anonfun$testConsumerRebalanceListenerAssignOnPartitionsRevoked$1(TopicPartition tp$4, Consumer consumer, Collection x$4) {
        Assertions.assertEquals((Object)((Exception)Assertions.assertThrows(IllegalStateException.class, () -> consumer.assign(Collections.singletonList(tp$4)))).getMessage(), (Object)"Subscription to topics, partitions and pattern are mutually exclusive");
    }

    public static final /* synthetic */ void $anonfun$testConsumerRebalanceListenerAssignmentOnPartitionsRevoked$1(TopicPartition tp$5, Consumer consumer, Collection x$5) {
        Assertions.assertTrue((boolean)consumer.assignment().contains(tp$5));
    }

    public static final /* synthetic */ void $anonfun$testConsumerRebalanceListenerBeginningOffsetsOnPartitionsRevoked$1(TopicPartition tp$6, Consumer consumer, Collection x$6) {
        Map map = consumer.beginningOffsets(Collections.singletonList(tp$6));
        Assertions.assertTrue((boolean)map.containsKey(tp$6));
        Assertions.assertEquals((long)0L, (Long)((Long)map.get(tp$6)));
    }

    public static final /* synthetic */ void $anonfun$testGetPositionOfNewlyAssignedPartitionOnPartitionsAssignedCallback$1(TopicPartition tp$7, Consumer consumer, Collection x$7) {
        Assertions.assertDoesNotThrow(() -> BoxesRunTime.boxToLong((long)consumer.position(tp$7)));
    }

    public static final /* synthetic */ void $anonfun$testSeekPositionAndPauseNewlyAssignedPartitionOnPartitionsAssignedCallback$1(PlaintextConsumerCallbackTest $this, long startingOffset$1, Consumer consumer, Collection x$8) {
        consumer.seek($this.tp(), startingOffset$1);
        consumer.pause(Arrays.asList($this.tp()));
    }

    public static final /* synthetic */ String $anonfun$triggerOnPartitionsAssigned$2() {
        return "Timed out before expected rebalance completed";
    }

    public static final /* synthetic */ String $anonfun$triggerOnPartitionsRevoked$2() {
        return "Timed out before expected rebalance completed";
    }
}

