/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005!2Aa\u0001\u0003\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/\t\tB)\u001a7bs\u0016$g)\u001e;ve\u0016$Vm\u001d;\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005)1.\u00194lC*\t\u0011\"A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0015!\t)\u0002!D\u0001\u0005\u0003E!Xm\u001d;EK2\f\u00170\u001a3GkR,(/\u001a\u000b\u00021A\u0011Q\"G\u0005\u000359\u0011A!\u00168ji\"\u0012!\u0001\b\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%A\u0004kkBLG/\u001a:\u000b\u0005\r\"\u0013!\u00026v]&$(\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(=\t!A+Z:u\u0001")
public class DelayedFutureTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        try {
            AtomicInteger result = new AtomicInteger();
            Assertions.assertFalse((boolean)DelayedFutureTest.hasExecutorThread$1(purgatoryName), (String)"Unnecessary thread created");
            .colon.colon futures1 = new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)10)), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)11)), (List)Nil$.MODULE$));
            Assertions.assertTrue((boolean)purgatory.tryCompleteElseWatch(100000L, (Seq)futures1, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedFutureTest.$anonfun$testDelayedFuture$5((List)futures1, result))).isCompleted(), (String)"r1 not completed");
            Assertions.assertEquals((int)21, (int)result.get());
            Assertions.assertFalse((boolean)DelayedFutureTest.hasExecutorThread$1(purgatoryName), (String)"Unnecessary thread created");
            result.set(-1);
            .colon.colon futures2 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
            DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures2, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedFutureTest.$anonfun$testDelayedFuture$6((List)futures2, result)));
            Assertions.assertFalse((boolean)r2.isCompleted(), (String)"r2 should be incomplete");
            ((CompletableFuture)futures2.head()).complete(Predef$.MODULE$.int2Integer(20));
            Assertions.assertFalse((boolean)r2.isCompleted());
            Assertions.assertEquals((int)-1, (int)result.get());
            ((CompletableFuture)futures2.apply(1)).complete(Predef$.MODULE$.int2Integer(21));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!r2.isCompleted()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DelayedFutureTest.$anonfun$testDelayedFuture$8());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!DelayedFutureTest.$anonfun$testDelayedFuture$9(result)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)DelayedFutureTest.$anonfun$testDelayedFuture$10());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)DelayedFutureTest.hasExecutorThread$1(purgatoryName), (String)"Thread not created for executing delayed task");
            result.set(-1);
            .colon.colon futures3 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)31)), (List)Nil$.MODULE$));
            DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures3, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedFutureTest.$anonfun$testDelayedFuture$11((List)futures3, result)));
            Assertions.assertFalse((boolean)r3.isCompleted(), (String)"r3 should be incomplete");
            Assertions.assertEquals((int)-1, (int)result.get());
            ((CompletableFuture)futures3.head()).complete(Predef$.MODULE$.int2Integer(30));
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!r3.isCompleted()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)DelayedFutureTest.$anonfun$testDelayedFuture$13());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            long l4 = 100L;
            long waitUntilTrue_waitTimeMs4 = 15000L;
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!DelayedFutureTest.$anonfun$testDelayedFuture$14(result)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                    Assertions.fail((String)DelayedFutureTest.$anonfun$testDelayedFuture$15());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
            }
            result.set(-1);
            long start = Time.SYSTEM.hiResClockMs();
            long expirationMs = 2000L;
            .colon.colon futures4 = new .colon.colon(new CompletableFuture(), (List)new .colon.colon(new CompletableFuture(), (List)Nil$.MODULE$));
            DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (Seq)futures4, (Function0)((JFunction0.mcV.sp & Serializable)() -> DelayedFutureTest.$anonfun$testDelayedFuture$16((List)futures4, result)));
            ((CompletableFuture)futures4.head()).complete(Predef$.MODULE$.int2Integer(40));
            long l5 = 100L;
            long waitUntilTrue_waitTimeMs5 = 15000L;
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!DelayedFutureTest.$anonfun$testDelayedFuture$17((List)futures4)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                    Assertions.fail((String)DelayedFutureTest.$anonfun$testDelayedFuture$18());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)r4.isCompleted(), (String)"r4 not completed after timeout");
            long elapsed = Time.SYSTEM.hiResClockMs() - start;
            Assertions.assertTrue((elapsed >= expirationMs ? 1 : 0) != 0, (String)("Time for expiration " + elapsed + " should at least " + expirationMs));
            Assertions.assertEquals((int)40, (Integer)((Integer)((CompletableFuture)futures4.head()).get()));
            Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> DelayedFutureTest.$anonfun$testDelayedFuture$19((List)futures4)).getCause().getClass());
            Assertions.assertEquals((int)40, (int)result.get());
        }
        finally {
            purgatory.shutdown();
        }
    }

    private static final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$1 -> x$1.getName())).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("DelayedExecutor-" + purgatoryName$1)));
    }

    public static final /* synthetic */ int $anonfun$testDelayedFuture$4(CompletableFuture x$4) {
        return (Integer)x$4.get();
    }

    private static final void updateResult$1(List futures, AtomicInteger result$1) {
        result$1.set(BoxesRunTime.unboxToInt((Object)futures.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isCompletedExceptionally())).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)DelayedFutureTest.$anonfun$testDelayedFuture$4(x$4))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$5(List futures1$1, AtomicInteger result$1) {
        DelayedFutureTest.updateResult$1(futures1$1, result$1);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$6(List futures2$1, AtomicInteger result$1) {
        DelayedFutureTest.updateResult$1(futures2$1, result$1);
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$8() {
        return "r2 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$9(AtomicInteger result$1) {
        return result$1.get() == 41;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$10() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$11(List futures3$1, AtomicInteger result$1) {
        DelayedFutureTest.updateResult$1(futures3$1, result$1);
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$13() {
        return "r3 not completed";
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$14(AtomicInteger result$1) {
        return result$1.get() == 61;
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$15() {
        return "callback not invoked";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$16(List futures4$1, AtomicInteger result$1) {
        DelayedFutureTest.updateResult$1(futures4$1, result$1);
    }

    public static final /* synthetic */ boolean $anonfun$testDelayedFuture$17(List futures4$1) {
        return ((CompletableFuture)futures4$1.apply(1)).isDone();
    }

    public static final /* synthetic */ String $anonfun$testDelayedFuture$18() {
        return "r4 futures not expired";
    }

    public static final /* synthetic */ void $anonfun$testDelayedFuture$19(List futures4$1) {
        ((CompletableFuture)futures4$1.apply(1)).get();
    }
}

