/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import kafka.controller.ReplicaAssignment;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u0013&\u0001)BQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005BYBq!\u0010\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004?\u0001\u0001\u0006Ia\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u0011\u0019I\u0005\u0001)A\u0005\u0003\"9!\n\u0001b\u0001\n\u0003Y\u0005B\u0002.\u0001A\u0003%A\nC\u0004\\\u0001\t\u0007I\u0011\u0001!\t\rq\u0003\u0001\u0015!\u0003B\u0011\u001di\u0006A1A\u0005\u0002-CaA\u0018\u0001!\u0002\u0013a\u0005bB0\u0001\u0005\u0004%\t\u0001\u0011\u0005\u0007A\u0002\u0001\u000b\u0011B!\t\u000f\u0005\u0004!\u0019!C\u0001\u0017\"1!\r\u0001Q\u0001\n1Cqa\u0019\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004e\u0001\u0001\u0006I!\u0011\u0005\bK\u0002\u0011\r\u0011\"\u0001L\u0011\u00191\u0007\u0001)A\u0005\u0019\"9q\r\u0001b\u0001\n\u0003\u0001\u0005B\u00025\u0001A\u0003%\u0011\tC\u0004j\u0001\t\u0007I\u0011A&\t\r)\u0004\u0001\u0015!\u0003M\u0011%1\u0003\u00011AA\u0002\u0013\u00051\u000eC\u0005y\u0001\u0001\u0007\t\u0019!C\u0001s\"Iq\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003C\u0003A\u0011AAR\u0005E\tE\r\u001a)beRLG/[8ogR+7\u000f\u001e\u0006\u0003M\u001d\nQ!\u00193nS:T\u0011\u0001K\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0006\u0005\u0002-_5\tQF\u0003\u0002/O\u000511/\u001a:wKJL!\u0001M\u0017\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u001a\u0011\u0005Q\u0002Q\"A\u0013\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t\u0019\u0011J\u001c;\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t1\fgn\u001a\u0006\u0002\r\u0006!!.\u0019<b\u0013\tA5I\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u0003A!x\u000e]5dc\u0005\u001b8/[4o[\u0016tG/F\u0001M!\u0011i%k\u000e+\u000e\u00039S!a\u0014)\u0002\u0013%lW.\u001e;bE2,'BA):\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003':\u00131!T1q!\t)\u0006,D\u0001W\u0015\t9v%\u0001\u0006d_:$(o\u001c7mKJL!!\u0017,\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/A\tu_BL7-M!tg&<g.\\3oi\u0002\na\u0001^8qS\u000e\u0014\u0014a\u0002;pa&\u001c'\u0007I\u0001\u0011i>\u0004\u0018n\u0019\u001aBgNLwM\\7f]R\f\u0011\u0003^8qS\u000e\u0014\u0014i]:jO:lWM\u001c;!\u0003\u0019!x\u000e]5dg\u00059Ao\u001c9jGN\u0002\u0013\u0001\u0005;pa&\u001c7'Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5dg\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0007i>\u0004\u0018n\u0019\u001b\u0002\u000fQ|\u0007/[25A\u0005\u0001Bo\u001c9jGR\n5o]5h]6,g\u000e^\u0001\u0012i>\u0004\u0018n\u0019\u001bBgNLwM\\7f]R\u0004\u0013A\u0002;pa&\u001cW'A\u0004u_BL7-\u000e\u0011\u0002!Q|\u0007/[26\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8uAU\tA\u000e\u0005\u0002nm6\taN\u0003\u0002'_*\u0011\u0001/]\u0001\bG2LWM\u001c;t\u0015\tA#O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<o\u0005\u0015\tE-\\5o\u0003%\tG-\\5o?\u0012*\u0017\u000f\u0006\u0002{{B\u0011\u0001h_\u0005\u0003yf\u0012A!\u00168ji\"9aPGA\u0001\u0002\u0004a\u0017a\u0001=%c\u00051\u0011\rZ7j]\u0002\nQa]3u+B$2A_A\u0003\u0011\u001d\t9\u0001\ba\u0001\u0003\u0013\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u0017\tI\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\r\t\u0007/\u001b\u0006\u0005\u0003'\t)\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005]A/A\u0003kk:LG/\u0003\u0003\u0002\u001c\u00055!\u0001\u0003+fgRLeNZ8)\u0007q\ty\u0002\u0005\u0003\u0002\f\u0005\u0005\u0012\u0002BA\u0012\u0003\u001b\u0011!BQ3g_J,W)Y2i\u0003U!Xm\u001d;Xe>twMU3qY&\u001c\u0017mQ8v]R$2A_A\u0015\u0011\u001d\tY#\ba\u0001\u0003[\ta!];peVl\u0007\u0003BA\u0018\u0003{qA!!\r\u0002:A\u0019\u00111G\u001d\u000e\u0005\u0005U\"bAA\u001cS\u00051AH]8pizJ1!a\u000f:\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001*a\u0010\u000b\u0007\u0005m\u0012\bK\u0002\u001e\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0005\u0003\u0013\n\t\"\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u001b\n9EA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!HA)\u0003;\ny\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&a\u0012\u0002\u0011A\u0014xN^5eKJLA!a\u0017\u0002V\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#!!\u0019\"\u0005\u0005\r\u0014!B6sC\u001a$\u0018a\t;fgRl\u0015n]:j]\u001e\u0004\u0016M\u001d;ji&|gn]%o\u0007J,\u0017\r^3U_BL7m\u001d\u000b\u0004u\u0006%\u0004bBA\u0016=\u0001\u0007\u0011Q\u0006\u0015\u0004=\u0005\r\u0003f\u0002\u0010\u0002R\u0005u\u0013q\u000e\u0017\u0003\u0003C\nq\u0005^3ti6K7o]5oOB\u000b'\u000f^5uS>t7/\u00138De\u0016\fG/\u001a)beRLG/[8ogR\u0019!0!\u001e\t\u000f\u0005-r\u00041\u0001\u0002.!\u001aq$a\u0011)\u000f}\t\t&!\u0018\u0002|1\u0012\u0011\u0011M\u0001\u0018i\u0016\u001cH/\u00138de\u0016lWM\u001c;QCJ$\u0018\u000e^5p]N$2A_AA\u0011\u001d\tY\u0003\ta\u0001\u0003[A3\u0001IA\"Q\u001d\u0001\u0013\u0011KA/\u0003\u000fc#!!\u0019\u0002=Q,7\u000f^'b]V\fG.Q:tS\u001etW.\u001a8u\u001f\u001a\u0014V\r\u001d7jG\u0006\u001cHc\u0001>\u0002\u000e\"9\u00111F\u0011A\u0002\u00055\u0002fA\u0011\u0002D!:\u0011%!\u0015\u0002^\u0005MEFAA1\u0003y!Xm\u001d;SKBd\u0017nY1QY\u0006\u001cW-\\3oi\u0006cGnU3sm\u0016\u00148\u000fF\u0002{\u00033Cq!a\u000b#\u0001\u0004\ti\u0003K\u0002#\u0003\u0007BsAIA)\u0003;\ny\n\f\u0002\u0002b\u0005\u0011C/Z:u%\u0016\u0004H.[2b!2\f7-Z7f]R\u0004\u0016M\u001d;jC2\u001cVM\u001d<feN$2A_AS\u0011\u001d\tYc\ta\u0001\u0003[A3aIA\"Q\u001d\u0019\u0013\u0011KA/\u0003Wc#!!\u0019")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment;
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment;
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment;
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment;
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokers().foreach((Function1 & Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        this.createTopicWithAssignment(this.topic1(), (Map<Object, Seq<Object>>)((Map)this.topic1Assignment().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic2(), (Map<Object, Seq<Object>>)((Map)this.topic2Assignment().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic3(), (Map<Object, Seq<Object>>)((Map)this.topic3Assignment().map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int k = x0$3._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$3._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic4(), (Map<Object, Seq<Object>>)((Map)this.topic4Assignment().map((Function1 & Serializable)x0$4 -> {
            if (x0$4 != null) {
                int k = x0$4._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$4._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            }
            throw new MatchError(null);
        })), this.createTopicWithAssignment$default$3());
        this.admin_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testWrongReplicaCount(String quorum) {
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)2, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause().getClass());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testMissingPartitionsInCreateTopics(String quorum) {
        HashMap<Integer, java.util.List<Integer>> topic6Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic6Placements.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic6Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        HashMap<Integer, java.util.List<Integer>> topic7Placements = new HashMap<Integer, java.util.List<Integer>>();
        topic7Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)));
        topic7Placements.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)));
        java.util.Map futures = this.admin().createTopics(Arrays.asList(new NewTopic("new-topic6", topic6Placements), new NewTopic("new-topic7", topic7Placements))).values();
        Throwable topic6Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic6")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic6Cause.getClass());
        Assertions.assertTrue((boolean)topic6Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)("Unexpected error message: " + topic6Cause.getMessage()));
        Throwable topic7Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic7")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic7Cause.getClass());
        Assertions.assertTrue((boolean)topic7Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)("Unexpected error message: " + topic7Cause.getMessage()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testMissingPartitionsInCreatePartitions(String quorum) {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, Collections.singletonList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))))).all().get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, cause.getClass());
        Assertions.assertTrue((boolean)cause.getMessage().contains("Attempted to add 2 additional partition(s), but only 1 assignment(s) were specified."), (String)("Unexpected error message: " + cause.getMessage()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testIncrementPartitions(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head()).partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testManualAssignmentOfReplicas(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 1, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 2, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        LeaderAndIsr partition1Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        Assertions.assertEquals((int)leader1, (int)partition1Metadata.leader());
        LeaderAndIsr partition2Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        Assertions.assertEquals((int)leader2, (int)partition2Metadata.leader());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Buffer partitionMetadata = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        java.util.List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(replicas).asScala().toSet());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testReplicaPlacementAllServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic3(), NewPartitions.increaseTo((int)7))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 2, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 3, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 4, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 5, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 6, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic3(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Assertions.assertEquals((int)7, (int)topicMetadata.partitionMetadata().size());
        CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testReplicaPlacementAllServers$1(partition);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testReplicaPlacementPartialServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, 15000L);
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response.topicMetadata()).asScala().head();
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().foreach((Function1 & Serializable)partition -> {
            AddPartitionsTest.$anonfun$testReplicaPlacementPartialServers$1(partition);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ void $anonfun$testReplicaPlacementAllServers$1(MetadataResponse.PartitionMetadata partition) {
        scala.collection.immutable.Set replicas = CollectionConverters$.MODULE$.ListHasAsScala(partition.replicaIds).asScala().toSet();
        Assertions.assertEquals((int)4, (int)replicas.size(), (String)("Partition " + partition.partition() + " should have 4 replicas"));
        Assertions.assertTrue((boolean)replicas.subsetOf((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))), (String)"Replicas should only include brokers 0-3");
        Assertions.assertTrue((boolean)partition.leaderId.isPresent(), (String)("Partition " + partition.partition() + " should have a leader"));
        Assertions.assertTrue((boolean)replicas.contains(partition.leaderId.get()), (String)"Leader should be one of the replicas");
    }

    public static final /* synthetic */ void $anonfun$testReplicaPlacementPartialServers$1(MetadataResponse.PartitionMetadata partition) {
        scala.collection.immutable.Set replicas = CollectionConverters$.MODULE$.ListHasAsScala(partition.replicaIds).asScala().toSet();
        Assertions.assertEquals((int)2, (int)replicas.size(), (String)("Partition " + partition.partition() + " should have 2 replicas"));
        Assertions.assertTrue((boolean)replicas.subsetOf((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))), (String)"Replicas should only include brokers 0-3");
        Assertions.assertTrue((boolean)partition.leaderId.isPresent(), (String)("Partition " + partition.partition() + " should have a leader"));
        Assertions.assertTrue((boolean)replicas.contains(partition.leaderId.get()), (String)"Leader should be one of the replicas");
    }

    /*
     * WARNING - void declaration
     */
    public AddPartitionsTest() {
        void apply_removingReplicas;
        void apply_addingReplicas;
        void apply_removingReplicas2;
        void apply_addingReplicas2;
        void apply_removingReplicas3;
        void apply_addingReplicas3;
        void apply_removingReplicas4;
        void apply_addingReplicas4;
        void apply_removingReplicas5;
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        Object[] objectArray = new Tuple2[1];
        Nil$ nil$ = Nil$.MODULE$;
        Nil$ apply_addingReplicas5 = Nil$.MODULE$;
        Seq apply_replicas = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Object var1_3 = null;
        Object var2_2 = null;
        nil$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas, (Seq)apply_addingReplicas5, (Seq)apply_removingReplicas5));
        this.topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.topic2 = "new-topic2";
        Object[] objectArray2 = new Tuple2[1];
        Nil$ nil$2 = Nil$.MODULE$;
        Nil$ nil$3 = Nil$.MODULE$;
        Seq apply_replicas2 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Object var4_6 = null;
        nil$3 = null;
        nil$2 = null;
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas2, (Seq)apply_addingReplicas4, (Seq)apply_removingReplicas4));
        this.topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        this.topic3 = "new-topic3";
        Object[] objectArray3 = new Tuple2[1];
        Nil$ nil$4 = Nil$.MODULE$;
        Nil$ nil$5 = Nil$.MODULE$;
        Seq apply_replicas3 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}));
        Object var7_9 = null;
        nil$5 = null;
        nil$4 = null;
        objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas3, (Seq)apply_addingReplicas3, (Seq)apply_removingReplicas3));
        this.topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        this.topic4 = "new-topic4";
        Object[] objectArray4 = new Tuple2[1];
        Nil$ nil$6 = Nil$.MODULE$;
        Nil$ nil$7 = Nil$.MODULE$;
        Seq apply_replicas4 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3}));
        Object var10_12 = null;
        nil$7 = null;
        nil$6 = null;
        objectArray4[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReplicaAssignment(apply_replicas4, (Seq)apply_addingReplicas2, (Seq)apply_removingReplicas2));
        this.topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
        this.topic5 = "new-topic5";
        Object[] objectArray5 = new Tuple2[1];
        Nil$ nil$8 = Nil$.MODULE$;
        Nil$ nil$9 = Nil$.MODULE$;
        Seq apply_replicas5 = (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Object var13_15 = null;
        nil$9 = null;
        nil$8 = null;
        objectArray5[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReplicaAssignment(apply_replicas5, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        this.topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
    }
}

