/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.admin.ConfigCommand;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;

public class ConfigCommandIntegrationTest {
    private final String defaultBrokerId = "0";
    private final String defaultGroupName = "group";
    private final String defaultClientMetricsName = "cm";
    private final ClusterInstance cluster;

    private static Runnable run(Stream<String> command) {
        return () -> {
            try {
                ConfigCommand.main((String[])((String[])command.toArray(String[]::new)));
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                Exit.resetExitProcedure();
            }
        };
    }

    public ConfigCommandIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest
    public void testExitWithNonZeroStatusOnUpdatingUnallowedConfig() {
        this.assertNonZeroStatusExit(Stream.concat(this.quorumArgs(), Stream.of("--entity-name", "0", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT")), errOut -> Assertions.assertTrue((boolean)errOut.contains("Cannot update these configs dynamically: Set(security.inter.broker.protocol)"), (String)errOut));
    }

    @ClusterTest
    public void testNullStatusOnKraftCommandAlterUserQuota() {
        Stream<String> command = Stream.concat(this.quorumArgs(), Stream.of("--entity-type", "users", "--entity-name", "admin", "--alter", "--add-config", "consumer_byte_rate=20000"));
        String message = ConfigCommandIntegrationTest.captureStandardStream(false, ConfigCommandIntegrationTest.run(command));
        Assertions.assertEquals((Object)"Completed updating config for user admin.", (Object)message);
    }

    @ClusterTest
    public void testNullStatusOnKraftCommandAlterGroup() {
        Stream<String> command = Stream.concat(this.quorumArgs(), Stream.of("--entity-type", "groups", "--entity-name", "group", "--alter", "--add-config", "consumer.session.timeout.ms=50000"));
        String message = ConfigCommandIntegrationTest.captureStandardStream(false, ConfigCommandIntegrationTest.run(command));
        Assertions.assertEquals((Object)"Completed updating config for group group.", (Object)message);
        command = Stream.concat(this.quorumArgs(), Stream.of("--group", "group", "--alter", "--add-config", "consumer.session.timeout.ms=50000"));
        message = ConfigCommandIntegrationTest.captureStandardStream(false, ConfigCommandIntegrationTest.run(command));
        Assertions.assertEquals((Object)"Completed updating config for group group.", (Object)message);
    }

    @ClusterTest
    public void testNullStatusOnKraftCommandAlterClientMetrics() {
        Stream<String> command = Stream.concat(this.quorumArgs(), Stream.of("--entity-type", "client-metrics", "--entity-name", "cm", "--alter", "--add-config", "metrics=org.apache"));
        String message = ConfigCommandIntegrationTest.captureStandardStream(false, ConfigCommandIntegrationTest.run(command));
        Assertions.assertEquals((Object)"Completed updating config for client-metric cm.", (Object)message);
        command = Stream.concat(this.quorumArgs(), Stream.of("--client-metrics", "cm", "--alter", "--add-config", "metrics=org.apache"));
        message = ConfigCommandIntegrationTest.captureStandardStream(false, ConfigCommandIntegrationTest.run(command));
        Assertions.assertEquals((Object)"Completed updating config for client-metric cm.", (Object)message);
    }

    @ClusterTest
    public void testDynamicBrokerConfigUpdateUsingKraft() throws Exception {
        List<String> alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.admin();){
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("message.max.bytes", "110000"), alterOpts);
            this.alterAndVerifyConfig(client, Optional.empty(), Collections.singletonMap("message.max.bytes", "120000"), alterOpts);
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("message.max.bytes", "130000"), alterOpts);
            this.alterAndVerifyConfig(client, Optional.empty(), Collections.singletonMap("message.max.bytes", "140000"), alterOpts);
            this.deleteAndVerifyConfigValue(client, "0", Collections.singleton("message.max.bytes"), true, alterOpts);
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("listener.name.internal.ssl.keystore.location", "/tmp/test.jks"), alterOpts);
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.empty(), Collections.singletonMap("listener.name.internal.ssl.keystore.location", "/tmp/test.jks"), alterOpts));
            this.deleteAndVerifyConfigValue(client, "0", Collections.singleton("listener.name.internal.ssl.keystore.location"), false, alterOpts);
            this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("listener.name.external.ssl.keystore.password", "secret"), alterOpts);
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("listener.name.external.ssl.keystore.password", "secret");
            configs.put("log.cleaner.threads", "2");
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), configs, alterOpts));
        }
    }

    @ClusterTest
    public void testGroupConfigUpdateUsingKraft() throws Exception {
        List<String> alterOpts = Stream.concat(this.entityOp(Optional.of("group")).stream(), Stream.of("--entity-type", "groups", "--alter")).collect(Collectors.toList());
        this.verifyGroupConfigUpdate(alterOpts);
        this.verifyGroupConfigUpdate(Arrays.asList("--group", "group", "--alter"));
    }

    private void verifyGroupConfigUpdate(List<String> alterOpts) throws Exception {
        try (Admin client = this.cluster.admin();){
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("consumer.session.timeout.ms", "50000");
            configs.put("consumer.heartbeat.interval.ms", "6000");
            this.alterAndVerifyGroupConfig(client, "group", configs, alterOpts);
            configs.put("consumer.session.timeout.ms", "45000");
            configs.put("consumer.heartbeat.interval.ms", "5000");
            this.deleteAndVerifyGroupConfigValue(client, "group", configs, alterOpts);
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Collections.singletonMap("unknown.config", "20000"), alterOpts));
        }
    }

    @ClusterTest(types={Type.KRAFT})
    public void testClientMetricsConfigUpdate() throws Exception {
        List<String> alterOpts = Stream.concat(this.entityOp(Optional.of("cm")).stream(), Stream.of("--entity-type", "client-metrics", "--alter")).collect(Collectors.toList());
        this.verifyClientMetricsConfigUpdate(alterOpts);
        this.verifyClientMetricsConfigUpdate(Arrays.asList("--client-metrics", "cm", "--alter"));
    }

    private void verifyClientMetricsConfigUpdate(List<String> alterOpts) throws Exception {
        try (Admin client = this.cluster.admin();){
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("metrics", "");
            configs.put("interval.ms", "6000");
            this.alterAndVerifyClientMetricsConfig(client, "cm", configs, alterOpts);
            this.deleteAndVerifyClientMetricsConfigValue(client, "cm", configs.keySet(), alterOpts);
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Collections.singletonMap("unknown.config", "20000"), alterOpts));
        }
    }

    @ClusterTest
    public void testAlterReadOnlyConfigInKRaftThenShouldFail() {
        List<String> alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.admin();){
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("auto.create.topics.enable", "false"), alterOpts));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("auto.leader.rebalance.enable", "false"), alterOpts));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("broker.id", "1"), alterOpts));
        }
    }

    @ClusterTest
    public void testUpdateClusterWideConfigInKRaftThenShouldSuccessful() throws Exception {
        List<String> alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.admin();){
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("log.flush.interval.messages", "100"), alterOpts);
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("log.retention.bytes", "20"), alterOpts);
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap("log.retention.ms", "2"), alterOpts);
        }
    }

    @ClusterTest
    public void testUpdatePerBrokerConfigWithListenerNameInKRaftThenShouldSuccessful() throws Exception {
        List<String> alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        String listenerName = "listener.name.internal.";
        try (Admin client = this.cluster.admin();){
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap(listenerName + "ssl.truststore.type", "PKCS12"), alterOpts);
            this.alterAndVerifyConfig(client, Optional.of("0"), Collections.singletonMap(listenerName + "ssl.truststore.location", "/temp/test.jks"), alterOpts);
            this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap(listenerName + "ssl.truststore.password", "password"), alterOpts);
            this.verifyConfigSecretValue(client, Optional.of("0"), Collections.singleton(listenerName + "ssl.truststore.password"));
        }
    }

    @ClusterTest
    public void testUpdatePerBrokerConfigInKRaftThenShouldFail() {
        List<String> alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.admin();){
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("ssl.truststore.type", "PKCS12"), alterOpts));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("ssl.truststore.location", "/temp/test.jks"), alterOpts));
            Assertions.assertThrows(ExecutionException.class, () -> this.alterConfigWithAdmin(client, Optional.of("0"), Collections.singletonMap("ssl.truststore.password", "password"), alterOpts));
        }
    }

    @ClusterTest
    public void testUpdateInvalidBrokerConfigs() {
        this.updateAndCheckInvalidBrokerConfig(Optional.empty());
        this.updateAndCheckInvalidBrokerConfig(Optional.of("" + this.cluster.anyBrokerSocketServer().config().brokerId()));
    }

    private void updateAndCheckInvalidBrokerConfig(Optional<String> brokerIdOrDefault) {
        List<String> alterOpts = this.generateDefaultAlterOpts(this.cluster.bootstrapServers());
        try (Admin client = this.cluster.admin();){
            this.alterConfigWithAdmin(client, brokerIdOrDefault, Collections.singletonMap("invalid", "2"), alterOpts);
            Stream<String> describeCommand = Stream.concat(Stream.concat(Stream.of("--bootstrap-server", this.cluster.bootstrapServers()), Stream.of(this.entityOp(brokerIdOrDefault).toArray(new String[0]))), Stream.of("--entity-type", "brokers", "--describe"));
            String describeResult = ConfigCommandIntegrationTest.captureStandardStream(false, ConfigCommandIntegrationTest.run(describeCommand));
            Assertions.assertTrue((boolean)describeResult.contains("sensitive=true"), (String)describeResult);
            Assertions.assertTrue((boolean)describeResult.contains("invalid=null"), (String)describeResult);
        }
    }

    @ClusterTest
    public void testUpdateInvalidTopicConfigs() throws ExecutionException, InterruptedException {
        List<String> alterOpts = Arrays.asList("--bootstrap-server", this.cluster.bootstrapServers(), "--entity-type", "topics", "--alter");
        try (Admin client = this.cluster.admin();){
            client.createTopics(Collections.singletonList(new NewTopic("test-config-topic", 1, 1))).all().get();
            Assertions.assertInstanceOf(InvalidConfigurationException.class, (Object)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(alterOpts, Arrays.asList("--add-config", "invalid=2", "--entity-type", "topics", "--entity-name", "test-config-topic")))))).getCause());
        }
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="log.cleaner.dedupe.buffer.size", value="2097154")})
    public void testUpdateBrokerConfigNotAffectedByInvalidConfig() {
        try (Admin client = this.cluster.admin();){
            ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(Arrays.asList("--bootstrap-server", this.cluster.bootstrapServers(), "--alter", "--add-config", "log.cleaner.threadzz=2", "--entity-type", "brokers", "--entity-default"))));
            ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(Arrays.asList("--bootstrap-server", this.cluster.bootstrapServers(), "--alter", "--add-config", "log.cleaner.threads=2", "--entity-type", "brokers", "--entity-default"))));
            kafka.utils.TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> this.cluster.brokerSocketServers().stream().allMatch(broker -> broker.config().getInt("log.cleaner.threads") == 2)), (Function0<String>)((Function0)() -> "Timeout waiting for topic config propagating to broker"), 15000L, 100L);
        }
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="log.cleaner.dedupe.buffer.size", value="2097154")}, metadataVersion=MetadataVersion.IBP_3_9_IV0)
    public void testUnsupportedVersionException() {
        try (Admin client = this.cluster.admin();){
            Admin spyAdmin = (Admin)Mockito.spy((Object)client);
            AlterConfigsResult mockResult = AdminClientTestUtils.alterConfigsResult((ConfigResource)new ConfigResource(ConfigResource.Type.BROKER, ""), (Throwable)new UnsupportedVersionException("simulated error"));
            ((Admin)Mockito.doReturn((Object)mockResult).when((Object)spyAdmin)).incrementalAlterConfigs((Map)ArgumentMatchers.any(Map.class), (AlterConfigsOptions)ArgumentMatchers.any(AlterConfigsOptions.class));
            Assertions.assertEquals((Object)"The INCREMENTAL_ALTER_CONFIGS API is not supported by the cluster. The API is supported starting from version 2.3.0. You may want to use an older version of this tool to interact with your cluster, or upgrade your brokers to version 2.3.0 or newer to avoid this error.", (Object)((UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> ConfigCommand.alterConfig((Admin)spyAdmin, (ConfigCommand.ConfigCommandOptions)new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(Arrays.asList("--bootstrap-server", this.cluster.bootstrapServers(), "--alter", "--add-config", "log.cleaner.threads=2", "--entity-type", "brokers", "--entity-default")))))).getMessage());
            ((Admin)Mockito.verify((Object)spyAdmin)).incrementalAlterConfigs((Map)ArgumentMatchers.any(Map.class), (AlterConfigsOptions)ArgumentMatchers.any(AlterConfigsOptions.class));
        }
    }

    private void assertNonZeroStatusExit(Stream<String> args, Consumer<String> checkErrOut) {
        AtomicReference exitStatus = new AtomicReference();
        Exit.setExitProcedure((status, __) -> {
            exitStatus.set(status);
            throw new RuntimeException();
        });
        String errOut = ConfigCommandIntegrationTest.captureStandardStream(true, ConfigCommandIntegrationTest.run(args));
        checkErrOut.accept(errOut);
        Assertions.assertNotNull(exitStatus.get());
        Assertions.assertEquals((int)1, (Integer)((Integer)exitStatus.get()));
    }

    private Stream<String> quorumArgs() {
        return Stream.of("--bootstrap-server", this.cluster.bootstrapServers());
    }

    private List<String> entityOp(Optional<String> entityId) {
        return entityId.map(id -> Arrays.asList("--entity-name", id)).orElse(Collections.singletonList("--entity-default"));
    }

    private List<String> generateDefaultAlterOpts(String bootstrapServers) {
        return Arrays.asList("--bootstrap-server", bootstrapServers, "--entity-type", "brokers", "--alter");
    }

    private void alterAndVerifyConfig(Admin client, Optional<String> brokerId, Map<String, String> config, List<String> alterOpts) throws Exception {
        this.alterConfigWithAdmin(client, brokerId, config, alterOpts);
        this.verifyConfig(client, brokerId, config);
    }

    private void alterAndVerifyGroupConfig(Admin client, String groupName, Map<String, String> config, List<String> alterOpts) throws Exception {
        this.alterConfigWithAdmin(client, config, alterOpts);
        this.verifyGroupConfig(client, groupName, config);
    }

    private void alterAndVerifyClientMetricsConfig(Admin client, String clientMetricsName, Map<String, String> config, List<String> alterOpts) throws Exception {
        this.alterConfigWithAdmin(client, config, alterOpts);
        this.verifyClientMetricsConfig(client, clientMetricsName, config);
    }

    private void alterConfigWithAdmin(Admin client, Optional<String> resourceName, Map<String, String> config, List<String> alterOpts) {
        String configStr = this.transferConfigMapToString(config);
        List bootstrapOpts = this.quorumArgs().collect(Collectors.toList());
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(bootstrapOpts, this.entityOp(resourceName), alterOpts, Arrays.asList("--add-config", configStr)));
        addOpts.checkArgs();
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)addOpts);
    }

    private void alterConfigWithAdmin(Admin client, Map<String, String> config, List<String> alterOpts) {
        String configStr = this.transferConfigMapToString(config);
        List bootstrapOpts = this.quorumArgs().collect(Collectors.toList());
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(bootstrapOpts, alterOpts, Arrays.asList("--add-config", configStr)));
        addOpts.checkArgs();
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)addOpts);
    }

    private void verifyConfig(Admin client, Optional<String> brokerId, Map<String, String> config) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId.orElse(""));
        TestUtils.waitForCondition(() -> {
            Map<String, String> current = this.getConfigEntryStream(client, configResource).filter(configEntry -> Objects.nonNull(configEntry.value())).collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
            return config.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(current.get(e.getKey())));
        }, (long)10000L, (String)(String.valueOf(config) + " are not updated"));
    }

    private void verifyGroupConfig(Admin client, String groupName, Map<String, String> config) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.GROUP, groupName);
        TestUtils.waitForCondition(() -> {
            Map<String, String> current = this.getConfigEntryStream(client, configResource).filter(configEntry -> Objects.nonNull(configEntry.value())).collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
            return config.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(current.get(e.getKey())));
        }, (long)10000L, (String)(String.valueOf(config) + " are not updated"));
    }

    private void verifyClientMetricsConfig(Admin client, String clientMetricsName, Map<String, String> config) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, clientMetricsName);
        TestUtils.waitForCondition(() -> {
            Map<String, String> current = this.getConfigEntryStream(client, configResource).filter(configEntry -> Objects.nonNull(configEntry.value())).collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
            if (config.isEmpty()) {
                return current.isEmpty();
            }
            return config.entrySet().stream().allMatch(e -> ((String)e.getValue()).equals(current.get(e.getKey())));
        }, (long)10000L, (String)(String.valueOf(config) + " are not updated"));
    }

    private Stream<ConfigEntry> getConfigEntryStream(Admin client, ConfigResource configResource) throws InterruptedException, ExecutionException {
        return ((Map)client.describeConfigs(Collections.singletonList(configResource)).all().get()).values().stream().flatMap(e -> e.entries().stream());
    }

    private void deleteAndVerifyConfigValue(Admin client, String brokerId, Set<String> config, boolean hasDefaultValue, List<String> alterOpts) throws Exception {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(alterOpts, Arrays.asList("--entity-name", brokerId), Arrays.asList("--delete-config", String.join((CharSequence)",", config))));
        deleteOpts.checkArgs();
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)deleteOpts);
        this.verifyPerBrokerConfigValue(client, brokerId, config, hasDefaultValue);
    }

    private void deleteAndVerifyGroupConfigValue(Admin client, String groupName, Map<String, String> defaultConfigs, List<String> alterOpts) throws Exception {
        List bootstrapOpts = this.quorumArgs().collect(Collectors.toList());
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(bootstrapOpts, alterOpts, Arrays.asList("--delete-config", String.join((CharSequence)",", defaultConfigs.keySet()))));
        deleteOpts.checkArgs();
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)deleteOpts);
        this.verifyGroupConfig(client, groupName, defaultConfigs);
    }

    private void deleteAndVerifyClientMetricsConfigValue(Admin client, String clientMetricsName, Set<String> defaultConfigs, List<String> alterOpts) throws Exception {
        List bootstrapOpts = this.quorumArgs().collect(Collectors.toList());
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(bootstrapOpts, alterOpts, Arrays.asList("--delete-config", String.join((CharSequence)",", defaultConfigs))));
        deleteOpts.checkArgs();
        ConfigCommand.alterConfig((Admin)client, (ConfigCommand.ConfigCommandOptions)deleteOpts);
        this.verifyClientMetricsConfig(client, clientMetricsName, Collections.emptyMap());
    }

    private void verifyPerBrokerConfigValue(Admin client, String brokerId, Set<String> config, boolean hasDefaultValue) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId);
        TestUtils.waitForCondition(() -> {
            if (hasDefaultValue) {
                Map<String, String> current = this.getConfigEntryStream(client, configResource).filter(configEntry -> Objects.nonNull(configEntry.value())).collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
                return config.stream().allMatch(current::containsKey);
            }
            return this.getConfigEntryStream(client, configResource).noneMatch(configEntry -> config.contains(configEntry.name()));
        }, (long)5000L, (String)(String.valueOf(config) + " are not updated"));
    }

    private void verifyConfigSecretValue(Admin client, Optional<String> brokerId, Set<String> config) throws Exception {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, brokerId.orElse(""));
        TestUtils.waitForCondition(() -> {
            Map current = this.getConfigEntryStream(client, configResource).filter(ConfigEntry::isSensitive).collect(HashMap::new, (map, entry) -> map.put(entry.name(), entry.value()), HashMap::putAll);
            return config.stream().allMatch(current::containsKey);
        }, (long)5000L, (String)(String.valueOf(config) + " are not updated"));
    }

    @SafeVarargs
    private static String[] toArray(List<String> ... lists) {
        return (String[])Stream.of(lists).flatMap(Collection::stream).toArray(String[]::new);
    }

    private String transferConfigMapToString(Map<String, String> configs) {
        return configs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String captureStandardStream(boolean isErr, Runnable runnable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream currentStream = isErr ? System.err : System.out;
        PrintStream tempStream = new PrintStream(outputStream);
        if (isErr) {
            System.setErr(tempStream);
        } else {
            System.setOut(tempStream);
        }
        try {
            runnable.run();
            String string = outputStream.toString().trim();
            return string;
        }
        finally {
            if (isErr) {
                System.setErr(currentStream);
            } else {
                System.setOut(currentStream);
            }
            tempStream.close();
        }
    }
}

