/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfig;
import org.apache.kafka.common.test.api.ClusterTemplate;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.test.junit.ClusterTestExtensions;
import org.apache.kafka.security.authorizer.AclEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ClusterTestExtensions.class})
public class DescribeAuthorizedOperationsTest {
    private static final String GROUP1 = "group1";
    private static final String GROUP2 = "group2";
    private static final String GROUP3 = "group3";
    private static final ResourcePattern GROUP1_PATTERN = new ResourcePattern(ResourceType.GROUP, "group1", PatternType.LITERAL);
    private static final ResourcePattern GROUP2_PATTERN = new ResourcePattern(ResourceType.GROUP, "group2", PatternType.LITERAL);
    private static final ResourcePattern GROUP3_PATTERN = new ResourcePattern(ResourceType.GROUP, "group3", PatternType.LITERAL);
    private static final ResourcePattern CLUSTER_PATTERN = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private static final AccessControlEntry ALTER_ENTRY = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.ALTER);
    private static final AccessControlEntry DESCRIBE_ENTRY = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.DESCRIBE);

    static List<ClusterConfig> generator() {
        return List.of(ClusterConfig.defaultBuilder().setTypes(Set.of(Type.KRAFT)).setServerProperties(Map.of("offsets.topic.num.partitions", "1")).setServerProperties(Map.of("offsets.topic.replication.factor", "1")).setBrokerSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT).setControllerSecurityProtocol(SecurityProtocol.SASL_PLAINTEXT).build());
    }

    private static AccessControlEntry createAccessControlEntry(String username, AclOperation operation) {
        return new AccessControlEntry(new KafkaPrincipal("User", username).toString(), "*", operation, AclPermissionType.ALLOW);
    }

    private Map<String, Object> createAdminConfig(String username, String password) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        configs.put("sasl.mechanism", "PLAIN");
        configs.put("sasl.jaas.config", String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";", username, password));
        return configs;
    }

    private void setupSecurity(ClusterInstance clusterInstance) throws ExecutionException, InterruptedException {
        try (Admin admin = clusterInstance.admin(this.createAdminConfig("plain-admin", "plain-admin-secret"));){
            ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
            admin.createAcls(List.of(new AclBinding(CLUSTER_PATTERN, ALTER_ENTRY), new AclBinding(topicResource, DESCRIBE_ENTRY))).all().get();
            clusterInstance.waitAcls(new AclBindingFilter(CLUSTER_PATTERN.toFilter(), AccessControlEntryFilter.ANY), Set.of(ALTER_ENTRY));
            clusterInstance.waitAcls(new AclBindingFilter(topicResource.toFilter(), AccessControlEntryFilter.ANY), Set.of(DESCRIBE_ENTRY));
        }
    }

    @ClusterTemplate(value="generator")
    public void testConsumerGroupAuthorizedOperations(ClusterInstance clusterInstance) throws ExecutionException, InterruptedException {
        this.setupSecurity(clusterInstance);
        try (Admin admin = clusterInstance.admin(this.createAdminConfig("plain-admin", "plain-admin-secret"));
             Admin user1 = clusterInstance.admin(this.createAdminConfig("plain-user1", "plain-user1-secret"));){
            admin.createTopics(List.of(new NewTopic("topic1", 1, 1)));
            clusterInstance.waitForTopic("topic1", 1);
            TopicPartition tp = new TopicPartition("topic1", 0);
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(0L);
            admin.alterConsumerGroupOffsets(GROUP1, Map.of(tp, offsetAndMetadata)).all().get();
            admin.alterConsumerGroupOffsets(GROUP2, Map.of(tp, offsetAndMetadata)).all().get();
            admin.alterConsumerGroupOffsets(GROUP3, Map.of(tp, offsetAndMetadata)).all().get();
            AccessControlEntry allOperationsEntry = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.ALL);
            AccessControlEntry describeEntry = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.DESCRIBE);
            AccessControlEntry deleteEntry = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.DELETE);
            user1.createAcls(List.of(new AclBinding(GROUP1_PATTERN, allOperationsEntry), new AclBinding(GROUP2_PATTERN, describeEntry), new AclBinding(GROUP3_PATTERN, deleteEntry))).all();
            clusterInstance.waitAcls(new AclBindingFilter(GROUP1_PATTERN.toFilter(), AccessControlEntryFilter.ANY), Set.of(allOperationsEntry));
            clusterInstance.waitAcls(new AclBindingFilter(GROUP2_PATTERN.toFilter(), AccessControlEntryFilter.ANY), Set.of(describeEntry));
            clusterInstance.waitAcls(new AclBindingFilter(GROUP3_PATTERN.toFilter(), AccessControlEntryFilter.ANY), Set.of(deleteEntry));
            DescribeConsumerGroupsResult describeConsumerGroupsResult = user1.describeConsumerGroups(List.of(GROUP1, GROUP2, GROUP3), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
            Assertions.assertEquals((int)3, (int)describeConsumerGroupsResult.describedGroups().size());
            ConsumerGroupDescription group1Description = (ConsumerGroupDescription)((KafkaFuture)describeConsumerGroupsResult.describedGroups().get(GROUP1)).get();
            Assertions.assertEquals((Object)AclEntry.supportedOperations((ResourceType)ResourceType.GROUP), (Object)group1Description.authorizedOperations());
            ConsumerGroupDescription group2Description = (ConsumerGroupDescription)((KafkaFuture)describeConsumerGroupsResult.describedGroups().get(GROUP2)).get();
            Assertions.assertEquals(Set.of(AclOperation.DESCRIBE), (Object)group2Description.authorizedOperations());
            ConsumerGroupDescription group3Description = (ConsumerGroupDescription)((KafkaFuture)describeConsumerGroupsResult.describedGroups().get(GROUP3)).get();
            Assertions.assertEquals(Set.of(AclOperation.DESCRIBE, AclOperation.DELETE), (Object)group3Description.authorizedOperations());
        }
    }

    @ClusterTemplate(value="generator")
    public void testClusterAuthorizedOperations(ClusterInstance clusterInstance) throws ExecutionException, InterruptedException {
        Set authorizedOperations;
        this.setupSecurity(clusterInstance);
        try (Admin admin = clusterInstance.admin(this.createAdminConfig("plain-user1", "plain-user1-secret"));){
            authorizedOperations = (Set)admin.describeCluster().authorizedOperations().get();
            Assertions.assertNull((Object)authorizedOperations);
            authorizedOperations = (Set)admin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true)).authorizedOperations().get();
            Assertions.assertEquals(Set.of(AclOperation.DESCRIBE, AclOperation.ALTER), (Object)authorizedOperations);
        }
        admin = clusterInstance.admin(this.createAdminConfig("plain-admin", "plain-admin-secret"));
        try {
            AccessControlEntry allOperationEntry = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.ALL);
            admin.createAcls(List.of(new AclBinding(CLUSTER_PATTERN, allOperationEntry))).all().get();
            clusterInstance.waitAcls(new AclBindingFilter(CLUSTER_PATTERN.toFilter(), AccessControlEntryFilter.ANY), Set.of(allOperationEntry, ALTER_ENTRY));
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
        admin = clusterInstance.admin(this.createAdminConfig("plain-user1", "plain-user1-secret"));
        try {
            authorizedOperations = (Set)admin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true)).authorizedOperations().get();
            Assertions.assertEquals((Object)AclEntry.supportedOperations((ResourceType)ResourceType.CLUSTER), (Object)authorizedOperations);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
    }

    @ClusterTemplate(value="generator")
    public void testTopicAuthorizedOperations(ClusterInstance clusterInstance) throws ExecutionException, InterruptedException {
        Map topicDescriptions;
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.setupSecurity(clusterInstance);
        try (Admin admin = clusterInstance.admin(this.createAdminConfig("plain-admin", "plain-admin-secret"));){
            admin.createTopics(List.of(new NewTopic(topic1, 1, 1), new NewTopic(topic2, 1, 1)));
            clusterInstance.waitForTopic(topic1, 1);
            clusterInstance.waitForTopic(topic2, 1);
        }
        admin = clusterInstance.admin(this.createAdminConfig("plain-user1", "plain-user1-secret"));
        try {
            topicDescriptions = (Map)admin.describeTopics(List.of(topic1, topic2)).allTopicNames().get();
            Assertions.assertNull((Object)((TopicDescription)topicDescriptions.get(topic1)).authorizedOperations());
            Assertions.assertNull((Object)((TopicDescription)topicDescriptions.get(topic2)).authorizedOperations());
            topicDescriptions = (Map)admin.describeTopics(List.of(topic1, topic2), new DescribeTopicsOptions().includeAuthorizedOperations(true)).allTopicNames().get();
            Assertions.assertEquals(Set.of(AclOperation.DESCRIBE), (Object)((TopicDescription)topicDescriptions.get(topic1)).authorizedOperations());
            Assertions.assertEquals(Set.of(AclOperation.DESCRIBE), (Object)((TopicDescription)topicDescriptions.get(topic2)).authorizedOperations());
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
        admin = clusterInstance.admin(this.createAdminConfig("plain-admin", "plain-admin-secret"));
        try {
            ResourcePattern topic1Resource = new ResourcePattern(ResourceType.TOPIC, topic1, PatternType.LITERAL);
            ResourcePattern topic2Resource = new ResourcePattern(ResourceType.TOPIC, topic2, PatternType.LITERAL);
            AccessControlEntry allOperationEntry = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.ALL);
            AccessControlEntry deleteEntry = DescribeAuthorizedOperationsTest.createAccessControlEntry("plain-user1", AclOperation.DELETE);
            admin.createAcls(List.of(new AclBinding(topic1Resource, allOperationEntry), new AclBinding(topic2Resource, deleteEntry))).all().get();
            clusterInstance.waitAcls(new AclBindingFilter(topic1Resource.toFilter(), AccessControlEntryFilter.ANY), Set.of(allOperationEntry));
            clusterInstance.waitAcls(new AclBindingFilter(topic2Resource.toFilter(), AccessControlEntryFilter.ANY), Set.of(deleteEntry));
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
        admin = clusterInstance.admin(this.createAdminConfig("plain-user1", "plain-user1-secret"));
        try {
            topicDescriptions = (Map)admin.describeTopics(List.of(topic1, topic2), new DescribeTopicsOptions().includeAuthorizedOperations(true)).allTopicNames().get();
            Assertions.assertEquals((Object)AclEntry.supportedOperations((ResourceType)ResourceType.TOPIC), (Object)((TopicDescription)topicDescriptions.get(topic1)).authorizedOperations());
            Assertions.assertEquals(Set.of(AclOperation.DESCRIBE, AclOperation.DELETE), (Object)((TopicDescription)topicDescriptions.get(topic2)).authorizedOperations());
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
    }
}

