/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.QuotaTestClients;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.server.quota.QuotaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=e!\u0002\u0010 \u0003\u0003!\u0003\"B\u0015\u0001\t\u0003Q\u0003b\u0002\u0017\u0001\u0005\u0004%\t%\f\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0018\t\u000bU\u0002A\u0011\u0003\u001c\t\u000b}\u0002A\u0011\u0003\u001c\t\u000b\u0001\u0003a\u0011C!\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013\u0005!\f\u0003\u0004a\u0001\u0001\u0006Ia\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u00191\u0007\u0001)A\u0005G\"9q\r\u0001b\u0001\n\u00031\u0004B\u00025\u0001A\u0003%q\u0007C\u0005S\u0001\u0001\u0007\t\u0019!C\u0001S\"I!\u000e\u0001a\u0001\u0002\u0004%\ta\u001b\u0005\nc\u0002\u0001\r\u0011!Q!\nMC\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011A5\t\u0013M\u0004\u0001\u0019!a\u0001\n\u0003!\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003T\u0011%9\b\u00011AA\u0002\u0013\u0005\u0001\u0010C\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"IA\u0010\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\u0006{\u0002!\tE \u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\ni!)Y:f#V|G/\u0019+fgRT!\u0001I\u0011\u0002\u0007\u0005\u0004\u0018NC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019:S\"A\u0010\n\u0005!z\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Y\u0003C\u0001\u0014\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u00121!\u00138u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003A\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE-F\u00018!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003mC:<'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012aa\u0015;sS:<\u0017\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003Y\u0019'/Z1uKF+x\u000e^1UKN$8\t\\5f]R\u001cHc\u0001\"F#B\u0011aeQ\u0005\u0003\t~\u0011\u0001#U;pi\u0006$Vm\u001d;DY&,g\u000e^:\t\u000b\u00193\u0001\u0019A$\u0002\u000bQ|\u0007/[2\u0011\u0005!{eBA%N!\tQ\u0005'D\u0001L\u0015\ta5%\u0001\u0004=e>|GOP\u0005\u0003\u001dB\na\u0001\u0015:fI\u00164\u0017B\u0001 Q\u0015\tq\u0005\u0007C\u0003S\r\u0001\u00071+\u0001\u0006mK\u0006$WM\u001d(pI\u0016\u0004\"\u0001V,\u000e\u0003US!AV\u0011\u0002\rM,'O^3s\u0013\tAVKA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\u0018\u0001\u00063fM\u0006,H\u000e\u001e)s_\u0012,8-\u001a:Rk>$\u0018-F\u0001\\!\tyC,\u0003\u0002^a\t!Aj\u001c8h\u0003U!WMZ1vYR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\u0002\nA\u0003Z3gCVdGoQ8ogVlWM])v_R\f\u0017!\u00063fM\u0006,H\u000e^\"p]N,X.\u001a:Rk>$\u0018\rI\u0001\u0014I\u00164\u0017-\u001e7u%\u0016\fX/Z:u#V|G/Y\u000b\u0002GB\u0011q\u0006Z\u0005\u0003KB\u0012a\u0001R8vE2,\u0017\u0001\u00063fM\u0006,H\u000e\u001e*fcV,7\u000f^)v_R\f\u0007%\u0001\u0004u_BL7-M\u0001\bi>\u0004\u0018nY\u0019!+\u0005\u0019\u0016A\u00047fC\u0012,'OT8eK~#S-\u001d\u000b\u0003Y>\u0004\"aL7\n\u00059\u0004$\u0001B+oSRDq\u0001\u001d\t\u0002\u0002\u0003\u00071+A\u0002yIE\n1\u0002\\3bI\u0016\u0014hj\u001c3fA\u0005aam\u001c7m_^,'OT8eK\u0006\u0001bm\u001c7m_^,'OT8eK~#S-\u001d\u000b\u0003YVDq\u0001]\n\u0002\u0002\u0003\u00071+A\u0007g_2dwn^3s\u001d>$W\rI\u0001\u0011cV|G/\u0019+fgR\u001cE.[3oiN,\u0012AQ\u0001\u0015cV|G/\u0019+fgR\u001cE.[3oiN|F%Z9\u0015\u00051\\\bb\u00029\u0017\u0003\u0003\u0005\rAQ\u0001\u0012cV|G/\u0019+fgR\u001cE.[3oiN\u0004\u0013!B:fiV\u0003HC\u00017\u0000\u0011\u001d\t\t\u0001\u0007a\u0001\u0003\u0007\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003\u000b\t)\"\u0004\u0002\u0002\b)\u0019\u0001%!\u0003\u000b\t\u0005-\u0011QB\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ty!!\u0005\u0002\u000b),h.\u001b;\u000b\u0005\u0005M\u0011aA8sO&!\u0011qCA\u0004\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\r\u0002\u001cA!\u0011QAA\u000f\u0013\u0011\ty\"a\u0002\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u000fuKN$H\u000b\u001b:piRdW\r\u001a)s_\u0012,8-\u001a:D_:\u001cX/\\3s)\u0015a\u0017QEA\u0015\u0011\u0019\t9#\u0007a\u0001\u000f\u00061\u0011/^8sk6Da!a\u000b\u001a\u0001\u00049\u0015!D4s_V\u0004\bK]8u_\u000e|G\u000eK\u0004\u001a\u0003_\tY$!\u0010\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQA!!\u000e\u0002\n\u00051\u0001/\u0019:b[NLA!!\u000f\u00024\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003\u007f\t!f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\fT\u0010K\u0004\u001a\u0003\u0007\ny%!\u0015\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fRA!!\u0013\u00024\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002N\u0005\u001d#\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA*C\t\t)&\u0001\u0016hKR$Vm\u001d;Rk>\u0014X/\\!oI\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0002OQ,7\u000f\u001e)s_\u0012,8-\u001a:D_:\u001cX/\\3s\u001fZ,'O]5eKVsG\u000f\u001b:piRdW\r\u001a\u000b\u0006Y\u0006m\u0013Q\f\u0005\u0007\u0003OQ\u0002\u0019A$\t\r\u0005-\"\u00041\u0001HQ\u001dQ\u0012qFA\u001e\u0003{AsAGA\"\u0003\u001f\n\u0019\u0007\f\u0002\u0002T\u00051C/Z:u!J|G-^2fe\u000e{gn];nKJ|e/\u001a:sS\u0012,Gj\\<feF+x\u000e^1\u0015\u000b1\fI'a\u001b\t\r\u0005\u001d2\u00041\u0001H\u0011\u0019\tYc\u0007a\u0001\u000f\":1$a\f\u0002<\u0005u\u0002fB\u000e\u0002D\u0005=\u0013\u0011\u000f\u0017\u0003\u0003'\nq\u0003^3tiF+x\u000e^1Pm\u0016\u0014(/\u001b3f\t\u0016dW\r^3\u0015\u000b1\f9(!\u001f\t\r\u0005\u001dB\u00041\u0001H\u0011\u0019\tY\u0003\ba\u0001\u000f\":A$a\f\u0002<\u0005u\u0002f\u0002\u000f\u0002D\u0005=\u0013q\u0010\u0017\u0003\u0003'\nA\u0003^3tiRC'o\u001c;uY\u0016$'+Z9vKN$H#\u00027\u0002\u0006\u0006\u001d\u0005BBA\u0014;\u0001\u0007q\t\u0003\u0004\u0002,u\u0001\ra\u0012\u0015\b;\u0005=\u00121HA\u001fQ\u001di\u00121IA(\u0003\u001bc#!a\u0015")
public abstract class BaseQuotaTest
extends IntegrationTestHarness {
    private final int brokerCount;
    private final long defaultProducerQuota;
    private final long defaultConsumerQuota;
    private final double defaultRequestQuota;
    private final String topic1;
    private KafkaBroker leaderNode;
    private KafkaBroker followerNode;
    private QuotaTestClients quotaTestClients;

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String producerClientId() {
        return "QuotasTestProducer-1";
    }

    public String consumerClientId() {
        return "QuotasTestConsumer-1";
    }

    public abstract QuotaTestClients createQuotaTestClients(String var1, KafkaBroker var2);

    public long defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public long defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public double defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public String topic1() {
        return this.topic1;
    }

    public KafkaBroker leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaBroker x$1) {
        this.leaderNode = x$1;
    }

    public KafkaBroker followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaBroker x$1) {
        this.followerNode = x$1;
    }

    public QuotaTestClients quotaTestClients() {
        return this.quotaTestClients;
    }

    public void quotaTestClients_$eq(QuotaTestClients x$1) {
        this.quotaTestClients = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        int numPartitions = 1;
        String x$1 = this.topic1();
        int x$3 = this.brokerCount();
        Properties x$4 = this.adminClientConfig();
        Properties x$5 = this.createTopic$default$4();
        ListenerName x$6 = this.createTopic$default$5();
        Map<Object, Object> leaders = this.createTopic(x$1, numPartitions, x$3, x$5, x$6, x$4);
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) == ((KafkaBroker)this.brokers().head()).config().brokerId() ? (KafkaBroker)this.brokers().head() : (KafkaBroker)this.brokers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaBroker)this.brokers().head()).config().brokerId() ? (KafkaBroker)this.brokers().head() : (KafkaBroker)this.brokers().apply(1));
        this.quotaTestClients_$eq(this.createQuotaTestClients(this.topic1(), this.leaderNode()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testThrottledProducerConsumer(String quorum, String groupProtocol) {
        int numRecords = 1000;
        QuotaTestClients qual$1 = this.quotaTestClients();
        boolean x$2 = qual$1.produceUntilThrottled$default$2();
        int produced = qual$1.produceUntilThrottled(numRecords, x$2);
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$4 = qual$2.verifyProduceThrottle$default$2();
        boolean x$5 = qual$2.verifyProduceThrottle$default$3();
        qual$2.verifyProduceThrottle(true, x$4, x$5);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$7 = qual$3.consumeUntilThrottled$default$2();
        Assertions.assertTrue((qual$3.consumeUntilThrottled(produced, x$7) > 0 ? 1 : 0) != 0, (String)"Should have consumed at least one record");
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$9 = qual$4.verifyConsumeThrottle$default$2();
        boolean x$10 = qual$4.verifyConsumeThrottle$default$3();
        qual$4.verifyConsumeThrottle(true, x$9, x$10);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testProducerConsumerOverrideUnthrottled(String quorum, String groupProtocol) {
        Properties props = new Properties();
        props.put("producer_byte_rate", Long.toString(Long.MAX_VALUE));
        props.put("consumer_byte_rate", Long.toString(Long.MAX_VALUE));
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 9.223372036854776E18);
        QuotaTestClients qual$1 = this.quotaTestClients();
        KafkaBroker x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 9.223372036854776E18, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(false, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$4.consumeUntilThrottled(numRecords, x$11));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(false, x$13, x$14);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testProducerConsumerOverrideLowerQuota(String quorum, String groupProtocol) {
        this.quotaTestClients().overrideQuotas(2000L, 250L, 9.223372036854776E18);
        QuotaTestClients qual$1 = this.quotaTestClients();
        KafkaBroker x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(2000L, 250L, 9.223372036854776E18, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        int produced = qual$2.produceUntilThrottled(numRecords, x$6);
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(true, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertTrue((qual$4.consumeUntilThrottled(produced, x$11) > 0 ? 1 : 0) != 0, (String)"Should have consumed at least one record");
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(true, x$13, x$14);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testQuotaOverrideDelete(String quorum, String groupProtocol) {
        this.quotaTestClients().overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE, 9.223372036854776E18);
        QuotaTestClients qual$1 = this.quotaTestClients();
        KafkaBroker x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE, 9.223372036854776E18, x$4);
        int numRecords = 1000;
        QuotaTestClients qual$2 = this.quotaTestClients();
        boolean x$6 = qual$2.produceUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$2.produceUntilThrottled(numRecords, x$6));
        QuotaTestClients qual$3 = this.quotaTestClients();
        boolean x$8 = qual$3.verifyProduceThrottle$default$2();
        boolean x$9 = qual$3.verifyProduceThrottle$default$3();
        qual$3.verifyProduceThrottle(false, x$8, x$9);
        QuotaTestClients qual$4 = this.quotaTestClients();
        boolean x$11 = qual$4.consumeUntilThrottled$default$2();
        Assertions.assertEquals((int)numRecords, (int)qual$4.consumeUntilThrottled(numRecords, x$11));
        QuotaTestClients qual$5 = this.quotaTestClients();
        boolean x$13 = qual$5.verifyConsumeThrottle$default$2();
        boolean x$14 = qual$5.verifyConsumeThrottle$default$3();
        qual$5.verifyConsumeThrottle(false, x$13, x$14);
        this.quotaTestClients().removeQuotaOverrides();
        QuotaTestClients qual$6 = this.quotaTestClients();
        long x$15 = this.defaultProducerQuota();
        long x$16 = this.defaultConsumerQuota();
        double x$17 = this.defaultRequestQuota();
        KafkaBroker x$18 = qual$6.waitForQuotaUpdate$default$4();
        qual$6.waitForQuotaUpdate(x$15, x$16, x$17, x$18);
        QuotaTestClients qual$7 = this.quotaTestClients();
        boolean x$20 = qual$7.produceUntilThrottled$default$2();
        int produced = qual$7.produceUntilThrottled(numRecords, x$20);
        QuotaTestClients qual$8 = this.quotaTestClients();
        boolean x$22 = qual$8.verifyProduceThrottle$default$2();
        boolean x$23 = qual$8.verifyProduceThrottle$default$3();
        qual$8.verifyProduceThrottle(true, x$22, x$23);
        this.quotaTestClients().consumer().seekToBeginning(Collections.singleton(new TopicPartition(this.topic1(), 0)));
        QuotaTestClients qual$9 = this.quotaTestClients();
        int x$24 = numRecords + produced;
        boolean x$25 = qual$9.consumeUntilThrottled$default$2();
        qual$9.consumeUntilThrottled(x$24, x$25);
        QuotaTestClients qual$10 = this.quotaTestClients();
        boolean x$27 = qual$10.verifyConsumeThrottle$default$2();
        boolean x$28 = qual$10.verifyConsumeThrottle$default$3();
        qual$10.verifyConsumeThrottle(true, x$27, x$28);
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testThrottledRequest(String quorum, String groupProtocol) {
        this.quotaTestClients().overrideQuotas(0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFFL, 0.1);
        qual$1 = this.quotaTestClients();
        x$4 = qual$1.waitForQuotaUpdate$default$4();
        qual$1.waitForQuotaUpdate(0x7FFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFFL, 0.1, x$4);
        consumer = this.quotaTestClients().consumer();
        consumer.subscribe(Collections.singleton(this.topic1()));
        endTimeMs = System.currentTimeMillis() + 10000L;
        throttled = false;
        while (true) {
            if (throttled && this.quotaTestClients().exemptRequestMetric() != null) {
                if (!(BoxesRunTime.unboxToDouble((Object)this.quotaTestClients().exemptRequestMetric().metricValue()) <= (double)false)) break;
            }
            if (System.currentTimeMillis() >= endTimeMs) break;
            consumer.poll(Duration.ofMillis(100L));
            throttleMetric = this.quotaTestClients().throttleMetric(QuotaType.REQUEST, this.consumerClientId());
            if (throttleMetric == null) ** GOTO lbl-1000
            if (BoxesRunTime.unboxToDouble((Object)throttleMetric.metricValue()) > (double)false) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            throttled = v0;
        }
        Assertions.assertTrue((boolean)throttled, (String)"Should have been throttled");
        this.quotaTestClients().verifyConsumerClientThrottleTimeMetric(true, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)1000.0)));
        exemptMetric = this.quotaTestClients().exemptRequestMetric();
        Assertions.assertNotNull((Object)exemptMetric, (String)"Exempt requests not recorded");
        Assertions.assertTrue((boolean)(BoxesRunTime.unboxToDouble((Object)exemptMetric.metricValue()) > (double)false), (String)"Exempt requests not recorded");
    }

    public BaseQuotaTest() {
        this.brokerCount = 2;
        this.serverConfig().setProperty("controlled.shutdown.enable", "false");
        this.serverConfig().setProperty("offsets.topic.replication.factor", "2");
        this.serverConfig().setProperty("offsets.topic.num.partitions", "1");
        this.serverConfig().setProperty("group.min.session.timeout.ms", "100");
        this.serverConfig().setProperty("group.max.session.timeout.ms", "60000");
        this.serverConfig().setProperty("group.initial.rebalance.delay.ms", "0");
        this.producerConfig().setProperty("acks", "-1");
        this.producerConfig().setProperty("buffer.memory", "300000");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.producerConfig().setProperty("linger.ms", Integer.toString(0));
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", Integer.toString(4096));
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("fetch.min.bytes", "0");
        this.consumerConfig().setProperty("fetch.max.wait.ms", "0");
        this.defaultProducerQuota = 8000L;
        this.defaultConsumerQuota = 2500L;
        this.defaultRequestQuota = 9.223372036854776E18;
        this.topic1 = "topic-1";
    }
}

