/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.api.AbstractConsumerTest;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Int$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\r\u001a\u0001yAQa\t\u0001\u0005\u0002\u0011BqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u00041\u0001\u0001\u0006I\u0001\u000b\u0005\bc\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0011\u0004\u0001)A\u0005Q!91\u0007\u0001b\u0001\n\u00039\u0003B\u0002\u001b\u0001A\u0003%\u0001\u0006C\u00046\u0001\t\u0007I\u0011\u0001\u001c\t\r\t\u0003\u0001\u0015!\u00038\u0011\u001d\u0019\u0005A1A\u0005\u0002YBa\u0001\u0012\u0001!\u0002\u00139\u0004bB#\u0001\u0005\u0004%\tA\u000e\u0005\u0007\r\u0002\u0001\u000b\u0011B\u001c\t\u000f\u001d\u0003!\u0019!C\u0001m!1\u0001\n\u0001Q\u0001\n]Bq!\u0013\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004K\u0001\u0001\u0006Ia\u000e\u0005\b\u0017\u0002\u0011\r\u0011\"\u00017\u0011\u0019a\u0005\u0001)A\u0005o!)Q\n\u0001C\u0005\u001d\")1\r\u0001C\u0005I\")Q\r\u0001C\u0001M\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}!AL\"p]N,X.\u001a:XSRDG*Z4bGflUm]:bO\u00164uN]7bi&sG/Z4sCRLwN\u001c+fgRT!AG\u000e\u0002\u0007\u0005\u0004\u0018NC\u0001\u001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\nS\"A\r\n\u0005\tJ\"\u0001F!cgR\u0014\u0018m\u0019;D_:\u001cX/\\3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011\u0001\u0005A\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003!\u0002\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t1\fgn\u001a\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#F\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u0003\u0019!x\u000e]5de\u00059Ao\u001c9jGJ\u0002\u0013A\u0002;pa&\u001c7'A\u0004u_BL7m\r\u0011\u0002\tQ\f\u0004\u000fM\u000b\u0002oA\u0011\u0001\bQ\u0007\u0002s)\u0011!hO\u0001\u0007G>lWn\u001c8\u000b\u0005qa$BA\u001f?\u0003\u0019\t\u0007/Y2iK*\tq(A\u0002pe\u001eL!!Q\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)A/\r91A\u0005!A/\r92\u0003\u0015!\u0018\u0007]\u0019!\u0003\u0011!(\u0007\u001d\u0019\u0002\u000bQ\u0014\u0004\u000f\r\u0011\u0002\tQ\u0014\u0004/M\u0001\u0006iJ\u0002\u0018\u0007I\u0001\u0005iN\u0002\b'A\u0003ugA\u0004\u0004%\u0001\u0003ugA\f\u0014!\u0002;4aF\u0002\u0013aE1qa\u0016tG\rT3hC\u000eL(+Z2pe\u0012\u001cH#B(V5rs\u0006C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&\u0001B+oSRDQA\u0016\u000bA\u0002]\u000b!B\\;n%\u0016\u001cwN\u001d3t!\t\u0001\u0006,\u0003\u0002Z#\n\u0019\u0011J\u001c;\t\u000bm#\u0002\u0019A\u001c\u0002\u0005Q\u0004\b\"B/\u0015\u0001\u00049\u0016\u0001\u00032s_.,'/\u00133\t\u000b}#\u0002\u0019\u00011\u0002\u00155\fw-[2WC2,X\r\u0005\u0002QC&\u0011!-\u0015\u0002\u0005\u0005f$X-A\u0006tKR,\b\u000fV8qS\u000e\u001cH#A(\u0002'Q,7\u000f^(gMN,Go\u001d$peRKW.Z:\u0015\u0007=;7\u000fC\u0003i-\u0001\u0007\u0011.\u0001\u0004rk>\u0014X/\u001c\t\u0003UFt!a[8\u0011\u00051\fV\"A7\u000b\u00059l\u0012A\u0002\u001fs_>$h(\u0003\u0002q#\u00061\u0001K]3eK\u001aL!a\f:\u000b\u0005A\f\u0006\"\u0002;\u0017\u0001\u0004I\u0017!D4s_V\u0004\bK]8u_\u000e|G\u000e\u000b\u0004\u0017m\u0006\u0005\u00111\u0001\t\u0003ozl\u0011\u0001\u001f\u0006\u0003sj\fa\u0001]1sC6\u001c(BA>}\u0003\u001dQW\u000f]5uKJT!!  \u0002\u000b),h.\u001b;\n\u0005}D(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t)!\u0001\u0016|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|autsM]8vaB\u0013x\u000e^8d_2l40M?)\u000fY\tI!!\u0006\u0002\u0018A!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010a\f\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003'\tiA\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002\u001a\u0005\u0012\u00111D\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u0003m!Xm\u001d;FCJd\u0017.Z:u\u001fJd\u0015\r^3ti>3gm]3ugR)q*!\t\u0002$!)\u0001n\u0006a\u0001S\")Ao\u0006a\u0001S\"2qC^A\u0001\u0003\u0007AsaFA\u0005\u0003+\tI\u0003\f\u0002\u0002\u001a\u0001")
public class ConsumerWithLegacyMessageFormatIntegrationTest
extends AbstractConsumerTest {
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private final TopicPartition t1p0 = new TopicPartition(this.topic1(), 0);
    private final TopicPartition t1p1 = new TopicPartition(this.topic1(), 1);
    private final TopicPartition t2p0 = new TopicPartition(this.topic2(), 0);
    private final TopicPartition t2p1 = new TopicPartition(this.topic2(), 1);
    private final TopicPartition t3p0 = new TopicPartition(this.topic3(), 0);
    private final TopicPartition t3p1 = new TopicPartition(this.topic3(), 1);

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String topic3() {
        return this.topic3;
    }

    public TopicPartition t1p0() {
        return this.t1p0;
    }

    public TopicPartition t1p1() {
        return this.t1p1;
    }

    public TopicPartition t2p0() {
        return this.t2p0;
    }

    public TopicPartition t2p1() {
        return this.t2p1;
    }

    public TopicPartition t3p0() {
        return this.t3p0;
    }

    public TopicPartition t3p1() {
        return this.t3p1;
    }

    /*
     * WARNING - void declaration
     */
    private void appendLegacyRecords(int numRecords, TopicPartition tp, int brokerId, byte magicValue) {
        void builder_partitionLeaderEpoch;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_producerId;
        void builder_logAppendTime;
        void builder_baseOffset;
        void builder_timestampType;
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> ConsumerWithLegacyMessageFormatIntegrationTest.$anonfun$appendLegacyRecords$1(BoxesRunTime.unboxToInt((Object)i)));
        ByteBuffer buffer = ByteBuffer.allocate(AbstractRecords.estimateSizeInBytes((byte)magicValue, (CompressionType)CompressionType.NONE, (Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records).asJava()));
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        long l = -1L;
        long l2 = -1L;
        long l3 = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        Compression builder_compression = Compression.of((CompressionType)CompressionType.NONE).build();
        Object var8_15 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)magicValue, (Compression)builder_compression, (TimestampType)builder_timestampType, (long)builder_baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.brokers().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConsumerWithLegacyMessageFormatIntegrationTest.$anonfun$appendLegacyRecords$3(brokerId, x$1)))).foreach((Function1 & Serializable)b -> {
            LogManager qual$1 = b.replicaManager().logManager();
            boolean x$2 = qual$1.getLog$default$2();
            UnifiedLog unifiedLog = (UnifiedLog)qual$1.getLog(tp, x$2).get();
            unifiedLog.appendAsLeaderWithRecordVersion(builder.build(), 0, RecordVersion.lookup((byte)magicValue));
            return unifiedLog.maybeIncrementHighWatermark(unifiedLog.logEndOffsetMetadata());
        });
    }

    private void setupTopics() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopic(this.topic1(), 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopicWithAssignment(this.topic2(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))}))), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic3(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))}))), this.createTopicWithAssignment$default$3());
        this.sendRecords(producer, 100, this.t1p0(), 0L, this.sendRecords$default$5());
        this.sendRecords(producer, 100, this.t1p1(), 0L, this.sendRecords$default$5());
        this.appendLegacyRecords(100, this.t2p0(), 0, (byte)0);
        this.appendLegacyRecords(100, this.t2p1(), 1, (byte)0);
        this.appendLegacyRecords(100, this.t3p0(), 0, (byte)1);
        this.appendLegacyRecords(100, this.t3p1(), 1, (byte)1);
        producer.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testOffsetsForTimes(String quorum, String groupProtocol) {
        this.setupTopics();
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(this.t1p0(), Predef$.MODULE$.long2Long(-1L))));
        java.util.Map<TopicPartition, Long> timestampsToSearch = java.util.Map.of(this.t1p0(), Predef$.MODULE$.long2Long(0L), this.t1p1(), Predef$.MODULE$.long2Long(20L), this.t2p0(), Predef$.MODULE$.long2Long(40L), this.t2p1(), Predef$.MODULE$.long2Long(60L), this.t3p0(), Predef$.MODULE$.long2Long(80L), this.t3p1(), Predef$.MODULE$.long2Long(100L));
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTopic1P0 = (OffsetAndTimestamp)timestampOffsets.get(this.t1p0());
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P0.leaderEpoch());
        OffsetAndTimestamp timestampTopic1P1 = (OffsetAndTimestamp)timestampOffsets.get(this.t1p1());
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P1.leaderEpoch());
        Assertions.assertNull((Object)((OffsetAndTimestamp)timestampOffsets.get(this.t2p0())));
        Assertions.assertNull((Object)((OffsetAndTimestamp)timestampOffsets.get(this.t2p1())));
        OffsetAndTimestamp timestampTopic3P0 = (OffsetAndTimestamp)timestampOffsets.get(this.t3p0());
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.offset());
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.timestamp());
        Assertions.assertEquals(Optional.empty(), (Object)timestampTopic3P0.leaderEpoch());
        Assertions.assertNull(timestampOffsets.get(this.t3p1()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testEarliestOrLatestOffsets(String quorum, String groupProtocol) {
        this.setupTopics();
        java.util.Set partitions = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1(), this.t2p0(), this.t2p1(), this.t3p0(), this.t3p1()}))).asJava();
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(this.t1p0())));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(this.t1p1())));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(this.t2p0())));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(this.t2p1())));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(this.t3p0())));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(this.t3p1())));
        java.util.Map latests = consumer.endOffsets((Collection)partitions);
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(this.t1p0())));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(this.t1p1())));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(this.t2p0())));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(this.t2p1())));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(this.t3p0())));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(this.t3p1())));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendLegacyRecords$1(int i) {
        return new SimpleRecord(Int$.MODULE$.int2long(i), ("key " + i).getBytes(), ("value " + i).getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$appendLegacyRecords$3(int brokerId$1, KafkaBroker x$1) {
        return x$1.config().brokerId() == brokerId$1;
    }

    public ConsumerWithLegacyMessageFormatIntegrationTest() {
        this.topic1 = "part-test-topic-1";
        this.topic2 = "part-test-topic-2";
        this.topic3 = "part-test-topic-3";
    }
}

