/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.GroupAuthorizerIntegrationTest$;
import kafka.server.BaseRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmq!B\u0012%\u0011\u0003Ic!B\u0016%\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007\r\u0006\u0001\u000b\u0011B\u001c\t\u000f\u001d\u000b!\u0019!C\u0001m!1\u0001*\u0001Q\u0001\n]Bq!S\u0001C\u0002\u0013\u0005!\n\u0003\u0004T\u0003\u0001\u0006Ia\u0013\u0005\b)\u0006\u0011\r\u0011\"\u0001K\u0011\u0019)\u0016\u0001)A\u0005\u0017\"9a+\u0001b\u0001\n\u0003Q\u0005BB,\u0002A\u0003%1J\u0002\u0003Y\u0003\u0001I\u0006\"B\u001a\u000e\t\u0003\u0001\u0007\"B2\u000e\t\u0003\"g\u0001B\u0016%\u0001)DQa\r\t\u0005\u0002EDqa\u001d\tC\u0002\u0013\u0005A\u000f\u0003\u0004y!\u0001\u0006I!\u001e\u0005\u0006sB!\tE\u001f\u0005\u0006}B!\te \u0005\u0007\u0003\u001b\u0001B\u0011I@\t\r\u0005=\u0001\u0003\"\u00017\u0011\u0019\t\t\u0002\u0005C\u0001m!9\u00111\u0003\t\u0005B\u0005U\u0001bBA#!\u0011\u0005\u0013q\t\u0005\b\u0003'\u0002B\u0011BA+\u0011\u001d\tI\u0006\u0005C!\u00037Bq!a\u001a\u0011\t\u0013\tI\u0007C\u0005\u0002\u0010B\t\n\u0011\"\u0003\u0002\u0012\"9\u0011q\u0015\t\u0005\u0002\u0005%\u0006bBAy!\u0011\u0005\u00111\u001f\u0005\b\u0003\u007f\u0004B\u0011\u0001B\u0001\u0011\u001d\u0011i\u0001\u0005C\u0001\u0005\u001f\tad\u0012:pkB\fU\u000f\u001e5pe&TXM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\u00152\u0013aA1qS*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005)\nQ\"\u0001\u0013\u0003=\u001d\u0013x.\u001e9BkRDwN]5{KJLe\u000e^3he\u0006$\u0018n\u001c8UKN$8CA\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!K\u0001\u0010\u0005J|7.\u001a:Qe&t7-\u001b9bYV\tq\u0007\u0005\u00029\t6\t\u0011H\u0003\u0002;w\u0005!\u0011-\u001e;i\u0015\taT(\u0001\u0005tK\u000e,(/\u001b;z\u0015\tqt(\u0001\u0004d_6lwN\u001c\u0006\u0003O\u0001S!!\u0011\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0015aA8sO&\u0011Q)\u000f\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003A\u0011%o\\6feB\u0013\u0018N\\2ja\u0006d\u0007%A\bDY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0003A\u0019E.[3oiB\u0013\u0018N\\2ja\u0006d\u0007%\u0001\nCe>\\WM\u001d'jgR,g.\u001a:OC6,W#A&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015\u0001\u00027b]\u001eT\u0011\u0001U\u0001\u0005U\u00064\u0018-\u0003\u0002S\u001b\n11\u000b\u001e:j]\u001e\f1C\u0011:pW\u0016\u0014H*[:uK:,'OT1nK\u0002\n!c\u00117jK:$H*[:uK:,'OT1nK\u0006\u00192\t\\5f]Rd\u0015n\u001d;f]\u0016\u0014h*Y7fA\u000512i\u001c8ue>dG.\u001a:MSN$XM\\3s\u001d\u0006lW-A\fD_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u0014h*Y7fA\t)rI]8vaB\u0013\u0018N\\2ja\u0006d')^5mI\u0016\u00148CA\u0007[!\tYf,D\u0001]\u0015\ti6(A\u0007bkRDWM\u001c;jG\u0006$xN]\u0005\u0003?r\u0013A\u0004R3gCVdGoS1gW\u0006\u0004&/\u001b8dSB\fGNQ;jY\u0012,'\u000fF\u0001b!\t\u0011W\"D\u0001\u0002\u0003\u0015\u0011W/\u001b7e)\t9T\rC\u0003g\u001f\u0001\u0007q-A\u0004d_:$X\r\u001f;\u0011\u0005aB\u0017BA5:\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:\u001cuN\u001c;fqR\u001c\"\u0001E6\u0011\u00051|W\"A7\u000b\u000594\u0013AB:feZ,'/\u0003\u0002q[\ny!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fF\u0001s!\tQ\u0003#\u0001\u0005ce>\\WM]%e+\u0005)\bC\u0001'w\u0013\t9XJA\u0004J]R,w-\u001a:\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013a\u00032s_.,'oQ8v]R,\u0012a\u001f\t\u0003]qL!!`\u0018\u0003\u0007%sG/A\fj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'OT1nKV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA\u001f\u0002\u000f9,Go^8sW&!\u00111BA\u0003\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0003=\u0011'o\\6feB\u0013\u0018N\\2ja\u0006d\u0017aD2mS\u0016tG\u000f\u0015:j]\u000eL\u0007/\u00197\u0002--\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u001cuN\u001c4jON$B!a\u0006\u00020A1\u0011\u0011DA\u0010\u0003Gi!!a\u0007\u000b\u0007\u0005uq&\u0001\u0006d_2dWm\u0019;j_:LA!!\t\u0002\u001c\t\u00191+Z9\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bP\u0003\u0011)H/\u001b7\n\t\u00055\u0012q\u0005\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\u00193\u0001\u0007\u00111G\u0001\ti\u0016\u001cH/\u00138g_B!\u0011QGA!\u001b\t\t9DC\u0002&\u0003sQA!a\u000f\u0002>\u00059!.\u001e9ji\u0016\u0014(bAA \u0005\u0006)!.\u001e8ji&!\u00111IA\u001c\u0005!!Vm\u001d;J]\u001a|\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\u0011\tI%a\u0014\u0011\u00079\nY%C\u0002\u0002N=\u0012A!\u00168ji\"9\u0011\u0011\u000b\u000eA\u0002\u0005\r\u0012A\u00039s_B,'\u000f^5fg\u0006\t\u0012\r\u001a3O_\u0012,\u0007K]8qKJ$\u0018.Z:\u0015\t\u0005%\u0013q\u000b\u0005\b\u0003#Z\u0002\u0019AA\u0012\u0003\u0015\u0019X\r^+q)\u0011\tI%!\u0018\t\u000f\u0005EB\u00041\u0001\u00024!\u001aA$!\u0019\u0011\t\u0005U\u00121M\u0005\u0005\u0003K\n9D\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011b\u0019:fCR,\u0017i\u00197\u0015\u0011\u0005-\u0014qOAA\u0003\u0017\u0003B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cj\u0014aA1dY&!\u0011QOA8\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\u000f\u0005eT\u00041\u0001\u0002|\u0005a\u0011m\u00197Pa\u0016\u0014\u0018\r^5p]B!\u0011QNA?\u0013\u0011\ty(a\u001c\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\t\u000f\u0005\rU\u00041\u0001\u0002\u0006\u0006\t\u0012m\u00197QKJl\u0017n]:j_:$\u0016\u0010]3\u0011\t\u00055\u0014qQ\u0005\u0005\u0003\u0013\u000byGA\tBG2\u0004VM]7jgNLwN\u001c+za\u0016D\u0001\"!$\u001e!\u0003\u0005\raN\u0001\naJLgnY5qC2\f1c\u0019:fCR,\u0017i\u00197%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007]\n)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\tkL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0005\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\r\u0015:pIV\u001cW-\u00118e\u0007>t7/^7f)\u0019\tI%a+\u0002D\"9\u0011QV\u0010A\u0002\u0005=\u0016AB9v_J,X\u000e\u0005\u0003\u00022\u0006}f\u0002BAZ\u0003w\u00032!!.0\u001b\t\t9LC\u0002\u0002:\"\na\u0001\u0010:p_Rt\u0014bAA__\u00051\u0001K]3eK\u001aL1AUAa\u0015\r\til\f\u0005\b\u0003\u000b|\u0002\u0019AAX\u000359'o\\;q!J|Go\\2pY\":q$!3\u0002V\u0006]\u0007\u0003BAf\u0003#l!!!4\u000b\t\u0005=\u0017\u0011H\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005M\u0017Q\u001a\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!!7\u0002Um$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TPL4s_V\u0004\bK]8u_\u000e|G.P>2{\":q$!8\u0002j\u0006-\b\u0003BAp\u0003Kl!!!9\u000b\t\u0005\r\u0018QZ\u0001\taJ|g/\u001b3fe&!\u0011q]Aq\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\ti/\t\u0002\u0002p\u0006Qs-\u001a;UKN$\u0018+^8sk6\fe\u000eZ$s_V\u0004\bK]8u_\u000e|G\u000eU1sC6,G/\u001a:t\u00032d\u0017\u0001\f;fgR\u001cuN\\:v[\u0016,fn];cg\u000e\u0014\u0018NY3XSRDw.\u001e;He>,\b\u000fU3s[&\u001c8/[8o)\u0019\tI%!>\u0002x\"9\u0011Q\u0016\u0011A\u0002\u0005=\u0006bBAcA\u0001\u0007\u0011q\u0016\u0015\bA\u0005%\u0017Q[AlQ\u001d\u0001\u0013Q\\Au\u0003{d#!!<\u0002MQ,7\u000f^\"p]N,X.Z\"m_N,w+\u001b;i_V$xI]8vaB+'/\\5tg&|g\u000e\u0006\u0004\u0002J\t\r!Q\u0001\u0005\b\u0003[\u000b\u0003\u0019AAX\u0011\u001d\t)-\ta\u0001\u0003_Cs!IAe\u0003+\f9\u000eK\u0004\"\u0003;\fIOa\u0003-\u0005\u00055\u0018a\b;fgR\fU\u000f\u001e5pe&TX\r\u001a)s_\u0012,8-Z!oI\u000e{gn];nKR1\u0011\u0011\nB\t\u0005'Aq!!,#\u0001\u0004\ty\u000bC\u0004\u0002F\n\u0002\r!a,)\u000f\t\nI-!6\u0002X\":!%!8\u0002j\neAFAAw\u0001")
public class GroupAuthorizerIntegrationTest
extends BaseRequestTest {
    private final Integer brokerId = Predef$.MODULE$.int2Integer(0);

    public static String ControllerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ControllerListenerName();
    }

    public static String ClientListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
    }

    public static String BrokerListenerName() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
    }

    public static KafkaPrincipal ClientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    public static KafkaPrincipal BrokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName());
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName(GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName());
    }

    public KafkaPrincipal brokerPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
    }

    public KafkaPrincipal clientPrincipal() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Seq<Properties> controllerConfigs = super.kraftControllerConfigs(testInfo);
        controllerConfigs.foreach((Function1 & Serializable)properties -> {
            this.addNodeProperties(properties);
            return BoxedUnit.UNIT;
        });
        return controllerConfigs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("broker.id", this.brokerId().toString());
        this.addNodeProperties(properties);
    }

    private void addNodeProperties(Properties properties) {
        properties.put("authorizer.class.name", StandardAuthorizer.class.getName());
        properties.put("super.users", GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal().toString());
        properties.put("offsets.topic.num.partitions", "1");
        properties.put("offsets.topic.replication.factor", "1");
        properties.put("transaction.state.log.num.partitions", "1");
        properties.put("transaction.state.log.replication.factor", "1");
        properties.put("transaction.state.log.min.isr", "1");
        properties.put("principal.builder.class", GroupPrincipalBuilder.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal())}))), new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL));
        this.createOffsetsTopic(this.interBrokerListenerName(), this.createOffsetsTopic$default$2());
    }

    private AccessControlEntry createAcl(AclOperation aclOperation, AclPermissionType aclPermissionType, KafkaPrincipal principal) {
        return new AccessControlEntry(principal.toString(), "*", aclOperation, aclPermissionType);
    }

    private KafkaPrincipal createAcl$default$3() {
        return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUnauthorizedProduceAndConsume(String quorum, String groupProtocol) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Throwable produceException = Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(topic, (Object)"message".getBytes())).get()).getCause();
        Assertions.assertTrue((boolean)(produceException instanceof TopicAuthorizationException));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(((TopicAuthorizationException)produceException).unauthorizedTopics()).asScala());
        .colon.colon x$7 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        Properties x$10 = this.createConsumer$default$3();
        Consumer consumer = this.createConsumer(x$8, x$9, x$10, (List<String>)x$7);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TopicAuthorizationException consumeException = (TopicAuthorizationException)Assertions.assertThrows(TopicAuthorizationException.class, () -> TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumeException.unauthorizedTopics()).asScala());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumeUnsubscribeWithoutGroupPermission(String quorum, String groupProtocol) {
        String topic = "topic";
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal()), this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        producer.close();
        String group = "group";
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.GROUP, group, PatternType.LITERAL));
        Properties props = new Properties();
        props.put("group.id", group);
        props.put("enable.auto.commit", "false");
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        List<String> x$10 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$8, x$9, props, x$10);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        this.removeAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.GROUP, group, PatternType.LITERAL));
        Assertions.assertDoesNotThrow((Executable)new Executable(null, consumer){
            private final Consumer consumer$2;

            public void execute() {
                this.consumer$2.unsubscribe();
            }
            {
                this.consumer$2 = consumer$2;
            }
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumeCloseWithoutGroupPermission(String quorum, String groupProtocol) {
        String topic = "topic";
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal()), this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        String group = "group";
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.GROUP, group, PatternType.LITERAL));
        Properties props = new Properties();
        props.put("group.id", group);
        props.put("enable.auto.commit", "false");
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        List<String> x$10 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$8, x$9, props, x$10);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        this.removeAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.GROUP, group, PatternType.LITERAL));
        Assertions.assertDoesNotThrow((Executable)new Executable(null, consumer){
            private final Consumer consumer$3;

            public void execute() {
                this.consumer$3.close();
            }
            {
                this.consumer$3 = consumer$3;
            }
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAuthorizedProduceAndConsume(String quorum, String groupProtocol) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        ListenerName x$2 = this.interBrokerListenerName();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        Properties x$5 = this.createTopic$default$4();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$3, x$4, x$5, x$2, x$6);
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.WRITE, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(topic, (Object)"message".getBytes())).get();
        this.addAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.createAcl(AclOperation.READ, AclPermissionType.ALLOW, GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal())}))), new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL));
        .colon.colon x$7 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$8 = this.createConsumer$default$1();
        ByteArrayDeserializer x$9 = this.createConsumer$default$2();
        Properties x$10 = this.createConsumer$default$3();
        Consumer consumer = this.createConsumer(x$8, x$9, x$10, (List<String>)x$7);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
    }

    public static class GroupPrincipalBuilder
    extends DefaultKafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            boolean bl;
            String string = context.listenerName();
            String string2 = GroupAuthorizerIntegrationTest$.MODULE$.BrokerListenerName();
            if (!(string2 != null ? !string2.equals(string) : string != null)) {
                bl = true;
            } else {
                String string3 = GroupAuthorizerIntegrationTest$.MODULE$.ControllerListenerName();
                bl = !(string3 != null ? !string3.equals(string) : string != null);
            }
            if (bl) {
                return GroupAuthorizerIntegrationTest$.MODULE$.BrokerPrincipal();
            }
            String string4 = GroupAuthorizerIntegrationTest$.MODULE$.ClientListenerName();
            if (!(string4 != null ? !string4.equals(string) : string != null)) {
                return GroupAuthorizerIntegrationTest$.MODULE$.ClientPrincipal();
            }
            throw new IllegalArgumentException("No principal mapped to listener " + string);
        }

        public GroupPrincipalBuilder() {
            super(null, null);
        }
    }
}

