/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.security.JaasTestUtils;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rMc!\u0002\u001e<\u0003\u0003\u0001\u0005\"B$\u0001\t\u0003A\u0005\"B&\u0001\r#a\u0005\"B*\u0001\t#a\u0005b\u0002+\u0001\u0005\u0004%\t!\u0016\u0005\u0007=\u0002\u0001\u000b\u0011\u0002,\t\u000f}\u0003!\u0019!C\u0001+\"1\u0001\r\u0001Q\u0001\nYCq!\u0019\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004c\u0001\u0001\u0006IA\u0016\u0005\bG\u0002\u0011\r\u0011\"\u0001V\u0011\u0019!\u0007\u0001)A\u0005-\"9Q\r\u0001b\u0001\n\u0003)\u0006B\u00024\u0001A\u0003%a\u000bC\u0004h\u0001\t\u0007I\u0011A+\t\r!\u0004\u0001\u0015!\u0003W\u0011\u001dI\u0007A1A\u0005\u0002UCaA\u001b\u0001!\u0002\u00131\u0006bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003n\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0015\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA#\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA4\u0011\u001d\t9\b\u0001C\t\u0003sBq!a#\u0001\t#\ti\tC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005M\u0006\u0001\"\u0015\u00026\"9\u0011Q\u001a\u0001\u0005\u0012\u0005=\u0007bBAj\u0001\u0011%\u0011Q\u001b\u0005\b\u00033\u0004A\u0011IAn\u0011\u001d\t9\u000f\u0001C\t\u0003SDq!!<\u0001\t\u0003\ty\u000fC\u0004\u0002~\u0002!\t!a@\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002\"\u0003B(\u0001E\u0005I\u0011\u0001B)\u0011%\u0011\u0019\bAI\u0001\n\u0003\u0011)\bC\u0005\u0003|\u0001\t\n\u0011\"\u0001\u0003~!9!q\u0011\u0001\u0005\u0002\t%\u0005\"\u0003B`\u0001E\u0005I\u0011\u0001Ba\u0011%\u0011\t\u000eAI\u0001\n\u0003\u0011\u0019\u000eC\u0005\u0003Z\u0002\t\n\u0011\"\u0001\u0003\\\"I!\u0011\u001d\u0001\u0012\u0002\u0013\u0005!1\u001d\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011%\u0019I\u0001AI\u0001\n\u0003\u0019Y\u0001C\u0005\u0004\u0012\u0001\t\n\u0011\"\u0001\u0004\u0014!I1\u0011\u0004\u0001\u0012\u0002\u0013\u000511\u0004\u0005\n\u0007C\u0001\u0011\u0013!C\u0001\u0007GAqa!\u000b\u0001\t\u0003\u0019Y\u0003C\u0005\u00044\u0001\t\n\u0011\"\u0001\u00046!I1\u0011\b\u0001\u0012\u0002\u0013\u0005!q\u0010\u0005\b\u0007w\u0001A\u0011AB\u001f\u0011%\u0019\u0019\u0005AI\u0001\n\u0003\u0019)\u0004C\u0005\u0004F\u0001\t\n\u0011\"\u0001\u0003\u0000!91q\t\u0001\u0005B\r%#AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u000b\u0005qj\u0014aA1qS*\ta(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#>\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005\u0019\u001b%AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005I\u0005C\u0001&\u0001\u001b\u0005Y\u0014a\u00032s_.,'oQ8v]R,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0004\u0013:$\u0018a\u00037pO\u0012K'oQ8v]R\fa\u0002\u001d:pIV\u001cWM]\"p]\u001aLw-F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003vi&d'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003=\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e\u0004\u0013AD2p]N,X.\u001a:D_:4\u0017nZ\u0001\u0010G>t7/^7fe\u000e{gNZ5hA\u0005\u00192\u000f[1sK\u000e{gn];nKJ\u001cuN\u001c4jO\u0006!2\u000f[1sK\u000e{gn];nKJ\u001cuN\u001c4jO\u0002\n\u0011#\u00193nS:\u001cE.[3oi\u000e{gNZ5h\u0003I\tG-\\5o\u00072LWM\u001c;D_:4\u0017n\u001a\u0011\u0002+M,\b/\u001a:vg\u0016\u00148\t\\5f]R\u001cuN\u001c4jO\u000612/\u001e9feV\u001cXM]\"mS\u0016tGoQ8oM&<\u0007%\u0001\u0007tKJ4XM]\"p]\u001aLw-A\u0007tKJ4XM]\"p]\u001aLw\rI\u0001\u0011G>tGO]8mY\u0016\u00148i\u001c8gS\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tg-[4!\u0003%\u0019wN\\:v[\u0016\u00148/F\u0001n!\rq7/^\u0007\u0002_*\u0011\u0001/]\u0001\b[V$\u0018M\u00197f\u0015\t\u0011x*\u0001\u0006d_2dWm\u0019;j_:L!\u0001^8\u0003\r\t+hMZ3sa\u00151\u00181BA\u0011!\u001d9\u00181AA\u0004\u0003?i\u0011\u0001\u001f\u0006\u0003sj\f\u0001bY8ogVlWM\u001d\u0006\u0003wr\fqa\u00197jK:$8O\u0003\u0002?{*\u0011ap`\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0011aA8sO&\u0019\u0011Q\u0001=\u0003\u0011\r{gn];nKJ\u0004B!!\u0003\u0002\f1\u0001AaCA\u0007'\u0005\u0005\t\u0011!B\u0001\u0003#\u00111a\u0018\u00132\u0003)\u0019wN\\:v[\u0016\u00148\u000fI\t\u0005\u0003'\tI\u0002E\u0002O\u0003+I1!a\u0006P\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ATA\u000e\u0013\r\tib\u0014\u0002\u0004\u0003:L\b\u0003BA\u0005\u0003C!1\"a\t\u0014\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\t\u0019q\f\n\u001a\u0002\u001dMD\u0017M]3D_:\u001cX/\\3sgV\u0011\u0011\u0011\u0006\t\u0005]N\fY\u0003\r\u0004\u0002.\u0005U\u0012Q\b\t\bo\u0006=\u00121GA\u001e\u0013\r\t\t\u0004\u001f\u0002\u000e'\"\f'/Z\"p]N,X.\u001a:\u0011\t\u0005%\u0011Q\u0007\u0003\f\u0003o)\u0012\u0011!A\u0001\u0006\u0003\t\tBA\u0002`IM\nqb\u001d5be\u0016\u001cuN\\:v[\u0016\u00148\u000f\t\t\u0005\u0003\u0013\ti\u0004B\u0006\u0002@U\t\t\u0011!A\u0003\u0002\u0005E!aA0%i\u0005I\u0001O]8ek\u000e,'o]\u000b\u0003\u0003\u000b\u0002BA\\:\u0002HA2\u0011\u0011JA,\u0003?\u0002\u0002\"a\u0013\u0002R\u0005U\u0013QL\u0007\u0003\u0003\u001bR1!a\u0014{\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BA*\u0003\u001b\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b\u0003BA\u0005\u0003/\"1\"!\u0017\u0018\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\t\u0019q\fJ\u001b\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b\u0005\u0005\u0003\u0002\n\u0005}CaCA1/\u0005\u0005\t\u0011!B\u0001\u0003#\u00111a\u0018\u00137\u00031\tG-\\5o\u00072LWM\u001c;t+\t\t9\u0007\u0005\u0003og\u0006%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=$0A\u0003bI6Lg.\u0003\u0003\u0002t\u00055$!B!e[&t\u0017!D1e[&t7\t\\5f]R\u001c\b%A\fj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'OT1nKV\u0011\u00111\u0010\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003\u001dqW\r^<pe.T1!!\"}\u0003\u0019\u0019w.\\7p]&!\u0011\u0011RA@\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u00035iw\u000eZ5gs\u000e{gNZ5hgR!\u0011qRAK!\rq\u0015\u0011S\u0005\u0004\u0003'{%\u0001B+oSRDq!a&\u001c\u0001\u0004\tI*A\u0003qe>\u00048\u000fE\u0003\u0002\u001c\u0006ue+D\u0001r\u0013\r\ty*\u001d\u0002\u0004'\u0016\f\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0005\u0005\u0015\u0006CBAN\u0003;\u000b9\u000b\u0005\u0003\u0002*\u0006=VBAAV\u0015\r\ti+P\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u00161\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\u0011\tI*a.\t\u000f\u0005eV\u00041\u0001\u0002<\u0006AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002>\u0006%WBAA`\u0015\ra\u0014\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u001dw0A\u0003kk:LG/\u0003\u0003\u0002L\u0006}&\u0001\u0003+fgRLeNZ8\u0002%\r|gNZ5hkJ,G*[:uK:,'o\u001d\u000b\u0005\u0003\u001f\u000b\t\u000eC\u0004\u0002\u0018z\u0001\r!!'\u0002C%t7/\u001a:u\u0007>tGO]8mY\u0016\u0014H*[:uK:,'o]%g\u001d\u0016,G-\u001a3\u0015\t\u0005=\u0015q\u001b\u0005\b\u0003/{\u0002\u0019AAM\u0003\u0015\u0019X\r^+q)\u0011\ty)!8\t\u000f\u0005e\u0006\u00051\u0001\u0002<\"\u001a\u0001%!9\u0011\t\u0005u\u00161]\u0005\u0005\u0003K\fyL\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0003Z8TkB,'/^:feN+G/\u001e9\u0015\t\u0005=\u00151\u001e\u0005\b\u0003s\u000b\u0003\u0019AA^\u0003\u001d!wnU3ukB$b!a$\u0002r\u0006M\bbBA]E\u0001\u0007\u00111\u0018\u0005\b\u0003k\u0014\u0003\u0019AA|\u0003I\u0019'/Z1uK>3gm]3ugR{\u0007/[2\u0011\u00079\u000bI0C\u0002\u0002|>\u0013qAQ8pY\u0016\fg.A\ndY&,g\u000e^*fGV\u0014\u0018\u000e^=Qe>\u00048\u000fF\u0002W\u0005\u0003AqAa\u0001$\u0001\u0004\u0011)!A\u0005dKJ$\u0018\t\\5bgB!!q\u0001B\u000b\u001d\u0011\u0011IA!\u0005\u0011\u0007\t-q*\u0004\u0002\u0003\u000e)\u0019!qB \u0002\rq\u0012xn\u001c;?\u0013\r\u0011\u0019bT\u0001\u0007!J,G-\u001a4\n\t\t]!\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tMq*\u0001\ftkB,'/^:feN+7-\u001e:jif\u0004&o\u001c9t)\r1&q\u0004\u0005\b\u0005\u0007!\u0003\u0019\u0001B\u0003\u00039\u0019'/Z1uKB\u0013x\u000eZ;dKJ,bA!\n\u0003,\tEB\u0003\u0003B\u0014\u0005k\u0011)Ea\u0013\u0011\u0011\u0005-\u0013\u0011\u000bB\u0015\u0005_\u0001B!!\u0003\u0003,\u00119!QF\u0013C\u0002\u0005E!!A&\u0011\t\u0005%!\u0011\u0007\u0003\b\u0005g)#\u0019AA\t\u0005\u00051\u0006\"\u0003B\u001cKA\u0005\t\u0019\u0001B\u001d\u00035YW-_*fe&\fG.\u001b>feB1!1\bB!\u0005Si!A!\u0010\u000b\t\t}\u00121Q\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\t\r#Q\b\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\"\u0003B$KA\u0005\t\u0019\u0001B%\u0003=1\u0018\r\\;f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0002B\u001e\u0005\u0003\u0012y\u0003\u0003\u0005\u0003N\u0015\u0002\n\u00111\u0001W\u0003=\u0019wN\u001c4jO>3XM\u001d:jI\u0016\u001c\u0018\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU1!1\u000bB8\u0005c*\"A!\u0016+\t\t]#Q\f\t\u0005\u0005w\u0011I&\u0003\u0003\u0003\\\tu\"a\u0005\"zi\u0016\f%O]1z'\u0016\u0014\u0018.\u00197ju\u0016\u00148F\u0001B0!\u0011\u0011\tGa\u001b\u000e\u0005\t\r$\u0002\u0002B3\u0005O\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%t*\u0001\u0006b]:|G/\u0019;j_:LAA!\u001c\u0003d\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\t5bE1\u0001\u0002\u0012\u00119!1\u0007\u0014C\u0002\u0005E\u0011\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU1!1\u000bB<\u0005s\"qA!\f(\u0005\u0004\t\t\u0002B\u0004\u00034\u001d\u0012\r!!\u0005\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0003\u0000\t\r%QQ\u000b\u0003\u0005\u0003S3A\u0016B/\t\u001d\u0011i\u0003\u000bb\u0001\u0003#!qAa\r)\u0005\u0004\t\t\"\u0001\bde\u0016\fG/Z\"p]N,X.\u001a:\u0016\r\t-%\u0011\u0013BK))\u0011iIa&\u0003\"\n\u001d&\u0011\u0016\t\bo\u0006\r!q\u0012BJ!\u0011\tIA!%\u0005\u000f\t5\u0012F1\u0001\u0002\u0012A!\u0011\u0011\u0002BK\t\u001d\u0011\u0019$\u000bb\u0001\u0003#A\u0011B!'*!\u0003\u0005\rAa'\u0002\u001f-,\u0017\u0010R3tKJL\u0017\r\\5{KJ\u0004bAa\u000f\u0003\u001e\n=\u0015\u0002\u0002BP\u0005{\u0011A\u0002R3tKJL\u0017\r\\5{KJD\u0011Ba)*!\u0003\u0005\rA!*\u0002#Y\fG.^3EKN,'/[1mSj,'\u000f\u0005\u0004\u0003<\tu%1\u0013\u0005\t\u0005\u001bJ\u0003\u0013!a\u0001-\"I!1V\u0015\u0011\u0002\u0003\u0007!QV\u0001\u0010G>tg-[4t)>\u0014V-\\8wKB1!q\u0016B]\u0005\u000bqAA!-\u00036:!!1\u0002BZ\u0013\u0005\u0001\u0016b\u0001B\\\u001f\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B^\u0005{\u0013A\u0001T5ti*\u0019!qW(\u00021\r\u0014X-\u0019;f\u0007>t7/^7fe\u0012\"WMZ1vYR$\u0013'\u0006\u0004\u0003D\n5'qZ\u000b\u0003\u0005\u000bTCAa2\u0003^A!!1\bBe\u0013\u0011\u0011YM!\u0010\u0003+\tKH/Z!se\u0006LH)Z:fe&\fG.\u001b>fe\u00129!Q\u0006\u0016C\u0002\u0005EAa\u0002B\u001aU\t\u0007\u0011\u0011C\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u0012TC\u0002Bb\u0005+\u00149\u000eB\u0004\u0003.-\u0012\r!!\u0005\u0005\u000f\tM2F1\u0001\u0002\u0012\u0005A2M]3bi\u0016\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\r\t}$Q\u001cBp\t\u001d\u0011i\u0003\fb\u0001\u0003#!qAa\r-\u0005\u0004\t\t\"\u0001\rde\u0016\fG/Z\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIQ*bA!:\u0003j\n-XC\u0001BtU\u0011\u0011iK!\u0018\u0005\u000f\t5RF1\u0001\u0002\u0012\u00119!1G\u0017C\u0002\u0005E\u0011aE2sK\u0006$Xm\u00155be\u0016\u001cuN\\:v[\u0016\u0014XC\u0002By\u0005o\u0014Y\u0010\u0006\u0006\u0003t\nu8\u0011AB\u0003\u0007\u000f\u0001ra^A\u0018\u0005k\u0014I\u0010\u0005\u0003\u0002\n\t]Ha\u0002B\u0017]\t\u0007\u0011\u0011\u0003\t\u0005\u0003\u0013\u0011Y\u0010B\u0004\u000349\u0012\r!!\u0005\t\u0013\tee\u0006%AA\u0002\t}\bC\u0002B\u001e\u0005;\u0013)\u0010C\u0005\u0003$:\u0002\n\u00111\u0001\u0004\u0004A1!1\bBO\u0005sD\u0001B!\u0014/!\u0003\u0005\rA\u0016\u0005\n\u0005Ws\u0003\u0013!a\u0001\u0005[\u000bQd\u0019:fCR,7\u000b[1sK\u000e{gn];nKJ$C-\u001a4bk2$H%M\u000b\u0007\u0005\u0007\u001ciaa\u0004\u0005\u000f\t5rF1\u0001\u0002\u0012\u00119!1G\u0018C\u0002\u0005E\u0011!H2sK\u0006$Xm\u00155be\u0016\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\r\t\r7QCB\f\t\u001d\u0011i\u0003\rb\u0001\u0003#!qAa\r1\u0005\u0004\t\t\"A\u000fde\u0016\fG/Z*iCJ,7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011yh!\b\u0004 \u00119!QF\u0019C\u0002\u0005EAa\u0002B\u001ac\t\u0007\u0011\u0011C\u0001\u001eGJ,\u0017\r^3TQ\u0006\u0014XmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU1!Q]B\u0013\u0007O!qA!\f3\u0005\u0004\t\t\u0002B\u0004\u00034I\u0012\r!!\u0005\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0004\u0002j\r52\u0011\u0007\u0005\n\u0007_\u0019\u0004\u0013!a\u0001\u0003w\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016D\u0001B!\u00144!\u0003\u0005\rAV\u0001\u001cGJ,\u0017\r^3BI6Lgn\u00117jK:$H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r]\"\u0006BA>\u0005;\n1d\u0019:fCR,\u0017\tZ7j]\u000ec\u0017.\u001a8uI\u0011,g-Y;mi\u0012\u0012\u0014AG2sK\u0006$XmU;qKJ,8/\u001a:BI6Lgn\u00117jK:$HCBA5\u0007\u007f\u0019\t\u0005C\u0005\u00040Y\u0002\n\u00111\u0001\u0002|!A!Q\n\u001c\u0011\u0002\u0003\u0007a+\u0001\u0013de\u0016\fG/Z*va\u0016\u0014Xo]3s\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003\u0011\u001a'/Z1uKN+\b/\u001a:vg\u0016\u0014\u0018\tZ7j]\u000ec\u0017.\u001a8uI\u0011,g-Y;mi\u0012\u0012\u0014\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005=\u0005fA\u001d\u0004NA!\u0011QXB(\u0013\u0011\u0019\t&a0\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007")
public abstract class IntegrationTestHarness
extends KafkaServerTestHarness {
    private final Properties producerConfig = new Properties();
    private final Properties consumerConfig = new Properties();
    private final Properties shareConsumerConfig = new Properties();
    private final Properties adminClientConfig = new Properties();
    private final Properties superuserClientConfig = new Properties();
    private final Properties serverConfig = new Properties();
    private final Properties controllerConfig = new Properties();
    private final Buffer<Consumer<?, ?>> consumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<ShareConsumer<?, ?>> shareConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaProducer<?, ?>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Admin> adminClients = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public abstract int brokerCount();

    public int logDirCount() {
        return 1;
    }

    public Properties producerConfig() {
        return this.producerConfig;
    }

    public Properties consumerConfig() {
        return this.consumerConfig;
    }

    public Properties shareConsumerConfig() {
        return this.shareConsumerConfig;
    }

    public Properties adminClientConfig() {
        return this.adminClientConfig;
    }

    public Properties superuserClientConfig() {
        return this.superuserClientConfig;
    }

    public Properties serverConfig() {
        return this.serverConfig;
    }

    public Properties controllerConfig() {
        return this.controllerConfig;
    }

    private Buffer<Consumer<?, ?>> consumers() {
        return this.consumers;
    }

    private Buffer<ShareConsumer<?, ?>> shareConsumers() {
        return this.shareConsumers;
    }

    private Buffer<KafkaProducer<?, ?>> producers() {
        return this.producers;
    }

    private Buffer<Admin> adminClients() {
        return this.adminClients;
    }

    public ListenerName interBrokerListenerName() {
        return this.listenerName();
    }

    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)x$1 -> {
            IntegrationTestHarness.$anonfun$modifyConfigs$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.brokerCount();
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$32 = this.trustStoreFile();
        Option<Properties> x$42 = this.serverSaslProperties();
        int x$5 = this.logDirCount();
        boolean x$6 = true;
        boolean x$7 = true;
        boolean x$8 = true;
        boolean x$9 = false;
        boolean x$10 = false;
        boolean x$11 = false;
        Map x$12 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        boolean x$13 = false;
        int x$14 = 1;
        short x$15 = 1;
        int x$16 = 0;
        boolean x$17 = false;
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$1, x$6, x$7, (Option<SecurityProtocol>)x$22, x$32, x$42, x$8, x$9, x$10, x$11, (Map<Object, String>)x$12, x$5, x$13, x$14, x$15, x$16, x$17);
        this.configureListeners(cfgs);
        this.modifyConfigs(cfgs);
        if (this.isShareGroupTest()) {
            cfgs.foreach((Function1 & Serializable)x$2 -> x$2.setProperty("group.coordinator.rebalance.protocols", "classic,consumer,share"));
            cfgs.foreach((Function1 & Serializable)x$3 -> x$3.setProperty("unstable.api.versions.enable", "true"));
        }
        cfgs.foreach((Function1 & Serializable)x$4 -> x$4.setProperty("metadata.log.dir", TestUtils.tempDirectory(null, null).getAbsolutePath()));
        this.insertControllerListenersIfNeeded(cfgs);
        return (Seq)cfgs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.controllerConfig(), (List)Nil$.MODULE$);
    }

    public void configureListeners(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)config -> {
            config.remove("security.inter.broker.protocol");
            config.setProperty("inter.broker.listener.name", this.interBrokerListenerName().value());
            Set listenerNames = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListenerName[]{this.listenerName(), this.interBrokerListenerName()}));
            String listeners = ((IterableOnceOps)listenerNames.map((Function1 & Serializable)listenerName -> listenerName.value() + "://localhost:" + TestUtils$.MODULE$.RandomPort())).mkString(",");
            String listenerSecurityMap = ((IterableOnceOps)listenerNames.map((Function1 & Serializable)listenerName -> listenerName.value() + ":" + $this.securityProtocol().name)).mkString(",");
            config.setProperty("listeners", listeners);
            config.setProperty("advertised.listeners", listeners);
            return config.setProperty("listener.security.protocol.map", listenerSecurityMap);
        });
    }

    private void insertControllerListenersIfNeeded(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)config -> {
            Object[] securityPairs = config.getProperty("listener.security.protocol.map", "").split(",");
            Object[] toAdd = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])config.getProperty("controller.listener.names", "").split(",")), arg_0 -> IntegrationTestHarness.$anonfun$insertControllerListenersIfNeeded$2$adapted((String[])securityPairs, arg_0));
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps(toAdd))) {
                return config.setProperty("listener.security.protocol.map", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(securityPairs), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(toAdd), (Function1 & Serializable)e -> e + ":" + this.controllerListenerSecurityProtocol().toString(), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class))).mkString(","));
            }
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, true);
    }

    public void doSuperuserSetup(TestInfo testInfo) {
        this.superuserClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
    }

    public void doSetup(TestInfo testInfo, boolean createOffsetsTopic) {
        Properties PropertiesOps_properties = this.producerConfig();
        Object var3_3 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties).$plus$plus$eq(this.clientSecurityProps("producer"));
        Properties PropertiesOps_properties2 = this.consumerConfig();
        Object var4_4 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties2).$plus$plus$eq(this.clientSecurityProps("consumer"));
        Properties PropertiesOps_properties3 = this.shareConsumerConfig();
        Object var5_5 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties3).$plus$plus$eq(this.clientSecurityProps("shareConsumer"));
        Properties PropertiesOps_properties4 = this.adminClientConfig();
        Object var6_6 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties4).$plus$plus$eq(this.clientSecurityProps("adminClient"));
        Properties PropertiesOps_properties5 = this.superuserClientConfig();
        Object var7_7 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties5).$plus$plus$eq(this.superuserSecurityProps("superuserClient"));
        super.setUp(testInfo);
        this.producerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.producerConfig().putIfAbsent("acks", "-1");
        this.producerConfig().putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        this.producerConfig().putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        this.consumerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.consumerConfig().putIfAbsent("auto.offset.reset", "earliest");
        this.consumerConfig().putIfAbsent("group.id", "group");
        this.consumerConfig().putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        this.consumerConfig().putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        this.maybeGroupProtocolSpecified().map((Function1 & Serializable)groupProtocol -> this.consumerConfig().putIfAbsent("group.protocol", groupProtocol.name));
        this.shareConsumerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.shareConsumerConfig().putIfAbsent("group.id", "group");
        this.shareConsumerConfig().putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        this.shareConsumerConfig().putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        this.adminClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.doSuperuserSetup(testInfo);
        if (createOffsetsTopic) {
            super.createOffsetsTopic(this.listenerName(), this.superuserClientConfig());
            return;
        }
    }

    public Properties clientSecurityProps(String certAlias) {
        return JaasTestUtils.securityConfigs(ConnectionMode.CLIENT, this.securityProtocol(), OptionConverters$.MODULE$.toJava(this.trustStoreFile()), certAlias, "localhost", OptionConverters$.MODULE$.toJava(this.clientSaslProperties()));
    }

    public Properties superuserSecurityProps(String certAlias) {
        return this.clientSecurityProps(certAlias);
    }

    public <K, V> KafkaProducer<K, V> createProducer(Serializer<K> keySerializer, Serializer<V> valueSerializer, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.producerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        KafkaProducer producer = new KafkaProducer(props, keySerializer, valueSerializer);
        this.producers().$plus$eq((Object)producer);
        return producer;
    }

    public <K, V> ByteArraySerializer createProducer$default$1() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$2() {
        return new ByteArraySerializer();
    }

    public <K, V> Properties createProducer$default$3() {
        return new Properties();
    }

    public <K, V> Consumer<K, V> createConsumer(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Properties configOverrides, List<String> configsToRemove) {
        if (!this.consumerConfig().containsKey("group.protocol")) {
            throw new IllegalStateException("Please specify the group.protocol configuration when creating a KafkaConsumer");
        }
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.consumerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        configsToRemove.foreach((Function1 & Serializable)x$6 -> props.remove(x$6));
        KafkaConsumer consumer = new KafkaConsumer(props, keyDeserializer, valueDeserializer);
        this.consumers().$plus$eq((Object)consumer);
        return consumer;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$1() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$2() {
        return new ByteArrayDeserializer();
    }

    public <K, V> Properties createConsumer$default$3() {
        return new Properties();
    }

    public <K, V> List<String> createConsumer$default$4() {
        return Nil$.MODULE$;
    }

    public <K, V> ShareConsumer<K, V> createShareConsumer(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Properties configOverrides, List<String> configsToRemove) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.shareConsumerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        configsToRemove.foreach((Function1 & Serializable)x$7 -> props.remove(x$7));
        KafkaShareConsumer shareConsumer = new KafkaShareConsumer(props, keyDeserializer, valueDeserializer);
        this.shareConsumers().$plus$eq((Object)shareConsumer);
        return shareConsumer;
    }

    public <K, V> ByteArrayDeserializer createShareConsumer$default$1() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createShareConsumer$default$2() {
        return new ByteArrayDeserializer();
    }

    public <K, V> Properties createShareConsumer$default$3() {
        return new Properties();
    }

    public <K, V> List<String> createShareConsumer$default$4() {
        return Nil$.MODULE$;
    }

    public Admin createAdminClient(ListenerName listenerName, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.adminClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, props);
        this.adminClients().$plus$eq((Object)admin);
        return admin;
    }

    public ListenerName createAdminClient$default$1() {
        return this.listenerName();
    }

    public Properties createAdminClient$default$2() {
        return new Properties();
    }

    public Admin createSuperuserAdminClient(ListenerName listenerName, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.superuserClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, props);
        this.adminClients().$plus$eq((Object)admin);
        return admin;
    }

    public ListenerName createSuperuserAdminClient$default$1() {
        return this.listenerName();
    }

    public Properties createSuperuserAdminClient$default$2() {
        return new Properties();
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            this.producers().foreach((Function1 & Serializable)x$8 -> {
                x$8.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.consumers().foreach((Function1 & Serializable)x$9 -> {
                x$9.wakeup();
                return BoxedUnit.UNIT;
            });
            this.consumers().foreach((Function1 & Serializable)x$10 -> {
                x$10.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.shareConsumers().foreach((Function1 & Serializable)x$11 -> {
                x$11.wakeup();
                return BoxedUnit.UNIT;
            });
            this.shareConsumers().foreach((Function1 & Serializable)x$12 -> {
                x$12.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.adminClients().foreach((Function1 & Serializable)x$13 -> {
                x$13.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.producers().clear();
            this.consumers().clear();
            this.shareConsumers().clear();
            this.adminClients().clear();
        }
        finally {
            super.tearDown();
        }
    }

    public static final /* synthetic */ void $anonfun$modifyConfigs$1(IntegrationTestHarness $this, Properties x$1) {
        new Implicits.PropertiesOps(x$1).$plus$plus$eq($this.serverConfig());
    }

    public static final /* synthetic */ boolean $anonfun$insertControllerListenersIfNeeded$2(String[] securityPairs$1, String e) {
        return !ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])securityPairs$1), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(e + ":")));
    }

    public static final /* synthetic */ Object $anonfun$insertControllerListenersIfNeeded$2$adapted(String[] securityPairs$1, String e) {
        return BoxesRunTime.boxToBoolean((boolean)IntegrationTestHarness.$anonfun$insertControllerListenersIfNeeded$2(securityPairs$1, e));
    }
}

