/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0007\u0001\u0005\u0002eAQA\u0013\u0001\u0005\u0002-CQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0017\u0001\u0005\u0002eCQa\u0018\u0001\u0005\u0002\u0001DQA\u001a\u0001\u0005\u0002\u001dDQ!\u001c\u0001\u0005\u00029DQ\u0001\u001e\u0001\u0005\u0002U\u00141\u0004\u00157bS:$X\r\u001f;D_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8UKN$(B\u0001\u0007\u000e\u0003\r\t\u0007/\u001b\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\f\u0013\t!2B\u0001\u000bBEN$(/Y2u\u0007>t7/^7feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001\u0002IQ,7\u000f^!tg&<g.\u00118e\u0007>lW.\u001b;Bgft7MT8u\u0007>lW.\u001b;uK\u0012$2A\u0007\u0011.!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0011)f.\u001b;\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\rE,xN];n!\t\u0019#F\u0004\u0002%QA\u0011Q\u0005H\u0007\u0002M)\u0011qeD\u0001\u0007yI|w\u000e\u001e \n\u0005%b\u0012A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\u000f\t\u000b9\u0012\u0001\u0019\u0001\u0012\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8mQ\u0011\u0011\u0001\u0007P\u001f\u0011\u0005ERT\"\u0001\u001a\u000b\u0005M\"\u0014A\u00029be\u0006l7O\u0003\u00026m\u00059!.\u001e9ji\u0016\u0014(BA\u001c9\u0003\u0015QWO\\5u\u0015\u0005I\u0014aA8sO&\u00111H\r\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013AP\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u0011\u0011\u0001IR$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0013\u0014\u0001\u00039s_ZLG-\u001a:\n\u0005\u0015\u0013%\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&\u0001%\"\u0003%\u000b!fZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.A\u0012uKN$\u0018i]:jO:\fe\u000eZ\"p[6LGoU=oG:{GoQ8n[&$H/\u001a3\u0015\u0007iaU\nC\u0003\"\u0007\u0001\u0007!\u0005C\u0003/\u0007\u0001\u0007!\u0005\u000b\u0003\u0004aqj\u0004\u0006B\u0002A\rBc\u0013\u0001S\u0001#i\u0016\u001cH/Q:tS\u001et\u0017I\u001c3D_6l\u0017\u000e^*z]\u000e\fE\u000e\\\"p]N,X.\u001a3\u0015\u0007i\u0019F\u000bC\u0003\"\t\u0001\u0007!\u0005C\u0003/\t\u0001\u0007!\u0005\u000b\u0003\u0005aqj\u0004\u0006\u0002\u0003A\r^c\u0013\u0001S\u0001\u0015i\u0016\u001cH/Q:tS\u001et\u0017I\u001c3D_:\u001cX/\\3\u0015\u0007iQ6\fC\u0003\"\u000b\u0001\u0007!\u0005C\u0003/\u000b\u0001\u0007!\u0005\u000b\u0003\u0006aqj\u0004\u0006B\u0003A\rzc\u0013\u0001S\u0001%i\u0016\u001cH/Q:tS\u001et\u0017I\u001c3D_:\u001cX/\\3TW&\u0004\b/\u001b8h!>\u001c\u0018\u000e^5p]R\u0019!$\u00192\t\u000b\u00052\u0001\u0019\u0001\u0012\t\u000b92\u0001\u0019\u0001\u0012)\t\u0019\u0001D(\u0010\u0015\u0005\r\u00013U\rL\u0001I\u0003\t\"Xm\u001d;BgNLwM\\!oI\u001a+Go\u00195D_6l\u0017\u000e\u001e;fI>3gm]3ugR\u0019!\u0004[5\t\u000b\u0005:\u0001\u0019\u0001\u0012\t\u000b9:\u0001\u0019\u0001\u0012)\t\u001d\u0001D(\u0010\u0015\u0005\u000f\u00013E\u000eL\u0001I\u0003!\"Xm\u001d;BgNLwM\\!oI\u000e{gn];nK\u001a\u0013x.\\\"p[6LG\u000f^3e\u001f\u001a47/\u001a;t)\rQr\u000e\u001d\u0005\u0006C!\u0001\rA\t\u0005\u0006]!\u0001\rA\t\u0015\u0005\u0011AbT\b\u000b\u0003\t\u0001\u001a\u001bH&\u0001%\u0002iQ,7\u000f^!tg&<g.\u00118e%\u0016$(/[3wS:<7i\\7nSR$X\rZ(gMN,Go]'vYRL\u0007\u000f\\3US6,7\u000fF\u0002\u001bm^DQ!I\u0005A\u0002\tBQAL\u0005A\u0002\tBC!\u0003\u0019={!\"\u0011\u0002\u0011${Y\u0005A\u0005&\u0002\u0001}\r\u0006\r\u0001CA?\u0000\u001b\u0005q(B\u0001\u00075\u0013\r\t\tA \u0002\b)&lWm\\;u=\t\u0011\u0001\f")
public class PlaintextConsumerAssignTest
extends AbstractConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndCommitAsyncNotCommitted(String quorum, String groupProtocol) {
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        AbstractConsumerTest.CountConsumerCommitCallback cb = new AbstractConsumerTest.CountConsumerCommitCallback(this);
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitAsync((OffsetCommitCallback)cb);
        long pollUntilTrue_waitTimeMs = 10000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerAssignTest.$anonfun$testAssignAndCommitAsyncNotCommitted$1(cb)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to observe commit callback before timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        java.util.Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndCommitSyncNotCommitted(String quorum, String groupProtocol) {
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 10000;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.commitSync();
        java.util.Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNull(committedOffset.get(this.tp()));
        Assertions.assertTrue((boolean)consumer.assignment().contains(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndCommitSyncAllConsumed(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        long x$13 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12, x$13);
        consumer.commitSync();
        java.util.Map committedOffset = consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertNotNull((Object)committedOffset);
        Assertions.assertNotNull(committedOffset.get(this.tp()));
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)committedOffset.get(this.tp())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndConsume(String quorum, String groupProtocol) {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties props = new Properties();
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer = this.createConsumer(x$3, x$4, props, (List<String>)x$2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        long x$13 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12, x$13);
        Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndConsumeSkippingPosition(String quorum, String groupProtocol) {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties props = new Properties();
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer = this.createConsumer(x$3, x$4, props, (List<String>)x$2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int offset = 1;
        consumer.seek(this.tp(), (long)offset);
        this.consumeAndVerifyRecords(consumer, numRecords - offset, offset, offset, startingTimestamp + (long)offset, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
        Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndFetchCommittedOffsets(String quorum, String groupProtocol) {
        int numRecords = 100;
        long startingTimestamp = System.currentTimeMillis();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        long x$13 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12, x$13);
        consumer.commitSync();
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        ByteArrayDeserializer x$15 = this.createConsumer$default$1();
        ByteArrayDeserializer x$16 = this.createConsumer$default$2();
        List<String> x$17 = this.createConsumer$default$4();
        Consumer anotherConsumer = this.createConsumer(x$15, x$16, props, x$17);
        anotherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndConsumeFromCommittedOffsets(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int numRecords = 100;
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties props = new Properties();
        props.setProperty("group.id", "group1");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int offset = 10;
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata((long)offset))}))).asJava());
        Assertions.assertEquals((long)offset, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        consumer.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        Consumer anotherConsumer = this.createConsumer(x$6, x$7, props, x$8);
        Assertions.assertEquals((long)offset, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        anotherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeAndVerifyRecords(anotherConsumer, numRecords - offset, offset, offset, startingTimestamp + (long)offset, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAssignAndRetrievingCommittedOffsetsMultipleTimes(String quorum, String groupProtocol) {
        int numRecords = 100;
        long startingTimestamp = System.currentTimeMillis();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Properties props = new Properties();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, props, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$9 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$10 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$11 = this.consumeAndVerifyRecords$default$7();
        int x$12 = this.consumeAndVerifyRecords$default$8();
        long x$13 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$9, startingTimestamp, x$10, x$11, x$12, x$13);
        consumer.commitSync();
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)numRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
    }

    public static final /* synthetic */ boolean $anonfun$testAssignAndCommitAsyncNotCommitted$1(AbstractConsumerTest.CountConsumerCommitCallback cb$1) {
        return cb$1.successCount() >= 1 || cb$1.lastError().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAssignAndCommitAsyncNotCommitted$2() {
        return "Failed to observe commit callback before timeout";
    }
}

