/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\u0006\f\u0001AAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0007\u0001\u0005\u0002eAQA\u0013\u0001\u0005\u0002-CQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0017\u0001\u0005\u0002eCQa\u0018\u0001\u0005\u0002\u0001DQA\u001a\u0001\u0005\u0002\u001dDQA\u001d\u0001\u0005\u0002MDQ!\u001f\u0001\u0005\u0002i\u0014a\u0004\u00157bS:$X\r\u001f;D_:\u001cX/\\3s\u0003N\u001c\u0018n\u001a8peN$Vm\u001d;\u000b\u00051i\u0011aA1qS*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u0005Y\u0011B\u0001\u000b\f\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u0006\t\u0003%\u0001\t\u0001\u0004^3tiJ{WO\u001c3S_\nLg.Q:tS\u001etW.\u001a8u)\rQ\u0002%\f\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0005+:LG\u000fC\u0003\"\u0005\u0001\u0007!%\u0001\u0004rk>\u0014X/\u001c\t\u0003G)r!\u0001\n\u0015\u0011\u0005\u0015bR\"\u0001\u0014\u000b\u0005\u001dz\u0011A\u0002\u001fs_>$h(\u0003\u0002*9\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\rM#(/\u001b8h\u0015\tIC\u0004C\u0003/\u0005\u0001\u0007!%A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0005\u0005AbT\b\u0005\u00022u5\t!G\u0003\u00024i\u00051\u0001/\u0019:b[NT!!\u000e\u001c\u0002\u000f),\b/\u001b;fe*\u0011q\u0007O\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002s\u0005\u0019qN]4\n\u0005m\u0012$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005q\u0014AK>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{::'o\\;q!J|Go\\2pYvZ\u0018' \u0015\u0005\u0005\u00013u\t\u0005\u0002B\t6\t!I\u0003\u0002De\u0005A\u0001O]8wS\u0012,'/\u0003\u0002F\u0005\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\n\u0001*I\u0001J\u0003}:W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:DY\u0006\u001c8/[2He>,\b\u000f\u0015:pi>\u001cw\u000e\\(oYf\f1\u0005^3ti6+H\u000e^5D_:\u001cX/\\3s%>,h\u000e\u001a*pE&t\u0017i]:jO:|'\u000fF\u0002\u001b\u00196CQ!I\u0002A\u0002\tBQAL\u0002A\u0002\tBCa\u0001\u0019={!\"1\u0001\u0011$QY\u0005A\u0015a\b;fgRlU\u000f\u001c;j\u0007>t7/^7feN#\u0018nY6z\u0003N\u001c\u0018n\u001a8peR\u0019!d\u0015+\t\u000b\u0005\"\u0001\u0019\u0001\u0012\t\u000b9\"\u0001\u0019\u0001\u0012)\t\u0011\u0001D(\u0010\u0015\u0005\t\u00013u\u000bL\u0001I\u0003M\"Xm\u001d;Nk2$\u0018nQ8ogVlWM\u001d#fM\u0006,H\u000e^!tg&<gn\u001c:B]\u00124VM]5gs\u0006\u001b8/[4o[\u0016tG\u000fF\u0002\u001b5nCQ!I\u0003A\u0002\tBQAL\u0003A\u0002\tBC!\u0002\u0019={!\"Q\u0001\u0011$_Y\u0005A\u0015\u0001\t;fgRlU\u000f\u001c;j\u0007>t7/^7fe\u0012+g-Y;mi\u0006\u001b8/[4o_J$2AG1c\u0011\u0015\tc\u00011\u0001#\u0011\u0015qc\u00011\u0001#Q\u00111\u0001\u0007P\u001f)\t\u0019\u0001e)\u001a\u0017\u0002\u0011\u0006IB/Z:u%\u0016lw\u000e^3BgNLwM\\8s\u0013:4\u0018\r\\5e)\rQ\u0002.\u001b\u0005\u0006C\u001d\u0001\rA\t\u0005\u0006]\u001d\u0001\rA\t\u0015\u0005\u000fAbT\b\u000b\u0003\bY\u001a{\u0007CA!n\u0013\tq'IA\u0005DgZ\u001cv.\u001e:dK2\n\u0001/I\u0001r\u0003=Y'/\u00194uY\u0001\u001awN\\:v[\u0016\u0014\u0018a\u0006;fgR\u0014V-\\8uK\u0006\u001b8/[4o_J\u0014\u0016M\\4f)\rQB/\u001e\u0005\u0006C!\u0001\rA\t\u0005\u0006]!\u0001\rA\t\u0015\u0005\u0011AbT\b\u000b\u0003\tY\u001aCH&\u00019\u0002-Q,7\u000f\u001e*fE\u0006d\u0017M\\2f\u0003:$'+\u001a6pS:$BAG>}{\")\u0011%\u0003a\u0001E!)a&\u0003a\u0001E!)a0\u0003a\u0001E\u0005\u0011\u0012m]:jO:lWM\u001c;TiJ\fG/Z4zQ\u0015I\u0001\u0007PA\u0001C\t\t\u0019!A!|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|autsM]8vaB\u0013x\u000e^8d_2l40M?/CN\u001c\u0018n\u001a8nK:$8\u000b\u001e:bi\u0016<\u00170P>3{\"*\u0011\u0002\u001c$\u0002\b1B\u0011\u0011BA\u0007\u0003#\t)\"\t\u0002\u0002\f\u0005Y%p\u001b\u0017!A\u0001\u00023\r\\1tg&\u001cG\u0006I8sO:\n\u0007/Y2iK:Z\u0017MZ6b]\rd\u0017.\u001a8ug:\u001awN\\:v[\u0016\u0014hfQ8pa\u0016\u0014\u0018\r^5wKN#\u0018nY6z\u0003N\u001c\u0018n\u001a8pe\u0006\u0012\u0011qB\u0001@u.d\u0003\u0005\t\u0011!G2\f7o]5dY\u0001z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018lC\u001a\\\u0017ML2mS\u0016tGo\u001d\u0018d_:\u001cX/\\3s]I\u000bgnZ3BgNLwM\\8sC\t\t\u0019\"A&le\u00064G\u000f\f\u0011dY\u0006\u001c8/[2-A=\u0014xML1qC\u000eDWML6bM.\fgf\u00197jK:$8OL2p]N,X.\u001a:/\u0007>|\u0007/\u001a:bi&4Xm\u0015;jG.L\u0018i]:jO:|'/\t\u0002\u0002\u0018\u0005y4N]1gi2\u00023\r\\1tg&\u001cG\u0006I8sO:\n\u0007/Y2iK:Z\u0017MZ6b]\rd\u0017.\u001a8ug:\u001awN\\:v[\u0016\u0014hFU1oO\u0016\f5o]5h]>\u0014\bF\u0002\u0001\u0002\u001c\u0019\u000b)\u0003\u0005\u0003\u0002\u001e\u0005\u0005RBAA\u0010\u0015\taA'\u0003\u0003\u0002$\u0005}!a\u0002+j[\u0016|W\u000f\u001e\u0010\u0003\u0005a\u0003")
public class PlaintextConsumerAssignorsTest
extends AbstractConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testRoundRobinAssignment(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic3, 0), new TopicPartition(topic3, 1)})));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerRoundRobinAssignor(String quorum, String groupProtocol) {
        void var9_9;
        this.consumerConfig().setProperty("group.id", "roundrobin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", RoundRobinAssignor.class.getName());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 5, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 8, 100));
        Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(10, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        try {
            void var8_8;
            this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var9_9, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<Consumer<byte[], byte[]>>)var8_8, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var9_9, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions, "roundrobin-group");
        }
        finally {
            var9_9.foreach((Function1 & Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerStickyAssignor(String quorum, String groupProtocol) {
        void var8_8;
        void var9_9;
        this.consumerConfig().setProperty("group.id", "sticky-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", StickyAssignor.class.getName());
        String topic = "single-topic";
        int rand = 1 + Random$.MODULE$.nextInt(10);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicAndSendRecords(producer, topic, rand * 10, 100);
        Tuple2<Buffer<Consumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.createConsumerGroupAndWaitForAssignment(9, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer consumerGroup = (Buffer)tuple2._1();
        Buffer consumerPollers = (Buffer)tuple2._2();
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var9_9, partitions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        Map prePartition2PollerId = PlaintextConsumerAssignorsTest.reverse$1(((IterableOnceOps)var9_9.map((Function1 & Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.addConsumersToGroupAndWaitForGroupAssignment(1, (Buffer<Consumer<byte[], byte[]>>)var8_8, (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)var9_9, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, "sticky-group");
        Map postPartition2PollerId = PlaintextConsumerAssignorsTest.reverse$1(((IterableOnceOps)var9_9.map((Function1 & Serializable)poller -> new Tuple2((Object)BoxesRunTime.boxToLong((long)poller.getId()), poller.consumerAssignment()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)prePartition2PollerId.keySet().union((Set)postPartition2PollerId.keySet());
        IntRef changes = IntRef.create((int)0);
        keys.foreach((Function1 & Serializable)key -> {
            PlaintextConsumerAssignorsTest.$anonfun$testMultiConsumerStickyAssignor$5(prePartition2PollerId, postPartition2PollerId, changes, key);
            return BoxedUnit.UNIT;
        });
        var9_9.foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)rand, (int)changes.elem, (String)"Expected only two topic partitions that have switched to other consumers.");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerDefaultAssignorAndVerifyAssignment(String quorum, String groupProtocol) {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic2, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        TopicPartition tp1_0 = new TopicPartition(topic1, 0);
        TopicPartition tp1_1 = new TopicPartition(topic1, 1);
        TopicPartition tp1_2 = new TopicPartition(topic1, 2);
        TopicPartition tp2_0 = new TopicPartition(topic2, 0);
        TopicPartition tp2_1 = new TopicPartition(topic2, 1);
        TopicPartition tp2_2 = new TopicPartition(topic2, 2);
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp1_2, tp2_0, tp2_1, tp2_2}));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<Consumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)));
        Buffer expectedAssignment = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{(scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_0, tp1_1, tp2_0, tp2_1})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1_2, tp2_2}))}));
        try {
            Option<String> x$4 = this.validateGroupAssignment$default$3();
            long x$5 = this.validateGroupAssignment$default$4();
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, x$4, x$5, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable)x$6 -> {
                x$6.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly"})
    public void testMultiConsumerDefaultAssignor(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 5, 100));
        Buffer consumersInGroup = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        consumersInGroup.$plus$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
        Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = this.subscribeConsumers((Buffer<Consumer<byte[], byte[]>>)consumersInGroup, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)));
        try {
            this.validateGroupAssignment(consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
            this.addConsumersToGroupAndWaitForGroupAssignment(2, (Buffer<Consumer<byte[], byte[]>>)consumersInGroup, consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.addConsumersToGroupAndWaitForGroupAssignment$default$6());
            String topic2 = "topic2";
            scala.collection.immutable.Set expandedSubscriptions = (scala.collection.immutable.Set)subscriptions.$plus$plus(this.createTopicAndSendRecords(producer, topic2, 3, 100));
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))), (scala.collection.immutable.Set<TopicPartition>)expandedSubscriptions);
            this.changeConsumerGroupSubscriptionAndValidateAssignment(consumerPollers, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)subscriptions);
        }
        finally {
            consumerPollers.foreach((Function1 & Serializable)x$7 -> {
                x$7.shutdown();
                return BoxedUnit.UNIT;
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @CsvSource(value={"kraft, consumer"})
    public void testRemoteAssignorInvalid(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("group.id", "invalid-assignor-group");
        this.consumerConfig().setProperty("group.remote.assignor", "invalid");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> expectedAssignment = this.createTopicAndSendRecords(producer, topic1, 2, 100);
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)((UnsupportedAssignorException)Assertions.assertThrows(UnsupportedAssignorException.class, () -> this.awaitAssignment(consumer, expectedAssignment))).getMessage().startsWith("ServerAssignor invalid is not supported. Supported assignors: "));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @CsvSource(value={"kraft, consumer"})
    public void testRemoteAssignorRange(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("group.id", "range-group");
        this.consumerConfig().setProperty("group.remote.assignor", "range");
        this.consumerConfig().setProperty("max.poll.interval.ms", "30000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic1 = "topic1";
        String topic2 = "topic2";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set expectedAssignment = (scala.collection.immutable.Set)this.createTopicAndSendRecords(producer, topic1, 2, 100).$plus$plus(this.createTopicAndSendRecords(producer, topic2, 2, 100));
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        String topic3 = "topic3";
        scala.collection.immutable.Set<TopicPartition> additionalAssignment = this.createTopicAndSendRecords(producer, topic3, 2, 100);
        scala.collection.immutable.Set newExpectedAssignment = (scala.collection.immutable.Set)expectedAssignment.$plus$plus(additionalAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)))).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)newExpectedAssignment);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)expectedAssignment);
        consumer.unsubscribe();
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}.assignmentStrategy={2}")
    @CsvSource(value={"zk,    classic, org.apache.kafka.clients.consumer.CooperativeStickyAssignor", "zk,    classic, org.apache.kafka.clients.consumer.RangeAssignor", "kraft, classic, org.apache.kafka.clients.consumer.CooperativeStickyAssignor", "kraft, classic, org.apache.kafka.clients.consumer.RangeAssignor"})
    public void testRebalanceAndRejoin(String quorum, String groupProtocol, String assignmentStrategy) {
        String stableMemberId1;
        int stableGeneration;
        this.consumerConfig().setProperty("group.protocol", groupProtocol);
        this.consumerConfig().setProperty("group.id", "rebalance-and-rejoin-group");
        this.consumerConfig().setProperty("partition.assignment.strategy", assignmentStrategy);
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        Consumer consumer1 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Consumer consumer2 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        String topic = "topic1";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        scala.collection.immutable.Set<TopicPartition> expectedAssignment = this.createTopicAndSendRecords(producer, topic, 2, 100);
        Assertions.assertEquals((int)0, (int)consumer1.assignment().size());
        Assertions.assertEquals((int)0, (int)consumer2.assignment().size());
        ReentrantLock lock = new ReentrantLock();
        IntRef generationId1 = IntRef.create((int)-1);
        ObjectRef memberId1 = ObjectRef.create((Object)"");
        ConsumerRebalanceListener customRebalanceListener = new ConsumerRebalanceListener(null, lock, generationId1, consumer1, memberId1){
            private final ReentrantLock lock$1;
            private final IntRef generationId1$1;
            private final Consumer consumer1$1;
            private final ObjectRef memberId1$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (!this.lock$1.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    Assertions.fail((String)"Time out while awaiting for lock.");
                }
                try {
                    this.generationId1$1.elem = this.consumer1$1.groupMetadata().generationId();
                    this.memberId1$1.elem = this.consumer1$1.groupMetadata().memberId();
                }
                finally {
                    this.lock$1.unlock();
                }
            }
            {
                this.lock$1 = lock$1;
                this.generationId1$1 = generationId1$1;
                this.consumer1$1 = consumer1$1;
                this.memberId1$1 = memberId1$1;
            }
        };
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1 = new AbstractConsumerTest.ConsumerAssignmentPoller(this, consumer1, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), customRebalanceListener);
        consumerPoller1.start();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$1(consumerPoller1, expectedAssignment)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$2(expectedAssignment));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Time out while awaiting for lock.");
        }
        try {
            stableGeneration = generationId1.elem;
            stableMemberId1 = (String)memberId1.elem;
        }
        finally {
            lock.unlock();
        }
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller2 = this.subscribeConsumerAndStartPolling(consumer2, (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$3(consumerPoller1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out while awaiting expected assignment size change to 1.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextConsumerAssignorsTest.$anonfun$testRebalanceAndRejoin$5(consumerPoller2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out while awaiting expected assignment size change to 1.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Time out while awaiting for lock.");
        }
        try {
            if (assignmentStrategy.equals(CooperativeStickyAssignor.class.getName())) {
                Assertions.assertEquals((int)(stableGeneration + 2), (int)generationId1.elem);
            } else {
                Assertions.assertEquals((int)(stableGeneration + 1), (int)generationId1.elem);
            }
            Assertions.assertEquals((Object)stableMemberId1, (Object)((String)memberId1.elem));
        }
        finally {
            lock.unlock();
        }
        consumerPoller1.shutdown();
        consumerPoller2.shutdown();
    }

    private static final Map reverse$1(Map m) {
        return ((IterableOnceOps)((IterableOps)m.values().toSet().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)v -> new Tuple2(v, ((IterableOps)m.keys().filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> ((SetOps)m.apply((Object)BoxesRunTime.boxToLong((long)x$3))).contains(v))).head()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ void $anonfun$testMultiConsumerStickyAssignor$5(Map prePartition2PollerId$1, Map postPartition2PollerId$1, IntRef changes$1, TopicPartition key) {
        Option preVal = prePartition2PollerId$1.get((Object)key);
        Option postVal = postPartition2PollerId$1.get((Object)key);
        if (preVal.nonEmpty() && postVal.nonEmpty()) {
            if (BoxesRunTime.unboxToLong((Object)preVal.get()) != BoxesRunTime.unboxToLong((Object)postVal.get())) {
                ++changes$1.elem;
                return;
            }
            return;
        }
        ++changes$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$1(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1$1, scala.collection.immutable.Set expectedAssignment$2) {
        scala.collection.immutable.Set<TopicPartition> set = consumerPoller1$1.consumerAssignment();
        return !(set != null ? !set.equals((Object)expectedAssignment$2) : expectedAssignment$2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$2(scala.collection.immutable.Set expectedAssignment$2) {
        return "Timed out while awaiting expected assignment change to " + expectedAssignment$2 + ".";
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$3(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller1$1) {
        return consumerPoller1$1.consumerAssignment().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$4() {
        return "Timed out while awaiting expected assignment size change to 1.";
    }

    public static final /* synthetic */ boolean $anonfun$testRebalanceAndRejoin$5(AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller2$1) {
        return consumerPoller2$1.consumerAssignment().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testRebalanceAndRejoin$6() {
        return "Timed out while awaiting expected assignment size change to 1.";
    }
}

