/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAQ\u0001\b\u0001\u0005\u0002uAQA\u0014\u0001\u0005\u0002=CQ!\u0016\u0001\u0005\u0002YCQ\u0001\u0018\u0001\u0005\u0002uCQa\u0019\u0001\u0005\u0002\u0011DQA\u001b\u0001\u0005\u0002-DQ!\u001d\u0001\u0005\u0002IDQ\u0001\u001f\u0001\u0005\u0002eDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\u00111\u0004\u00157bS:$X\r\u001f;D_:\u001cX/\\3s\u0007>lW.\u001b;UKN$(B\u0001\t\u0012\u0003\r\t\u0007/\u001b\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\u0010\u0013\tArB\u0001\u000bBEN$(/Y2u\u0007>t7/^7feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002+Q,7\u000f^!vi>\u001cu.\\7ji>s7\t\\8tKR\u0019a\u0004J\u0019\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\t\u0001\rAJ\u0001\u0007cV|'/^7\u0011\u0005\u001drcB\u0001\u0015-!\tI\u0003%D\u0001+\u0015\tY3#\u0001\u0004=e>|GOP\u0005\u0003[\u0001\na\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006\t\u0005\u0006e\t\u0001\rAJ\u0001\u000eOJ|W\u000f\u001d)s_R|7m\u001c7)\t\t!\u0004)\u0011\t\u0003kyj\u0011A\u000e\u0006\u0003oa\na\u0001]1sC6\u001c(BA\u001d;\u0003\u001dQW\u000f]5uKJT!a\u000f\u001f\u0002\u000b),h.\u001b;\u000b\u0003u\n1a\u001c:h\u0013\tydGA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\n!)\u0001\u0016|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|autsM]8vaB\u0013x\u000e^8d_2l40M?)\t\t!%j\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fZ\n\u0001\u0002\u001d:pm&$WM]\u0005\u0003\u0013\u001a\u0013A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013\u0001T\u0011\u0002\u001b\u0006Qs-\u001a;UKN$\u0018+^8sk6\fe\u000eZ$s_V\u0004\bK]8u_\u000e|G\u000eU1sC6,G/\u001a:t\u00032d\u0017\u0001\t;fgR\fU\u000f^8D_6l\u0017\u000e^(o\u00072|7/Z!gi\u0016\u0014x+Y6fkB$2A\b)R\u0011\u0015)3\u00011\u0001'\u0011\u0015\u00114\u00011\u0001'Q\u0011\u0019A\u0007Q!)\t\r!%\n\u0016\u0017\u0002\u0019\u0006\u0011B/Z:u\u0007>lW.\u001b;NKR\fG-\u0019;b)\rqr\u000b\u0017\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006e\u0011\u0001\rA\n\u0015\u0005\tQ\u0002\u0015\t\u000b\u0003\u0005\t*[F&\u0001'\u0002\u001fQ,7\u000f^!ts:\u001c7i\\7nSR$2A\b0`\u0011\u0015)S\u00011\u0001'\u0011\u0015\u0011T\u00011\u0001'Q\u0011)A\u0007Q!)\t\u0015!%J\u0019\u0017\u0002\u0019\u00069B/Z:u\u0003V$xnQ8n[&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u000b\u0004=\u00154\u0007\"B\u0013\u0007\u0001\u00041\u0003\"\u0002\u001a\u0007\u0001\u00041\u0003\u0006\u0002\u00045\u0001\u0006CCA\u0002#KS2\nA*\u0001\u000euKN$8i\\7nSR\u001c\u0006/Z2jM&,Gm\u00144gg\u0016$8\u000fF\u0002\u001fY6DQ!J\u0004A\u0002\u0019BQAM\u0004A\u0002\u0019BCa\u0002\u001bA\u0003\"\"q\u0001\u0012&qY\u0005a\u0015!\u0007;fgR\fU\u000f^8D_6l\u0017\u000e^(o%\u0016\u0014\u0017\r\\1oG\u0016$2AH:u\u0011\u0015)\u0003\u00021\u0001'\u0011\u0015\u0011\u0004\u00021\u0001'Q\u0011AA\u0007Q!)\t!!%j\u001e\u0017\u0002\u0019\u0006QB/Z:u'V\u00147o\u0019:jE\u0016\fe\u000eZ\"p[6LGoU=oGR\u0019aD_>\t\u000b\u0015J\u0001\u0019\u0001\u0014\t\u000bIJ\u0001\u0019\u0001\u0014)\t%!\u0004)\u0011\u0015\u0005\u0013\u0011Se\u0010L\u0001M\u0003U!Xm\u001d;Q_NLG/[8o\u0003:$7i\\7nSR$RAHA\u0002\u0003\u000bAQ!\n\u0006A\u0002\u0019BQA\r\u0006A\u0002\u0019BCA\u0003\u001bA\u0003\"*!\u0002\u0012&\u0002\f1\nA*\u0001\u0017uKN$8i\\7nSR\f5/\u001f8d\u0007>l\u0007\u000f\\3uK\u0012\u0014UMZ8sK\u000e{gn];nKJ\u001cEn\\:fgR)a$!\u0005\u0002\u0014!)Qe\u0003a\u0001M!)!g\u0003a\u0001M!\"1\u0002\u000e!BQ\u0015YAISA\rY\t\tY\"\t\u0002\u0002\u001e\u0005\u0001u-\u001a;UKN$\u0018+^8sk6\fe\u000eZ$s_V\u0004\bK]8u_\u000e|G\u000eU1sC6,G/\u001a:t\u0007>t7/^7fe\u001e\u0013x.\u001e9Qe>$xnY8m\u001f:d\u00170A\u0018uKN$8i\\7nSR\f5/\u001f8d\u0007>l\u0007\u000f\\3uK\u0012\u0014UMZ8sK\u000e{W.\\5u'ft7MU3ukJt7\u000fF\u0003\u001f\u0003G\t)\u0003C\u0003&\u0019\u0001\u0007a\u0005C\u00033\u0019\u0001\u0007a\u0005\u000b\u0003\ri\u0001\u000b\u0005&\u0002\u0007E\u0015\u0006-BFAA\u000e\u0003=\u001a\u0007.\u00198hK\u000e{gn];nKJ\u001cVOY:de&\u0004H/[8o\u0003:$g+\u00197jI\u0006$X-Q:tS\u001etW.\u001a8u+\u0019\t\t$a\u0014\u0002dQIa$a\r\u0002h\u0005u\u00141\u0013\u0005\b\u0003ki\u0001\u0019AA\u001c\u0003!\u0019wN\\:v[\u0016\u0014\b\u0003CA\u001d\u0003\u000f\nY%!\u0019\u000e\u0005\u0005m\"\u0002BA\u001b\u0003{QA!a\u0010\u0002B\u000591\r\\5f]R\u001c(b\u0001\n\u0002D)\u0019\u0011Q\t\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tI%a\u000f\u0003\u0011\r{gn];nKJ\u0004B!!\u0014\u0002P1\u0001AaBA)\u001b\t\u0007\u00111\u000b\u0002\u0002\u0017F!\u0011QKA.!\ry\u0012qK\u0005\u0004\u00033\u0002#a\u0002(pi\"Lgn\u001a\t\u0004?\u0005u\u0013bAA0A\t\u0019\u0011I\\=\u0011\t\u00055\u00131\r\u0003\b\u0003Kj!\u0019AA*\u0005\u00051\u0006bBA5\u001b\u0001\u0007\u00111N\u0001\u0012i>\u0004\u0018nY:U_N+(m]2sS\n,\u0007#BA7\u0003o2c\u0002BA8\u0003gr1!KA9\u0013\u0005\t\u0013bAA;A\u00059\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u0012A\u0001T5ti*\u0019\u0011Q\u000f\u0011\t\u000f\u0005}T\u00021\u0001\u0002\u0002\u0006\u0011R\r\u001f9fGR,G-Q:tS\u001etW.\u001a8u!\u00159\u00131QAD\u0013\r\t)\t\r\u0002\u0004'\u0016$\b\u0003BAE\u0003\u001fk!!a#\u000b\t\u00055\u0015\u0011I\u0001\u0007G>lWn\u001c8\n\t\u0005E\u00151\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)*\u0004a\u0001\u0003/\u000b\u0011C]3cC2\fgnY3MSN$XM\\3s!\u0011\tI$!'\n\t\u0005m\u00151\b\u0002\u001a\u0007>t7/^7feJ+'-\u00197b]\u000e,G*[:uK:,'\u000f\u000b\u0004\u0001\u0003?S\u0015\u0011\u0016\t\u0005\u0003C\u000b)+\u0004\u0002\u0002$*\u0011\u0001\u0003O\u0005\u0005\u0003O\u000b\u0019KA\u0004US6,w.\u001e;\u001f\u0005\tA\u0006")
public class PlaintextConsumerCommitTest
extends AbstractConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoCommitOnClose(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.close();
        Consumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoCommitOnCloseAfterWakeup(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.wakeup();
        consumer.close();
        Consumer anotherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)anotherConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCommitMetadata(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        OffsetAndMetadata syncMetadata = new OffsetAndMetadata(5L, Optional.of(Predef$.MODULE$.int2Integer(15)), "foo");
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)syncMetadata)}))).asJava());
        Assertions.assertEquals((Object)syncMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata asyncMetadata = new OffsetAndMetadata(10L, "bar");
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)asyncMetadata)}))));
        Assertions.assertEquals((Object)asyncMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
        OffsetAndMetadata nullMetadata = new OffsetAndMetadata(5L, null);
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)nullMetadata)}))).asJava());
        Assertions.assertEquals((Object)nullMetadata, consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAsyncCommit(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback callback = new AbstractConsumerTest.CountConsumerCommitCallback();
        int count = 5;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata((long)i))}))).asJava(), (OffsetCommitCallback)callback));
        long pollUntilTrue_waitTimeMs = 10000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (PlaintextConsumerCommitTest.$anonfun$testAsyncCommit$2(callback, count)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to observe commit callback before timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)None$.MODULE$, callback.lastError());
        Assertions.assertEquals((int)count, (int)callback.successCount());
        Assertions.assertEquals((Object)new OffsetAndMetadata((long)count), consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoCommitIntercept(String quorum, String groupProtocol) {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        int numRecords = 100;
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), this.createProducer$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)("key " + BoxesRunTime.unboxToInt((Object)i)), (Object)("value " + BoxesRunTime.unboxToInt((Object)i))))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, testConsumer){
            private final Consumer testConsumer$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.testConsumer$1.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.testConsumer$1 = testConsumer$1;
            }
        };
        this.changeConsumerSubscriptionAndValidateAssignment(testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))), rebalanceListener);
        testConsumer.seek(this.tp(), 10L);
        testConsumer.seek(this.tp2(), 20L);
        int commitCountBeforeRebalance = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        this.changeConsumerSubscriptionAndValidateAssignment(testConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), rebalanceListener);
        Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        String string = groupProtocol.toUpperCase();
        String string2 = GroupProtocol.CONSUMER.name;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            testConsumer.poll(Duration.ZERO);
        }
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeRebalance ? 1 : 0) != 0);
        int commitCountBeforeClose = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.close();
        Assertions.assertTrue((MockConsumerInterceptor.ON_COMMIT_COUNT.intValue() > commitCountBeforeClose ? 1 : 0) != 0);
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCommitSpecifiedOffsets(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 5, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 7, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$))).asJava());
        long pos1 = consumer.position(this.tp());
        long pos2 = consumer.position(this.tp2());
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertNull(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2()));
        Assertions.assertEquals((long)pos1, (long)consumer.position(this.tp()));
        Assertions.assertEquals((long)pos2, (long)consumer.position(this.tp2()));
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(5L))}))).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        this.sendAndAwaitAsyncCommit(consumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)new OffsetAndMetadata(7L))}))));
        Assertions.assertEquals((long)7L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoCommitOnRebalance(String quorum, String groupProtocol) {
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.consumerConfig().setProperty("enable.auto.commit", "true");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(null, consumer){
            private final Consumer consumer$2;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.consumer$2.pause(partitions);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.consumer$2 = consumer$2;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 300L);
        consumer.seek(this.tp2(), 500L);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), rebalanceListener);
        scala.collection.immutable.Set newAssignment = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2(), new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}));
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)newAssignment);
        Assertions.assertEquals((long)300L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)500L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSubscribeAndCommitSync(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        consumer.seek(this.tp(), 0L);
        consumer.commitSync();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPositionAndCommit(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertNull(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))).asJava()).get(topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.position(topicPartition));
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()), (String)"position() on a partition that we are subscribed to should reset the offset");
        consumer.commitSync();
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        Assertions.assertEquals((long)5L, (long)consumer.position(this.tp()), (String)"After consuming 5 records, position should be 5");
        consumer.commitSync();
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset(), (String)"Committed offset should be returned");
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer otherConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        otherConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$14 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$16 = this.consumeAndVerifyRecords$default$7();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(otherConsumer, 1, 5, x$14, startingTimestamp, x$15, x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testCommitAsyncCompletedBeforeConsumerCloses(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 3, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 3, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$))).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback cb = new AbstractConsumerTest.CountConsumerCommitCallback();
        consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(1L))}))).asJava(), (OffsetCommitCallback)cb);
        consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(1L))}))).asJava(), (OffsetCommitCallback)cb);
        consumer.close();
        Assertions.assertEquals((int)2, (int)cb.successCount());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersConsumerGroupProtocolOnly"})
    public void testCommitAsyncCompletedBeforeCommitSyncReturns(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 3, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 3, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$))).asJava());
        AbstractConsumerTest.CountConsumerCommitCallback cb = new AbstractConsumerTest.CountConsumerCommitCallback();
        consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(1L))}))).asJava(), (OffsetCommitCallback)cb);
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertEquals((long)1L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)1, (int)cb.successCount());
        consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava(), (OffsetCommitCallback)cb);
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp2(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assertions.assertEquals((int)2, (int)cb.successCount());
        consumer.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(3L))}))).asJava(), (OffsetCommitCallback)cb);
        consumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        Assertions.assertEquals((long)3L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp2()}))).asJava()).get(this.tp2())).offset());
        Assertions.assertEquals((int)3, (int)cb.successCount());
    }

    public <K, V> void changeConsumerSubscriptionAndValidateAssignment(Consumer<K, V> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> expectedAssignment, ConsumerRebalanceListener rebalanceListener) {
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicsToSubscribe).asJava(), rebalanceListener);
        this.awaitAssignment(consumer, expectedAssignment);
    }

    public static final /* synthetic */ boolean $anonfun$testAsyncCommit$2(AbstractConsumerTest.CountConsumerCommitCallback callback$1, int count$1) {
        return callback$1.successCount() >= count$1 || callback$1.lastError().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testAsyncCommit$3() {
        return "Failed to observe commit callback before timeout";
    }
}

