/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005RyAQa\f\u0001\u0005\u0002ABQa\u0017\u0001\u0005\u0002qCQA\u0019\u0001\u0005\u0002\rDQ!\u001b\u0001\u0005\u0002)DQ\u0001\u001d\u0001\u0005\u0002EDQa\u001e\u0001\u0005\u0002aDQA \u0001\u0005\u0002}Dq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0002\u001a!2\f\u0017N\u001c;fqR\u001cuN\\:v[\u0016\u0014\bk\u001c7m)\u0016\u001cHO\u0003\u0002\u0012%\u0005\u0019\u0011\r]5\u000b\u0003M\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002!%\u0011\u0011\u0004\u0005\u0002\u0015\u0003\n\u001cHO]1di\u000e{gn];nKJ$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005a\u0002CA\f\u0001\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5u\u0011\u00151#\u00011\u0001(\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nA!\u001e;jY*\tA&\u0001\u0003kCZ\f\u0017B\u0001\u0018*\u0005)\u0001&o\u001c9feRLWm]\u0001\u0013i\u0016\u001cH/T1y!>dGNU3d_J$7\u000fF\u0002 cyBQAM\u0002A\u0002M\na!];peVl\u0007C\u0001\u001b<\u001d\t)\u0014\b\u0005\u00027C5\tqG\u0003\u00029)\u00051AH]8pizJ!AO\u0011\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u\u0005BQaP\u0002A\u0002M\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0006B\u0002B\u001b:\u0003\"AQ&\u000e\u0003\rS!\u0001R#\u0002\rA\f'/Y7t\u0015\t1u)A\u0004kkBLG/\u001a:\u000b\u0005!K\u0015!\u00026v]&$(\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0007\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u001f\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\b\u0006B\u0002R/b\u0003\"AU+\u000e\u0003MS!\u0001V\"\u0002\u0011A\u0014xN^5eKJL!AV*\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003e\u000b\u0013AW\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u0003U!Xm\u001d;NCb\u0004v\u000e\u001c7J]R,'O^1m\u001bN$2aH/_\u0011\u0015\u0011D\u00011\u00014\u0011\u0015yD\u00011\u00014Q\u0011!\u0011)\u0014()\t\u0011\tv+\u0019\u0017\u00023\u00061C/Z:u\u001b\u0006D\bk\u001c7m\u0013:$XM\u001d<bY6\u001bH)\u001a7bs&s'+\u001a<pG\u0006$\u0018n\u001c8\u0015\u0007}!W\rC\u00033\u000b\u0001\u00071\u0007C\u0003@\u000b\u0001\u00071\u0007\u000b\u0003\u0006\u00036s\u0005\u0006B\u0003R/\"d\u0013!W\u0001'i\u0016\u001cH/T1y!>dG.\u00138uKJ4\u0018\r\\'t\t\u0016d\u0017-_%o\u0003N\u001c\u0018n\u001a8nK:$HcA\u0010lY\")!G\u0002a\u0001g!)qH\u0002a\u0001g!\"a!Q'OQ\u00111\u0011kV8-\u0003e\u000b1\u0006^3ti6\u000b\u0007\u0010U8mY&sG/\u001a:wC2l5o\u00155peR,'\u000f\u00165b]B{G\u000e\u001c+j[\u0016|W\u000f\u001e\u000b\u0004?I\u001c\b\"\u0002\u001a\b\u0001\u0004\u0019\u0004\"B \b\u0001\u0004\u0019\u0004\u0006B\u0004B\u001b:CCaB)Xm2\n\u0011,\u0001\u0014uKN$\b+\u001a:QCJ$\u0018\u000e^5p]2+\u0017\rZ,ji\"l\u0015\r\u001f)pY2\u0014VmY8sIN$2aH={\u0011\u0015\u0011\u0004\u00021\u00014\u0011\u0015y\u0004\u00021\u00014Q\u0011A\u0011)\u0014()\t!\tv+ \u0017\u00023\u0006)C/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c'bO^KG\u000f['bqB{G\u000e\u001c*fG>\u0014Hm\u001d\u000b\u0006?\u0005\u0005\u00111\u0001\u0005\u0006e%\u0001\ra\r\u0005\u0006\u007f%\u0001\ra\r\u0015\u0005\u0013\u0005ke\nK\u0003\n#^\u000bI\u0001L\u0001Z\u00031\"Xm\u001d;Nk2$\u0018nQ8ogVlWM]*fgNLwN\u001c+j[\u0016|W\u000f^(o'R|\u0007\u000fU8mY&tw\rF\u0003 \u0003\u001f\t\t\u0002C\u00033\u0015\u0001\u00071\u0007C\u0003@\u0015\u0001\u00071\u0007\u000b\u0003\u000b\u00036s\u0005&\u0002\u0006R/\u0006]A&A-\u0002MQ,7\u000f^'vYRL7i\u001c8tk6,'oU3tg&|g\u000eV5nK>,Ho\u00148DY>\u001cX\rF\u0003 \u0003;\ty\u0002C\u00033\u0017\u0001\u00071\u0007C\u0003@\u0017\u0001\u00071\u0007\u000b\u0003\f\u00036s\u0005&B\u0006R/\u0006\u0015B&A-\u0002_Q,7\u000f\u001e)pY2,e/\u001a8uk\u0006dG.\u001f*fiV\u0014hn\u001d*fG>\u0014Hm],ji\"TVM]8US6,w.\u001e;\u0015\u000b}\tY#!\f\t\u000bIb\u0001\u0019A\u001a\t\u000b}b\u0001\u0019A\u001a)\t1\tUJ\u0014\u0015\u0006\u0019E;\u00161\u0007\u0017\u00023\u0006YC/Z:u\u001d>|eMZ:fi\u001a{'\u000fU1si&$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]>s\u0007k\u001c7m5\u0016\u0014x\u000eF\u0003 \u0003s\tY\u0004C\u00033\u001b\u0001\u00071\u0007C\u0003@\u001b\u0001\u00071\u0007\u000b\u0003\u000e\u00036s\u0005&B\u0007R/\u0006\u0005C&A-\u0002EI,h.T;mi&\u001cuN\\:v[\u0016\u00148+Z:tS>tG+[7f_V$H+Z:u)\ry\u0012q\t\u0005\b\u0003\u0013r\u0001\u0019AA&\u00035\u0019Gn\\:f\u0007>t7/^7feB\u0019\u0001%!\u0014\n\u0007\u0005=\u0013EA\u0004C_>dW-\u00198)\r\u0001\t\u0019fVA/!\u0011\t)&!\u0017\u000e\u0005\u0005]#BA\tF\u0013\u0011\tY&a\u0016\u0003\u000fQKW.Z8viz\u0011!\u0001\u0017")
public class PlaintextConsumerPollTest
extends AbstractConsumerTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.setProperty("group.consumer.heartbeat.interval.ms", Integer.toString(500));
        properties.setProperty("group.consumer.min.heartbeat.interval.ms", Integer.toString(500));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollRecords(String quorum, String groupProtocol) {
        int maxPollRecords = 2;
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$6 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$6, startingTimestamp, x$7, x$8, maxPollRecords, x$9);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMs(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
            this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(2000));
        }
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        Thread.sleep(3000L);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)2, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsDelayInRevocation(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
            this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        }
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        BooleanRef commitCompleted = BooleanRef.create((boolean)false);
        LongRef committedPosition = LongRef.create((long)-1L);
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this, committedPosition, consumer, commitCompleted){
            private final /* synthetic */ PlaintextConsumerPollTest $outer;
            private final LongRef committedPosition$1;
            private final Consumer consumer$1;
            private final BooleanRef commitCompleted$1;

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                if (!partitions.isEmpty() && partitions.contains(this.$outer.tp())) {
                    Utils.sleep((long)1500L);
                    this.committedPosition$1.elem = this.consumer$1.position(this.$outer.tp());
                    this.consumer$1.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.tp()), (Object)new OffsetAndMetadata(this.committedPosition$1.elem))}))).asJava());
                    this.commitCompleted$1.elem = true;
                }
                super.onPartitionsRevoked(partitions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.committedPosition$1 = committedPosition$1;
                this.consumer$1 = consumer$1;
                this.commitCompleted$1 = commitCompleted$1;
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"otherTopic", (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((long)0L, (long)committedPosition.elem);
        Assertions.assertTrue((boolean)commitCompleted.elem);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsDelayInAssignment(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(5000));
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
            this.consumerConfig().setProperty("session.timeout.ms", Integer.toString(1000));
        }
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this){

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                Utils.sleep((long)1500L);
                super.onPartitionsAssigned(partitions);
            }
        };
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        this.ensureNoRebalance(consumer, listener);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMaxPollIntervalMsShorterThanPollTimeout(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("max.poll.interval.ms", Integer.toString(1000));
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("heartbeat.interval.ms", Integer.toString(500));
        }
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        int callsToAssignedAfterFirstRebalance = listener.callsToAssigned();
        consumer.poll(Duration.ofMillis(2000L));
        consumer.poll(Duration.ofMillis(500L));
        consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)callsToAssignedAfterFirstRebalance, (int)listener.callsToAssigned());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadWithMaxPollRecords(String quorum, String groupProtocol) {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)maxPollRecords, (double)BoxesRunTime.unboxToDouble((Object)lead.metricValue()), (String)("The lead should be " + maxPollRecords));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagWithMaxPollRecords(String quorum, String groupProtocol) {
        int numMessages = 1000;
        int maxPollRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagWithMaxPollRecords");
        this.consumerConfig().setProperty("max.poll.records", Integer.toString(maxPollRecords));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagWithMaxPollRecords");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric lag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertEquals((double)(numMessages - records.count()), (double)BoxesRunTime.unboxToDouble((Object)lag.metricValue()), (double)this.epsilon(), (String)("The lag should be " + (numMessages - records.count())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultiConsumerSessionTimeoutOnStopPolling(String quorum, String groupProtocol) {
        this.runMultiConsumerSessionTimeoutTest(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultiConsumerSessionTimeoutOnClose(String quorum, String groupProtocol) {
        this.runMultiConsumerSessionTimeoutTest(true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPollEventuallyReturnsRecordsWithZeroTimeout(String quorum, String groupProtocol) {
        int numMessages = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), 0L);
        Assertions.assertEquals((int)numMessages, (int)records.count());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNoOffsetForPartitionExceptionOnPollZero(String quorum, String groupProtocol) {
        void var13_16;
        Tuple2 tuple2;
        this.consumerConfig().setProperty("auto.offset.reset", "none");
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        long l = 100L;
        long tryUntilNoAssertionError_waitTime = 15000L;
        long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void tryUntilNoAssertionError_pause;
            Right right;
            try {
                NoOffsetForPartitionException $anonfun$tryUntilNoAssertionError$1_res = PlaintextConsumerPollTest.$anonfun$testNoOffsetForPartitionExceptionOnPollZero$1(consumer);
                right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
            }
            catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
            }
            Object var17_12 = null;
            Object var18_13 = null;
            Right tryUntilNoAssertionError_computeUntilTrue_result = right;
            if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
        }
        Object var16_11 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Either tryUntilNoAssertionError_either = (Either)tuple22._1();
        if (var13_16 instanceof Left) {
            ((Left)var13_16).value();
            return;
        }
        if (var13_16 instanceof Right) {
            throw (AssertionError)((Right)var13_16).value();
        }
        throw new MatchError((Object)var13_16);
    }

    public void runMultiConsumerSessionTimeoutTest(boolean closeConsumer) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, 100, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        String topic1 = "topic1";
        scala.collection.immutable.Set subscriptions = (scala.collection.immutable.Set)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))).$plus$plus(this.createTopicAndSendRecords(producer, topic1, 6, 100));
        Buffer consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        consumerPollers.$plus$eq((Object)this.subscribeConsumerAndStartPolling(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()), (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3()));
        Consumer timeoutConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.ConsumerAssignmentPoller timeoutPoller = this.subscribeConsumerAndStartPolling(timeoutConsumer, (List<String>)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)), this.subscribeConsumerAndStartPolling$default$3());
        consumerPollers.$plus$eq((Object)timeoutPoller);
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        timeoutPoller.shutdown();
        consumerPollers.$minus$eq((Object)timeoutPoller);
        if (closeConsumer) {
            timeoutConsumer.close();
        }
        this.validateGroupAssignment((Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)consumerPollers, (scala.collection.immutable.Set<TopicPartition>)subscriptions, (Option<String>)new Some((Object)("Did not get valid assignment for partitions " + CollectionConverters$.MODULE$.SetHasAsJava((Set)subscriptions).asJava() + " after one consumer left")), 3L * this.groupMaxSessionTimeoutMs(), this.validateGroupAssignment$default$5());
        consumerPollers.foreach((Function1 & Serializable)poller -> {
            poller.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ NoOffsetForPartitionException $anonfun$testNoOffsetForPartitionExceptionOnPollZero$1(Consumer consumer$2) {
        return (NoOffsetForPartitionException)Assertions.assertThrows(NoOffsetForPartitionException.class, () -> consumer$2.poll(Duration.ZERO));
    }
}

