/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.test.api.Flaky;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockProducerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=600L)
@ScalaSignature(bytes="\u0006\u0005\t\rh\u0001B\u0012%\u0001%BQA\f\u0001\u0005\u0002=BQ!\r\u0001\u0005\u0002IBQa\u0019\u0001\u0005\n\u0011DQ! \u0001\u0005\u0002yDq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA!\u0001\u0011\u0005\u00111\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\tY\r\u0001C\u0001\u0003\u001bDq!!7\u0001\t\u0003\tY\u000eC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_AqAa\u000f\u0001\t\u0003\u0011i\u0004C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\t]\u0003\u0001\"\u0001\u0003Z!9!Q\r\u0001\u0005\u0002\t\u001d\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqA!,\u0001\t\u0003\u0011y\u000bC\u0004\u0003>\u0002!\tAa0\u0003+Ac\u0017-\u001b8uKb$8i\u001c8tk6,'\u000fV3ti*\u0011QEJ\u0001\u0004CBL'\"A\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000b\t\u0003W1j\u0011\u0001J\u0005\u0003[\u0011\u0012\u0001CQ1tK\u000e{gn];nKJ$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0001\u0004CA\u0016\u0001\u0003-!Xm\u001d;IK\u0006$WM]:\u0015\u0007MJd\t\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0003V]&$\b\"\u0002\u001e\u0003\u0001\u0004Y\u0014AB9v_J,X\u000e\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}Uj\u0011a\u0010\u0006\u0003\u0001\"\na\u0001\u0010:p_Rt\u0014B\u0001\"6\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t+\u0004\"B$\u0003\u0001\u0004Y\u0014!D4s_V\u0004\bK]8u_\u000e|G\u000e\u000b\u0003\u0003\u0013V3\u0006C\u0001&T\u001b\u0005Y%B\u0001'N\u0003\u0019\u0001\u0018M]1ng*\u0011ajT\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0001\u0016+A\u0003kk:LGOC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003]\u000b!f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\fT\u0010\u000b\u0003\u00033~\u0003\u0007C\u0001.^\u001b\u0005Y&B\u0001/L\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u00010\\\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\u0005\t\u0017%\u00012\u0002U\u001d,G\u000fV3tiF+xN];n\u0003:$wI]8vaB\u0013x\u000e^8d_2\u0004\u0016M]1nKR,'o]!mY\u0006yB/Z:u\u0011\u0016\fG-\u001a:t'\u0016\u0014\u0018.\u00197ju\u0016$Um]3sS\u0006d\u0017N_3\u0015\u0007M*\u0007\u0010C\u0003g\u0007\u0001\u0007q-\u0001\u0006tKJL\u0017\r\\5{KJ\u00042\u0001\u001b9s\u001b\u0005I'B\u00016l\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u001dr'BA8R\u0003\u0019\t\u0007/Y2iK&\u0011\u0011/\u001b\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bc\u0001\u001btk&\u0011A/\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003iYL!a^\u001b\u0003\t\tKH/\u001a\u0005\u0006s\u000e\u0001\rA_\u0001\rI\u0016\u001cXM]5bY&TXM\u001d\t\u0004Qn\u0014\u0018B\u0001?j\u00051!Um]3sS\u0006d\u0017N_3s\u0003\u0005\"Xm\u001d;IK\u0006$WM]:TKJL\u0017\r\\5{KJ$Um]3sS\u0006d\u0017N_3s)\u0011\u0019t0!\u0001\t\u000bi\"\u0001\u0019A\u001e\t\u000b\u001d#\u0001\u0019A\u001e)\t\u0011IUK\u0016\u0015\u0006\te{\u0016q\u0001\u0017\u0002C\u0006\u0019B/Z:u\u0003V$xn\u00144gg\u0016$(+Z:fiR)1'!\u0004\u0002\u0010!)!(\u0002a\u0001w!)q)\u0002a\u0001w!\"Q!S+WQ\u0015)\u0011lXA\u000bY\u0005\t\u0017\u0001\u0006;fgR<%o\\;q\u0007>t7/^7qi&|g\u000eF\u00034\u00037\ti\u0002C\u0003;\r\u0001\u00071\bC\u0003H\r\u0001\u00071\b\u000b\u0003\u0007\u0013V3\u0006&\u0002\u0004Z?\u0006\rB&A1\u0002#Q,7\u000f\u001e)beRLG/[8og\u001a{'\u000fF\u00034\u0003S\tY\u0003C\u0003;\u000f\u0001\u00071\bC\u0003H\u000f\u0001\u00071\b\u000b\u0003\b\u0013V3\u0006&B\u0004Z?\u0006EB&A1\u00027Q,7\u000f\u001e)beRLG/[8og\u001a{'/Q;u_\u000e\u0013X-\u0019;f)\u0015\u0019\u0014qGA\u001d\u0011\u0015Q\u0004\u00021\u0001<\u0011\u00159\u0005\u00021\u0001<Q\u0011A\u0011*\u0016,)\u000b!Iv,a\u0010-\u0003\u0005\fQ\u0004^3tiB\u000b'\u000f^5uS>t7OR8s\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019\u000b\u0006g\u0005\u0015\u0013q\t\u0005\u0006u%\u0001\ra\u000f\u0005\u0006\u000f&\u0001\ra\u000f\u0015\u0005\u0013%+f\u000bK\u0003\n3~\u000bi\u0005L\u0001b\u0003!!Xm\u001d;TK\u0016\\G#B\u001a\u0002T\u0005U\u0003\"\u0002\u001e\u000b\u0001\u0004Y\u0004\"B$\u000b\u0001\u0004Y\u0004\u0006\u0002\u0006J+ZCSAC-`\u00037b\u0013!Y\u0001\u0017g\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4fgR)1'!\u0019\u0002l!9\u00111M\u0006A\u0002\u0005\u0015\u0014A\u00038v[J+7m\u001c:egB\u0019A'a\u001a\n\u0007\u0005%TGA\u0002J]RDq!!\u001c\f\u0001\u0004\ty'\u0001\u0002uaB!\u0011\u0011OA:\u001b\u0005Y\u0017bAA;W\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0007;fgR\u0004\u0016M\u001d;ji&|g\u000eU1vg\u0016\fe\u000e\u001a*fgVlW\rF\u00034\u0003w\ni\bC\u0003;\u0019\u0001\u00071\bC\u0003H\u0019\u0001\u00071\b\u000b\u0003\r\u0013V3\u0006&\u0002\u0007Z?\u0006\rE&A1\u0002!Q,7\u000f^%oi\u0016\u00148-\u001a9u_J\u001cH#B\u001a\u0002\n\u0006-\u0005\"\u0002\u001e\u000e\u0001\u0004Y\u0004\"B$\u000e\u0001\u0004Y\u0004\u0006B\u0007J+ZCS!D-`\u0003#c\u0013!Y\u0001\"i\u0016\u001cH/\u00138uKJ\u001cW\r\u001d;peN<\u0016\u000e\u001e5Xe>twmS3z-\u0006dW/\u001a\u000b\u0006g\u0005]\u0015\u0011\u0014\u0005\u0006u9\u0001\ra\u000f\u0005\u0006\u000f:\u0001\ra\u000f\u0015\u0005\u001d%+f\u000bK\u0003\u000f3~\u000by\nL\u0001b\u0003\u0005\"Xm\u001d;D_:\u001cX/\\3NKN\u001c\u0018mZ3t/&$\bn\u0011:fCR,G+[7f)\u0015\u0019\u0014QUAT\u0011\u0015Qt\u00021\u0001<\u0011\u00159u\u00021\u0001<Q\u0011y\u0011*\u0016,)\u000b=Iv,!,-\u0003\u0005\fA\u0005^3ti\u000e{gn];nK6+7o]1hKN<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u000b\u0006g\u0005M\u0016Q\u0017\u0005\u0006uA\u0001\ra\u000f\u0005\u0006\u000fB\u0001\ra\u000f\u0015\u0005!%+f\u000bK\u0003\u00113~\u000bY\fL\u0001b\u00039!Xm\u001d;MSN$Hk\u001c9jGN$RaMAa\u0003\u0007DQAO\tA\u0002mBQaR\tA\u0002mBC!E%V-\"*\u0011#W0\u0002J2\n\u0011-A\u0013uKN$\b+Y;tKN#\u0018\r^3O_R\u0004&/Z:feZ,GMQ=SK\n\fG.\u00198dKR)1'a4\u0002R\")!H\u0005a\u0001w!)qI\u0005a\u0001w!\"!#S+WQ\u0015\u0011\u0012lXAlY\u0005\t\u0017a\f;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0016\fG-T3ue&\u001c7o\u00117fC:,\u0006oV5uQN+(m]2sS\n,G#B\u001a\u0002^\u0006}\u0007\"\u0002\u001e\u0014\u0001\u0004Y\u0004\"B$\u0014\u0001\u0004Y\u0004\u0006B\nJ+ZCSaE-`\u0003Kd\u0013!Y\u0001/i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\u001cVOY:de&\u0014W\rF\u00034\u0003W\fi\u000fC\u0003;)\u0001\u00071\bC\u0003H)\u0001\u00071\b\u000b\u0003\u0015\u0013V3\u0006&\u0002\u000bZ?\u0006MH&A1\u0002YQ,7\u000f\u001e)feB\u000b'\u000f^5uS>tG*Z1e\u001b\u0016$(/[2t\u00072,\u0017M\\+q/&$\b.Q:tS\u001etG#B\u001a\u0002z\u0006m\b\"\u0002\u001e\u0016\u0001\u0004Y\u0004\"B$\u0016\u0001\u0004Y\u0004\u0006B\u000bJ+ZCS!F-`\u0005\u0003a\u0013!Y\u0001,i\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:d\u0015mZ'fiJL7m]\"mK\u0006tW\u000b],ji\"\f5o]5h]R)1Ga\u0002\u0003\n!)!H\u0006a\u0001w!)qI\u0006a\u0001w!\"a#S+WQ\u00151\u0012l\u0018B\bY\u0005\t\u0017a\u000b;fgR\u0004VM\u001d)beRLG/[8o\u0019\u0006<W*\u001a;sS\u000e\u001cx\u000b[3o%\u0016\fGmQ8n[&$H/\u001a3\u0015\u000bM\u0012)Ba\u0006\t\u000bi:\u0002\u0019A\u001e\t\u000b\u001d;\u0002\u0019A\u001e)\t]IUK\u0016\u0015\u0006/e{&Q\u0004\u0017\u0002C\u0006qC/Z:u#V|G/Y'fiJL7m\u001d(pi\u000e\u0013X-\u0019;fI&3gj\\)v_R\f7oQ8oM&<WO]3e)\u0015\u0019$1\u0005B\u0013\u0011\u0015Q\u0004\u00041\u0001<\u0011\u00159\u0005\u00041\u0001<Q\u0011A\u0012*\u0016,)\u000baIvLa\u000b-\u0003\u0005\fA\u0004^3ti\u000e{gn];nS:<w+\u001b;i\u001dVdGn\u0012:pkBLE\rF\u00034\u0005c\u0011\u0019\u0004C\u0003;3\u0001\u00071\bC\u0003H3\u0001\u00071\b\u000b\u0003\u001a\u0013V3\u0006&B\rZ?\neB&A1\u0002OQ,7\u000f\u001e(vY2<%o\\;q\u0013\u0012tu\u000e^*vaB|'\u000f^3e\u0013\u001a\u001cu.\\7jiRLgn\u001a\u000b\u0006g\t}\"\u0011\t\u0005\u0006ui\u0001\ra\u000f\u0005\u0006\u000fj\u0001\ra\u000f\u0015\u00055%+f\u000bK\u0003\u001b3~\u00139\u0005L\u0001b\u0003a\"Xm\u001d;Ti\u0006$\u0018nY\"p]N,X.\u001a:EKR,7\r^:OK^\u0004\u0016M\u001d;ji&|gn\u0011:fCR,G-\u00114uKJ\u0014Vm\u001d;beR$Ra\rB'\u0005\u001fBQAO\u000eA\u0002mBQaR\u000eA\u0002mBCaG%V-\"*1$W0\u0003V1\n\u0011-\u0001\buKN$XI\u001c3PM\u001a\u001cX\r^:\u0015\u000bM\u0012YF!\u0018\t\u000bib\u0002\u0019A\u001e\t\u000b\u001dc\u0002\u0019A\u001e)\tqIUK\u0016\u0015\u00069e{&1\r\u0017\u0002C\u0006\tD/Z:u'\u0016,7\u000e\u00165s_^\u001c\u0018\n\u001c7fO\u0006d7\u000b^1uK&3\u0007+\u0019:uSRLwN\\:O_R\f5o]5h]\u0016$G#B\u001a\u0003j\t-\u0004\"\u0002\u001e\u001e\u0001\u0004Y\u0004\"B$\u001e\u0001\u0004Y\u0004\u0006B\u000fJ+ZCS!H-`\u0005cb\u0013!Y\u0001\u0018i\u0016\u001cHOR3uG\"|eMZ:fiN4uN\u001d+j[\u0016$Ra\rB<\u0005sBQA\u000f\u0010A\u0002mBQa\u0012\u0010A\u0002mBCAH%V-\"*a$W0\u0003\u00001\n\u0011-A\u000euKN$\bk\\:ji&|gNU3ta\u0016\u001cGo\u001d+j[\u0016|W\u000f\u001e\u000b\u0006g\t\u0015%q\u0011\u0005\u0006u}\u0001\ra\u000f\u0005\u0006\u000f~\u0001\ra\u000f\u0015\u0005?%+f\u000bK\u0003 3~\u0013i\tL\u0001bQ\u0019y\"\u0011S0\u0003\u001cB!!1\u0013BL\u001b\t\u0011)J\u0003\u0002&\u001b&!!\u0011\u0014BK\u0005\u001d!\u0016.\\3pkRt\u0012aD\u0001\u001bi\u0016\u001cH\u000fU8tSRLwN\u001c*fgB,7\r^:XC.,W\u000f\u001d\u000b\u0006g\t\u0005&1\u0015\u0005\u0006u\u0001\u0002\ra\u000f\u0005\u0006\u000f\u0002\u0002\ra\u000f\u0015\u0005A%+f\u000bK\u0003!3~\u0013I\u000bL\u0001bQ\u0019\u0001#\u0011S0\u0003\u001c\u0006iC/Z:u!>\u001c\u0018\u000e^5p]^KG\u000f[#se>\u00148i\u001c8oK\u000e$\u0018n\u001c8SKN\u0004Xm\u0019;t/\u0006\\W-\u001e9\u0015\u000bM\u0012\tLa-\t\u000bi\n\u0003\u0019A\u001e\t\u000b\u001d\u000b\u0003\u0019A\u001e)\t\u0005JUK\u0016\u0015\u0006Ce{&\u0011\u0018\u0017\u0002C\"2\u0011E!%`\u00057\u000bq\u0004^3ti\u000ecwn]3MK\u00064Xm]$s_V\u0004xJ\\%oi\u0016\u0014(/\u001e9u)\u0015\u0019$\u0011\u0019Bb\u0011\u0015Q$\u00051\u0001<\u0011\u00159%\u00051\u0001<Q\u0019\u0011#qY0\u0003VB!!\u0011\u001aBi\u001b\t\u0011YMC\u0002&\u0005\u001bT1Aa4l\u0003\u0011!Xm\u001d;\n\t\tM'1\u001a\u0002\u0006\r2\f7._\u0011\u0003\u0005/\f1bS!G\u0017\u0006k\u0013\u0007\u000f\u00194c!\"!%S+WQ\u0015\u0011\u0013l\u0018BoY\u0005\t\u0007F\u0002\u0001\u0003\u0012~\u0013\tO\b\u0002\u00031\u0002")
public class PlaintextConsumerTest
extends BaseConsumerTest {
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testHeaders(String quorum, String groupProtocol) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        record.headers().add("headerKey", "headerValue".getBytes());
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(record);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Header header = ((ConsumerRecord)records.apply(i)).headers().lastHeader("headerKey");
            Assertions.assertEquals((Object)"headerValue", (Object)(header == null ? null : new String(header.value())));
        });
    }

    private void testHeadersSerializeDeserialize(Serializer<byte[]> serializer, Deserializer<byte[]> deserializer) {
        int numRecords = 1;
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.createProducer(new ByteArraySerializer(), serializer, this.createProducer$default$3()).send(record);
        Consumer consumer = this.createConsumer(new ByteArrayDeserializer(), deserializer, this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(consumer, numRecords, this.consumeRecords$default$3());
        Assertions.assertEquals((int)numRecords, (int)records.size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testHeadersSerializerDeserializer(String quorum, String groupProtocol) {
        BaseConsumerTest.SerializerImpl extendedSerializer = new BaseConsumerTest.SerializerImpl();
        BaseConsumerTest.DeserializerImpl extendedDeserializer = new BaseConsumerTest.DeserializerImpl();
        this.testHeadersSerializeDeserialize(extendedSerializer, extendedDeserializer);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoOffsetReset(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 1, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testGroupConsumption(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 10, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionsFor(String quorum, String groupProtocol) {
        int numParts = 2;
        this.createTopic("part-test", numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.List parts = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("part-test");
        Assertions.assertNotNull((Object)parts);
        Assertions.assertEquals((int)2, (int)parts.size());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionsForAutoCreate(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.partitionsFor("non-exist-topic");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testPartitionsForAutoCreate$1(consumer)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out while awaiting non empty partitions.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionsForInvalidTopic(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.partitionsFor(";3# ads,{234"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSeek(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        long totalRecords = 50L;
        long mid = totalRecords / 2L;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int startingTimestamp = 0;
        this.sendRecords(producer, (int)totalRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp()));
        long x$4 = startingTimestamp;
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$5, x$4, x$6, x$7, x$8, x$9);
        consumer.seek(this.tp(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp()));
        this.consumeAndVerifyRecords(consumer, 1, (int)mid, (int)mid, mid, this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8(), this.consumeAndVerifyRecords$default$9());
        this.sendCompressedMessages((int)totalRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        consumer.seekToEnd((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)totalRecords, (long)consumer.position(this.tp2()));
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(50L)).isEmpty());
        consumer.seekToBeginning((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((long)0L, (long)consumer.position(this.tp2()));
        TopicPartition x$13 = this.tp2();
        int x$14 = this.consumeAndVerifyRecords$default$4();
        long x$15 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$16 = this.consumeAndVerifyRecords$default$6();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, 0, x$14, x$15, x$16, x$13, x$17, x$18);
        consumer.seek(this.tp2(), mid);
        Assertions.assertEquals((long)mid, (long)consumer.position(this.tp2()));
        int x$21 = (int)mid;
        int x$22 = (int)mid;
        TopicPartition x$24 = this.tp2();
        TimestampType x$25 = this.consumeAndVerifyRecords$default$6();
        int x$26 = this.consumeAndVerifyRecords$default$8();
        long x$27 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 1, x$21, x$22, mid, x$25, x$24, x$26, x$27);
    }

    private void sendCompressedMessages(int numRecords, TopicPartition tp) {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", CompressionType.GZIP.name);
        producerProps.setProperty("linger.ms", Integer.toString(Integer.MAX_VALUE));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, producerProps);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)("key " + BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)("value " + BoxesRunTime.unboxToInt((Object)i)).getBytes())));
        producer.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPartitionPauseAndResume(String quorum, String groupProtocol) {
        java.util.List partitions = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)partitions);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        consumer.pause((Collection)partitions);
        startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Assertions.assertTrue((boolean)consumer.poll(Duration.ofMillis(100L)).isEmpty());
        consumer.resume((Collection)partitions);
        int x$14 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$16 = this.consumeAndVerifyRecords$default$7();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 5, x$14, startingTimestamp, x$15, x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testInterceptors(String quorum, String groupProtocol) {
        String appendStr = "mock";
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
        Properties producerProps = new Properties();
        producerProps.put("interceptor.classes", MockProducerInterceptor.class.getName());
        producerProps.put("mock.interceptor.append", appendStr);
        KafkaProducer testProducer = this.createProducer(new StringSerializer(), new StringSerializer(), producerProps);
        int numRecords = 10;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> testProducer.send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)("key " + BoxesRunTime.unboxToInt((Object)i)), (Object)("value " + BoxesRunTime.unboxToInt((Object)i))))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ONSEND_COUNT.intValue());
        Assertions.assertEquals((int)numRecords, (int)MockProducerInterceptor.ON_SUCCESS_COUNT.intValue());
        Assertions.assertThrows(Throwable.class, () -> testProducer.send(null), () -> "Should not allow sending a null record");
        Assertions.assertEquals((int)1, (int)MockProducerInterceptor.ON_ERROR_COUNT.intValue(), (String)"Interceptor should be notified about exception");
        Assertions.assertEquals((int)0, (int)MockProducerInterceptor.ON_ERROR_WITH_METADATA_COUNT.intValue(), (String)"Interceptor should not receive metadata with an exception when record is null");
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ArrayBuffer records = this.consumeRecords(testConsumer, numRecords, this.consumeRecords$default$3());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            Assertions.assertEquals((Object)("key " + i), (Object)new String((String)record.key()));
            Assertions.assertEquals((Object)("value " + i + appendStr).toUpperCase(Locale.ROOT), (Object)new String((String)record.value()));
        });
        int commitCountBefore = MockConsumerInterceptor.ON_COMMIT_COUNT.intValue();
        testConsumer.commitSync(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)new OffsetAndMetadata(2L))}))).asJava());
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 1), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        this.sendAndAwaitAsyncCommit(testConsumer, (Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new OffsetAndMetadata(5L))}))));
        Assertions.assertEquals((long)5L, (long)((OffsetAndMetadata)testConsumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        Assertions.assertEquals((int)(commitCountBefore + 2), (int)MockConsumerInterceptor.ON_COMMIT_COUNT.intValue());
        testConsumer.close();
        testProducer.close();
        MockConsumerInterceptor.resetCounters();
        MockProducerInterceptor.resetCounters();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testInterceptorsWithWrongKeyValue(String quorum, String groupProtocol) {
        String appendStr = "mock";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("interceptor.classes", "org.apache.kafka.test.MockProducerInterceptor");
        producerProps.put("mock.interceptor.append", appendStr);
        this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()).send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), (Object)"key".getBytes(), (Object)"value will not be modified".getBytes()));
        this.consumerConfig().setProperty("interceptor.classes", "org.apache.kafka.test.MockConsumerInterceptor");
        Consumer testConsumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        testConsumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        testConsumer.seek(this.tp(), 0L);
        ConsumerRecord record = (ConsumerRecord)this.consumeRecords(testConsumer, 1, this.consumeRecords$default$3()).head();
        Assertions.assertEquals((Object)"value will not be modified", (Object)new String((byte[])record.value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumeMessagesWithCreateTime(String quorum, String groupProtocol) {
        int numRecords = 50;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        this.sendCompressedMessages(numRecords, this.tp2());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        TopicPartition x$12 = this.tp2();
        int x$14 = this.consumeAndVerifyRecords$default$4();
        long x$15 = this.consumeAndVerifyRecords$default$5();
        TimestampType x$16 = this.consumeAndVerifyRecords$default$6();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$14, x$15, x$16, x$12, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumeMessagesWithLogAppendTime(String quorum, String groupProtocol) {
        String topicName = "testConsumeMessagesWithLogAppendTime";
        Properties topicProps = new Properties();
        topicProps.setProperty("message.timestamp.type", "LogAppendTime");
        this.createTopic(topicName, 2, 2, topicProps, this.createTopic$default$5(), this.createTopic$default$6());
        long startTime = System.currentTimeMillis();
        int numRecords = 50;
        TopicPartition tp1 = new TopicPartition(topicName, 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, tp1, this.sendRecords$default$4(), this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)).asJava());
        int x$7 = this.consumeAndVerifyRecords$default$4();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$7, startTime, TimestampType.LOG_APPEND_TIME, tp1, x$8, x$9);
        TopicPartition tp2 = new TopicPartition(topicName, 1);
        this.sendCompressedMessages(numRecords, tp2);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$16 = this.consumeAndVerifyRecords$default$4();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$16, startTime, TimestampType.LOG_APPEND_TIME, tp2, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testListTopics(String quorum, String groupProtocol) {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        this.createTopic(topic1, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic2, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topic3, numParts, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        java.util.Map topics = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).listTopics();
        Assertions.assertNotNull((Object)topics);
        Assertions.assertEquals((int)5, (int)topics.size());
        Assertions.assertEquals((int)5, (int)topics.keySet().size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic1)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic2)).size());
        Assertions.assertEquals((int)2, (int)((java.util.List)topics.get(topic3)).size());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPauseStateNotPreservedByRebalance(String quorum, String groupProtocol) {
        if (groupProtocol.equals(GroupProtocol.CLASSIC.name)) {
            this.consumerConfig().setProperty("session.timeout.ms", "100");
            this.consumerConfig().setProperty("heartbeat.interval.ms", "30");
        }
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, 5, this.tp(), startingTimestamp, this.sendRecords$default$5());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        long x$9 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 5, 0, x$5, startingTimestamp, x$6, x$7, x$8, x$9);
        consumer.pause((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)).asJava());
        int x$14 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$15 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$16 = this.consumeAndVerifyRecords$default$7();
        int x$17 = this.consumeAndVerifyRecords$default$8();
        long x$18 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, 0, 5, x$14, startingTimestamp, x$15, x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadMetricsCleanUpWithSubscribe(String quorum, String groupProtocol) {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLeadMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLead0 = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLead0);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead0.metricValue(), (String)("The lead should be " + records.count()));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsCleanUpWithSubscribe(String quorum, String groupProtocol) {
        int numMessages = 1000;
        String topic2 = "topic2";
        this.createTopic(topic2, 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), (ConsumerRebalanceListener)listener);
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned(), (String)"should be assigned once");
        HashMap<String, String> tags1 = new HashMap<String, String>();
        tags1.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags1.put("topic", this.tp().topic());
        tags1.put("partition", String.valueOf(this.tp().partition()));
        HashMap<String, String> tags2 = new HashMap<String, String>();
        tags2.put("client-id", "testPerPartitionLagMetricsCleanUpWithSubscribe");
        tags2.put("topic", this.tp2().topic());
        tags2.put("partition", String.valueOf(this.tp2().partition()));
        Metric fetchLag0 = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1));
        Assertions.assertNotNull((Object)fetchLag0);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag0.metricValue()), (double)this.epsilon(), (String)("The lag should be " + expectedLag));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags1)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags2)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLeadMetricsCleanUpWithAssign(String quorum, String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLeadMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLead = (Metric)consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLead);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)records.count()), (Object)fetchLead.metricValue(), (String)("The lead should be " + records.count()));
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp2(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lead", "consumer-fetch-manager-metrics", "", tags)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsCleanUpWithAssign(String quorum, String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        ConsumerRecords records = this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Metric fetchLag = (Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags));
        Assertions.assertNotNull((Object)fetchLag);
        int expectedLag = numMessages - records.count();
        Assertions.assertEquals((double)expectedLag, (double)BoxesRunTime.unboxToDouble((Object)fetchLag.metricValue()), (double)this.epsilon(), (String)("The lag should be " + expectedLag));
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp2(), this.awaitNonEmptyRecords$default$3());
        Assertions.assertNull(consumer.metrics().get(new MetricName(this.tp().toString() + ".records-lag", "consumer-fetch-manager-metrics", "", tags)));
        Assertions.assertNull(consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testPerPartitionLagMetricsWhenReadCommitted(String quorum, String groupProtocol) {
        int numMessages = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numMessages, this.tp(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.sendRecords(producer, numMessages, this.tp2(), this.sendRecords$default$4(), this.sendRecords$default$5());
        this.consumerConfig().setProperty("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        this.consumerConfig().setProperty("client.id", "testPerPartitionLagMetricsCleanUpWithAssign");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.awaitNonEmptyRecords(consumer, this.tp(), this.awaitNonEmptyRecords$default$3());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", "testPerPartitionLagMetricsCleanUpWithAssign");
        tags.put("topic", this.tp().topic());
        tags.put("partition", String.valueOf(this.tp().partition()));
        Assertions.assertNotNull((Object)((Metric)consumer.metrics().get(new MetricName("records-lag", "consumer-fetch-manager-metrics", "", tags))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testQuotaMetricsNotCreatedIfNoQuotasConfigured(String quorum, String groupProtocol) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp, this.sendRecords$default$5());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        int x$52 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$62 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$72 = this.consumeAndVerifyRecords$default$7();
        int x$82 = this.consumeAndVerifyRecords$default$8();
        long x$92 = this.consumeAndVerifyRecords$default$9();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$52, startingTimestamp, x$62, x$72, x$82, x$92);
        this.brokers().foreach((Function1 & Serializable)x$2 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$2, "byte-rate", QuotaType.PRODUCE, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$3 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$3, "throttle-time", QuotaType.PRODUCE, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$4 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$4, "byte-rate", QuotaType.FETCH, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$5 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$5, "throttle-time", QuotaType.FETCH, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$6 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$6, "request-time", QuotaType.REQUEST, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$7 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$7, "throttle-time", QuotaType.REQUEST, this.producerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$8 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$8, "request-time", QuotaType.REQUEST, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)x$9 -> {
            PlaintextConsumerTest.assertNoMetric$1(x$9, "throttle-time", QuotaType.REQUEST, this.consumerClientId());
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumingWithNullGroupId(String quorum, String groupProtocol) {
        String topic = "test_topic";
        int partition = 0;
        TopicPartition tp = new TopicPartition(topic, partition);
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k1".getBytes(), (Object)"v1".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k2".getBytes(), (Object)"v2".getBytes())).get();
        producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(partition), (Object)"k3".getBytes(), (Object)"v3".getBytes())).get();
        producer.close();
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        Properties consumer2Config = new Properties(this.consumerConfig());
        consumer2Config.put("auto.offset.reset", "latest");
        consumer2Config.put("client.id", "consumer2");
        .colon.colon x$6 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$7 = this.createConsumer$default$1();
        ByteArrayDeserializer x$8 = this.createConsumer$default$2();
        Consumer consumer2 = this.createConsumer(x$7, x$8, consumer2Config, (List<String>)x$6);
        Properties consumer3Config = new Properties(this.consumerConfig());
        consumer3Config.put("client.id", "consumer3");
        .colon.colon x$10 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$11 = this.createConsumer$default$1();
        ByteArrayDeserializer x$12 = this.createConsumer$default$2();
        Consumer consumer3 = this.createConsumer(x$11, x$12, consumer3Config, (List<String>)x$10);
        consumer1.assign(Arrays.asList(tp));
        consumer2.assign(Arrays.asList(tp));
        consumer3.assign(Arrays.asList(tp));
        consumer3.seek(tp, 1L);
        int numRecords1 = consumer1.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer2.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()));
        int numRecords2 = consumer2.poll(Duration.ofMillis(5000L)).count();
        int numRecords3 = consumer3.poll(Duration.ofMillis(5000L)).count();
        consumer1.unsubscribe();
        consumer2.unsubscribe();
        consumer3.unsubscribe();
        Assertions.assertTrue((boolean)consumer1.assignment().isEmpty());
        Assertions.assertTrue((boolean)consumer2.assignment().isEmpty());
        Assertions.assertTrue((boolean)consumer3.assignment().isEmpty());
        consumer1.close();
        consumer2.close();
        consumer3.close();
        Assertions.assertEquals((int)3, (int)numRecords1, (String)"Expected consumer1 to consume from earliest offset");
        Assertions.assertEquals((int)0, (int)numRecords2, (String)"Expected consumer2 to consume from latest offset");
        Assertions.assertEquals((int)2, (int)numRecords3, (String)"Expected consumer3 to consume from offset 1");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNullGroupIdNotSupportedIfCommitting(String quorum, String groupProtocol) {
        Properties consumer1Config = new Properties(this.consumerConfig());
        consumer1Config.put("auto.offset.reset", "earliest");
        consumer1Config.put("client.id", "consumer1");
        .colon.colon x$2 = new .colon.colon((Object)"group.id", (List)Nil$.MODULE$);
        ByteArrayDeserializer x$3 = this.createConsumer$default$1();
        ByteArrayDeserializer x$4 = this.createConsumer$default$2();
        Consumer consumer1 = this.createConsumer(x$3, x$4, consumer1Config, (List<String>)x$2);
        consumer1.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(InvalidGroupIdException.class, () -> consumer1.commitSync());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testStaticConsumerDetectsNewPartitionCreatedAfterRestart(String quorum, String groupProtocol) {
        String foo = "foo";
        TopicPartition foo0 = new TopicPartition(foo, 0);
        TopicPartition foo1 = new TopicPartition(foo, 1);
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        admin.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new NewTopic(foo, 1, (short)1), (List)Nil$.MODULE$)).asJava()).all().get();
        Properties consumerConfig = new Properties();
        consumerConfig.put("group.id", "my-group-id");
        consumerConfig.put("group.instance.id", "my-instance-id");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer1 = this.createConsumer(x$2, x$3, consumerConfig, x$4);
        consumer1.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)foo, (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer1, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        consumer1.close();
        ByteArrayDeserializer x$6 = this.createConsumer$default$1();
        ByteArrayDeserializer x$7 = this.createConsumer$default$2();
        List<String> x$8 = this.createConsumer$default$4();
        Consumer consumer2 = this.createConsumer(x$6, x$7, consumerConfig, x$8);
        consumer2.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)foo, (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0}))));
        admin.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
        this.awaitAssignment(consumer2, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1}))));
        consumer2.close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testEndOffsets(String quorum, String groupProtocol) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        int numRecords = 10000;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> PlaintextConsumerTest.$anonfun$testEndOffsets$1(this, startingTimestamp, producer, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.awaitAssignment(consumer, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()}))));
        java.util.Map endOffsets = consumer.endOffsets((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assertions.assertEquals((long)numRecords, (Long)((Long)endOffsets.get(this.tp())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSeekThrowsIllegalStateIfPartitionsNotAssigned(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Properties x$1 = this.consumerConfig();
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> consumer.seekToEnd(Collections.singletonList(tp)));
        Assertions.assertEquals((Object)("No current assignment for partition " + tp), (Object)e.getMessage());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFetchOffsetsForTime(String quorum, String groupProtocol) {
        int numPartitions = 2;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(this.topic(), part);
            this.sendRecords((KafkaProducer<byte[], byte[]>)producer, 100, tp, 0L, this.sendRecords$default$5());
            timestampsToSearch.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition(this.topic(), 0), Predef$.MODULE$.long2Long(-1L))));
        java.util.Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTp0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(this.topic(), 0));
        Assertions.assertEquals((long)0L, (long)timestampTp0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTp0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTp0.leaderEpoch());
        OffsetAndTimestamp timestampTp1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(this.topic(), 1));
        Assertions.assertEquals((long)20L, (long)timestampTp1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTp1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTp1.leaderEpoch());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionRespectsTimeout(String quorum, String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        Assertions.assertThrows(TimeoutException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(3L)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionRespectsWakeup(String quorum, String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        CompletableFuture.runAsync(() -> {
            TimeUnit.SECONDS.sleep(1L);
            consumer.wakeup();
        });
        Assertions.assertThrows(WakeupException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(3L)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    @Timeout(value=15L)
    public void testPositionWithErrorConnectionRespectsWakeup(String quorum, String groupProtocol) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 15);
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "localhost:12345");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, properties, x$4);
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$)).asJava());
        CompletableFuture.runAsync(() -> {
            TimeUnit.SECONDS.sleep(1L);
            consumer.wakeup();
        });
        Assertions.assertThrows(WakeupException.class, () -> consumer.position(topicPartition, Duration.ofSeconds(100L)));
    }

    /*
     * WARNING - void declaration
     */
    @Flaky(value="KAFKA-18031")
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCloseLeavesGroupOnInterrupt(String quorum, String groupProtocol) {
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)0, (int)listener.callsToRevoked());
        try {
            Thread.currentThread().interrupt();
            Assertions.assertThrows(InterruptException.class, () -> consumer.close());
        }
        finally {
            Thread.interrupted();
        }
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Assertions.assertEquals((int)1, (int)listener.callsToRevoked());
        ConsumerConfig config = new ConsumerConfig(this.consumerConfig());
        int leaveGroupTimeoutMs = Predef$.MODULE$.Integer2int(config.getInt("session.timeout.ms")) / 2;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = leaveGroupTimeoutMs;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextConsumerTest.$anonfun$testCloseLeavesGroupOnInterrupt$2(config, adminClient)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PlaintextConsumerTest.$anonfun$testCloseLeavesGroupOnInterrupt$3(leaveGroupTimeoutMs));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionsForAutoCreate$1(Consumer consumer$1) {
        return !consumer$1.partitionsFor("non-exist-topic").isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionsForAutoCreate$2() {
        return "Timed out while awaiting non empty partitions.";
    }

    private static final void assertNoMetric$1(KafkaBroker broker, String name, QuotaType quotaType, String clientId) {
        MetricName metricName = broker.metrics().metricName("throttle-time", quotaType.toString(), "", new String[]{"user", "", "client-id", clientId});
        Assertions.assertNull((Object)broker.metrics().metric(metricName), (String)("Metric should not have been created " + metricName));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testEndOffsets$1(PlaintextConsumerTest $this, long startingTimestamp$1, KafkaProducer producer$2, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord($this.tp().topic(), Predef$.MODULE$.int2Integer($this.tp().partition()), Predef$.MODULE$.long2Long(timestamp), (Object)("key " + i).getBytes(), (Object)("value " + i).getBytes());
        producer$2.send(record);
        return record;
    }

    public static final /* synthetic */ boolean $anonfun$testCloseLeavesGroupOnInterrupt$2(ConsumerConfig config$1, Admin adminClient$1) {
        try {
            String groupId = config$1.getString("group.id");
            return ((ConsumerGroupDescription)((KafkaFuture)adminClient$1.describeConsumerGroups(Collections.singletonList(groupId)).describedGroups().get(groupId)).get()).members().isEmpty();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException ? true : throwable instanceof InterruptedException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$testCloseLeavesGroupOnInterrupt$3(int leaveGroupTimeoutMs$1) {
        return "Consumer did not leave the consumer group within " + leaveGroupTimeoutMs$1 + " ms of close";
    }
}

