/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import kafka.api.IntegrationTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000593A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!9q\u0003\u0001b\u0001\n\u0003A\u0002BB\u0010\u0001A\u0003%\u0011\u0004C\u0004!\u0001\t\u0007I\u0011\u0001\r\t\r\u0005\u0002\u0001\u0015!\u0003\u001a\u0011\u001d\u0011\u0003A1A\u0005\u0002aAaa\t\u0001!\u0002\u0013I\u0002\"\u0002\u0013\u0001\t\u0003)#!\b)s_\u0012,8-\u001a:TK:$w\u000b[5mK\u0012+G.\u001a;j_:$Vm\u001d;\u000b\u0005-a\u0011aA1qS*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005Q\u0011BA\n\u000b\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!A\u0007qe>$WoY3s\u0007>,h\u000e^\u000b\u00023A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA\u0005Y!M]8lKJ\u001cu.\u001e8u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003=!WMZ1vYRd\u0015N\\4fe6\u001b\u0018\u0001\u00053fM\u0006,H\u000e\u001e'j]\u001e,'/T:!\u0003}!Xm\u001d;TK:$w+\u001b;i)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8NS\u0012<\u0016-\u001f\u000b\u0003M%\u0002\"AG\u0014\n\u0005!Z\"\u0001B+oSRDQA\u000b\u0005A\u0002-\na!];peVl\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/75\tqF\u0003\u00021\u001d\u00051AH]8pizJ!AM\u000e\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003emA#\u0001C\u001c\u0011\u0005a\nU\"A\u001d\u000b\u0005iZ\u0014A\u00029be\u0006l7O\u0003\u0002={\u00059!.\u001e9ji\u0016\u0014(B\u0001 @\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006\u0002\u0005E\u0015.\u0003\"!\u0012%\u000e\u0003\u0019S!aR\u001d\u0002\u0011A\u0014xN^5eKJL!!\u0013$\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0005a\u0015%A'\u0002\u000b-\u0014\u0018M\u001a;")
public class ProducerSendWhileDeletionTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int brokerCount;
    private final int defaultLingerMs;

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public int defaultLingerMs() {
        return this.defaultLingerMs;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSendWithTopicDeletionMidWay(String quorum) {
        int numRecords = 10;
        String topic = "topic";
        this.createTopicWithAssignment(topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.createTopicWithAssignment$default$3());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 1)), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))))}));
        this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).alterPartitionReassignments(CollectionConverters$.MODULE$.MapHasAsJava((Map)reassignment).asJava()).all().get();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            RecordMetadata resp = (RecordMetadata)producer.send(new ProducerRecord(topic, null, (Object)("value" + i).getBytes(StandardCharsets.UTF_8))).get();
            Assertions.assertEquals((Object)topic, (Object)resp.topic());
        });
        this.deleteTopic(topic, this.listenerName());
        TestUtils$.MODULE$.verifyTopicDeletion(topic, 2, this.brokers());
        Assertions.assertEquals((Object)topic, (Object)((RecordMetadata)producer.send(new ProducerRecord(topic, null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get()).topic());
    }

    public ProducerSendWhileDeletionTest() {
        this.producerCount = 1;
        this.brokerCount = 2;
        this.defaultLingerMs = 5;
        this.serverConfig().put("num.partitions", Integer.toString(2));
        this.serverConfig().put("default.replication.factor", Integer.toString(2));
        this.serverConfig().put("auto.leader.rebalance.enable", Boolean.toString(false));
        this.producerConfig().put("max.block.ms", Long.toString(5000L));
        this.producerConfig().put("request.timeout.ms", Integer.toString(10000));
        this.producerConfig().put("delivery.timeout.ms", Integer.toString(10000 + this.defaultLingerMs()));
    }
}

