/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u000b\u0016\u0001iAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u0001-\u0011\u0019)\u0004\u0001)A\u0005[!9a\u0007\u0001b\u0001\n\u0003a\u0003BB\u001c\u0001A\u0003%Q\u0006C\u00049\u0001\t\u0007I\u0011A\u001d\t\r\t\u0003\u0001\u0015!\u0003;\u0011%!\u0003\u00011AA\u0002\u0013\u00051\tC\u0005Q\u0001\u0001\u0007\t\u0019!C\u0001#\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006K\u0001\u0012\u0005\u00061\u0002!\t!\u0017\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019\u0001\b\u0001)A\u0005U\")\u0011\u000f\u0001C!e\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0002A\u0011BA/\u0005y\u0011\u0016mY6Bo\u0006\u0014X-Q;u_R{\u0007/[2De\u0016\fG/[8o)\u0016\u001cHO\u0003\u0002\u0017/\u0005\u0019\u0011\r]5\u000b\u0003a\tQa[1gW\u0006\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ!AH\f\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003Au\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003E\u0015j\u0011a\t\u0006\u0003I]\tQ!\u00193nS:L!AJ\u0012\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\tQ#\u0001\u0006ok6\u001cVM\u001d<feN,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0004\u0013:$\u0018a\u00038v[N+'O^3sg\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018A\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0005kRLGNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u000b\u0002\tB\u0011QIT\u0007\u0002\r*\u0011Ae\u0012\u0006\u0003\u0011&\u000bqa\u00197jK:$8O\u0003\u0002\u0019\u0015*\u00111\nT\u0001\u0007CB\f7\r[3\u000b\u00035\u000b1a\u001c:h\u0013\tyeIA\u0003BI6Lg.A\u0005bI6Lgn\u0018\u0013fcR\u0011!+\u0016\t\u0003]MK!\u0001V\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b-.\t\t\u00111\u0001E\u0003\rAH%M\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u0017\t\u00047\u0002\u0014W\"\u0001/\u000b\u0005us\u0016!C5n[V$\u0018M\u00197f\u0015\tyv&\u0001\u0006d_2dWm\u0019;j_:L!!\u0019/\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u0002dM6\tAM\u0003\u0002f/\u000511/\u001a:wKJL!a\u001a3\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0006i>\u0004\u0018nY\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011QNP\u0001\u0005Y\u0006tw-\u0003\u0002pY\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013!B:fiV\u0003HC\u0001*t\u0011\u0015!\b\u00031\u0001v\u0003!!Xm\u001d;J]\u001a|\u0007C\u0001<}\u001b\u00059(B\u0001\fy\u0015\tI(0A\u0004kkBLG/\u001a:\u000b\u0005md\u0015!\u00026v]&$\u0018BA?x\u0005!!Vm\u001d;J]\u001a|\u0007F\u0001\t\u0000!\r1\u0018\u0011A\u0005\u0004\u0003\u00079(A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001SQ\r\t\u00121\u0002\t\u0004m\u00065\u0011bAA\bo\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0014i\u0016\u001cH/Q;u_\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0006%\u0006U\u0011Q\u0006\u0005\b\u0003/\u0011\u0002\u0019AA\r\u0003\u0019\tXo\u001c:v[B!\u00111DA\u0015\u001d\u0011\ti\"!\n\u0011\u0007\u0005}q&\u0004\u0002\u0002\")\u0019\u00111E\r\u0002\rq\u0012xn\u001c;?\u0013\r\t9cL\u0001\u0007!J,G-\u001a4\n\u0007=\fYCC\u0002\u0002(=Bq!a\f\u0013\u0001\u0004\tI\"A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\b%\u0005M\u0012qHA!!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001dq\u00061\u0001/\u0019:b[NLA!!\u0010\u00028\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003\u0007\n!f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\fT\u0010K\u0004\u0013\u0003\u000f\n\u0019&!\u0016\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017RA!!\u0014\u00028\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002R\u0005-#\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA,C\t\tI&\u0001\u0016hKR$Vm\u001d;Rk>\u0014X/\\!oI\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0002)\u001d,GOU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u0011\ty&!\u001f\u0011\u000f\u0005\u0005\u00141M\u0017\u0002h5\ta,C\u0002\u0002fy\u00131!T1q!\u0015\tI'a\u001d.\u001d\u0011\tY'a\u001c\u000f\t\u0005}\u0011QN\u0005\u0002a%\u0019\u0011\u0011O\u0018\u0002\u000fA\f7m[1hK&!\u0011QOA<\u0005\r\u0019V-\u001d\u0006\u0004\u0003cz\u0003B\u00025\u0014\u0001\u0004\tI\u0002")
public class RackAwareAutoTopicCreationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numServers;
    private final int numPartitions;
    private final int replicationFactor;
    private final Properties overridingProps = new Properties();
    private Admin admin;
    private final String topic;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Collection<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public int numServers() {
        return this.numServers;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public IndexedSeq<KafkaConfig> generateConfigs() {
        return (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numServers()).map((Function1 & Serializable)node -> RackAwareAutoTopicCreationTest.$anonfun$generateConfigs$1(BoxesRunTime.unboxToInt((Object)node))).map((Function1 & Serializable)x$2 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$2, fromProps_overrides, true);
        });
    }

    private String topic() {
        return this.topic;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new Properties()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAutoCreateTopic(String quorum, String groupProtocol) {
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(this.bootstrapServers(this.bootstrapServers$default$1()), -1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
            Map<Object, scala.collection.immutable.Seq<Object>> assignment = this.getReplicaAssignment(this.topic());
            Iterable brokerMetadatas = ((KafkaBroker)this.brokers().head()).metadataCache().getAliveBrokers();
            Map expectedMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"1")}));
            Assertions.assertEquals((Object)expectedMap, (Object)((IterableOnceOps)brokerMetadatas.map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b.id)), b.rack.get()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            int x$3 = this.numServers();
            int x$4 = this.numPartitions();
            int x$5 = this.replicationFactor();
            boolean x$7 = this.checkReplicaDistribution$default$6();
            boolean x$8 = this.checkReplicaDistribution$default$8();
            this.checkReplicaDistribution(assignment, (Map<Object, String>)expectedMap, x$3, x$4, x$5, x$7, false, x$8);
        }
    }

    private Map<Object, scala.collection.immutable.Seq<Object>> getReplicaAssignment(String topic) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(TestUtils$.MODULE$.describeTopic(this.admin(), topic).partitions()).asScala().map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition.partition())), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()))).toSeq()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Properties $anonfun$generateConfigs$1(int node) {
        Some x$3 = new Some((Object)Integer.toString(node / 2));
        boolean x$4 = true;
        TestUtils$ createBrokerConfig$default$4_this = TestUtils$.MODULE$;
        Object var19_3 = null;
        int x$5 = createBrokerConfig$default$4_this.RandomPort();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var20_10 = null;
        int x$11 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var21_13 = null;
        int x$13 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var22_16 = null;
        int x$15 = createBrokerConfig$default$14_this.RandomPort();
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        return TestUtils$.MODULE$.createBrokerConfig(node, false, x$4, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$3, x$16, x$17, x$18, x$19, x$20);
    }

    public RackAwareAutoTopicCreationTest() {
        this.numServers = 4;
        this.numPartitions = 8;
        this.replicationFactor = 2;
        this.overridingProps().put("num.partitions", Integer.toString(this.numPartitions()));
        this.overridingProps().put("default.replication.factor", Integer.toString(this.replicationFactor()));
        this.topic = "topic";
    }
}

