/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractSaslTest;
import kafka.security.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.metadata.storage.Formatter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u0016-\u0001EBQA\u000e\u0001\u0005\u0002]Bq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019\u0001\u0006\u0001)A\u0005\r\"9\u0011\u000b\u0001b\u0001\n#\u0012\u0006B\u00022\u0001A\u0003%1\u000bC\u0004d\u0001\t\u0007I\u0011\u000b3\t\r=\u0004\u0001\u0015!\u0003f\u0011\u001d\u0001\bA1A\u0005R\u0011Da!\u001d\u0001!\u0002\u0013)\u0007b\u0002:\u0001\u0005\u0004%\ta\u001d\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\t\u000fa\u0004!\u0019!C\u0001g\"1\u0011\u0010\u0001Q\u0001\nQDqA\u001f\u0001C\u0002\u0013\u00051\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001e\u0005\by\u0002\u0011\r\u0011\"\u0001;\u0011\u0019i\b\u0001)A\u0005w!9a\u0010\u0001b\u0001\n\u0003\u0019\bBB@\u0001A\u0003%A\u000fC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001\u0002\u0004!A\u0011Q\u0002\u0001!\u0002\u0013\t)\u0001C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011q\t\u0001\u0005B\u0005%\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!!,\u0001\t\u0003\ty\u000bC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\t\u0001\u0011%!1\u0003\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0003WBqA!\u0010\u0001\t\u0013\u0011y\u0004C\u0005\u0003Z\u0001\t\n\u0011\"\u0003\u0003\\!9!\u0011\u000f\u0001\u0005\n\tM\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\n\u0005[\u0003\u0011\u0013!C\u0005\u0005_CqAa0\u0001\t\u0013\u0011\tMA\u0013TCNd7\t\\5f]R\u001cx+\u001b;i\u0013:4\u0018\r\\5e\u0007J,G-\u001a8uS\u0006d7\u000fV3ti*\u0011QFL\u0001\u0004CBL'\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\r\t\u0003gQj\u0011\u0001L\u0005\u0003k1\u0012\u0001#\u00112tiJ\f7\r^*bg2$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005A\u0004CA\u001a\u0001\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$AB*ue&tw-A\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u0004\u0013!G6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N,\u0012A\u0012\t\u0004\u000f:[T\"\u0001%\u000b\u0005%S\u0015!C5n[V$\u0018M\u00197f\u0015\tYE*\u0001\u0006d_2dWm\u0019;j_:T\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f\"\u0013A\u0001T5ti\u0006Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002'B\u0011A\u000bY\u0007\u0002+*\u0011akV\u0001\u0005CV$\bN\u0003\u0002Y3\u0006A1/Z2ve&$\u0018P\u0003\u0002[7\u000611m\\7n_:T!a\f/\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0005\u0003CV\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0002#M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007%\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002KB\u0019amZ5\u000e\u00031K!\u0001\u001b'\u0003\tM{W.\u001a\t\u0003U6l\u0011a\u001b\u0006\u0003Y~\nA!\u001e;jY&\u0011an\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005i1m\u001c8tk6,'oQ8v]R,\u0012\u0001\u001e\t\u0003MVL!A\u001e'\u0003\u0007%sG/\u0001\bd_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0011\u0002\u001bA\u0014x\u000eZ;dKJ\u001cu.\u001e8u\u00039\u0001(o\u001c3vG\u0016\u00148i\\;oi\u0002\n1B\u0019:pW\u0016\u00148i\\;oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0003iB,\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011B\u0007\u00023&\u0019\u00111B-\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002G\r|gNZ5hkJ,7+Z2ve&$\u0018PQ3g_J,7+\u001a:wKJ\u001c8\u000b^1siR!\u00111CA\r!\r1\u0017QC\u0005\u0004\u0003/a%\u0001B+oSRDq!a\u0007\u0019\u0001\u0004\ti\"\u0001\u0005uKN$\u0018J\u001c4p!\u0011\ty\"a\u000b\u000e\u0005\u0005\u0005\"bA\u0017\u0002$)!\u0011QEA\u0014\u0003\u001dQW\u000f]5uKJT1!!\u000b_\u0003\u0015QWO\\5u\u0013\u0011\ti#!\t\u0003\u0011Q+7\u000f^%oM>\fA#\u00193e\r>\u0014X.\u0019;uKJ\u001cV\r\u001e;j]\u001e\u001cH\u0003BA\n\u0003gAq!!\u000e\u001a\u0001\u0004\t9$A\u0005g_Jl\u0017\r\u001e;feB!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012aB:u_J\fw-\u001a\u0006\u0004\u0003\u0003Z\u0016\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\u0015\u00131\b\u0002\n\r>\u0014X.\u0019;uKJ\f1d\u0019:fCR,\u0007K]5wS2,w-\u001a3BI6Lgn\u00117jK:$HCAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\nQ!\u00193nS:T1!!\u0016\\\u0003\u001d\u0019G.[3oiNLA!!\u0017\u0002P\t)\u0011\tZ7j]\u0006)1/\u001a;VaR!\u00111CA0\u0011\u001d\tYb\u0007a\u0001\u0003;A3aGA2!\u0011\ty\"!\u001a\n\t\u0005\u001d\u0014\u0011\u0005\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005M\u0001f\u0001\u000f\u0002pA!\u0011qDA9\u0013\u0011\t\u0019(!\t\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\n;fgR\u0004&o\u001c3vG\u0016\u0014x+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:f)\u0011\t\u0019\"!\u001f\t\u000f\u0005mT\u00041\u0001\u0002~\u0005!\u0012n]%eK6\u0004x\u000e^3oG\u0016,e.\u00192mK\u0012\u00042AZA@\u0013\r\t\t\t\u0014\u0002\b\u0005>|G.Z1oQ\u001di\u0012QQAI\u0003'\u0003B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000b\u0019#\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u001f\u000bIIA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011QS\u00014w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>WJ\fg\r\u001e\u0018jg&#W-\u001c9pi\u0016t7-Z#oC\ndW\rZ\u001f|auDs!HAM\u0003K\u000b9\u000b\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\u0011\ty*!#\u0002\u0011A\u0014xN^5eKJLA!a)\u0002\u001e\nYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BAU\u0003WK\u0012!A\r\u0002\u0001\u0005\u0011D/Z:u)J\fgn]1di&|g.\u00197Qe>$WoY3s/&$\b.Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\r\u0006\u0003\u0002\u0014\u0005E\u0006bBAZ=\u0001\u0007\u0011QW\u0001\u0007cV|'/^7\u0011\t\u0005]\u0016Q\u0019\b\u0005\u0003s\u000b\t\rE\u0002\u0002<2k!!!0\u000b\u0007\u0005}\u0006'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0007d\u0015A\u0002)sK\u0012,g-C\u0002C\u0003\u000fT1!a1MQ\rq\u0012Q\u0011\u0015\b=\u0005e\u0015QZAh\u0003\u001d\u0019HO]5oONd#!!5\"\u0005\u0005M\u0017!B6sC\u001a$\u0018!\n;fgR\u001cuN\\:v[\u0016\u0014x+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:f)\u0019\t\u0019\"!7\u0002\\\"9\u00111W\u0010A\u0002\u0005U\u0006bBAo?\u0001\u0007\u0011QW\u0001\u000eOJ|W\u000f\u001d)s_R|7m\u001c7)\u000f}\t))!%\u0002b\u0006\u0012\u00111]\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u001dy\u0012q]Aw\u0003_\u0004B!a'\u0002j&!\u00111^AO\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\t\t0\t\u0002\u0002t\u0006Qs-\u001a;UKN$\u0018+^8sk6\fe\u000eZ$s_V\u0004\bK]8u_\u000e|G\u000eU1sC6,G/\u001a:t\u00032d\u0017!\u000e;fgRl\u0015M\\;bY\u0006\u001b8/[4o[\u0016tGoQ8ogVlWM],ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$b!a\u0005\u0002z\u0006m\bbBAZA\u0001\u0007\u0011Q\u0017\u0005\b\u0003;\u0004\u0003\u0019AA[Q\u001d\u0001\u0013QQAI\u0003CDs\u0001IAt\u0003[\u0014\t\u0001\f\u0002\u0002r\u0006YE/Z:u\u001b\u0006tW/\u00197BgNLwM\\7f]R\u001cuN\\:v[\u0016\u0014x+\u001b;i\u0003V$xnQ8n[&$H)[:bE2,GmV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sKR1\u00111\u0003B\u0004\u0005\u0013Aq!a-\"\u0001\u0004\t)\fC\u0004\u0002^\u0006\u0002\r!!.)\u000f\u0005\n))!%\u0002b\":\u0011%a:\u0002n\n=AFAAy\u0003\u001d2XM]5gs\u000e{gn];nKJ<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\t\u0005M!Q\u0003\u0005\b\u0005/\u0011\u0003\u0019\u0001B\r\u0003!\u0019wN\\:v[\u0016\u0014\b\u0003\u0003B\u000e\u0005?\u0011\u0019Ca\t\u000e\u0005\tu!\u0002\u0002B\f\u0003'JAA!\t\u0003\u001e\tA1i\u001c8tk6,'\u000fE\u0003g\u0005K\u0011I#C\u0002\u0003(1\u0013Q!\u0011:sCf\u00042A\u001aB\u0016\u0013\r\u0011i\u0003\u0014\u0002\u0005\u0005f$X-A\u0017uKN$8*\u00194lC\u0006#W.\u001b8DY&,g\u000e^,ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$B!a\u0005\u00034!9\u00111W\u0012A\u0002\u0005U\u0006fA\u0012\u0002\u0006\":1%!'\u0002N\neBFAAi\u0003Y\u0019'/Z1uK\u000ec\u0017.\u001a8u\u0007J,G-\u001a8uS\u0006d\u0017!D:f]\u0012|e.\u001a*fG>\u0014H\r\u0006\u0004\u0002\u0014\t\u0005#q\n\u0005\b\u0005\u0007*\u0003\u0019\u0001B#\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003\u0003B$\u0005\u0017\u0012\u0019Ca\t\u000e\u0005\t%#\u0002\u0002B\"\u0003'JAA!\u0014\u0003J\ti1*\u00194lCB\u0013x\u000eZ;dKJD\u0011B!\u0015&!\u0003\u0005\rAa\u0015\u0002\u00135\f\u0007pV1ji6\u001b\bc\u00014\u0003V%\u0019!q\u000b'\u0003\t1{gnZ\u0001\u0018g\u0016tGm\u00148f%\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uII*\"A!\u0018+\t\tM#qL\u0016\u0003\u0005C\u0002BAa\u0019\u0003n5\u0011!Q\r\u0006\u0005\u0005O\u0012I'A\u0005v]\u000eDWmY6fI*\u0019!1\u000e'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003p\t\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ib/\u001a:jMf\fU\u000f\u001e5f]RL7-\u0019;j_:,\u0005pY3qi&|g\u000e\u0006\u0003\u0002\u0014\tU\u0004\u0002\u0003B<O\u0011\u0005\rA!\u001f\u0002\r\u0005\u001cG/[8o!\u00151'1PA\n\u0013\r\u0011i\b\u0014\u0002\ty\tLh.Y7f}\u0005ya/\u001a:jMf<\u0016\u000e\u001e5SKR\u0014\u00180\u0006\u0003\u0003\u0004\nUE\u0003\u0002BC\u0005O#B!a\u0005\u0003\b\"I!\u0011\u0012\u0015\u0011\u0002\u0003\u0007!1R\u0001\naJ,G-[2bi\u0016\u0004rA\u001aBG\u0005#\u000bi(C\u0002\u0003\u00102\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\tM%Q\u0013\u0007\u0001\t\u001d\u00119\n\u000bb\u0001\u00053\u0013\u0011\u0001V\t\u0005\u00057\u0013\t\u000bE\u0002g\u0005;K1Aa(M\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u001aBR\u0013\r\u0011)\u000b\u0014\u0002\u0004\u0003:L\b\u0002\u0003BUQ\u0011\u0005\rAa+\u0002\u0013=\u0004XM]1uS>t\u0007#\u00024\u0003|\tE\u0015!\u0007<fe&4\u0017pV5uQJ+GO]=%I\u00164\u0017-\u001e7uII*BA!-\u0003:R!!1\u0017B^U\u0011\u0011)La\u0018\u0011\u000f\u0019\u0014iIa.\u0002~A!!1\u0013B]\t\u001d\u00119*\u000bb\u0001\u00053C\u0001B!+*\t\u0003\u0007!Q\u0018\t\u0006M\nm$qW\u0001\u001cGJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:\u0015\u0005\t\u0015\u0003")
public class SaslClientsWithInvalidCredentialsTest
extends AbstractSaslTest {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
    private final SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    private final int consumerCount;
    private final int producerCount;
    private final int brokerCount;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp;

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @Override
    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
    }

    @Override
    public void addFormatterSettings(Formatter formatter) {
        formatter.setScramArguments(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"SCRAM-SHA-256=[name=scram-admin,password=scram-admin-secret]", (List)Nil$.MODULE$)).asJava());
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createAdminClient(this.bootstrapServers(this.bootstrapServers$default$1()), this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties(), this.kafkaClientSaslMechanism(), "scram-admin", "scram-admin-secret");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), "KafkaServer"));
        String superuserLoginContext = this.jaasAdminLoginModule(this.kafkaClientSaslMechanism(), this.jaasAdminLoginModule$default$2());
        this.superuserClientConfig().put("sasl.jaas.config", superuserLoginContext);
        super.setUp(testInfo);
        Using$.MODULE$.resource((Object)this.createPrivilegedAdminClient(), (Function1 & Serializable)superuserAdminClient -> TestUtils$.MODULE$.createTopicWithAdmin((Admin)superuserAdminClient, this.topic(), this.brokers(), this.controllerServers(), this.numPartitions(), 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum=kraft.isIdempotenceEnabled={0}")
    @ValueSource(booleans={true, false})
    public void testProducerWithAuthenticationFailure(boolean isIdempotenceEnabled) {
        KafkaProducer kafkaProducer;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", Boolean.toString(isIdempotenceEnabled));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 10000L);
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + verifyAuthenticationException_elapsedMs));
        Object var9_6 = null;
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action2 = (JFunction0.mcV.sp & Serializable)() -> producer.partitionsFor(this.topic());
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action2));
        long verifyAuthenticationException_elapsedMs2 = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs2 <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + verifyAuthenticationException_elapsedMs2));
        Object var14_9 = null;
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
        if (isIdempotenceEnabled) {
            ByteArraySerializer x$5 = this.createProducer$default$1();
            ByteArraySerializer x$6 = this.createProducer$default$2();
            kafkaProducer = this.createProducer(x$5, x$6, prop);
        } else {
            kafkaProducer = producer;
        }
        KafkaProducer producer2 = kafkaProducer;
        int n = 0;
        long l = 100L;
        long verifyWithRetry_waitUntilTrue_waitTimeMs = 15000L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyWithRetry_waitUntilTrue_pause;
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer2, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + verifyWithRetry_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Operation did not succeed within timeout after " + n));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs), (long)verifyWithRetry_waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testTransactionalProducerWithAuthenticationFailure(String quorum) {
        KafkaProducer<byte[], byte[]> txProducer = this.createTransactionalProducer();
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> txProducer.initTransactions();
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + verifyAuthenticationException_elapsedMs));
        Object var3_3 = null;
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
        Assertions.assertThrows(KafkaException.class, () -> txProducer.initTransactions());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsumerWithAuthenticationFailure(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testManualAssignmentConsumerWithAuthenticationFailure(String quorum, String groupProtocol) {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testManualAssignmentConsumerWithAutoCommitDisabledWithAuthenticationFailure(String quorum, String groupProtocol) {
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyConsumerWithAuthenticationFailure(Consumer<byte[], byte[]> consumer) {
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> consumer.poll(Duration.ofMillis(1000L));
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + verifyAuthenticationException_elapsedMs));
        Object var3_2 = null;
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action2 = (JFunction0.mcV.sp & Serializable)() -> consumer.partitionsFor(this.topic());
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action2));
        long verifyAuthenticationException_elapsedMs2 = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs2 <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + verifyAuthenticationException_elapsedMs2));
        Object var8_5 = null;
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int n = 0;
        long l = 100L;
        long verifyWithRetry_waitUntilTrue_waitTimeMs = 15000L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyWithRetry_waitUntilTrue_pause;
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + verifyWithRetry_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Operation did not succeed within timeout after " + n));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs), (long)verifyWithRetry_waitUntilTrue_pause));
        }
        int n2 = 0;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyWithRetry_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyWithRetry_waitUntilTrue_pause;
            boolean bl;
            try {
                ++n2;
                bl = SaslClientsWithInvalidCredentialsTest.$anonfun$verifyConsumerWithAuthenticationFailure$5(consumer.poll(Duration.ofMillis(1000L)));
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime2 + verifyWithRetry_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)("Operation did not succeed within timeout after " + n2));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs2), (long)verifyWithRetry_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testKafkaAdminClientWithAuthenticationFailure(String quorum) {
        Properties props = JaasTestUtils.adminClientSecurityConfigs(this.securityProtocol(), OptionConverters$.MODULE$.toJava(this.trustStoreFile()), OptionConverters$.MODULE$.toJava(this.clientSaslProperties()));
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        try (Admin adminClient = Admin.create((Properties)props);){
            JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> this.describeTopic$1(adminClient);
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + verifyAuthenticationException_elapsedMs));
            Object var5_4 = null;
            this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
            int n = 0;
            long l = 100L;
            long verifyWithRetry_waitUntilTrue_waitTimeMs = 15000L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    this.describeTopic$1(adminClient);
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (!bl) {
                    void verifyWithRetry_waitUntilTrue_pause;
                    if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + verifyWithRetry_waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)("Operation did not succeed within timeout after " + n));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs), (long)verifyWithRetry_waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
    }

    private void createClientCredential() {
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
    }

    private void sendOneRecord(KafkaProducer<byte[], byte[]> producer, long maxWaitMs) {
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes());
        Future future = producer.send(record);
        producer.flush();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(maxWaitMs, TimeUnit.MILLISECONDS);
            Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)("Invalid offset " + recordMetadata));
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private long sendOneRecord$default$2() {
        return 15000L;
    }

    private void verifyAuthenticationException(Function0<BoxedUnit> action) {
        long startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> action.apply$mcV$sp());
        long elapsedMs = System.currentTimeMillis() - startMs;
        Assertions.assertTrue((elapsedMs <= 5000L ? 1 : 0) != 0, (String)("Poll took too long, elapsed=" + elapsedMs));
    }

    /*
     * WARNING - void declaration
     */
    private <T> void verifyWithRetry(Function0<T> operation, Function1<T, Object> predicate) {
        int n = 0;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            try {
                ++n;
                bl = BoxesRunTime.unboxToBoolean((Object)predicate.apply(operation.apply()));
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Operation did not succeed within timeout after " + n));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private <T> Function1<T, Object> verifyWithRetry$default$2(Function0<T> operation) {
        return (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SaslClientsWithInvalidCredentialsTest.$anonfun$verifyWithRetry$default$2$1(x$3));
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer() {
        this.producerConfig().setProperty("transactional.id", "txclient-1");
        this.producerConfig().put("enable.idempotence", "true");
        return this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerWithAuthenticationFailure$5(ConsumerRecords x$1) {
        return x$1.count() == 1;
    }

    private final void describeTopic$1(Admin adminClient$1) {
        try {
            java.util.Map response = (java.util.Map)adminClient$1.describeTopics(Collections.singleton(this.topic())).allTopicNames().get();
            Assertions.assertEquals((int)1, (int)response.size());
            response.forEach((x$2, description) -> Assertions.assertEquals((int)this.numPartitions(), (int)description.partitions().size()));
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyWithRetry$1(IntRef attempts$1, Function1 predicate$1, Function0 operation$1) {
        try {
            ++attempts$1.elem;
            return BoxesRunTime.unboxToBoolean((Object)predicate$1.apply(operation$1.apply()));
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyWithRetry$2(IntRef attempts$1) {
        return "Operation did not succeed within timeout after " + attempts$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$verifyWithRetry$default$2$1(Object x$3) {
        return true;
    }

    public SaslClientsWithInvalidCredentialsTest() {
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.consumerCount = 1;
        this.producerCount = 1;
        this.brokerCount = 1;
        this.serverConfig().setProperty("offsets.topic.replication.factor", "1");
        this.serverConfig().setProperty("transaction.state.log.replication.factor", "1");
        this.serverConfig().setProperty("transaction.state.log.min.isr", "1");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.topic = "topic";
        this.numPartitions = 1;
        this.tp = new TopicPartition(this.topic(), 0);
    }

    public static final /* synthetic */ Object $anonfun$verifyConsumerWithAuthenticationFailure$5$adapted(ConsumerRecords x$1) {
        return BoxesRunTime.boxToBoolean((boolean)SaslClientsWithInvalidCredentialsTest.$anonfun$verifyConsumerWithAuthenticationFailure$5(x$1));
    }
}

