/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.SaslSetup;
import kafka.security.JaasTestUtils;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaBroker;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.DelegationTokenExpiredException;
import org.apache.kafka.common.errors.DelegationTokenNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Properties$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\r]f\u0001\u0002!B\u0001\u0019CQA\u0014\u0001\u0005\u0002=Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004a\u0001\u0001\u0006Ia\u0015\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0011\u0019Y\u0007\u0001)A\u0005G\"9A\u000e\u0001b\u0001\n\u0003i\u0007B\u0002<\u0001A\u0003%a\u000eC\u0005x\u0001\u0001\u0007\t\u0019!C\u0001q\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0003\u0011)\t9\u0002\u0001a\u0001\u0002\u0003\u0006K!\u001f\u0005\t\u00033\u0001!\u0019!C\u0001E\"9\u00111\u0004\u0001!\u0002\u0013\u0019\u0007bBA\u000f\u0001\u0011E\u0013q\u0004\u0005\u000b\u0003O\u0001\u0001R1A\u0005R\u0005%\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002\n\u0002!\t%!\u0019\t\u0013\u0005M\u0005A1A\u0005\u0002\u0005U\u0005\u0002CAO\u0001\u0001\u0006I!a&\t\u0013\u0005}\u0005A1A\u0005\u0002\u0005U\u0005\u0002CAQ\u0001\u0001\u0006I!a&\t\u0013\u0005\r\u0006A1A\u0005\u0002\u0005U\u0005\u0002CAS\u0001\u0001\u0006I!a&\t\u0013\u0005\u001d\u0006A1A\u0005\u0002\u0005U\u0005\u0002CAU\u0001\u0001\u0006I!a&\t\u0013\u0005-\u0006A1A\u0005\u0002\u0005U\u0005\u0002CAW\u0001\u0001\u0006I!a&\t\u0013\u0005=\u0006A1A\u0005\u0002\u0005U\u0005\u0002CAY\u0001\u0001\u0006I!a&\t\u0013\u0005M\u0006A1A\u0005\u0002\u0005U\u0005\u0002CA[\u0001\u0001\u0006I!a&\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqA!\u000e\u0001\t\u0003\u00119\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B3\u0001\u0011\u0005!q\r\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011i\b\u0001C\u0005\u0005\u007fBqAa&\u0001\t\u0013\u0011I\nC\u0004\u0003&\u0002!IAa*\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"9!q\u0017\u0001\u0005\n\te\u0006b\u0002B`\u0001\u0011%!\u0011\u0019\u0005\b\u0005\u000f\u0004A\u0011\u0001Be\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+DqAa8\u0001\t\u0003\u0011\t\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\t]\b\u0001\"\u0003\u0003z\"91q\u0003\u0001\u0005\n\re\u0001bBB\u0016\u0001\u0011%1Q\u0006\u0005\b\u0007\u000f\u0002A\u0011BB%\u0011\u001d\u0019y\u0005\u0001C\u0005\u0007#Bqa!\u001a\u0001\t\u0003\u00199\u0007C\u0005\u0004\f\u0002\t\n\u0011\"\u0001\u0004\u000e\"911\u0015\u0001\u0005\u0002\r\u0015\u0006\"CBY\u0001E\u0005I\u0011ABG\u0005m\u0019\u0016m\u001d7Tg2\fE-\\5o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011!iQ\u0001\u0004CBL'\"\u0001#\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aR&\u0011\u0005!KU\"A!\n\u0005)\u000b%\u0001\u0007\"bg\u0016\fE-\\5o\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0011\u0001\nT\u0005\u0003\u001b\u0006\u0013\u0011bU1tYN+G/\u001e9\u0002\rqJg.\u001b;?)\u0005\u0001\u0006C\u0001%\u0001\u0003Y\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0007+\u0019;uKJtW#A*\u0011\u0005QsV\"A+\u000b\u0005Y;\u0016\u0001\u0003:fg>,(oY3\u000b\u0005aK\u0016AB2p[6|gN\u0003\u0002E5*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyVKA\bSKN|WO]2f!\u0006$H/\u001a:o\u0003]\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0007+\u0019;uKJt\u0007%\u0001\rle\u00064G/Q;uQ>\u0014\u0018N_3s\u00072\f7o\u001d(b[\u0016,\u0012a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fA\u0001\\1oO*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016f\u0005\u0019\u0019FO]5oO\u0006I2N]1gi\u0006+H\u000f[8sSj,'o\u00117bgNt\u0015-\\3!\u00039Y\u0017MZ6b!JLgnY5qC2,\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA!Y;uQ*\u00111oV\u0001\tg\u0016\u001cWO]5us&\u0011Q\u000f\u001d\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003=Y\u0017MZ6b!JLgnY5qC2\u0004\u0013AD:va\u0016\u0014Xk]3s\u0003\u0012l\u0017N\\\u000b\u0002sB\u0011!p`\u0007\u0002w*\u0011A0`\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003}f\u000bqa\u00197jK:$8/C\u0002\u0002\u0002m\u0014Q!\u00113nS:\f!c];qKJ,6/\u001a:BI6Lgn\u0018\u0013fcR!\u0011qAA\n!\u0011\tI!a\u0004\u000e\u0005\u0005-!BAA\u0007\u0003\u0015\u00198-\u00197b\u0013\u0011\t\t\"a\u0003\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+I\u0011\u0011!a\u0001s\u0006\u0019\u0001\u0010J\u0019\u0002\u001fM,\b/\u001a:Vg\u0016\u0014\u0018\tZ7j]\u0002\n\u0011b]3de\u0016$8*Z=\u0002\u0015M,7M]3u\u0017\u0016L\b%\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\u0011\u0011\u0011\u0005\t\u0004_\u0006\r\u0012bAA\u0013a\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u000fiJ,8\u000f^*u_J,g)\u001b7f+\t\tY\u0003\u0005\u0004\u0002\n\u00055\u0012\u0011G\u0005\u0005\u0003_\tYA\u0001\u0003T_6,\u0007\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]r-\u0001\u0002j_&!\u00111HA\u001b\u0005\u00111\u0015\u000e\\3\u0002\u000bM,G/\u00169\u0015\t\u0005\u001d\u0011\u0011\t\u0005\b\u0003\u0007z\u0001\u0019AA#\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA$\u0003'j!!!\u0013\u000b\u0007\t\u000bYE\u0003\u0003\u0002N\u0005=\u0013a\u00026va&$XM\u001d\u0006\u0004\u0003#b\u0016!\u00026v]&$\u0018\u0002BA+\u0003\u0013\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u0004\u001f\u0005e\u0003\u0003BA$\u00037JA!!\u0018\u0002J\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0013M,G/\u00169TCNdGCAA\u0004\u00039\u0019X\r^%oSRL\u0017\r\\!dYN\f!b\u00197vgR,'/Q2m)\u0019\tI'!\u001e\u0002\u0000A!\u00111NA9\u001b\t\tiGC\u0002\u0002p]\u000b1!Y2m\u0013\u0011\t\u0019(!\u001c\u0003%\u0005\u001b7-Z:t\u0007>tGO]8m\u000b:$(/\u001f\u0005\b\u0003o\u0012\u0002\u0019AA=\u00039\u0001XM]7jgNLwN\u001c+za\u0016\u0004B!a\u001b\u0002|%!\u0011QPA7\u0005E\t5\r\u001c)fe6L7o]5p]RK\b/\u001a\u0005\b\u0003\u0003\u0013\u0002\u0019AAB\u0003%y\u0007/\u001a:bi&|g\u000e\u0005\u0003\u0002l\u0005\u0015\u0015\u0002BAD\u0003[\u0012A\"Q2m\u001fB,'/\u0019;j_:\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004'\u00055\u0005\u0003BA$\u0003\u001fKA!!%\u0002J\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0007C:L\u0018i\u00197\u0016\u0005\u0005]\u0005\u0003BA6\u00033KA!a'\u0002n\tQ\u0011i\u00197CS:$\u0017N\\4\u0002\u000f\u0005t\u00170Q2mA\u0005!\u0011m\u001973\u0003\u0015\t7\r\u001c\u001a!\u0003\u0011\t7\r\\\u001a\u0002\u000b\u0005\u001cGn\r\u0011\u0002\r\u0019|w.Q2m\u0003\u001d1wn\\!dY\u0002\n\u0011\u0002\u001d:fM&D\u0018i\u00197\u0002\u0015A\u0014XMZ5y\u0003\u000ed\u0007%\u0001\nue\u0006t7/Y2uS>t\u0017\r\\%e\u0003\u000ed\u0017a\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133BG2\u0004\u0013\u0001C4s_V\u0004\u0018i\u00197\u0002\u0013\u001d\u0014x.\u001e9BG2\u0004\u0013\u0001\n;fgR\f5\r\\(qKJ\fG/[8og^KG\u000f[(qi&|g\u000eV5nK>,H/T:\u0015\t\u0005\u001d\u00111\u0018\u0005\b\u0003{\u0013\u0003\u0019AA`\u0003\u0019\tXo\u001c:v[B!\u0011\u0011YAh\u001d\u0011\t\u0019-a3\u0011\t\u0005\u0015\u00171B\u0007\u0003\u0003\u000fT1!!3F\u0003\u0019a$o\\8u}%!\u0011QZA\u0006\u0003\u0019\u0001&/\u001a3fM&\u0019!.!5\u000b\t\u00055\u00171\u0002\u0015\u0004E\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\t\u0005m\u00171J\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005}\u0017\u0011\u001c\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\u0012\u0002d\u0006%\u00181\u001e\t\u0005\u0003\u000f\n)/\u0003\u0003\u0002h\u0006%#a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002=!:!%a<\u0002|\u0006u\b\u0003BAy\u0003ol!!a=\u000b\t\u0005U\u0018\u0011\\\u0001\taJ|g/\u001b3fe&!\u0011\u0011`Az\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011q`\u0011\u0003\u0005\u0003\tQa\u001b:bMR\f\u0011\u0005^3ti\u0012+G.\u001a;f\u0003\u000ed7oV5uQ>\u0003H/[8o)&lWm\\;u\u001bN$B!a\u0002\u0003\b!9\u0011QX\u0012A\u0002\u0005}\u0006fA\u0012\u0002V\":1%a9\u0002j\u0006-\bfB\u0012\u0002p\u0006m(q\u0002\u0017\u0003\u0003\u007f\fQ\u0007^3ti\u0016C\b/\u001b:f\t\u0016dWmZ1uS>tGk\\6f]^KG\u000f[(qi&|g.\u0012=qSJ,G+[7f!\u0016\u0014\u0018n\u001c3NgR!\u0011q\u0001B\u000b\u0011\u001d\ti\f\na\u0001\u0003\u007fC3\u0001JAkQ\u001d!\u0013q^A~\u00057a#!a@\u0002#Q,7\u000f^!dY>\u0003XM]1uS>t7\u000f\u0006\u0003\u0002\b\t\u0005\u0002bBA_K\u0001\u0007\u0011q\u0018\u0015\u0004K\u0005U\u0007fB\u0013\u0002p\u0006m(q\u0005\u0017\u0003\u0003\u007f\f!\u0003^3ti\u0006\u001bGn\u00149fe\u0006$\u0018n\u001c8teQ!\u0011q\u0001B\u0017\u0011\u001d\tiL\na\u0001\u0003\u007fC3AJAkQ\u001d1\u0013q^A~\u0005ga#!a@\u0002\u001fQ,7\u000f^!dY\u0012+7o\u0019:jE\u0016$B!a\u0002\u0003:!9\u0011QX\u0014A\u0002\u0005}\u0006fA\u0014\u0002V\":q%a<\u0002|\n}BFAA\u0000\u00035!Xm\u001d;BG2$U\r\\3uKR!\u0011q\u0001B#\u0011\u001d\ti\f\u000ba\u0001\u0003\u007fC3\u0001KAkQ\u001dA\u0013q^A~\u0005\u0017b#!a@\u0002WQ,7\u000f\u001e'fO\u0006\u001c\u00170Q2m\u001fB\u001ch*\u001a<fe\u00063g-Z2u\u001fJ\u0014V\r^;s]B\u0013XMZ5yK\u0012$B!a\u0002\u0003R!9\u0011QX\u0015A\u0002\u0005}\u0006fA\u0015\u0002V\":\u0011&a<\u0002|\n]CFAA\u0000\u0003y!Xm\u001d;BiR,W\u000e\u001d;U_\u000e\u0013X-\u0019;f\u0013:4\u0018\r\\5e\u0003\u000ed7\u000f\u0006\u0003\u0002\b\tu\u0003bBA_U\u0001\u0007\u0011q\u0018\u0015\u0004U\u0005U\u0007f\u0002\u0016\u0002p\u0006m(1\r\u0017\u0003\u0003\u007f\f1\u0006^3ti\u000e\u0013X-\u0019;f\t\u0016dWmZ1uS>tGk\\6f]^KG\u000f[*nC2dWM\u001d+j[\u0016|W\u000f\u001e\u000b\u0005\u0003\u000f\u0011I\u0007C\u0004\u0002>.\u0002\r!a0)\u0007-\n)\u000eK\u0004,\u0003_\fYPa\u001c-\u0005\u0005}\u0018A\u000b;fgR,\u0005\u0010]5sK\u0012$\u0016.\\3Ti\u0006l\u0007\u000fT1sO\u0016\u0014H\u000b[1o\u001b\u0006DH*\u001b4f'R\fW\u000e\u001d\u000b\u0005\u0003\u000f\u0011)\bC\u0004\u0002>2\u0002\r!a0)\u00071\n)\u000eK\u0004-\u0003_\fYPa\u001f-\u0005\u0005}\u0018\u0001\u0007<fe&4\u0017pQ1vg\u0016L5o\u00117vgR,'/Q;uQR!\u0011q\u0001BA\u0011\u001d\u0011\u0019)\fa\u0001\u0005\u000b\u000b\u0011!\u001a\t\u0005\u0005\u000f\u0013\tJ\u0004\u0003\u0003\n\n5e\u0002BAc\u0005\u0017K!!!\u0004\n\t\t=\u00151B\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019J!&\u0003\u0013QC'o\\<bE2,'\u0002\u0002BH\u0003\u0017\ta\u0003^3ti\u0006\u001bGn\u0011:fCR,w)\u001a;EK2,G/\u001a\u000b\u0005\u0003\u000f\u0011Y\nC\u0004\u0003\u001e:\u0002\rAa(\u0002\u0015\u0015D\b/Z2u\u0003V$\b\u000e\u0005\u0003\u0002\n\t\u0005\u0016\u0002\u0002BR\u0003\u0017\u0011qAQ8pY\u0016\fg.\u0001\u0006uKN$\u0018i\u00197HKR$B!a\u0002\u0003*\"9!QT\u0018A\u0002\t}\u0015A\u0007;fgR\f5\r\\!vi\"|'/\u001b>bi&|g\u000eR3oS\u0016$G\u0003BA\u0004\u0005_Cq!!01\u0001\u0004\ty\fK\u00021\u0003+Ds\u0001MAx\u0003w\u0014)\f\f\u0002\u0002\u0000\u0006i\u0011\r\u001a3DYV\u001cH/\u001a:BG2$b!a\u0002\u0003<\nu\u0006bBA<c\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u0003\u000b\u0004\u0019AAB\u0003A\u0011X-\\8wK\u000ecWo\u001d;fe\u0006\u001bG\u000e\u0006\u0004\u0002\b\t\r'Q\u0019\u0005\b\u0003o\u0012\u0004\u0019AA=\u0011\u001d\t\tI\ra\u0001\u0003\u0007\u000b\u0011\u0006^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKN\u0004xN\\:f\u001b\u0016$\u0018\rZ1uC\u0006sGmQ8oM&<G\u0003BA\u0004\u0005\u0017Dq!!04\u0001\u0004\ty\fK\u00024\u0003+DsaMAx\u0003w\u0014\t\u000e\f\u0002\u0002\u0000\u0006IB/Z:u\u000bb\u0004\u0018N]3EK2,w-\u0019;j_:$vn[3o)\u0011\t9Aa6\t\u000f\u0005uF\u00071\u0001\u0002@\"\u001aA'!6)\u000fQ\ny/a?\u0003^2\u0012\u0011q`\u0001%i\u0016\u001cHo\u0011:fCR,Gk\\6f]^KG\u000f[(wKJ4Gn\\<US6,7\u000f^1naR!\u0011q\u0001Br\u0011\u001d\ti,\u000ea\u0001\u0003\u007fC3!NAkQ\u001d)\u0014q^A~\u0005Sd#!a@\u0002IQ,7\u000f^#ya&\u0014X\rV8lK:<\u0016\u000e\u001e5Pm\u0016\u0014h\r\\8x)&lWm\u001d;b[B$B!a\u0002\u0003p\"9\u0011Q\u0018\u001cA\u0002\u0005}\u0006f\u0001\u001c\u0002V\":a'a<\u0002|\nUHFAA\u0000\u0003m)\u0007\u0010]5sKR{7.\u001a8Pe\u001a\u000b\u0017\u000e\\,ji\"\f5o]3siR1!1`B\u0001\u0007'\u0001B!!\u0003\u0003~&!!q`A\u0006\u0005\u0011auN\\4\t\u000f\r\rq\u00071\u0001\u0004\u0006\u0005)Ao\\6f]B!1qAB\b\u001b\t\u0019IA\u0003\u0003\u0004\f\r5\u0011A\u00033fY\u0016<\u0017\r^5p]*\u001911\u0001:\n\t\rE1\u0011\u0002\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\"91QC\u001cA\u0002\tm\u0018AE3ya&\u0014\u0018\u0010V5nKB+'/[8e\u001bN\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\u0005\u00077\u00199\u0003\u0005\u0004\u0003\b\u000eu1\u0011E\u0005\u0005\u0007?\u0011)J\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\rQ81E\u0005\u0004\u0007KY(aC\"p]\u001aLw-\u00128uefDqa!\u000b9\u0001\u0004\ty,A\u0003u_BL7-A\nxC&$hi\u001c:EKN\u001c'/\u001b2f\u0003\u000ed7\u000f\u0006\u0005\u0002\b\r=21GB\u001f\u0011\u0019\u0019\t$\u000fa\u0001s\u000611\r\\5f]RDqa!\u000e:\u0001\u0004\u00199$\u0001\u0004gS2$XM\u001d\t\u0005\u0003W\u001aI$\u0003\u0003\u0004<\u00055$\u0001E!dY\nKg\u000eZ5oO\u001aKG\u000e^3s\u0011\u001d\u0019y$\u000fa\u0001\u0007\u0003\nA!Y2mgB1\u0011\u0011YB\"\u0003/KAa!\u0012\u0002R\n\u00191+\u001a;\u0002\u0015\u0015t7/\u001e:f\u0003\u000ed7\u000f\u0006\u0003\u0002\b\r-\u0003bBB'u\u0001\u00071\u0011I\u0001\tE&tG-\u001b8hg\u00069q-\u001a;BG2\u001cH\u0003BB*\u0007C\u0002ba!\u0016\u0004`\u0005]UBAB,\u0015\u0011\u0019Ifa\u0017\u0002\u0013%lW.\u001e;bE2,'\u0002BB/\u0003\u0017\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019)ea\u0016\t\u000f\r\r4\b1\u0001\u00048\u0005a\u0011\r\u001c7U_BL7-Q2mg\u00069r/Y5u\u0003:$g+\u001a:jMf\u0014V-\\8wK\u0012\f5\r\u001c\u000b\u000b\u0003\u000f\u0019Ig!\u001c\u0004\u0000\r\u0005\u0005bBB6y\u0001\u0007\u0011\u0011N\u0001\u0012Kb\u0004Xm\u0019;fIR{'+Z7pm\u0016$\u0007bBB8y\u0001\u00071\u0011O\u0001\u000bCV$\bn\u001c:ju\u0016\u0014\b\u0003BB:\u0007wj!a!\u001e\u000b\t\r=4q\u000f\u0006\u0004\u0007sJ\u0016AB:feZ,'/\u0003\u0003\u0004~\rU$AC!vi\"|'/\u001b>fe\")a\u000b\u0010a\u0001'\"I11\u0011\u001f\u0011\u0002\u0003\u00071QQ\u0001\u0019C\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018PR5mi\u0016\u0014\b\u0003BA6\u0007\u000fKAa!#\u0002n\tA\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\r&dG/\u001a:\u0002C]\f\u0017\u000e^!oIZ+'/\u001b4z%\u0016lwN^3e\u0003\u000edG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r=%\u0006BBC\u0007#[#aa%\u0011\t\rU5qT\u0007\u0003\u0007/SAa!'\u0004\u001c\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0007;\u000bY!\u0001\u0006b]:|G/\u0019;j_:LAa!)\u0004\u0018\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!]\f\u0017\u000e^!oIZ+'/\u001b4z\u0003\u000edGCCA\u0004\u0007O\u001bYk!,\u00040\"91\u0011\u0016 A\u0002\u0005%\u0014\u0001C3ya\u0016\u001cG/\u001a3\t\u000f\r=d\b1\u0001\u0004r!)aK\u0010a\u0001'\"I11\u0011 \u0011\u0002\u0003\u00071QQ\u0001\u001bo\u0006LG/\u00118e-\u0016\u0014\u0018NZ=BG2$C-\u001a4bk2$H\u0005\u000e\u0015\b\u0001\u0005\r\u0018\u0011^B[=\u0005A\b")
public class SaslSslAdminIntegrationTest
extends BaseAdminIntegrationTest
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final ResourcePattern clusterResourcePattern;
    private final String kraftAuthorizerClassName;
    private final KafkaPrincipal kafkaPrincipal;
    private Admin superUserAdmin;
    private final String secretKey;
    private final AclBinding anyAcl;
    private final AclBinding acl2;
    private final AclBinding acl3;
    private final AclBinding fooAcl;
    private final AclBinding prefixAcl;
    private final AclBinding transactionalIdAcl;
    private final AclBinding groupAcl;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, kafkaServerEntryName);
    }

    @Override
    public String jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$(this, adminClient, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    public ResourcePattern clusterResourcePattern() {
        return this.clusterResourcePattern;
    }

    public String kraftAuthorizerClassName() {
        return this.kraftAuthorizerClassName;
    }

    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    public Admin superUserAdmin() {
        return this.superUserAdmin;
    }

    public void superUserAdmin_$eq(Admin x$1) {
        this.superUserAdmin = x$1;
    }

    public String secretKey() {
        return this.secretKey;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)TestUtils.tempFile((String)"truststore", (String)".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.serverConfig().setProperty("authorizer.class.name", this.kraftAuthorizerClassName());
        this.controllerConfig().setProperty("authorizer.class.name", this.kraftAuthorizerClassName());
        this.serverConfig().setProperty("super.users", this.kafkaPrincipal().toString() + ";" + KafkaPrincipal.ANONYMOUS.toString());
        this.controllerConfig().setProperty("super.users", this.kafkaPrincipal().toString());
        this.serverConfig().setProperty("delegation.token.secret.key", this.secretKey());
        this.serverConfig().setProperty("delegation.token.expiry.time.ms", Long.toString(Long.MAX_VALUE));
        this.serverConfig().setProperty("delegation.token.max.lifetime.ms", Long.toString(Long.MAX_VALUE));
        this.setUpSasl();
        super.setUp(testInfo);
        this.setInitialAcls();
    }

    public void setUpSasl() {
        this.startSasl(this.jaasSections((Seq<String>)new .colon.colon((Object)"GSSAPI", (List)Nil$.MODULE$), (Option<String>)new Some((Object)"GSSAPI"), "KafkaServer"));
        String loginContext = this.jaasAdminLoginModule("GSSAPI", this.jaasAdminLoginModule$default$2());
        this.superuserClientConfig().put("sasl.jaas.config", loginContext);
    }

    private void setInitialAcls() {
        this.superUserAdmin_$eq(this.createSuperuserAdminClient(this.createSuperuserAdminClient$default$1(), this.createSuperuserAdminClient$default$2()));
        AccessControlEntry ace2 = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.ALLOW);
        this.superUserAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), ace2), (List)Nil$.MODULE$)).asJava());
        this.superUserAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AclBinding(new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL), ace2), (List)Nil$.MODULE$)).asJava());
        .colon.colon clusterAcls = new .colon.colon((Object)this.clusterAcl(AclPermissionType.ALLOW, AclOperation.CREATE), (List)new .colon.colon((Object)this.clusterAcl(AclPermissionType.ALLOW, AclOperation.DELETE), (List)new .colon.colon((Object)this.clusterAcl(AclPermissionType.ALLOW, AclOperation.CLUSTER_ACTION), (List)new .colon.colon((Object)this.clusterAcl(AclPermissionType.ALLOW, AclOperation.ALTER_CONFIGS), (List)new .colon.colon((Object)this.clusterAcl(AclPermissionType.ALLOW, AclOperation.ALTER), (List)new .colon.colon((Object)this.clusterAcl(AclPermissionType.ALLOW, AclOperation.IDEMPOTENT_WRITE), (List)Nil$.MODULE$))))));
        this.superUserAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)clusterAcls.map((Function1 & Serializable)ace -> new AclBinding(this.clusterResourcePattern(), ace))).asJava());
        this.brokers().foreach(arg_0 -> SaslSslAdminIntegrationTest.$anonfun$setInitialAcls$2$adapted(this, ace2, (List)clusterAcls, arg_0));
    }

    private AccessControlEntry clusterAcl(AclPermissionType permissionType, AclOperation operation) {
        return new AccessControlEntry(new KafkaPrincipal("User", "*").toString(), "*", operation, permissionType);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    public AclBinding anyAcl() {
        return this.anyAcl;
    }

    public AclBinding acl2() {
        return this.acl2;
    }

    public AclBinding acl3() {
        return this.acl3;
    }

    public AclBinding fooAcl() {
        return this.fooAcl;
    }

    public AclBinding prefixAcl() {
        return this.prefixAcl;
    }

    public AclBinding transactionalIdAcl() {
        return this.transactionalIdAcl;
    }

    public AclBinding groupAcl() {
        return this.groupAcl;
    }

    @ParameterizedTest
    @Timeout(value=30L)
    @ValueSource(strings={"kraft"})
    public void testAclOperationsWithOptionTimeoutMs(String quorum) {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:" + TestUtils$.MODULE$.IncorrectBrokerPort());
        Admin brokenClient = Admin.create(config);
        try {
            AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> brokenClient.createAcls(Collections.singleton(acl), new CreateAclsOptions().timeoutMs(Predef$.MODULE$.int2Integer(0))).all().get());
            Assertions.assertInstanceOf(TimeoutException.class, (Object)exception.getCause());
        }
        finally {
            brokenClient.close(Duration.ZERO);
        }
    }

    @ParameterizedTest
    @Timeout(value=30L)
    @ValueSource(strings={"kraft"})
    public void testDeleteAclsWithOptionTimeoutMs(String quorum) {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", "localhost:" + TestUtils$.MODULE$.IncorrectBrokerPort());
        Admin brokenClient = Admin.create(config);
        try {
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> brokenClient.deleteAcls(Collections.singleton(AclBindingFilter.ANY), new DeleteAclsOptions().timeoutMs(Predef$.MODULE$.int2Integer(0))).all().get());
            Assertions.assertInstanceOf(TimeoutException.class, (Object)exception.getCause());
        }
        finally {
            brokenClient.close(Duration.ZERO);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testExpireDelegationTokenWithOptionExpireTimePeriodMs(String quorum) {
        this.client_$eq(this.createAdminClient());
        .colon.colon renewer = new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer"), (List)Nil$.MODULE$);
        try {
            void var11_11;
            void var10_10;
            void var8_8;
            void var7_7;
            void var5_5;
            void var4_4;
            Tuple2 tuple2 = this.generateTokenResult$1(10000, -1, 1, (List)renewer);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            CreateDelegationTokenResult createResult1 = (CreateDelegationTokenResult)tuple2._1();
            ExpireDelegationTokenResult expireResult1 = (ExpireDelegationTokenResult)tuple2._2();
            Assertions.assertTrue((((DelegationToken)var4_4.delegationToken().get()).tokenInfo().maxTimestamp() > Predef$.MODULE$.Long2long((Long)var5_5.expiryTimestamp().get()) ? 1 : 0) != 0);
            Tuple2 tuple22 = this.generateTokenResult$1(50000, 100000, 1, (List)renewer);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            CreateDelegationTokenResult createResult2 = (CreateDelegationTokenResult)tuple22._1();
            ExpireDelegationTokenResult expireResult2 = (ExpireDelegationTokenResult)tuple22._2();
            Predef$.MODULE$.assert(BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)((DelegationToken)var7_7.delegationToken().get()).tokenInfo().expiryTimestamp()), (Object)var8_8.expiryTimestamp().get()));
            Tuple2 tuple23 = this.generateTokenResult$1(5000, 2000, 2, (List)renewer);
            if (tuple23 == null) {
                throw new MatchError(null);
            }
            CreateDelegationTokenResult createResult3 = (CreateDelegationTokenResult)tuple23._1();
            ExpireDelegationTokenResult expireResult3 = (ExpireDelegationTokenResult)tuple23._2();
            Predef$.MODULE$.assert(((DelegationToken)var10_10.delegationToken().get()).tokenInfo().expiryTimestamp() > Predef$.MODULE$.Long2long((Long)var11_11.expiryTimestamp().get()));
        }
        finally {
            this.client().close(Duration.ZERO);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclOperations(String quorum) {
        this.client_$eq(this.createAdminClient());
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        Assertions.assertEquals((int)8, (int)this.getAcls(AclBindingFilter.ANY).size());
        CreateAclsResult results = this.client().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.acl2(), (List)new .colon.colon((Object)this.acl3(), (List)Nil$.MODULE$))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl3()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(results.values().keySet()).asScala());
        results.values().values().forEach(value -> value.get());
        AclBinding aclUnknown = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.UNKNOWN, AclPermissionType.ALLOW));
        CreateAclsResult results2 = this.client().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)aclUnknown, (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclUnknown})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(results2.values().keySet()).asScala());
        TestUtils.assertFutureThrows((Future)results2.all(), InvalidRequestException.class);
        java.util.Map results3 = this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl.toFilter(), (List)new .colon.colon((Object)this.acl2().toFilter(), (List)new .colon.colon((Object)this.acl3().toFilter(), (List)Nil$.MODULE$)))).asJava()).values();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{acl.toFilter(), this.acl2().toFilter(), this.acl3().toFilter()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(results3.keySet()).asScala());
        Assertions.assertEquals((int)0, (int)((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(acl.toFilter())).get()).values().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.acl2().toFilter())).get()).values()).asScala().map((Function1 & Serializable)x$5 -> x$5.binding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl3()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)results3.get(this.acl3().toFilter())).get()).values()).asScala().map((Function1 & Serializable)x$6 -> x$6.binding())).toSet());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclOperations2(String quorum) {
        this.client_$eq(this.createAdminClient());
        CreateAclsResult results = this.client().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.acl2(), (List)new .colon.colon((Object)this.acl2(), (List)new .colon.colon((Object)this.transactionalIdAcl(), (List)Nil$.MODULE$)))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.acl2(), this.transactionalIdAcl()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(results.values().keySet()).asScala());
        results.all().get();
        this.waitForDescribeAcls(this.client(), this.acl2().toFilter(), (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()}))));
        this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        AclBindingFilter filterA = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, null, PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter filterB = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic2", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter filterC = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TRANSACTIONAL_ID, null, PatternType.LITERAL), AccessControlEntryFilter.ANY);
        this.waitForDescribeAcls(this.client(), filterA, (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.groupAcl()}))));
        this.waitForDescribeAcls(this.client(), filterC, (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        DeleteAclsResult results2 = this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)filterA, (List)new .colon.colon((Object)filterB, (List)new .colon.colon((Object)filterC, (List)Nil$.MODULE$)))).asJava(), new DeleteAclsOptions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filterA, filterB, filterC})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(results2.values().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.groupAcl()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterA)).get()).values()).asScala().map((Function1 & Serializable)x$7 -> x$7.binding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterC)).get()).values()).asScala().map((Function1 & Serializable)x$8 -> x$8.binding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)results2.values().get(filterB)).get()).values()).asScala().map((Function1 & Serializable)x$9 -> x$9.binding())).toSet());
        this.waitForDescribeAcls(this.client(), filterB, (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.waitForDescribeAcls(this.client(), filterC, (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclDescribe(String quorum) {
        this.client_$eq(this.createAdminClient());
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl(), this.prefixAcl()}))));
        AclBindingFilter allTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.ANY), AccessControlEntryFilter.ANY);
        AclBindingFilter allLiteralTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter allPrefixedTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.PREFIXED), AccessControlEntryFilter.ANY);
        AclBindingFilter literalMyTopic2Acls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic2", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter prefixedMyTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
        AclBindingFilter allMyTopic2Acls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic2", PatternType.MATCH), AccessControlEntryFilter.ANY);
        AclBindingFilter allFooTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "foobar", PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl()})), this.getAcls(this.anyAcl().toFilter()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.prefixAcl()})), this.getAcls(this.prefixAcl().toFilter()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), this.getAcls(this.acl2().toFilter()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()})), this.getAcls(this.fooAcl().toFilter()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), this.getAcls(literalMyTopic2Acls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.prefixAcl()})), this.getAcls(prefixedMyTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl()})), this.getAcls(allLiteralTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.prefixAcl()})), this.getAcls(allPrefixedTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.prefixAcl()})), this.getAcls(allMyTopic2Acls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.fooAcl()})), this.getAcls(allFooTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl(), this.prefixAcl()})), this.getAcls(allTopicAcls));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclDelete(String quorum) {
        this.client_$eq(this.createAdminClient());
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl(), this.prefixAcl()}))));
        AclBindingFilter allTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.MATCH), AccessControlEntryFilter.ANY);
        AclBindingFilter allLiteralTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter allPrefixedTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.PREFIXED), AccessControlEntryFilter.ANY);
        scala.collection.immutable.Set deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.acl2().toFilter(), (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(this.acl2().entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.acl2().pattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.fooAcl(), this.prefixAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.anyAcl().toFilter(), (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(this.anyAcl().entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.anyAcl().pattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.fooAcl(), this.prefixAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.prefixAcl().toFilter(), (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(this.prefixAcl().entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.prefixAcl().pattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)allLiteralTopicAcls, (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            SaslSslAdminIntegrationTest.$anonfun$testAclDelete$4(this, b);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.prefixAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)allPrefixedTopicAcls, (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(this.prefixAcl().entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.prefixAcl().pattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)allTopicAcls, (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        deleted = null;
        this.brokers().foreach((Function1 & Serializable)b -> {
            SaslSslAdminIntegrationTest.$anonfun$testAclDelete$7(this, b);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.getAcls(allTopicAcls));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testLegacyAclOpsNeverAffectOrReturnPrefixed(String quorum) {
        this.client_$eq(this.createAdminClient());
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl(), this.prefixAcl()}))));
        AclBindingFilter allTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.MATCH), AccessControlEntryFilter.ANY);
        AclBindingFilter legacyAllTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, null, PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter legacyMyTopic2Acls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic2", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter legacyAnyTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "*", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        AclBindingFilter legacyFooTopicAcls = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "foobar", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.acl2(), this.fooAcl()})), this.getAcls(legacyAllTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2()})), this.getAcls(legacyMyTopic2Acls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl()})), this.getAcls(legacyAnyTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()})), this.getAcls(legacyFooTopicAcls));
        scala.collection.immutable.Set deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)legacyMyTopic2Acls, (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(this.acl2().entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.acl2().pattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.anyAcl(), this.fooAcl(), this.prefixAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        deleted = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)legacyAnyTopicAcls, (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(this.anyAcl().entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.anyAcl().pattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.acl2(), this.fooAcl(), this.prefixAcl()})), this.getAcls(allTopicAcls));
        this.ensureAcls((scala.collection.immutable.Set<AclBinding>)deleted);
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)legacyAllTopicAcls, (List)Nil$.MODULE$)).asJava()).all().get()).asScala().toSet();
        deleted = null;
        this.brokers().foreach((Function1 & Serializable)b -> {
            SaslSslAdminIntegrationTest.$anonfun$testLegacyAclOpsNeverAffectOrReturnPrefixed$3(this, b);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.getAcls(legacyAllTopicAcls));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.prefixAcl()})), this.getAcls(allTopicAcls));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAttemptToCreateInvalidAcls(String quorum) {
        this.client_$eq(this.createAdminClient());
        AclBinding clusterAcl = new AclBinding(new ResourcePattern(ResourceType.CLUSTER, "foobar", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding emptyResourceNameAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        CreateAclsResult results = this.client().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)clusterAcl, (List)new .colon.colon((Object)emptyResourceNameAcl, (List)Nil$.MODULE$))).asJava(), new CreateAclsOptions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{clusterAcl, emptyResourceNameAcl})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(results.values().keySet()).asScala());
        TestUtils.assertFutureThrows((Future)((Future)results.values().get(clusterAcl)), InvalidRequestException.class);
        TestUtils.assertFutureThrows((Future)((Future)results.values().get(emptyResourceNameAcl)), InvalidRequestException.class);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateDelegationTokenWithSmallerTimeout(String quorum) {
        this.client_$eq(this.createAdminClient());
        int timeout = 5000;
        CreateDelegationTokenOptions options = new CreateDelegationTokenOptions().maxLifetimeMs((long)timeout);
        TokenInformation tokenInfo = ((DelegationToken)this.client().createDelegationToken(options).delegationToken().get()).tokenInfo();
        Assertions.assertEquals((long)timeout, (long)(tokenInfo.maxTimestamp() - tokenInfo.issueTimestamp()));
        Assertions.assertTrue((tokenInfo.maxTimestamp() >= tokenInfo.expiryTimestamp() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testExpiredTimeStampLargerThanMaxLifeStamp(String quorum) {
        this.client_$eq(this.createAdminClient());
        int timeout = 5000;
        CreateDelegationTokenOptions createOptions = new CreateDelegationTokenOptions().maxLifetimeMs((long)timeout);
        DelegationToken token = (DelegationToken)this.client().createDelegationToken(createOptions).delegationToken().get();
        TokenInformation tokenInfo = token.tokenInfo();
        Assertions.assertEquals((long)timeout, (long)(tokenInfo.maxTimestamp() - tokenInfo.issueTimestamp()));
        Assertions.assertTrue((tokenInfo.maxTimestamp() >= tokenInfo.expiryTimestamp() ? 1 : 0) != 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$testExpiredTimeStampLargerThanMaxLifeStamp$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for token to propagate to all servers");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ExpireDelegationTokenOptions expiredOptions = new ExpireDelegationTokenOptions().expiryTimePeriodMs(tokenInfo.maxTimestamp() + 1L);
        ExpireDelegationTokenResult expiredResult = this.client().expireDelegationToken(token.hmac(), expiredOptions);
        Assertions.assertEquals((long)tokenInfo.maxTimestamp(), (Long)((Long)expiredResult.expiryTimestamp().get()));
    }

    private void verifyCauseIsClusterAuth(Throwable e) {
        Assertions.assertEquals(ClusterAuthorizationException.class, e.getCause().getClass());
    }

    /*
     * WARNING - void declaration
     */
    private void testAclCreateGetDelete(boolean expectAuth) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$testAclCreateGetDelete$1(this, expectAuth)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SaslSslAdminIntegrationTest.$anonfun$testAclCreateGetDelete$4(expectAuth));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (expectAuth) {
            this.waitForDescribeAcls(this.client(), this.fooAcl().toFilter(), (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.fooAcl()}))));
            this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{this.transactionalIdAcl()}))));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$testAclCreateGetDelete$5(this, expectAuth)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)SaslSslAdminIntegrationTest.$anonfun$testAclCreateGetDelete$10(expectAuth));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        if (expectAuth) {
            this.waitForDescribeAcls(this.client(), this.fooAcl().toFilter(), (scala.collection.immutable.Set<AclBinding>)Predef$.MODULE$.Set().empty());
            this.waitForDescribeAcls(this.client(), this.transactionalIdAcl().toFilter(), (scala.collection.immutable.Set<AclBinding>)Predef$.MODULE$.Set().empty());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testAclGet(boolean expectAuth) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$testAclGet$1(this, expectAuth)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SaslSslAdminIntegrationTest.$anonfun$testAclGet$4(expectAuth));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclAuthorizationDenied(String quorum) {
        this.client_$eq(this.createAdminClient());
        this.addClusterAcl(AclPermissionType.DENY, AclOperation.ALTER);
        this.testAclGet(true);
        this.testAclCreateGetDelete(false);
        this.addClusterAcl(AclPermissionType.DENY, AclOperation.DESCRIBE);
        this.testAclGet(false);
        this.testAclCreateGetDelete(false);
        this.removeClusterAcl(AclPermissionType.DENY, AclOperation.DESCRIBE);
        this.removeClusterAcl(AclPermissionType.DENY, AclOperation.ALTER);
        this.testAclGet(true);
        this.testAclCreateGetDelete(true);
        this.removeClusterAcl(AclPermissionType.ALLOW, AclOperation.ALTER);
        this.removeClusterAcl(AclPermissionType.ALLOW, AclOperation.DELETE);
        this.testAclGet(false);
        this.testAclCreateGetDelete(false);
        this.addClusterAcl(AclPermissionType.ALLOW, AclOperation.DESCRIBE);
        this.testAclGet(true);
        this.testAclCreateGetDelete(false);
    }

    private void addClusterAcl(AclPermissionType permissionType, AclOperation operation) {
        AccessControlEntry ace = this.clusterAcl(permissionType, operation);
        this.superUserAdmin().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AclBinding(this.clusterResourcePattern(), ace), (List)Nil$.MODULE$)).asJava());
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyAcl(ace, (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.clusterResourcePattern(), this.waitAndVerifyAcl$default$4());
            return BoxedUnit.UNIT;
        });
    }

    private void removeClusterAcl(AclPermissionType permissionType, AclOperation operation) {
        AccessControlEntry ace = this.clusterAcl(permissionType, operation);
        this.superUserAdmin().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AclBinding(this.clusterResourcePattern(), ace).toFilter(), (List)Nil$.MODULE$)).asJava()).values();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.waitAndVerifyRemovedAcl(ace, (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), this.clusterResourcePattern(), this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicsResponseMetadataAndConfig(String quorum) {
        String topic1 = "mytopic1";
        String topic2 = "mytopic2";
        AclBinding denyAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic2, PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.DESCRIBE_CONFIGS, AclPermissionType.DENY));
        this.client_$eq(this.createAdminClient());
        this.client().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)denyAcl, (List)Nil$.MODULE$)).asJava(), new CreateAclsOptions()).all().get();
        .colon.colon topics = new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$));
        java.util.Map configsOverride = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"100000")}))).asJava();
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic1, 2, (short)3).configs(configsOverride), (List)new .colon.colon((Object)new NewTopic(topic2, OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.empty())), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.empty()))).configs(configsOverride), (List)Nil$.MODULE$));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        SaslSslAdminIntegrationTest.validateMetadataAndConfigs$1(validateResult, topic1, topic2);
        CreateTopicsResult createResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newTopics).asJava(), new CreateTopicsOptions());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        SaslSslAdminIntegrationTest.validateMetadataAndConfigs$1(createResult, topic1, topic2);
        scala.collection.immutable.Map<String, Uuid> topicIds = this.getTopicIds();
        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)createResult.topicId(topic1).get());
        Assertions.assertEquals((Object)topicIds.apply((Object)topic1), (Object)createResult.topicId(topic1).get());
        TestUtils.assertFutureThrows((Future)createResult.topicId(topic2), TopicAuthorizationException.class);
        Iterable createResponseConfig = CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)createResult.config(topic1).get()).entries()).asScala();
        Iterable<ConfigEntry> describeResponseConfig = this.describeConfigs(topic1);
        Assertions.assertEquals((Object)((IterableOnceOps)describeResponseConfig.map((Function1 & Serializable)x$14 -> x$14.name())).toSet(), (Object)((IterableOnceOps)createResponseConfig.map((Function1 & Serializable)x$15 -> x$15.name())).toSet());
        describeResponseConfig.foreach((Function1 & Serializable)describeEntry -> {
            SaslSslAdminIntegrationTest.$anonfun$testCreateTopicsResponseMetadataAndConfig$5(createResponseConfig, describeEntry);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testExpireDelegationToken(String quorum) {
        this.client_$eq(this.createAdminClient());
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions().maxLifetimeMs(5000L);
        TestUtils.assertFutureThrows((Future)this.client().expireDelegationToken("".getBytes()).expiryTimestamp(), DelegationTokenNotFoundException.class);
        DelegationToken token1 = (DelegationToken)this.client().createDelegationToken(createDelegationTokenOptions).delegationToken().get();
        long l = 1000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                SaslSslAdminIntegrationTest.$anonfun$testExpireDelegationToken$1(this, token1);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var20_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var6_5 = null;
        Object var9_6 = null;
        Object var12_10 = null;
        DelegationToken token2 = (DelegationToken)this.client().createDelegationToken(createDelegationTokenOptions.maxLifetimeMs(1000L)).delegationToken().get();
        Thread.sleep(1000L);
        TestUtils.assertFutureThrows((Future)this.client().expireDelegationToken(token2.hmac(), new ExpireDelegationTokenOptions().expiryTimePeriodMs(1L)).expiryTimestamp(), DelegationTokenExpiredException.class);
        Assertions.assertDoesNotThrow(() -> BoxesRunTime.boxToLong((long)this.expireTokenOrFailWithAssert(token2, -1L)));
        DelegationToken token3 = (DelegationToken)this.client().createDelegationToken(createDelegationTokenOptions).delegationToken().get();
        long l2 = 1000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                SaslSslAdminIntegrationTest.$anonfun$testExpireDelegationToken$3(this, token3);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var21_18 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTokenWithOverflowTimestamp(String quorum) {
        this.client_$eq(this.createAdminClient());
        DelegationToken token = (DelegationToken)this.client().createDelegationToken(new CreateDelegationTokenOptions().maxLifetimeMs(Long.MAX_VALUE)).delegationToken().get();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)token.tokenInfo().expiryTimestamp());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testExpireTokenWithOverflowTimestamp(String quorum) {
        this.client_$eq(this.createAdminClient());
        DelegationToken token = (DelegationToken)this.client().createDelegationToken(new CreateDelegationTokenOptions().maxLifetimeMs(Long.MAX_VALUE)).delegationToken().get();
        long l = 1000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                SaslSslAdminIntegrationTest.$anonfun$testExpireTokenWithOverflowTimestamp$1(this, token);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long expireTokenOrFailWithAssert(DelegationToken token, long expiryTimePeriodMs) {
        try {
            return Predef$.MODULE$.Long2long((Long)this.client().expireDelegationToken(token.hmac(), new ExpireDelegationTokenOptions().expiryTimePeriodMs(expiryTimePeriodMs)).expiryTimestamp().get());
        }
        catch (ExecutionException executionException) {
            throw new AssertionError((Object)"Metadata not sync yet.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private Iterable<ConfigEntry> describeConfigs(String topic) {
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
        Iterable iterable = null;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            try {
                Config $anonfun$describeConfigs$1_topicResponse = (Config)((java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource, (List)Nil$.MODULE$)).asJava()).all().get()).get(topicResource);
                iterable = CollectionConverters$.MODULE$.CollectionHasAsScala($anonfun$describeConfigs$1_topicResponse.entries()).asScala();
                bl = true;
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                    bl = false;
                }
                throw throwable;
            }
            Object var9_7 = null;
            Object var10_8 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for describeConfigs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForDescribeAcls(Admin client, AclBindingFilter filter, scala.collection.immutable.Set<AclBinding> acls) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            Collection collection = (Collection)client.describeAcls(filter).values().get();
            scala.collection.immutable.Set<AclBinding> set = acls;
            scala.collection.immutable.Set set2 = CollectionConverters$.MODULE$.CollectionHasAsScala(collection).asScala().toSet();
            boolean bl = !(set != null ? !set.equals((Object)set2) : set2 != null);
            set2 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("timed out waiting for ACLs " + acls + ".\nActual " + collection));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void ensureAcls(scala.collection.immutable.Set<AclBinding> bindings) {
        this.client().createAcls((Collection)CollectionConverters$.MODULE$.SetHasAsJava(bindings).asJava()).all().get();
        bindings.foreach((Function1 & Serializable)binding -> {
            this.waitForDescribeAcls(this.client(), binding.toFilter(), (scala.collection.immutable.Set<AclBinding>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{binding}))));
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<AclBinding> getAcls(AclBindingFilter allTopicAcls) {
        return CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)this.client().describeAcls(allTopicAcls).values().get()).asScala().toSet();
    }

    /*
     * WARNING - void declaration
     */
    public void waitAndVerifyRemovedAcl(AccessControlEntry expectedToRemoved, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 45000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$waitAndVerifyRemovedAcl$1(authorizer, filter, expectedToRemoved)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SaslSslAdminIntegrationTest.$anonfun$waitAndVerifyRemovedAcl$3(expectedToRemoved, authorizer, filter, newLine));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public AccessControlEntryFilter waitAndVerifyRemovedAcl$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    /*
     * WARNING - void declaration
     */
    public void waitAndVerifyAcl(AccessControlEntry expected, Authorizer authorizer, ResourcePattern resource, AccessControlEntryFilter accessControlEntryFilter) {
        String newLine = Properties$.MODULE$.lineSeparator();
        AclBindingFilter filter = new AclBindingFilter(resource.toFilter(), accessControlEntryFilter);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 45000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$waitAndVerifyAcl$1(authorizer, filter, expected)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)SaslSslAdminIntegrationTest.$anonfun$waitAndVerifyAcl$3(expected, authorizer, filter, newLine));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public AccessControlEntryFilter waitAndVerifyAcl$default$4() {
        return AccessControlEntryFilter.ANY;
    }

    public static final /* synthetic */ void $anonfun$setInitialAcls$2(SaslSslAdminIntegrationTest $this, AccessControlEntry ace$1, List clusterAcls$1, KafkaBroker b) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace$1}))), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{ace$1}))), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)clusterAcls$1.toSet(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), $this.clusterResourcePattern(), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ boolean $anonfun$testExpireDelegationTokenWithOptionExpireTimePeriodMs$2(int expectedTokenNum$1, KafkaBroker server) {
        return server.tokenCache().tokens().size() == expectedTokenNum$1;
    }

    public static final /* synthetic */ boolean $anonfun$testExpireDelegationTokenWithOptionExpireTimePeriodMs$1(SaslSslAdminIntegrationTest $this, int expectedTokenNum$1) {
        return $this.brokers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)SaslSslAdminIntegrationTest.$anonfun$testExpireDelegationTokenWithOptionExpireTimePeriodMs$2(expectedTokenNum$1, server)));
    }

    public static final /* synthetic */ String $anonfun$testExpireDelegationTokenWithOptionExpireTimePeriodMs$3() {
        return "Timed out waiting for token to propagate to all servers";
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 generateTokenResult$1(int maxLifeTimeMs, int expiryTimePeriodMs, int expectedTokenNum, List renewer$1) {
        CreateDelegationTokenResult createResult = this.client().createDelegationToken(new CreateDelegationTokenOptions().renewers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)renewer$1).asJava()).maxLifetimeMs((long)maxLifeTimeMs));
        DelegationToken tokenCreated = (DelegationToken)createResult.delegationToken().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!SaslSslAdminIntegrationTest.$anonfun$testExpireDelegationTokenWithOptionExpireTimePeriodMs$1(this, expectedTokenNum)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for token to propagate to all servers");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ExpireDelegationTokenResult expireResult = this.client().expireDelegationToken(tokenCreated.hmac(), new ExpireDelegationTokenOptions().expiryTimePeriodMs((long)expiryTimePeriodMs));
        return new Tuple2((Object)createResult, (Object)expireResult);
    }

    public static final /* synthetic */ void $anonfun$testAclDelete$4(SaslSslAdminIntegrationTest $this, KafkaBroker b) {
        ((IterableOnceOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{$this.anyAcl(), $this.acl2(), $this.fooAcl()}))).foreach((Function1 & Serializable)acl -> {
            $this.waitAndVerifyRemovedAcl(acl.entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), acl.pattern(), $this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testAclDelete$7(SaslSslAdminIntegrationTest $this, KafkaBroker b) {
        ((IterableOnceOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{$this.anyAcl(), $this.acl2(), $this.fooAcl(), $this.prefixAcl()}))).foreach((Function1 & Serializable)acl -> {
            $this.waitAndVerifyRemovedAcl(acl.entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), acl.pattern(), $this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testLegacyAclOpsNeverAffectOrReturnPrefixed$3(SaslSslAdminIntegrationTest $this, KafkaBroker b) {
        ((IterableOnceOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{$this.anyAcl(), $this.acl2(), $this.fooAcl()}))).foreach((Function1 & Serializable)acl -> {
            $this.waitAndVerifyRemovedAcl(acl.entry(), (Authorizer)b.dataPlaneRequestProcessor().authorizer().get(), acl.pattern(), $this.waitAndVerifyRemovedAcl$default$4());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testExpiredTimeStampLargerThanMaxLifeStamp$2(KafkaBroker server) {
        return server.tokenCache().tokens().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testExpiredTimeStampLargerThanMaxLifeStamp$1(SaslSslAdminIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)SaslSslAdminIntegrationTest.$anonfun$testExpiredTimeStampLargerThanMaxLifeStamp$2(server)));
    }

    public static final /* synthetic */ String $anonfun$testExpiredTimeStampLargerThanMaxLifeStamp$3() {
        return "Timed out waiting for token to propagate to all servers";
    }

    public static final /* synthetic */ boolean $anonfun$testAclCreateGetDelete$1(SaslSslAdminIntegrationTest $this, boolean expectAuth$1) {
        CreateAclsResult result = $this.client().createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)$this.fooAcl(), (List)new .colon.colon((Object)$this.transactionalIdAcl(), (List)Nil$.MODULE$))).asJava(), new CreateAclsOptions());
        if (expectAuth$1) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Void)result.all().get());
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                $this.verifyCauseIsClusterAuth(e);
                return false;
            }
            if (try_ instanceof Success) {
                return true;
            }
            throw new MatchError((Object)try_);
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Void)result.all().get());
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            $this.verifyCauseIsClusterAuth(e);
            return true;
        }
        if (try_ instanceof Success) {
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ String $anonfun$testAclCreateGetDelete$4(boolean expectAuth$1) {
        return "timed out waiting for createAcls to " + (expectAuth$1 ? "succeed" : "fail");
    }

    public static final /* synthetic */ boolean $anonfun$testAclCreateGetDelete$5(SaslSslAdminIntegrationTest $this, boolean expectAuth$1) {
        DeleteAclsResult result = $this.client().deleteAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)$this.fooAcl().toFilter(), (List)new .colon.colon((Object)$this.transactionalIdAcl().toFilter(), (List)Nil$.MODULE$))).asJava(), new DeleteAclsOptions());
        if (expectAuth$1) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Collection)result.all().get());
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                $this.verifyCauseIsClusterAuth(e);
                return false;
            }
            if (try_ instanceof Success) {
                return true;
            }
            throw new MatchError((Object)try_);
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Collection)result.all().get());
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            $this.verifyCauseIsClusterAuth(e);
            return true;
        }
        if (try_ instanceof Success) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{$this.fooAcl(), $this.transactionalIdAcl()})), result.values().keySet());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{$this.fooAcl()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get($this.fooAcl().toFilter())).get()).values()).asScala().map((Function1 & Serializable)x$10 -> x$10.binding())).toSet());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{$this.transactionalIdAcl()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DeleteAclsResult.FilterResults)((KafkaFuture)result.values().get($this.transactionalIdAcl().toFilter())).get()).values()).asScala().map((Function1 & Serializable)x$11 -> x$11.binding())).toSet());
            return true;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ String $anonfun$testAclCreateGetDelete$10(boolean expectAuth$1) {
        return "timed out waiting for deleteAcls to " + (expectAuth$1 ? "succeed" : "fail");
    }

    public static final /* synthetic */ boolean $anonfun$testAclGet$1(SaslSslAdminIntegrationTest $this, boolean expectAuth$2) {
        AclBinding userAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW));
        DescribeAclsResult results = $this.client().describeAcls(userAcl.toFilter());
        if (expectAuth$2) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Collection)results.values().get());
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                $this.verifyCauseIsClusterAuth(e);
                return false;
            }
            if (try_ instanceof Success) {
                Collection acls = (Collection)((Success)try_).value();
                return ((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{userAcl}))).equals((Object)CollectionConverters$.MODULE$.CollectionHasAsScala(acls).asScala().toSet());
            }
            throw new MatchError((Object)try_);
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Collection)results.values().get());
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            $this.verifyCauseIsClusterAuth(e);
            return true;
        }
        if (try_ instanceof Success) {
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ String $anonfun$testAclGet$4(boolean expectAuth$2) {
        return "timed out waiting for describeAcls to " + (expectAuth$2 ? "succeed" : "fail");
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsResponseMetadataAndConfig$1(ConfigEntry x$12) {
        String string = x$12.name();
        String string2 = "segment.bytes";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsResponseMetadataAndConfig$2(ConfigEntry x$13) {
        String string = x$13.name();
        String string2 = "compression.type";
        return string != null && string.equals(string2);
    }

    private static final void validateMetadataAndConfigs$1(CreateTopicsResult result, String topic1$1, String topic2$1) {
        Assertions.assertEquals((int)2, (Integer)((Integer)result.numPartitions(topic1$1).get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.replicationFactor(topic1$1).get()));
        Iterable topicConfigs = CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)result.config(topic1$1).get()).entries()).asScala();
        Assertions.assertTrue((boolean)topicConfigs.nonEmpty());
        ConfigEntry segmentBytesConfig = (ConfigEntry)topicConfigs.find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SaslSslAdminIntegrationTest.$anonfun$testCreateTopicsResponseMetadataAndConfig$1(x$12))).get();
        Assertions.assertEquals((long)100000L, (long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(segmentBytesConfig.value())));
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (Object)segmentBytesConfig.source());
        ConfigEntry compressionConfig = (ConfigEntry)topicConfigs.find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SaslSslAdminIntegrationTest.$anonfun$testCreateTopicsResponseMetadataAndConfig$2(x$13))).get();
        Assertions.assertEquals((Object)LogConfig.DEFAULT_COMPRESSION_TYPE, (Object)compressionConfig.value());
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DEFAULT_CONFIG, (Object)compressionConfig.source());
        TestUtils.assertFutureThrows((Future)result.numPartitions(topic2$1), TopicAuthorizationException.class);
        TestUtils.assertFutureThrows((Future)result.replicationFactor(topic2$1), TopicAuthorizationException.class);
        TestUtils.assertFutureThrows((Future)result.config(topic2$1), TopicAuthorizationException.class);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsResponseMetadataAndConfig$6(String name$1, ConfigEntry x$16) {
        String string = x$16.name();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testCreateTopicsResponseMetadataAndConfig$5(Iterable createResponseConfig$1, ConfigEntry describeEntry) {
        String name = describeEntry.name();
        ConfigEntry createEntry = (ConfigEntry)createResponseConfig$1.find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)SaslSslAdminIntegrationTest.$anonfun$testCreateTopicsResponseMetadataAndConfig$6(name, x$16))).get();
        Assertions.assertEquals((Object)describeEntry.value(), (Object)createEntry.value(), (String)("Value mismatch for " + name));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)describeEntry.isReadOnly()), (Object)BoxesRunTime.boxToBoolean((boolean)createEntry.isReadOnly()), (String)("isReadOnly mismatch for " + name));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)describeEntry.isSensitive()), (Object)BoxesRunTime.boxToBoolean((boolean)createEntry.isSensitive()), (String)("isSensitive mismatch for " + name));
        Assertions.assertEquals((Object)describeEntry.source(), (Object)createEntry.source(), (String)("Source mismatch for " + name));
    }

    public static final /* synthetic */ void $anonfun$testExpireDelegationToken$1(SaslSslAdminIntegrationTest $this, DelegationToken token1$1) {
        Assertions.assertTrue(($this.expireTokenOrFailWithAssert(token1$1, -1L) < System.currentTimeMillis() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testExpireDelegationToken$3(SaslSslAdminIntegrationTest $this, DelegationToken token3$1) {
        Assertions.assertTrue(($this.expireTokenOrFailWithAssert(token3$1, 200L) < token3$1.tokenInfo().expiryTimestamp() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testExpireTokenWithOverflowTimestamp$1(SaslSslAdminIntegrationTest $this, DelegationToken token$1) {
        Assertions.assertTrue(($this.expireTokenOrFailWithAssert(token$1, Long.MAX_VALUE) == Long.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$1(SaslSslAdminIntegrationTest $this, ConfigResource topicResource$1, ObjectRef configEntries$1) {
        try {
            Config topicResponse = (Config)((java.util.Map)$this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource$1, (List)Nil$.MODULE$)).asJava()).all().get()).get(topicResource$1);
            configEntries$1.elem = CollectionConverters$.MODULE$.CollectionHasAsScala(topicResponse.entries()).asScala();
            return true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$describeConfigs$2() {
        return "Timed out waiting for describeConfigs";
    }

    public static final /* synthetic */ boolean $anonfun$waitForDescribeAcls$1(ObjectRef lastResults$1, Admin client$1, AclBindingFilter filter$1, scala.collection.immutable.Set acls$1) {
        lastResults$1.elem = (Collection)client$1.describeAcls(filter$1).values().get();
        scala.collection.immutable.Set set = acls$1;
        scala.collection.immutable.Set set2 = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)lastResults$1.elem).asScala().toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$waitForDescribeAcls$2(scala.collection.immutable.Set acls$1, ObjectRef lastResults$1) {
        return "timed out waiting for ACLs " + acls$1 + ".\nActual " + (Collection)lastResults$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyRemovedAcl$1(Authorizer authorizer$1, AclBindingFilter filter$2, AccessControlEntry expectedToRemoved$1) {
        return !((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(filter$2)).asScala().map((Function1 & Serializable)x$17 -> x$17.entry())).toSet().contains((Object)expectedToRemoved$1);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyRemovedAcl$3(AccessControlEntry expectedToRemoved$1, Authorizer authorizer$1, AclBindingFilter filter$2, String newLine$1) {
        return "expected acl to be removed : " + expectedToRemoved$1 + "but got:" + ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$1.acls(filter$2)).asScala().map((Function1 & Serializable)x$18 -> x$18.entry())).mkString(newLine$1 + "\t", newLine$1 + "\t", newLine$1);
    }

    public static final /* synthetic */ boolean $anonfun$waitAndVerifyAcl$1(Authorizer authorizer$2, AclBindingFilter filter$3, AccessControlEntry expected$1) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$2.acls(filter$3)).asScala().map((Function1 & Serializable)x$19 -> x$19.entry())).toSet().contains((Object)expected$1);
    }

    public static final /* synthetic */ String $anonfun$waitAndVerifyAcl$3(AccessControlEntry expected$1, Authorizer authorizer$2, AclBindingFilter filter$3, String newLine$2) {
        return "expected to contain acl: " + expected$1 + "but got:" + ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer$2.acls(filter$3)).asScala().map((Function1 & Serializable)x$20 -> x$20.entry())).mkString(newLine$2 + "\t", newLine$2 + "\t", newLine$2);
    }

    public SaslSslAdminIntegrationTest() {
        SaslSetup.$init$(this);
        this.clusterResourcePattern = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.kraftAuthorizerClassName = StandardAuthorizer.class.getName();
        this.kafkaPrincipal = new KafkaPrincipal("User", "kafka");
        this.secretKey = "secretKey";
        this.anyAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW));
        this.acl2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic2", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        this.acl3 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.fooAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foobar", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.prefixAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.PREFIXED), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.transactionalIdAcl = new AclBinding(new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "transactional_id", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        this.groupAcl = new AclBinding(new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALL, AclPermissionType.ALLOW));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$setInitialAcls$2$adapted(SaslSslAdminIntegrationTest $this, AccessControlEntry ace$1, List clusterAcls$1, KafkaBroker b) {
        SaslSslAdminIntegrationTest.$anonfun$setInitialAcls$2($this, ace$1, clusterAcls$1, b);
        return BoxedUnit.UNIT;
    }
}

