/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AlterPartitionManager;
import kafka.server.MetadataCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpoints;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]v!B#G\u0011\u0003Ye!B'G\u0011\u0003q\u0005\"B+\u0002\t\u00031\u0006bB,\u0002\u0005\u0004%\t\u0001\u0017\u0005\u00079\u0006\u0001\u000b\u0011B-\u0007\t53\u0005!\u0018\u0005\u0006+\u0016!\tA\u0018\u0005\b/\u0016\u0011\r\u0011\"\u0001Y\u0011\u0019aV\u0001)A\u00053\"9\u0001-\u0002b\u0001\n\u0003A\u0006BB1\u0006A\u0003%\u0011\fC\u0004c\u000b\t\u0007I\u0011A2\t\rI,\u0001\u0015!\u0003e\u0011\u001d\u0019XA1A\u0005\u0002QDa\u0001_\u0003!\u0002\u0013)\bbB=\u0006\u0005\u0004%\tA\u001f\u0005\b\u0003\u000f)\u0001\u0015!\u0003|\u0011-\tI!\u0002a\u0001\u0002\u0004%\t!a\u0003\t\u0017\u0005uQ\u00011AA\u0002\u0013\u0005\u0011q\u0004\u0005\f\u0003W)\u0001\u0019!A!B\u0013\ti\u0001C\u0006\u0002.\u0015\u0001\r\u00111A\u0005\u0002\u0005-\u0001bCA\u0018\u000b\u0001\u0007\t\u0019!C\u0001\u0003cA1\"!\u000e\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\u000e!Y\u0011qG\u0003A\u0002\u0003\u0007I\u0011AA\u0006\u0011-\tI$\u0002a\u0001\u0002\u0004%\t!a\u000f\t\u0017\u0005}R\u00011A\u0001B\u0003&\u0011Q\u0002\u0005\f\u0003\u0003*\u0001\u0019!a\u0001\n\u0003\t\u0019\u0005C\u0006\u0002R\u0015\u0001\r\u00111A\u0005\u0002\u0005M\u0003bCA,\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u000bB1\"!\u0017\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\\!Y\u0011QP\u0003A\u0002\u0003\u0007I\u0011AA@\u0011-\t\u0019)\u0002a\u0001\u0002\u0003\u0006K!!\u0018\t\u0017\u0005\u0015U\u00011AA\u0002\u0013\u0005\u0011q\u0011\u0005\f\u0003\u0007,\u0001\u0019!a\u0001\n\u0003\t)\rC\u0006\u0002J\u0016\u0001\r\u0011!Q!\n\u0005%\u0005bCAf\u000b\u0001\u0007\t\u0019!C\u0001\u0003\u001bD1\"!9\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002d\"Y\u0011q]\u0003A\u0002\u0003\u0005\u000b\u0015BAh\u0011-\tI/\u0002a\u0001\u0002\u0004%\t!a;\t\u0017\u0005mX\u00011AA\u0002\u0013\u0005\u0011Q \u0005\f\u0005\u0003)\u0001\u0019!A!B\u0013\ti\u000fC\u0005\u0003\u0004\u0015\u0011\r\u0011\"\u0001\u0003\u0006!A!QB\u0003!\u0002\u0013\u00119\u0001C\u0005\u0003\u0010\u0015\u0011\r\u0011\"\u0001\u0003\u0012!A!1D\u0003!\u0002\u0013\u0011\u0019\u0002C\u0005\u0003\u001e\u0015\u0011\r\u0011\"\u0001\u0003 !A!QF\u0003!\u0002\u0013\u0011\t\u0003C\u0006\u00030\u0015\u0001\r\u00111A\u0005\u0002\tE\u0002b\u0003B\u001d\u000b\u0001\u0007\t\u0019!C\u0001\u0005wA1Ba\u0010\u0006\u0001\u0004\u0005\t\u0015)\u0003\u00034!9!\u0011I\u0003\u0005\u0002\u0005m\u0006b\u0002B-\u000b\u0011E!1\f\u0005\b\u0005O*A\u0011\u0001B5\u0011\u001d\u0011i)\u0002C\u0001\u0003wCqAa&\u0006\t#\u0011I\nC\u0004\u0003*\u0016!\tAa+\t\u000f\tUV\u0001\"\u0003\u0002\u0018\u001a1\u0011QR\u0003\u0001\u0003\u001fCa!V\u001d\u0005\u0002\u0005]\u0005\"CAMs\t\u0007I\u0011AAN\u0011!\ty+\u000fQ\u0001\n\u0005u\u0005\"CAYs\t\u0007I\u0011AAN\u0011!\t\u0019,\u000fQ\u0001\n\u0005u\u0005\"CA[s\t\u0007I\u0011AAN\u0011!\t9,\u000fQ\u0001\n\u0005u\u0005bBA]s\u0011\u0005\u00131\u0018\u0005\b\u0003{KD\u0011IA^\u0011\u001d\ty,\u000fC!\u0003wCq!!1:\t\u0003\tY,A\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005\u001dC\u0015aB2mkN$XM\u001d\u0006\u0002\u0013\u0006)1.\u00194lC\u000e\u0001\u0001C\u0001'\u0002\u001b\u00051%!F!cgR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]R+7\u000f^\n\u0003\u0003=\u0003\"\u0001U*\u000e\u0003ES\u0011AU\u0001\u0006g\u000e\fG.Y\u0005\u0003)F\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001L\u0003!\u0011'o\\6fe&#W#A-\u0011\u0005AS\u0016BA.R\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\u001a\"!B(\u0015\u0003}\u0003\"\u0001T\u0003\u0002\u001fI,Wn\u001c;f%\u0016\u0004H.[2b\u0013\u0012\f\u0001C]3n_R,'+\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u000fQ|\u0007/[2JIV\tA\rE\u0002QK\u001eL!AZ)\u0003\r=\u0003H/[8o!\tA\u0007/D\u0001j\u0015\tQ7.\u0001\u0004d_6lwN\u001c\u0006\u0003\u00132T!!\u001c8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0017aA8sO&\u0011\u0011/\u001b\u0002\u0005+VLG-\u0001\u0005u_BL7-\u00133!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012!\u001e\t\u0003QZL!a^5\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0003uS6,W#A>\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003vi&d'bAA\u0001W\u000611/\u001a:wKJL1!!\u0002~\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002;na\u0012K'/\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011AA5p\u0015\t\t9\"\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003#\u0011AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\t\u0005\u0005\u0012q\u0005\t\u0004!\u0006\r\u0012bAA\u0013#\n!QK\\5u\u0011%\tICEA\u0001\u0002\u0004\ti!A\u0002yIE\nq\u0001^7q\t&\u0014\b%A\u0004m_\u001e$\u0015N]\u0019\u0002\u00171|w\rR5sc}#S-\u001d\u000b\u0005\u0003C\t\u0019\u0004C\u0005\u0002*U\t\t\u00111\u0001\u0002\u000e\u0005AAn\\4ESJ\f\u0004%A\u0004m_\u001e$\u0015N\u001d\u001a\u0002\u00171|w\rR5se}#S-\u001d\u000b\u0005\u0003C\ti\u0004C\u0005\u0002*a\t\t\u00111\u0001\u0002\u000e\u0005AAn\\4ESJ\u0014\u0004%\u0001\u0006m_\u001el\u0015M\\1hKJ,\"!!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013I\u0003\rawnZ\u0005\u0005\u0003\u001f\nIE\u0001\u0006M_\u001el\u0015M\\1hKJ\fa\u0002\\8h\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005U\u0003\"CA\u00157\u0005\u0005\t\u0019AA#\u0003-awnZ'b]\u0006<WM\u001d\u0011\u0002+\u0005dG/\u001a:QCJ$\u0018\u000e^5p]6\u000bg.Y4feV\u0011\u0011Q\f\t\u0005\u0003?\n9H\u0004\u0003\u0002b\u0005Ed\u0002BA2\u0003[rA!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003SR\u0015A\u0002\u001fs_>$h(C\u0001J\u0013\r\ty\u0007S\u0001\u0006kRLGn]\u0005\u0005\u0003g\n)(A\u0005UKN$X\u000b^5mg*\u0019\u0011q\u000e%\n\t\u0005e\u00141\u0010\u0002\u001a\u001b>\u001c7.\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'O\u0003\u0003\u0002t\u0005U\u0014!G1mi\u0016\u0014\b+\u0019:uSRLwN\\'b]\u0006<WM]0%KF$B!!\t\u0002\u0002\"I\u0011\u0011\u0006\u0010\u0002\u0002\u0003\u0007\u0011QL\u0001\u0017C2$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3sA\u00051\u0012\r\u001c;feB\u000b'\u000f^5uS>tG*[:uK:,'/\u0006\u0002\u0002\nB\u0019\u00111R\u001d\u000e\u0003\u0015\u0011!$T8dW\u0006cG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ\u001cB!O(\u0002\u0012B\u0019A*a%\n\u0007\u0005UeI\u0001\fBYR,'\u000fU1si&$\u0018n\u001c8MSN$XM\\3s)\t\tI)A\u0004fqB\fg\u000eZ:\u0016\u0005\u0005u\u0005\u0003BAP\u0003Wk!!!)\u000b\t\u0005\r\u0016QU\u0001\u0007CR|W.[2\u000b\t\u0005\u001d\u0016\u0011V\u0001\u000bG>t7-\u001e:sK:$(b\u0001@\u0002\u0016%!\u0011QVAQ\u00055\tEo\\7jG&sG/Z4fe\u0006AQ\r\u001f9b]\u0012\u001c\b%A\u0004tQJLgn[:\u0002\u0011MD'/\u001b8lg\u0002\n\u0001BZ1jYV\u0014Xm]\u0001\nM\u0006LG.\u001e:fg\u0002\nQ\"\\1sW&\u001b(/\u0012=qC:$GCAA\u0011\u00035i\u0017M]6JgJ\u001c\u0006N]5oW\u0006QQ.\u0019:l\r\u0006LG.\u001a3\u0002\u000bI,7/\u001a;\u00025\u0005dG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ|F%Z9\u0015\t\u0005\u0005\u0012q\u0019\u0005\n\u0003S\t\u0013\u0011!a\u0001\u0003\u0013\u000bq#\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM\u001d\u0011\u0002\u00131|wmQ8oM&<WCAAh!\u0011\t\t.!8\u000e\u0005\u0005M'\u0002BA&\u0003+TA!a6\u0002Z\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u00037\\\u0017aB:u_J\fw-Z\u0005\u0005\u0003?\f\u0019NA\u0005M_\u001e\u001cuN\u001c4jO\u0006iAn\\4D_:4\u0017nZ0%KF$B!!\t\u0002f\"I\u0011\u0011\u0006\u0013\u0002\u0002\u0003\u0007\u0011qZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001E2p]\u001aLwMU3q_NLGo\u001c:z+\t\ti\u000f\u0005\u0003\u0002p\u0006]XBAAy\u0015\u0011\t\u00190!>\u0002\u00115,G/\u00193bi\u0006T1!!\u0001I\u0013\u0011\tI0!=\u0003)5{7m[\"p]\u001aLwMU3q_NLGo\u001c:z\u0003Q\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018p\u0018\u0013fcR!\u0011\u0011EA\u0000\u0011%\tIcJA\u0001\u0002\u0004\ti/A\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011\u0003Z3mCf,Gm\u00149fe\u0006$\u0018n\u001c8t+\t\u00119\u0001E\u0002M\u0005\u0013I1Aa\u0003G\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u0001\u0013I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0005'\u0001BA!\u0006\u0003\u00185\u0011\u0011Q_\u0005\u0005\u00053\t)PA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EygMZ:fi\u000eCWmY6q_&tGo]\u000b\u0003\u0005C\u0001BAa\t\u0003*5\u0011!Q\u0005\u0006\u0005\u0005O\t).\u0001\u0006dQ\u0016\u001c7\u000e]8j]RLAAa\u000b\u0003&\t\trJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e^:\u0002%=4gm]3u\u0007\",7m\u001b9pS:$8\u000fI\u0001\na\u0006\u0014H/\u001b;j_:,\"Aa\r\u0011\u00071\u0013)$C\u0002\u00038\u0019\u0013\u0011\u0002U1si&$\u0018n\u001c8\u0002\u001bA\f'\u000f^5uS>tw\fJ3r)\u0011\t\tC!\u0010\t\u0013\u0005%\u0002'!AA\u0002\tM\u0012A\u00039beRLG/[8oA\u0005)1/\u001a;va\"\u001a!G!\u0012\u0011\t\t\u001d#QK\u0007\u0003\u0005\u0013RAAa\u0013\u0003N\u0005\u0019\u0011\r]5\u000b\t\t=#\u0011K\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011\u0019F\\\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005/\u0012IE\u0001\u0006CK\u001a|'/Z#bG\"\f!$\u001b8uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:,\"A!\u0018\u0011\t\t}#1M\u0007\u0003\u0005CR!A[@\n\t\t\u0015$\u0011\r\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006\u00192M]3bi\u0016dun\u001a)s_B,'\u000f^5fgR!!1\u000eB:!\u0011\u0011iGa\u001c\u000e\u0005\u0005%\u0016\u0002\u0002B9\u0003S\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011)\b\u000ea\u0001\u0005o\n\u0011b\u001c<feJLG-Z:\u0011\u0011\te$\u0011\u0011BD\u0005\u000fsAAa\u001f\u0003~A\u0019\u0011QM)\n\u0007\t}\u0014+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0007\u0013)IA\u0002NCBT1Aa R!\u0011\u0011IH!#\n\t\t-%Q\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011Q,\u0017M\u001d#po:D3!\u000eBI!\u0011\u00119Ea%\n\t\tU%\u0011\n\u0002\n\u0003\u001a$XM]#bG\"\fqc]3ukB\u0004\u0016M\u001d;ji&|gnV5uQ6{7m[:\u0015\r\tM\"1\u0014BP\u0011\u0019\u0011iJ\u000ea\u00013\u0006YA.Z1eKJ,\u0005o\\2i\u0011\u001d\u0011\tK\u000ea\u0001\u0005G\u000b\u0001\"[:MK\u0006$WM\u001d\t\u0004!\n\u0015\u0016b\u0001BT#\n9!i\\8mK\u0006t\u0017A\u00053fM\u0006,H\u000e\u001e\"s_.,'/\u00129pG\"$BA!,\u00034B\u0019\u0001Ka,\n\u0007\tE\u0016K\u0001\u0003M_:<\u0007\"B,8\u0001\u0004I\u0016aF2sK\u0006$X-S:s\u0007\"\fgnZ3MSN$XM\\3s\u0001")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final Option<Uuid> topicId = Option$.MODULE$.apply((Object)Uuid.randomUuid());
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public Option<Uuid> topicId() {
        return this.topicId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils.tempDirectory(null, null));
        this.logDir1_$eq(TestUtils.randomPartitionLogDir((File)this.tmpDir()));
        this.logDir2_$eq(TestUtils.randomPartitionLogDir((File)this.tmpDir()));
        .colon.colon x$1 = new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$));
        LogConfig x$2 = this.logConfig();
        MockConfigRepository x$3 = this.configRepository();
        CleanerConfig x$4 = new CleanerConfig(false);
        MockTime x$5 = this.time();
        int x$7 = 4;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = false;
        long x$10 = 30000L;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$1, x$2, x$3, x$4, x$5, x$7, true, (Option<UnifiedLog>)x$8, x$9, x$10));
        LogManager qual$1 = this.logManager();
        scala.collection.immutable.Set x$11 = Predef$.MODULE$.Set().empty();
        Function1 x$12 = qual$1.startup$default$2();
        qual$1.startup((Set)x$11, x$12);
        this.alterPartitionManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.alterPartitionListener_$eq(new MockAlterPartitionListener());
        this.partition_$eq(new Partition(this.topicPartition(), 30000L, this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterPartitionManager)this.alterPartitionManager(), (Option)None$.MODULE$));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn(Optional.empty());
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latestTesting();
    }

    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return logProps.put(k, v);
            }
            throw new MatchError(null);
        });
        return logProps;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            LogManager qual$1 = this.logManager();
            long x$1 = qual$1.shutdown$default$1();
            qual$1.shutdown(x$1);
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
            return;
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        Partition qual$1 = this.partition();
        OffsetCheckpoints x$3 = this.offsetCheckpoints();
        None$ x$4 = None$.MODULE$;
        Option x$5 = qual$1.createLogIfNotExists$default$5();
        qual$1.createLogIfNotExists(false, false, x$3, (Option)x$4, x$5);
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Partition qual$2 = this.partition();
            LeaderAndIsrRequest.PartitionState x$6 = new LeaderAndIsrRequest.PartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$7 = this.offsetCheckpoints();
            None$ x$8 = None$.MODULE$;
            Option x$9 = qual$2.makeLeader$default$4();
            Assertions.assertTrue((boolean)qual$2.makeLeader(x$6, x$7, (Option)x$8, x$9), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Partition qual$3 = this.partition();
            LeaderAndIsrRequest.PartitionState x$10 = new LeaderAndIsrRequest.PartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true);
            OffsetCheckpoints x$11 = this.offsetCheckpoints();
            None$ x$12 = None$.MODULE$;
            Option x$13 = qual$3.makeFollower$default$4();
            Assertions.assertTrue((boolean)qual$3.makeFollower(x$10, x$11, (Option)x$12, x$13), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    public long defaultBrokerEpoch(int brokerId) {
        return (long)brokerId + 1000L;
    }

    private MockAlterPartitionListener createIsrChangeListener() {
        return new MockAlterPartitionListener();
    }

    public class MockAlterPartitionListener
    implements AlterPartitionListener {
        private final AtomicInteger expands;
        private final AtomicInteger shrinks;
        private final AtomicInteger failures;

        public AtomicInteger expands() {
            return this.expands;
        }

        public AtomicInteger shrinks() {
            return this.shrinks;
        }

        public AtomicInteger failures() {
            return this.failures;
        }

        public void markIsrExpand() {
            this.expands().incrementAndGet();
        }

        public void markIsrShrink() {
            this.shrinks().incrementAndGet();
        }

        public void markFailed() {
            this.failures().incrementAndGet();
        }

        public void reset() {
            this.expands().set(0);
            this.shrinks().set(0);
            this.failures().set(0);
        }

        public /* synthetic */ AbstractPartitionTest kafka$cluster$AbstractPartitionTest$MockAlterPartitionListener$$$outer() {
            return AbstractPartitionTest.this;
        }

        public MockAlterPartitionListener() {
            if (AbstractPartitionTest.this == null) {
                throw null;
            }
            this.expands = new AtomicInteger(0);
            this.shrinks = new AtomicInteger(0);
            this.failures = new AtomicInteger(0);
        }
    }
}

