/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001\u0002\u0015*\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004K\u0001\u0001\u0006I!\u0010\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0001\u0006\u0001)A\u0005\u001b\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003m\u0001\u0011\u0005Q\fC\u0003o\u0001\u0011\u0005Q\fC\u0003q\u0001\u0011\u0005Q\fC\u0003s\u0001\u0011\u0005Q\fC\u0003u\u0001\u0011\u0005Q\fC\u0003w\u0001\u0011\u0005Q\fC\u0003y\u0001\u0011\u0005Q\fC\u0003{\u0001\u0011\u0005Q\fC\u0003}\u0001\u0011\u0005Q\fC\u0003\u007f\u0001\u0011\u0005Q\fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!1\u0011q\b\u0001\u0005\u0002uCa!a\u0011\u0001\t\u0003i\u0006BBA$\u0001\u0011\u0005Q\f\u0003\u0004\u0002L\u0001!\t!\u0018\u0005\u0007\u0003\u001f\u0002A\u0011A/\t\r\u0005M\u0003\u0001\"\u0001^\u0011\u0019\t9\u0006\u0001C\u0001;\"1\u00111\f\u0001\u0005\u0002uCq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\r\u0005]\u0004\u0001\"\u0001^\u0011\u0019\tY\b\u0001C\u0001;\"1\u0011q\u0010\u0001\u0005\u0002uCa!a!\u0001\t\u0003i\u0006BBAD\u0001\u0011\u0005Q\f\u0003\u0004\u0002\f\u0002!\t!\u0018\u0005\b\u00037\u0002A\u0011BAH\u0011\u001d\tY\u000b\u0001C\u0005\u0003[C\u0011\"a4\u0001#\u0003%I!!5\u0003/Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1UKN$(B\u0001\u0016,\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u00051j\u0013aC2p_J$\u0017N\\1u_JT\u0011AL\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003%\nA\u0001^5nKV\tQ\b\u0005\u0002?\u00116\tqH\u0003\u0002A\u0003\u0006!Q\u000f^5m\u0015\t\u00115)\u0001\u0004tKJ4XM\u001d\u0006\u0003]\u0011S!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO&\u0011\u0011j\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u00035\u0003\"A\r(\n\u0005=\u001b$\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005yAO]1og\u0006\u001cG/[8oC2LE-F\u0001T!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003mC:<'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013aa\u0015;sS:<\u0017\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003M!Xm\u001d;J]&$\u0018.\u00197ju\u0016,\u0005o\\2i)\u0005q\u0006C\u0001\u001a`\u0013\t\u00017G\u0001\u0003V]&$\bF\u0001\u0005c!\t\u0019'.D\u0001e\u0015\t)g-A\u0002ba&T!a\u001a5\u0002\u000f),\b/\u001b;fe*\u0011\u0011NR\u0001\u0006UVt\u0017\u000e^\u0005\u0003W\u0012\u0014A\u0001V3ti\u0006\u0019B/Z:u\u001d>\u0014X.\u00197Fa>\u001c\u0007NQ;na\"\u0012\u0011BY\u0001)i\u0016\u001cHOQ;na\u0016\u0003xn\u00195O_R\fE\u000e\\8xK\u0012Le-\u00129pG\"\u001cX\t\u001f5bkN$X\r\u001a\u0015\u0003\u0015\t\fa\u0005^3tiR\u0013\u0018M\\:ji\u001a\u0013x.\\#naRLHk\u001c)sKB\f'/Z!c_J$\u0018J\u001c,3Q\tY!-\u0001\u0018uKN$HK]1og&$hI]8n\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;U_B\u0013X\r]1sK\u0006\u0013wN\u001d;J]Z\u0013\u0004F\u0001\u0007c\u0003=\"Xm\u001d;Ue\u0006t7/\u001b;Ge>l7i\\7qY\u0016$XmQ8n[&$Hk\u001c)sKB\f'/Z!c_J$\u0018J\u001c,3Q\ti!-\u0001\u0016uKN$Hk\u001c7fe\u0006$X-\u00169eCR,G+[7f'\"Lg\r\u001e#ve&tw-\u00129pG\"\u0014U/\u001c9)\u00059\u0011\u0017a\r;fgR$v\u000e\\3sCR,W\u000b\u001d3bi\u0016$\u0016.\\3SKN,G\u000fR;sS:<\u0007K]8ek\u000e,'/\u00133S_R\fG/[8oQ\ty!-\u0001\u0015uKN$Hk\u001c7fe\u0006$X\rV5nKNC\u0017N\u001a;EkJLgnZ!eIB\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u0011E\u0006AC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u0004&/\u001a9be\u0016\u001cu.\\7ji\"\u0012\u0011CY\u0001(i\u0016\u001cH\u000fV8mKJ\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4Qe\u0016\u0004\u0018M]3BE>\u0014H\u000f\u000b\u0002\u0013E\u0006IC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u001cu.\u001c9mKR,7i\\7nSR$2AXA\u0003\u0011\u001d\t9a\u0005a\u0001\u0003\u0013\t!\u0003\u001e:b]N\f7\r^5p]Z+'o]5p]B\u0019!'a\u0003\n\u0007\u000551GA\u0003TQ>\u0014H\u000fK\u0002\u0014\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/1\u0017A\u00029be\u0006l7/\u0003\u0003\u0002\u001c\u0005U!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":1#a\b\u0002,\u00055\u0002\u0003BA\u0011\u0003Oi!!a\t\u000b\t\u0005\u0015\u0012QC\u0001\taJ|g/\u001b3fe&!\u0011\u0011FA\u0012\u0005-1\u0016\r\\;f'>,(oY3\u0002\rMDwN\u001d;tY\u0011\ty#!\r\u001c\u0003\u0001Y\u0012AA\u0001)i\u0016\u001cH\u000fV8mKJ\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4D_6\u0004H.\u001a;f\u0003\n|'\u000f\u001e\u000b\u0004=\u0006]\u0002bBA\u0004)\u0001\u0007\u0011\u0011\u0002\u0015\u0004)\u0005E\u0001f\u0002\u000b\u0002 \u0005-\u0012Q\b\u0017\u0005\u0003_\t\t$A\u0013uKN$h)\u001a8dKB\u0013x\u000eZ;dKJ\fe\r^3s\u000bB|7\r[:Fq\"\fWo\u001d;fI\"\u0012QCY\u0001/i\u0016\u001cH/\u00138wC2LG\r\u0016:b]NLG/[8o\rJ|WnQ8na2,G/Z\"p[6LG\u000fV8GK:\u001cW\r\u000b\u0002\u0017E\u0006iC/Z:u\u0013:4\u0018\r\\5e)J\fgn]5uS>tgI]8n\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;U_\u001a+gnY3)\u0005]\u0011\u0017\u0001\f;fgR4UM\\2f!J|G-^2fe:{G/\u00117m_^,G-\u00134Ji^{W\u000f\u001c3Pm\u0016\u0014h\r\\8xQ\tA\"-\u0001\u000buKN$(k\u001c;bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0015\u00033\t\fQ\u0003^3ti\u0016\u0003xn\u00195Ck6\u0004xJ\\#oIRCh\u000e\u000b\u0002\u001bE\u0006iB/Z:u\u000bB|7\r\u001b\"v[B|e.\u00128e)btwJ^3sM2|w\u000f\u000b\u0002\u001cE\u0006\u0011C/Z:u%>$\u0018\r^3Qe>$WoY3s\u0013\u0012Len\u00148h_&twm\u0015;bi\u0016D#\u0001\b2\u0002OQ,7\u000f\u001e*pi\u0006$X\r\u0015:pIV\u001cWM]%e\u0013:\u0004&/\u001a9be\u0016\f%m\u001c:u'R\fG/\u001a\u000b\u0004=\u0006\r\u0004bBA\u0004;\u0001\u0007\u0011\u0011\u0002\u0015\u0004;\u0005E\u0001fB\u000f\u0002 \u0005-\u0012\u0011\u000e\u0017\u0005\u0003_\t\t$\u0001\u0015uKN$(k\u001c;bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ%o!J,\u0007/\u0019:f\u0007>lW.\u001b;Ti\u0006$X\rF\u0002_\u0003_Bq!a\u0002\u001f\u0001\u0004\tI\u0001K\u0002\u001f\u0003#AsAHA\u0010\u0003W\t)\b\f\u0003\u00020\u0005E\u0012A\f;fgR\fE\u000f^3naR,G-\u00129pG\"\u0014U/\u001c9XSRDg*Z<ms\u000e\u0013X-\u0019;fI6+G/\u00193bi\u0006D#a\b2\u0002KQ,7\u000f^#q_\u000eD')^7q/&$\bnQ;se\u0016tG/\u00129pG\"\u0004&o\u001c<jI\u0016$\u0007F\u0001\u0011c\u0003\r\"Xm\u001d;BiR,W\u000e\u001d;fI\u0016\u0003xn\u00195Ck6\u0004x+\u001b;i\u0019\u0006\u001cH/\u00129pG\"D#!\t2\u0002KQ,7\u000f^!ui\u0016l\u0007\u000f^3e\u000bB|7\r\u001b\"v[B<\u0016\u000e\u001e5GK:\u001cW\rZ#q_\u000eD\u0007F\u0001\u0012c\u0003\u0011\"Xm\u001d;Ue\u0006t7/Y2uS>t7\u000b^1uK&#\u0017I\u001c3OC6,W*\u00199qS:<\u0007FA\u0012c\u0003\u0005\"Xm\u001d;BY2$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$Xm]!sK6\u000b\u0007\u000f]3eQ\t!#\rF\u0003_\u0003#\u000bY\nC\u0004\u0002\u0014\u0016\u0002\r!!&\u0002\u000bM$\u0018\r^3\u0011\u0007i\n9*C\u0002\u0002\u001a&\u0012\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\t\u000f\u0005uU\u00051\u0001\u0002 \u0006A2\r\\5f]R$&/\u00198tC\u000e$\u0018n\u001c8WKJ\u001c\u0018n\u001c8\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1!!*B\u0003\u0019\u0019w.\\7p]&!\u0011\u0011VAR\u0005I!&/\u00198tC\u000e$\u0018n\u001c8WKJ\u001c\u0018n\u001c8\u0002OA\u0014X\r]1sKN+8mY3tg\u001a,H.\u00138de\u0016lWM\u001c;Qe>$WoY3s\u000bB|7\r\u001b\u000b\t\u0003_\u000b),a0\u0002JB\u0019!(!-\n\u0007\u0005M\u0016F\u0001\nUq:$&/\u00198tSRlU\r^1eCR\f\u0007bBA\\M\u0001\u0007\u0011\u0011X\u0001\fibtW*\u001a;bI\u0006$\u0018\rE\u0002;\u0003wK1!!0*\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\t\tM\na\u0001\u0003\u0007\fQ#\u001a=qK\u000e$X\r\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u00033\u0003\u000b\fI!C\u0002\u0002HN\u0012aa\u00149uS>t\u0007\"CAfMA\u0005\t\u0019AAg\u0003\rqwn\u001e\t\u0005e\u0005\u0015W*A\u0019qe\u0016\u0004\u0018M]3Tk\u000e\u001cWm]:gk2Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M'\u0006BAg\u0003+\\#!a6\u0011\t\u0005e\u00171]\u0007\u0003\u00037TA!!8\u0002`\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C\u001c\u0014AC1o]>$\u0018\r^5p]&!\u0011Q]An\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()));
    }

    @Test
    public void testTransitFromEmptyToPrepareAbortInV2() {
        short producerEpoch = (short)735;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), -1L, this.time().milliseconds(), TransactionVersion.TV_2);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, TransactionVersion.TV_2, -1L, this.time().milliseconds() + 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() + 1L), (long)txnMetadata.txnStartTimestamp());
    }

    @Test
    public void testTransitFromCompleteAbortToPrepareAbortInV2() {
        short producerEpoch = (short)735;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)CompleteAbort$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds() - 1L, this.time().milliseconds(), TransactionVersion.TV_2);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, TransactionVersion.TV_2, -1L, this.time().milliseconds() + 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() + 1L), (long)txnMetadata.txnStartTimestamp());
    }

    @Test
    public void testTransitFromCompleteCommitToPrepareAbortInV2() {
        short producerEpoch = (short)735;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)CompleteCommit$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds() - 1L, this.time().milliseconds(), TransactionVersion.TV_2);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, TransactionVersion.TV_2, -1L, this.time().milliseconds() + 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() + 1L), (long)txnMetadata.txnStartTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds(), TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().milliseconds() - 1L))));
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds(), TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds(), TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), this.time().milliseconds() - 1L, TransactionVersion.TV_0);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds() - 2L, TransactionVersion.TV_0);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds(), TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, TransactionVersion.TV_0, -1L, this.time().milliseconds() - 1L, false);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds(), TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, TransactionVersion.TV_0, -1L, this.time().milliseconds() - 1L, false);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @ParameterizedTest
    @ValueSource(shorts={0, 2})
    public void testTolerateTimeShiftDuringCompleteCommit(short transactionVersion) {
        TransactionVersion clientTransactionVersion = (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(transactionVersion, true);
        short producerEpoch = 1;
        short lastProducerEpoch = 0;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds(), clientTransactionVersion);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)lastProducerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @ParameterizedTest
    @ValueSource(shorts={0, 2})
    public void testTolerateTimeShiftDuringCompleteAbort(short transactionVersion) {
        TransactionVersion clientTransactionVersion = (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(transactionVersion, true);
        short producerEpoch = 1;
        short lastProducerEpoch = 0;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)PrepareAbort$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds(), clientTransactionVersion);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)lastProducerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$8 = Ongoing$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)fencingTransitMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)fencingTransitMetadata.lastProducerEpoch());
        Assertions.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, TransactionVersion.TV_0, -1L, this.time().milliseconds(), false);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test
    public void testInvalidTransitionFromCompleteCommitToFence() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        CompleteCommit$ x$8 = CompleteCommit$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareFenceProducerEpoch());
    }

    @Test
    public void testInvalidTransitionFromCompleteAbortToFence() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        CompleteAbort$ x$8 = CompleteAbort$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareFenceProducerEpoch());
    }

    @Test
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$8 = Ongoing$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareFenceProducerEpoch());
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.previousProducerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpOnEndTxn() {
        this.time().sleep(100L);
        short producerEpoch = (short)10;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds(), TransactionVersion.TV_2);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, TransactionVersion.TV_2, -1L, this.time().milliseconds() - 1L, false);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)((short)(producerEpoch + 1)), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((Object)TransactionVersion.TV_2, (Object)txnMetadata.clientTransactionVersion());
        transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)((short)(producerEpoch + 1)), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((Object)TransactionVersion.TV_2, (Object)txnMetadata.clientTransactionVersion());
    }

    @Test
    public void testEpochBumpOnEndTxnOverflow() {
        this.time().sleep(100L);
        short producerEpoch = (short)32766;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds(), TransactionVersion.TV_2);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, TransactionVersion.TV_2, newProducerId, this.time().milliseconds() - 1L, false);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((Object)TransactionVersion.TV_2, (Object)txnMetadata.clientTransactionVersion());
        transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((Object)TransactionVersion.TV_2, (Object)txnMetadata.clientTransactionVersion());
    }

    @Test
    public void testRotateProducerIdInOngoingState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$, TransactionVersion.TV_0));
    }

    @ParameterizedTest
    @ValueSource(shorts={0, 2})
    public void testRotateProducerIdInPrepareAbortState(short transactionVersion) {
        TransactionVersion clientTransactionVersion = (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(transactionVersion, true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$, clientTransactionVersion));
    }

    @ParameterizedTest
    @ValueSource(shorts={0, 2})
    public void testRotateProducerIdInPrepareCommitState(short transactionVersion) {
        TransactionVersion clientTransactionVersion = (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(transactionVersion, true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$, clientTransactionVersion));
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, -1, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, -1, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)lastProducerEpoch)), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)lastProducerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Empty$ x$8 = Empty$.MODULE$;
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        Either result = new TransactionMetadata(x$1, x$2, x$3, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$8, x$9, x$12, x$10, TransactionVersion.TV_0).prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)(lastProducerEpoch - 1)))), this.time().milliseconds());
        Assertions.assertEquals((Object)new Left((Object)Errors.PRODUCER_FENCED), (Object)result);
    }

    @Test
    public void testTransactionStateIdAndNameMapping() {
        TransactionState$.MODULE$.AllStates().foreach((Function1 & Serializable)state -> {
            TransactionMetadataTest.$anonfun$testTransactionStateIdAndNameMapping$1(state);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllTransactionStatesAreMapped() {
        Set unmatchedStates = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{Empty$.MODULE$, Ongoing$.MODULE$, PrepareCommit$.MODULE$, PrepareAbort$.MODULE$, CompleteCommit$.MODULE$, CompleteAbort$.MODULE$, PrepareEpochFence$.MODULE$, Dead$.MODULE$}));
        TransactionState$.MODULE$.AllStates().foreach((Function1 & Serializable)x0$1 -> {
            TransactionMetadataTest.$anonfun$testAllTransactionStatesAreMapped$1(unmatchedStates, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)unmatchedStates);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state, TransactionVersion clientTransactionVersion) {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Set x$9 = (Set)Set$.MODULE$.empty();
        long x$10 = this.time().milliseconds();
        long x$12 = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, -1L, producerEpoch, -1, 30000, state, x$9, x$12, x$10, clientTransactionVersion);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    private TxnTransitMetadata prepareSuccessfulIncrementProducerEpoch(TransactionMetadata txnMetadata, Option<Object> expectedProducerEpoch, Option<Object> now) {
        Either result = txnMetadata.prepareIncrementProducerEpoch(30000, expectedProducerEpoch, BoxesRunTime.unboxToLong((Object)now.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.time().milliseconds())));
        return (TxnTransitMetadata)result.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("prepareIncrementProducerEpoch failed with " + result));
        });
    }

    private Option<Object> prepareSuccessfulIncrementProducerEpoch$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$testTransactionStateIdAndNameMapping$1(TransactionState state) {
        Assertions.assertEquals((Object)state, (Object)TransactionState$.MODULE$.fromId(state.id()));
        Assertions.assertEquals((Object)new Some((Object)state), (Object)TransactionState$.MODULE$.fromName(state.name()));
        if (!state.equals(Dead$.MODULE$)) {
            org.apache.kafka.clients.admin.TransactionState clientTransactionState = org.apache.kafka.clients.admin.TransactionState.parse((String)state.name());
            Assertions.assertEquals((Object)state.name(), (Object)clientTransactionState.toString());
            Assertions.assertNotEquals((Object)org.apache.kafka.clients.admin.TransactionState.UNKNOWN, (Object)clientTransactionState);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testAllTransactionStatesAreMapped$1(Set unmatchedStates$1, TransactionState x0$1) {
        if (Empty$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Empty$.MODULE$));
            return;
        }
        if (Ongoing$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Ongoing$.MODULE$));
            return;
        }
        if (PrepareCommit$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareCommit$.MODULE$));
            return;
        }
        if (PrepareAbort$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareAbort$.MODULE$));
            return;
        }
        if (CompleteCommit$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)CompleteCommit$.MODULE$));
            return;
        }
        if (CompleteAbort$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)CompleteAbort$.MODULE$));
            return;
        }
        if (PrepareEpochFence$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)PrepareEpochFence$.MODULE$));
            return;
        }
        if (Dead$.MODULE$.equals(x0$1)) {
            Assertions.assertTrue((boolean)unmatchedStates$1.remove((Object)Dead$.MODULE$));
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

