/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\r-b!\u0002 @\u0003\u0003!\u0005\"B&\u0001\t\u0003a\u0005\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u0001Q\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005e\u0001\u0001\u0007\t\u0011)Q\u0005#\"9Q\r\u0001b\u0001\n\u00131\u0007B\u00029\u0001A\u0003%q\rC\u0003r\u0001\u0011\u0005!\u000fC\u0003w\u0001\u0011\u0005!\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0005~\u0001\u0001\u0007\t\u0019!C\u0001}\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011AA\u0007\u0011)\t\t\u0002\u0001a\u0001\u0002\u0003\u0006Ka \u0005\u0007\u0003'\u0001a\u0011\u0001)\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002BBA\u001d\u0001\u0011\u0005\u0001\u000bC\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003\"CAE\u0001E\u0005I\u0011AAF\u0011\u001d\t\t\u000b\u0001C\t\u0003GCq!!\u001d\u0001\t#\t)\fC\u0004\u00028\u0002!\t\"!/\t\u000f\u00055\u0007\u0001\"\u0005\u0002P\"9\u0011q\u001c\u0001\u0005\u0012\u0005=\u0007bBAq\u0001\u0011E\u00111\u001d\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\u0011\u0019\u0001\u0001C!\u0003oAqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0005\u0003\u001a\u0001\t\n\u0011\"\u0001\u0003\u001c!I!q\u0004\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011%\u0011Y\u0003AI\u0001\n\u0003\tY\tC\u0005\u0003.\u0001\t\n\u0011\"\u0001\u00030!9!1\u0007\u0001\u0005\u0002\tU\u0002\"\u0003B,\u0001E\u0005I\u0011\u0001B-\u0011%\u0011i\u0006AI\u0001\n\u0003\u0011I\u0006C\u0005\u0003`\u0001\t\n\u0011\"\u0001\u00030!I!\u0011\r\u0001\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0005G\u0002\u0011\u0013!C\u0001\u0005_AqA!\u001a\u0001\t\u0003\u00119\u0007C\u0005\u0003x\u0001\t\n\u0011\"\u0001\u0002\f\"9!\u0011\u0010\u0001\u0005\u0002\tm\u0004\"\u0003BA\u0001E\u0005I\u0011AAF\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0005\u000bCqAa+\u0001\t\u0003\u0011i\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\t]\u0006\u0001\"\u0001\u0003:\"9!q\u0017\u0001\u0005\u0002\t}\u0006b\u0002Bj\u0001\u0011\u0005!Q\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011%\u0011y\u000eAI\u0001\n\u0003\u0011Y\u0002C\u0004\u0003b\u0002!\tAa9\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!Q\u001e\u0001\u0005\u0002\r\r\u0001bBB\u0003\u0001\u0011\u00051q\u0001\u0005\b\u0007\u0017\u0001A\u0011BB\u0007\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'Aqa!\u0007\u0001\t\u0003\u0019Y\u0002C\u0004\u0004 \u0001!\t!a\u000e\t\u000f\r\u0005\u0002\u0001\"\u0001\u0004$\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u0002A\u0003\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0015\u0005\u0011\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001S!\u0002\rM,'O^3s\u0013\tQuIA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A \u0002\u001f%t7\u000f^1oG\u0016\u001cuN\u001c4jON,\u0012!\u0015\t\u0004%^KV\"A*\u000b\u0005Q+\u0016AC2pY2,7\r^5p]*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y'\n\u00191+Z9\u0011\u0005\u0019S\u0016BA.H\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002'%t7\u000f^1oG\u0016\u001cuN\u001c4jON|F%Z9\u0015\u0005y\u0013\u0007CA0a\u001b\u0005)\u0016BA1V\u0005\u0011)f.\u001b;\t\u000f\r\u001c\u0011\u0011!a\u0001#\u0006\u0019\u0001\u0010J\u0019\u0002!%t7\u000f^1oG\u0016\u001cuN\u001c4jON\u0004\u0013\u0001C0ce>\\WM]:\u0016\u0003\u001d\u00042\u0001[6n\u001b\u0005I'B\u00016T\u0003\u001diW\u000f^1cY\u0016L!\u0001\\5\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003\r:L!a\\$\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\n?\n\u0014xn[3sg\u0002\nqA\u0019:pW\u0016\u00148/F\u0001t!\rAG/\\\u0005\u0003k&\u0014aAQ;gM\u0016\u0014\u0018aB:feZ,'o]\u0001\u000eEJ|7.\u001a:TKJ4XM]:\u0016\u0003e\u00042\u0001\u001b;{!\t150\u0003\u0002}\u000f\na!I]8lKJ\u001cVM\u001d<fe\u0006)\u0011\r\\5wKV\tq\u0010E\u0003`\u0003\u0003\t)!C\u0002\u0002\u0004U\u0013Q!\u0011:sCf\u00042aXA\u0004\u0013\r\tI!\u0016\u0002\b\u0005>|G.Z1o\u0003%\tG.\u001b<f?\u0012*\u0017\u000fF\u0002_\u0003\u001fAqaY\u0006\u0002\u0002\u0003\u0007q0\u0001\u0004bY&4X\rI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hg\u0006\u00193m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=CK\u001a|'/Z*feZ,'o]*uCJ$Hc\u00010\u0002\u001a!9\u00111\u0004\bA\u0002\u0005u\u0011\u0001\u0003;fgRLeNZ8\u0011\t\u0005}\u0011\u0011G\u0007\u0003\u0003CQA!a\t\u0002&\u0005\u0019\u0011\r]5\u000b\t\u0005\u001d\u0012\u0011F\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tY#!\f\u0002\u000b),h.\u001b;\u000b\u0005\u0005=\u0012aA8sO&!\u00111GA\u0011\u0005!!Vm\u001d;J]\u001a|\u0017AI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\u00063G/\u001a:TKJ4XM]:Ti\u0006\u0014H\u000fF\u0001_\u0003\u001d\u0019wN\u001c4jON\f1b]3sm\u0016\u0014hi\u001c:JIR!\u0011qHA#!\u0011y\u0016\u0011I7\n\u0007\u0005\rSK\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000f\n\u0002\u0019AA%\u0003\tIG\rE\u0002`\u0003\u0017J1!!\u0014V\u0005\rIe\u000e^\u0001\nE>,h\u000e\u001a)peR$B!!\u0013\u0002T!)\u0001J\u0005a\u0001[\u0006\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u000b\u0005\u00033\ny\u0007\u0005\u0003\u0002\\\u0005%d\u0002BA/\u0003K\u00022!a\u0018V\u001b\t\t\tGC\u0002\u0002d\r\u000ba\u0001\u0010:p_Rt\u0014bAA4+\u00061\u0001K]3eK\u001aLA!a\u001b\u0002n\t11\u000b\u001e:j]\u001eT1!a\u001aV\u0011%\t\th\u0005I\u0001\u0002\u0004\t\u0019(\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002v\u0005\u0015UBAA<\u0015\u0011\tI(a\u001f\u0002\u000f9,Go^8sW*!\u0011QPA@\u0003\u0019\u0019w.\\7p]*\u0019!)!!\u000b\t\u0005\r\u0015QF\u0001\u0007CB\f7\r[3\n\t\u0005\u001d\u0015q\u000f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u001bE>|Go\u001d;sCB\u001cVM\u001d<feN$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bSC!a\u001d\u0002\u0010.\u0012\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001cV\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty*!&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\u0011\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005=\u00161P\u0001\tg\u0016\u001cWO]5us&!\u00111WAU\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0006\u0002\u0002t\u0005qAO];tiN#xN]3GS2,WCAA^!\u0015y\u0016\u0011IA_!\u0011\ty,!3\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f!![8\u000b\u0005\u0005\u001d\u0017\u0001\u00026bm\u0006LA!a3\u0002B\n!a)\u001b7f\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\u0011\u0011\u0011\u001b\t\u0006?\u0006\u0005\u00131\u001b\t\u0005\u0003+\fY.\u0004\u0002\u0002X*!\u0011\u0011\\Ac\u0003\u0011)H/\u001b7\n\t\u0005u\u0017q\u001b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7/\u0001\u0006ce>\\WM\u001d+j[\u0016$B!!:\u0002rB!\u0011q]Aw\u001b\t\tIO\u0003\u0003\u0002l\u0006m\u0014!B;uS2\u001c\u0018\u0002BAx\u0003S\u0014A\u0001V5nK\"9\u00111\u001f\u000eA\u0002\u0005%\u0013\u0001\u00032s_.,'/\u00133\u0002\u000bM,G/\u00169\u0015\u0007y\u000bI\u0010C\u0004\u0002\u001cm\u0001\r!!\b)\u0007m\ti\u0010\u0005\u0003\u0002 \u0005}\u0018\u0002\u0002B\u0001\u0003C\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u000f\u0003\bA!\u0011q\u0004B\u0005\u0013\u0011\u0011Y!!\t\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0004:fGJ,\u0017\r^3Ce>\\WM]:\u0015\u000by\u0013\tB!\u0006\t\u0013\tMQ\u0004%AA\u0002\u0005\u0015\u0011a\u0003:fG>tg-[4ve\u0016D\u0011Ba\u0006\u001e!\u0003\u0005\r!!\u0002\u0002\u000fM$\u0018M\u001d;va\u0006I\"/Z2sK\u0006$XM\u0011:pW\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iB\u000b\u0003\u0002\u0006\u0005=\u0015!\u0007:fGJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uII\n!c\u0019:fCR,wJ\u001a4tKR\u001cHk\u001c9jGR)aL!\n\u0003(!I\u0011\u0011\u000f\u0011\u0011\u0002\u0003\u0007\u00111\u000f\u0005\n\u0005S\u0001\u0003\u0013!a\u0001\u0003'\f\u0011#\u00193nS:\u001cE.[3oi\u000e{gNZ5h\u0003q\u0019'/Z1uK>3gm]3ugR{\u0007/[2%I\u00164\u0017-\u001e7uIE\nAd\u0019:fCR,wJ\u001a4tKR\u001cHk\u001c9jG\u0012\"WMZ1vYR$#'\u0006\u0002\u00032)\"\u00111[AH\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u001d\t]\"1\tB$\u0005\u0017\u0012yEa\u0015\u0003VAA!\u0011\bB \u0003\u0013\nI%\u0004\u0002\u0003<)\u0019!QH*\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B!\u0005w\u00111!T1q\u0011\u001d\u0011)e\ta\u0001\u00033\nQ\u0001^8qS\u000eD\u0011B!\u0013$!\u0003\u0005\r!!\u0013\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011%\u0011ie\tI\u0001\u0002\u0004\tI%A\tsKBd\u0017nY1uS>tg)Y2u_JD\u0011B!\u0015$!\u0003\u0005\r!a5\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\u0005\n\u0003c\u001a\u0003\u0013!a\u0001\u0003gB\u0011B!\u000b$!\u0003\u0005\r!a5\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\f\u0016\u0005\u0003\u0013\ny)A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000fJ\u001a\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012*\u0014!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$HEN\u0001\u001aGJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u00038\t%$1\u000eB;\u0011\u001d\u0011)%\u000ba\u0001\u00033BqA!\u001c*\u0001\u0004\u0011y'\u0001\u000eqCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fE\u0004S\u0005c\nIEa\u001d\n\u0007\t\u00053\u000b\u0005\u0003S/\u0006%\u0003\"CA9SA\u0005\t\u0019AA:\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIM\n1\u0002Z3mKR,Gk\u001c9jGR)aL! \u0003\u0000!9!QI\u0016A\u0002\u0005e\u0003\"CA9WA\u0005\t\u0019AA:\u0003U!W\r\\3uKR{\u0007/[2%I\u00164\u0017-\u001e7uII\n\u0001#\u00193e\u0003:$g+\u001a:jMf\f5\r\\:\u0015\u000by\u00139I!(\t\u000f\t%U\u00061\u0001\u0003\f\u0006!\u0011m\u00197t!\u0019\tYF!$\u0003\u0012&!!qRA7\u0005\r\u0019V\r\u001e\t\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*!!qSA>\u0003\r\t7\r\\\u0005\u0005\u00057\u0013)J\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\bb\u0002BP[\u0001\u0007!\u0011U\u0001\te\u0016\u001cx.\u001e:dKB!!1\u0015BT\u001b\t\u0011)K\u0003\u0003\u0003 \u0006m\u0014\u0002\u0002BU\u0005K\u0013qBU3t_V\u00148-\u001a)biR,'O\\\u0001\u0014e\u0016lwN^3B]\u00124VM]5gs\u0006\u001bGn\u001d\u000b\u0006=\n=&\u0011\u0017\u0005\b\u0005\u0013s\u0003\u0019\u0001BF\u0011\u001d\u0011yJ\fa\u0001\u0005C\u000b\u0001c[5mYJ\u000bg\u000eZ8n\u0005J|7.\u001a:\u0015\u0005\u0005%\u0013AC6jY2\u0014%o\\6feR\u0019aLa/\t\u000f\tu\u0006\u00071\u0001\u0002J\u0005)\u0011N\u001c3fqR)aL!1\u0003D\"9!QX\u0019A\u0002\u0005%\u0003b\u0002Bcc\u0001\u0007!qY\u0001\bi&lWm\\;u!\u0011\u0011IMa4\u000e\u0005\t-'\u0002\u0002Bg\u0003\u000b\fA\u0001^5nK&!!\u0011\u001bBf\u0005!!UO]1uS>t\u0017aC:uCJ$(I]8lKJ$2A\u0018Bl\u0011\u001d\u0011iL\ra\u0001\u0003\u0013\n!C]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sgR\u0019aL!8\t\u0013\tM1\u0007%AA\u0002\u0005\u0015\u0011\u0001\b:fgR\f'\u000f\u001e#fC\u0012\u0014%o\\6feN$C-\u001a4bk2$H%M\u0001/o\u0006LGOR8s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\u001c+p\u0003B\u0004X-\u0019:P]\u0006cGN\u0011:pW\u0016\u00148\u000fF\u0003_\u0005K\u0014I\u000fC\u0004\u0003hV\u0002\r!!\u0017\u0002\u001f\rd\u0017.\u001a8u!JLgnY5qC2DqAa;6\u0001\u0004\tI&A\u0007nK\u000eD\u0017M\\5t[:\u000bW.Z\u0001\fO\u0016$Hk\u001c9jG&#7\u000f\u0006\u0003\u0003r\nu\b\u0003CA.\u0005g\fIF!>\n\t\t\u0005\u0013Q\u000e\t\u0005\u0005o\u0014I0\u0004\u0002\u0002|%!!1`A>\u0005\u0011)V/\u001b3\t\u000f\t}h\u00071\u0001\u0004\u0002\u0005)a.Y7fgB!!kVA-)\t\u0011\t0A\u0007hKR$v\u000e]5d\u001d\u0006lWm\u001d\u000b\u0003\u0007\u0013\u0001\u0002\"a\u0017\u0003t\nU\u0018\u0011L\u0001\u000eGJ,\u0017\r^3Ce>\\WM]:\u0015\u0007y\u001by\u0001C\u0004\u0003\u0018e\u0002\r!!\u0002\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:Ge>l7i\u001c8gS\u001e$2!\\B\u000b\u0011\u0019\u00199B\u000fa\u00013\u000611m\u001c8gS\u001e\fA\"\u00197jm\u0016\u0014%o\\6feN,\"a!\b\u0011\u0007I;V.A\u000ff]N,(/Z\"p]NL7\u000f^3oi.\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0003Q\u0019\u0007.\u00198hK\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR)al!\n\u0004*!91qE\u001fA\u0002\u0005e\u0013!E:b]&$\u0018N_3e\u00072LWM\u001c;JI\"9\u0011\u0011H\u001fA\u0002\u0005M\u0007")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive;

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaBroker> servers() {
        return this.brokers();
    }

    public Buffer<BrokerServer> brokerServers() {
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaBroker> serverForId(int id) {
        return this.brokers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public int boundPort(KafkaBroker server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart(testInfo);
        this.createBrokers(true);
        this.configureSecurityAfterServersStart();
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), true);
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig), (Function1 & Serializable)admin -> TestUtils$.MODULE$.createOffsetsTopicWithAdmin((Admin)admin, this.brokers(), this.controllerServers()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName, Properties adminClientConfig) {
        return (scala.collection.immutable.Map)Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig), (Function1 & Serializable)admin -> {
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            Map x$8 = (Map)Map$.MODULE$.empty();
            return TestUtils$.MODULE$.createTopicWithAdmin((Admin)admin, topic, x$3, x$4, numPartitions, replicationFactor, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        return (scala.collection.immutable.Map)Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties()), (Function1 & Serializable)admin -> {
            Buffer<KafkaBroker> x$4 = this.brokers();
            Seq<ControllerServer> x$5 = this.controllerServers();
            int x$6 = 1;
            int x$7 = 1;
            Properties x$8 = new Properties();
            return TestUtils$.MODULE$.createTopicWithAdmin((Admin)admin, topic, x$4, x$5, x$6, x$7, partitionReplicaAssignment, x$8);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    public void deleteTopic(String topic, ListenerName listenerName) {
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, new Properties()), (Function1 & Serializable)admin -> {
            TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic, this.aliveBrokers(), this.controllerServers());
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public void addAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        Authorizer authorizerForWrite = TestUtils$.MODULE$.pickAuthorizerForWrite(this.brokers(), this.controllerServers());
        Set aclBindings = (Set)acls.map((Function1 & Serializable)acl -> new AclBinding(resource, acl));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizerForWrite.createAcls(TestUtils$.MODULE$.anonymousAuthorizableContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)aclBindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$3 -> (AclCreateResult)x$3.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            KafkaServerTestHarness.$anonfun$addAndVerifyAcls$3(result);
            return BoxedUnit.UNIT;
        });
        AclBindingFilter aclFilter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        ((IterableOnceOps)((IterableOps)this.brokers().map((Function1 & Serializable)x$4 -> (Authorizer)x$4.authorizer().get())).$plus$plus((IterableOnce)this.controllerServers().map((Function1 & Serializable)x$5 -> (Authorizer)x$5.authorizer().get()))).foreach((Function1 & Serializable)authorizer -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(aclFilter)).asScala().map((Function1 & Serializable)x$6 -> x$6.entry())).toSet().$plus$plus((IterableOnce)acls)), authorizer, resource, AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    public void removeAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        Authorizer authorizerForWrite = TestUtils$.MODULE$.pickAuthorizerForWrite(this.brokers(), this.controllerServers());
        Set aclBindingFilters = (Set)acls.map((Function1 & Serializable)acl -> new AclBindingFilter(resource.toFilter(), acl.toFilter()));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizerForWrite.deleteAcls(TestUtils$.MODULE$.anonymousAuthorizableContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)aclBindingFilters.toList()).asJava())).asScala().map((Function1 & Serializable)x$7 -> (AclDeleteResult)x$7.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            KafkaServerTestHarness.$anonfun$removeAndVerifyAcls$3(result);
            return BoxedUnit.UNIT;
        });
        AclBindingFilter aclFilter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        ((IterableOnceOps)((IterableOps)this.brokers().map((Function1 & Serializable)x$8 -> (Authorizer)x$8.authorizer().get())).$plus$plus((IterableOnce)this.controllerServers().map((Function1 & Serializable)x$9 -> (Authorizer)x$9.authorizer().get()))).foreach((Function1 & Serializable)authorizer -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(aclFilter)).asScala().map((Function1 & Serializable)x$10 -> x$10.entry())).toSet().$minus$minus((IterableOnce)acls)), authorizer, resource, AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    public int killRandomBroker() {
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return index;
    }

    public void killBroker(int index) {
        this.killBroker(index, Duration.ofMinutes(5L));
    }

    public void killBroker(int index, Duration timeout) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown(timeout);
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
            return;
        }
    }

    public void startBroker(int index) {
        if (!this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).startup();
            this.alive()[index] = true;
            return;
        }
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable)i -> !this.alive()[i]).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (reconfigure) {
                this._brokers().update(i, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(i)));
            }
            ((KafkaBroker)this._brokers().apply(i)).startup();
            $this.alive()[i] = true;
        });
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(names).asJava()).get();
        names.foreach((Function1 & Serializable)name -> {
            ResultOrError response = (ResultOrError)topicIdsMap.get(name);
            return (Uuid)result.put(name, response.result());
        });
        return CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        HashMap result = new HashMap();
        ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).forEach((key, value) -> result.put(value, key));
        return CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        return this.createBroker(config, this.brokerTime(config.brokerId()), false, this.createBroker$default$4());
    }

    public Seq<KafkaBroker> aliveBrokers() {
        return ((IterableOnceOps)this._brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$aliveBrokers$1(this, broker)))).toSeq();
    }

    public void ensureConsistentKRaftMetadata() {
        TestUtils$.MODULE$.ensureConsistentKRaftMetadata(this.aliveBrokers(), this.controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), new Properties()), (Function1 & Serializable)admin -> {
            Object[] objectArray = new Tuple2[1];
            String string = sanitizedClientId;
            String string2 = "<default>";
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), string != null && string.equals(string2) ? null : sanitizedClientId);
            return (Void)admin.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(configs).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String key = (String)x0$1._1();
                    String value = (String)x0$1._2();
                    return new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value))));
                }
                throw new MatchError(null);
            })).toList()).asJava()))).all().get();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaBroker s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ void $anonfun$addAndVerifyAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ void $anonfun$removeAndVerifyAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return "SCRAM credentials not created for " + clientPrincipal$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache.cache(mechanismName$1, ScramCredential.class);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aliveBrokers$1(KafkaServerTestHarness $this, KafkaBroker broker) {
        return $this.alive()[broker.config().brokerId()];
    }
}

