/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.network.Processor;
import kafka.server.ControllerServer;
import kafka.server.KafkaApis;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t]f\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006B\u0002,\u0001A\u0003%1\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"I\u0011\r\u0001a\u0001\u0002\u0004%\tA\u0019\u0005\nQ\u0002\u0001\r\u0011!Q!\neC\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u0001-\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0003Y\u0007\"C7\u0001\u0001\u0004\u0005\t\u0015)\u0003Z\u0011\u001dq\u0007\u00011A\u0005\u0002=Dq!\u001f\u0001A\u0002\u0013\u0005!\u0010\u0003\u0004}\u0001\u0001\u0006K\u0001\u001d\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0011%\t9\u0001\u0001a\u0001\n\u0003\tI\u0001C\u0004\u0002\u000e\u0001\u0001\u000b\u0015B@\t\u0017\u0005=\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011\u0003\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0003C\u0006\u00022\u0001\u0001\r\u0011!Q!\n\u0005M\u0001\"CA\u001a\u0001\t\u0007I\u0011AA\u001b\u0011!\t\t\u0005\u0001Q\u0001\n\u0005]\u0002\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005\u001d\u0003\u0002CA+\u0001\t\u0007I\u0011A$\t\u000f\u0005]\u0003\u0001)A\u0005\u0011\"I\u0011\u0011\f\u0001C\u0002\u0013\u0005\u00111\f\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002^!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002p!I\u0011\u0011\u0011\u0001C\u0002\u0013\u0005\u0011Q\u000e\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002p!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!2\u0001\t\u0003\t9\rC\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!1\u0006\u0001\u0005\u0002\t5\u0002b\u0002B\u001d\u0001\u0011\u0005!1\b\u0005\b\u0005\u000f\u0002A\u0011AAV\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003WCqAa\u0013\u0001\t\u0013\u0011i\u0005C\u0004\u0003l\u0001!IA!\u001c\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!q\u0010\u0001\u0005\u0002\t\u0005\u0005b\u0002BG\u0001\u0011%!q\u0012\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005O\u0013\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u0011q\u0007O\u0001\fS:$Xm\u001a:bi&|gNC\u0001:\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}B\u0014AB:feZ,'/\u0003\u0002B}\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005!\u0005CA#\u0001\u001b\u00051\u0014!\u00032s_.,'/\u001332+\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%aA%oi\u0006Q!M]8lKJLE-\r\u0011\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0014\u0014A\u00032s_.,'/\u001333A\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003M\u0003\"!\u0013+\n\u0005US%a\u0002\"p_2,\u0017M\\\u0001\u001aK:\f'\r\\3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007%\u0001\u0007d_:4\u0017n\u001a)s_B\u001c\u0018'F\u0001Z!\tQv,D\u0001\\\u0015\taV,\u0001\u0003vi&d'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003A\u0019wN\u001c4jOB\u0013x\u000e]:2?\u0012*\u0017\u000f\u0006\u0002dMB\u0011\u0011\nZ\u0005\u0003K*\u0013A!\u00168ji\"9q-CA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005i1m\u001c8gS\u001e\u0004&o\u001c9tc\u0001\nAbY8oM&<\u0007K]8qgJ\n\u0001cY8oM&<\u0007K]8qgJzF%Z9\u0015\u0005\rd\u0007bB4\r\u0003\u0003\u0005\r!W\u0001\u000eG>tg-[4Qe>\u00048O\r\u0011\u0002\u000f\r|gNZ5hgV\t\u0001\u000fE\u0002riZl\u0011A\u001d\u0006\u0003g*\u000b!bY8mY\u0016\u001cG/[8o\u0013\t)(OA\u0002TKF\u0004\"!P<\n\u0005at$aC&bM.\f7i\u001c8gS\u001e\f1bY8oM&<7o\u0018\u0013fcR\u00111m\u001f\u0005\bO>\t\t\u00111\u0001q\u0003!\u0019wN\u001c4jON\u0004\u0013a\u00022s_.,'o]\u000b\u0002\u007fB!\u0011\u000f^A\u0001!\ri\u00141A\u0005\u0004\u0003\u000bq$aC&bM.\f'I]8lKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u00191-a\u0003\t\u000f\u001d\u0014\u0012\u0011!a\u0001\u007f\u0006A!M]8lKJ\u001c\b%A\u0003bI6Lg.\u0006\u0002\u0002\u0014A!\u0011QCA\u0014\u001b\t\t9B\u0003\u0003\u0002\u0010\u0005e!\u0002BA\u000e\u0003;\tqa\u00197jK:$8OC\u0002:\u0003?QA!!\t\u0002$\u00051\u0011\r]1dQ\u0016T!!!\n\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0005]!!B!e[&t\u0017!C1e[&tw\fJ3r)\r\u0019\u0017q\u0006\u0005\tOV\t\t\u00111\u0001\u0002\u0014\u00051\u0011\rZ7j]\u0002\naA]1oI>lWCAA\u001c!\u0011\tI$!\u0010\u000e\u0005\u0005m\"B\u0001/K\u0013\u0011\ty$a\u000f\u0003\rI\u000bg\u000eZ8n\u0003\u001d\u0011\u0018M\u001c3p[\u0002\nQ\u0001^8qS\u000e,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014^\u0003\u0011a\u0017M\\4\n\t\u0005E\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u000f\u0003\u0019\u0019w.\\7p]&!\u0011qMA1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0010W\u000647.Y!qSNdunZ4feV\u0011\u0011q\u000e\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003\u0015awn\u001a\u001bk\u0015\u0011\tI(a\b\u0002\u000f1|wmZ5oO&!\u0011QPA:\u0005\u0019aunZ4fe\u0006\u00012.\u00194lC\u0006\u0003\u0018n\u001d'pO\u001e,'\u000fI\u0001\u0017]\u0016$xo\u001c:l!J|7-Z:t_JdunZ4fe\u00069b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004G\u0006%\u0005bBAFG\u0001\u0007\u0011QR\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qRAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015aA1qS*!\u0011qSAM\u0003\u001dQW\u000f]5uKJTA!a'\u0002$\u0005)!.\u001e8ji&!\u0011qTAI\u0005!!Vm\u001d;J]\u001a|\u0007fA\u0012\u0002$B!\u0011qRAS\u0013\u0011\t9+!%\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0019\u0007f\u0001\u0013\u00020B!\u0011qRAY\u0013\u0011\t\u0019,!%\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\t\u0005e\u00161\u0018\t\u0004cRL\u0006bBAFK\u0001\u0007\u0011QR\u0001\rgR\f'\u000f\u001e\"s_.,'o\u001d\u000b\u0004G\u0006\u0005\u0007bBAbM\u0001\u0007\u0011\u0011X\u0001\bG2,8\u000f^3s\u0003\u0001\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0015\u000b\r\fI-!9\t\u000f\u0005-w\u00051\u0001\u0002N\u00061\u0011/^8sk6\u0004B!a4\u0002^:!\u0011\u0011[Am!\r\t\u0019NS\u0007\u0003\u0003+T1!a6;\u0003\u0019a$o\\8u}%\u0019\u00111\u001c&\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t&a8\u000b\u0007\u0005m'\nC\u0004\u0002d\u001e\u0002\r!!4\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8mQ\u001d9\u0013q]Az\u0003k\u0004B!!;\u0002p6\u0011\u00111\u001e\u0006\u0005\u0003[\f)*\u0001\u0004qCJ\fWn]\u0005\u0005\u0003c\fYOA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012\u0011q_\u0001+w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBjhf\u001a:pkB\u0004&o\u001c;pG>dWh_\u0019~Q\u001d9\u00131 B\u0004\u0005\u0013\u0001B!!@\u0003\u00045\u0011\u0011q \u0006\u0005\u0005\u0003\tY/\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\u0011)!a@\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\t-\u0011E\u0001B\u0007\u0003):W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f\u0011\u0005^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012K7/\u00192mK\u0012$Ra\u0019B\n\u0005+Aq!a3)\u0001\u0004\ti\rC\u0004\u0002d\"\u0002\r!!4)\u000f!\n9/a=\u0002v\":\u0001&a?\u0003\b\tmAF\u0001B\u0006\u0003=\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3CsR{\u0007/[2Pm\u0016\u0014(/\u001b3f)\u0015\u0019'\u0011\u0005B\u0012\u0011\u001d\tY-\u000ba\u0001\u0003\u001bDq!a9*\u0001\u0004\ti\rK\u0004*\u0003O\f\u00190!>)\u000f%\nYPa\u0002\u0003*1\u0012!1B\u00011i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eR5tC\ndW\r\u001a\"z)>\u0004\u0018nY(wKJ\u0014\u0018\u000eZ3\u0015\u000b\r\u0014yC!\r\t\u000f\u0005-'\u00061\u0001\u0002N\"9\u00111\u001d\u0016A\u0002\u00055\u0007f\u0002\u0016\u0002h\u0006M\u0018Q\u001f\u0015\bU\u0005m(q\u0001B\u001cY\t\u0011Y!A\u0017uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>t\u0017J\u001c<bY&$Gk\u001c9jG>3XM\u001d:jI\u0016$Ra\u0019B\u001f\u0005\u007fAq!a3,\u0001\u0004\ti\rC\u0004\u0002d.\u0002\r!!4)\u000f-\n9/a=\u0002v\":1&a?\u0003\b\t\u0015CF\u0001B\u0006\u0003\t2XM]5gsVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\u0006\u0019c/\u001a:jMf,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0017\u0001C4fi\u001e\u000bWoZ3\u0015\t\t=#q\r\t\u0005\u0005#\u0012\u0019'\u0004\u0002\u0003T)!!Q\u000bB,\u0003\u0011\u0019wN]3\u000b\t\te#1L\u0001\b[\u0016$(/[2t\u0015\u0011\u0011iFa\u0018\u0002\re\fW.\\3s\u0015\t\u0011\t'A\u0002d_6LAA!\u001a\u0003T\t)Q*\u001a;fe\"9!\u0011\u000e\u0018A\u0002\u00055\u0017AC7fiJL7MT1nK\u0006q1\u000f[;uI><hN\u0011:pW\u0016\u0014HcA2\u0003p!9!\u0011O\u0018A\u0002\u0005\u0005\u0011A\u00022s_.,'/\u0001\nd_:\u001cX/\\3BY2lUm]:bO\u0016\u001cHC\u0002B<\u0005s\u0012Y\b\u0005\u0003ri\u00065\u0007bBA\"a\u0001\u0007\u0011Q\u001a\u0005\u0007\u0005{\u0002\u0004\u0019\u0001%\u0002\u00179,X.T3tg\u0006<Wm]\u0001:i\u0016\u001cH\u000fV8qS\u000e,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK^KG\u000f[!mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5hgR)1Ma!\u0003\u0006\"9\u00111Z\u0019A\u0002\u00055\u0007bBArc\u0001\u0007\u0011Q\u001a\u0015\bc\u0005\u001d\u00181_A{Q\u001d\t\u00141 B\u0004\u0005\u0017c#Aa\u0003\u0002#\u0005dG/\u001a:U_BL7mQ8oM&<7\u000f\u0006\u0005\u0003\u0012\n]%1\u0014BO!\u0011\t)Ba%\n\t\tU\u0015q\u0003\u0002\u0013\u00032$XM]\"p]\u001aLwm\u001d*fgVdG\u000fC\u0004\u0003\u001aJ\u0002\r!a\u0005\u0002\u0017\u0005$W.\u001b8DY&,g\u000e\u001e\u0005\b\u0003\u0007\u0012\u0004\u0019AAg\u0011\u0019\u0011yJ\ra\u00013\u0006aAo\u001c9jG\u000e{gNZ5hg\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\u0005\u0005M\u0011aI<bSR4uN\u001d(p\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d%bg>cG\rT3bI\u0016\u0014\u0018\n\u001a\u000b\u0006G\n%&1\u0017\u0005\b\u0005W#\u0004\u0019\u0001BW\u00035iW\r^1eCR\f7)Y2iKB\u0019QHa,\n\u0007\tEfHA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\u0007\u0005k#\u0004\u0019\u0001%\u0002\u00111,\u0017\rZ3s\u0013\u0012\u0004")
public class UncleanLeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1;
    private Properties configProps2;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaBroker> brokers = (Seq)Seq$.MODULE$.empty();
    private Admin admin;
    private final Random random = new Random();
    private final String topic = "topic" + this.random().nextLong();
    private final int partitionId;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partitionId());
    private final Logger kafkaApisLogger = LogManager.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = LogManager.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)configProps -> configProps.put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown())));
        Configurator.setLevel((String)this.kafkaApisLogger().getName(), (Level)Level.FATAL);
        Configurator.setLevel((String)this.networkProcessorLogger().getName(), (Level)Level.FATAL);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)broker -> {
            CoreUtils$.MODULE$.delete(broker.config().logDirs());
            return BoxedUnit.UNIT;
        });
        Configurator.setLevel((String)this.kafkaApisLogger().getName(), (Level)Level.ERROR);
        Configurator.setLevel((String)this.networkProcessorLogger().getName(), (Level)Level.ERROR);
        this.admin().close();
        super.tearDown();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties properties = new Properties();
        if (((Method)testInfo.getTestMethod().get()).getName().contains("testUncleanLeaderElectionEnabled")) {
            properties.setProperty("unclean.leader.election.enable", "true");
        }
        properties.setProperty("unclean.leader.election.interval.ms", "10");
        return new .colon.colon((Object)properties, (List)Nil$.MODULE$);
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
        Properties adminConfigs = new Properties();
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), adminConfigs));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionEnabled(String quorum, String groupProtocol) {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionDisabled(String quorum, String groupProtocol) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionEnabledByTopicOverride(String quorum, String groupProtocol) {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$7 = 1;
        int x$8 = 1;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionDisabledByTopicOverride(String quorum, String groupProtocol) {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$7 = 1;
        int x$8 = 1;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionInvalidTopicOverride(String quorum, String groupProtocol) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Admin x$1 = this.admin();
            String x$2 = this.topic();
            Seq<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
            int x$7 = 1;
            int x$8 = 1;
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        });
        Assertions.assertEquals(InvalidConfigurationException.class, e.getCause().getClass());
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Leader for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)})));
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)("Leader id is set to expected value for topic: " + this.topic()));
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Follower for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)})));
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(leaderId, x$4)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$7(followerId, x$5))).get()).startup();
        Seq<KafkaBroker> x$1 = this.brokers();
        TopicPartition x$2 = this.topicPartition();
        Some x$3 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$52 = None$.MODULE$;
        TestUtils$.MODULE$.awaitLeaderChange(x$1, x$2, (Option<Object>)x$52, (Option<Object>)x$3, 30000L);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)1L, (long)uncleanLeaderElectionsPerSec);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Leader for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)})));
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)("Leader id is set to expected value for topic: " + this.topic()));
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Follower for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)})));
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(leaderId, x$6)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        KafkaBroker followerServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$7(followerId, x$7))).get();
        followerServer.startup();
        this.waitForNoLeaderAndIsrHasOldLeaderId(followerServer.replicaManager().metadataCache(), leaderId);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaBroker> x$1 = this.brokers();
            String x$2 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$1, x$2, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, x$8))).get()).startup();
        Seq<KafkaBroker> x$72 = this.brokers();
        TopicPartition x$82 = this.topicPartition();
        Some x$92 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        None$ x$10 = None$.MODULE$;
        long x$11 = 15000L;
        TestUtils$.MODULE$.awaitLeaderChange(x$72, x$82, (Option<Object>)x$10, (Option<Object>)x$92, x$11);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$10(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Inconsistent metadata after first server startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(leaderId, x$9)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        Seq<KafkaBroker> x$12 = this.brokers();
        TopicPartition x$13 = this.topicPartition();
        Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$15 = None$.MODULE$;
        long x$16 = 15000L;
        TestUtils$.MODULE$.awaitLeaderChange(x$12, x$13, (Option<Object>)x$15, (Option<Object>)x$14, x$16);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private Meter getGauge(String metricName) {
        return (Meter)((Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$getGauge$1(metricName, x0$1))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("Unable to find metric " + metricName));
        }))._2();
    }

    private void shutdownBroker(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        GroupProtocol x$2 = this.groupProtocolFromTestParameters();
        String x$3 = "group" + this.random().nextLong();
        StringDeserializer x$5 = new StringDeserializer();
        String x$6 = "earliest";
        boolean x$7 = false;
        int x$8 = 500;
        SecurityProtocol x$9 = SecurityProtocol.PLAINTEXT;
        None$ x$102 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        try (Consumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$3, x$6, false, x$7, x$8, x$9, (Option<File>)x$102, (Option<Properties>)x$11, x$12, x$5);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, 15000L).map((Function1 & Serializable)x$10 -> (String)x$10.value());
        }
        return seq;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs(String quorum, String groupProtocol) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        try (Admin adminClient = this.createAdminClient();){
            Properties newProps = new Properties();
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
            this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            Seq<KafkaBroker> x$9 = this.brokers();
            TopicPartition x$10 = this.topicPartition();
            Some x$112 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            None$ x$13 = None$.MODULE$;
            TestUtils$.MODULE$.awaitLeaderChange(x$9, x$10, (Option<Object>)x$13, (Option<Object>)x$112, 10000L);
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "false");
            this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            Seq<KafkaBroker> x$14 = this.brokers();
            TopicPartition x$15 = this.topicPartition();
            Some x$16 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            None$ x$18 = None$.MODULE$;
            TestUtils$.MODULE$.awaitLeaderChange(x$14, x$15, (Option<Object>)x$18, (Option<Object>)x$16, 10000L);
        }
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$1(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$3(leaderId, x$11)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        KafkaBroker followerBroker = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$5(followerId, x$12))).get();
        followerBroker.startup();
        this.waitForNoLeaderAndIsrHasOldLeaderId(followerBroker.replicaManager().metadataCache(), leaderId);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaBroker> x$19 = this.brokers();
            String x$20 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$19, x$20, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        try (Admin adminClient2 = this.createAdminClient();){
            Properties newProps = new Properties();
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
            this.alterTopicConfigs(adminClient2, this.topic(), newProps).all().get();
        }
        Seq<KafkaBroker> x$25 = this.brokers();
        TopicPartition x$26 = this.topicPartition();
        Some x$27 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$29 = None$.MODULE$;
        TestUtils$.MODULE$.awaitLeaderChange(x$25, x$26, (Option<Object>)x$29, (Option<Object>)x$27, 30000L);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)1L, (long)uncleanLeaderElectionsPerSec);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfigs).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new ConfigEntry(k, v);
            }
            throw new MatchError(null);
        })).toList()).asJava();
        return adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(configEntries).asScala().map((Function1 & Serializable)e -> new AlterConfigOp(e, AlterConfigOp.OpType.SET))).toSeq()).asJavaCollection())}))).asJava());
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForNoLeaderAndIsrHasOldLeaderId(MetadataCache metadataCache, int leaderId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$waitForNoLeaderAndIsrHasOldLeaderId$1(this, metadataCache, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$waitForNoLeaderAndIsrHasOldLeaderId$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker broker = $this.createBroker(config, $this.createBroker$default$2(), $this.createBroker$default$3(), $this.createBroker$default$4());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((IterableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$))));
        $this.brokers_$eq((Seq<KafkaBroker>)((Seq)$this.brokers().$plus$plus((IterableOnce)new .colon.colon((Object)broker, (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$5(int leaderId$1, KafkaBroker x$4) {
        return x$4.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$7(int followerId$1, KafkaBroker x$5) {
        return x$5.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$5(int leaderId$2, KafkaBroker x$6) {
        return x$6.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$7(int followerId$2, KafkaBroker x$7) {
        return x$7.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaBroker x$8) {
        return x$8.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$10(UncleanLeaderElectionTest $this, KafkaBroker followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getLeaderAndIsr($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((LeaderAndIsr)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$11() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$12(int leaderId$2, KafkaBroker x$9) {
        return x$9.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getName().endsWith(metricName$1);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$1(int followerId$3, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$3(int leaderId$3, KafkaBroker x$11) {
        return x$11.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$5(int followerId$3, KafkaBroker x$12) {
        return x$12.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$waitForNoLeaderAndIsrHasOldLeaderId$1(UncleanLeaderElectionTest $this, MetadataCache metadataCache$1, int leaderId$4) {
        return metadataCache$1.getLeaderAndIsr($this.topic(), $this.partitionId()).isDefined() && ((LeaderAndIsr)metadataCache$1.getLeaderAndIsr($this.topic(), $this.partitionId()).get()).leader() == -1 && ((Object)Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{leaderId$4}))).equals(((LeaderAndIsr)metadataCache$1.getLeaderAndIsr($this.topic(), $this.partitionId()).get()).isr());
    }

    public static final /* synthetic */ String $anonfun$waitForNoLeaderAndIsrHasOldLeaderId$2(UncleanLeaderElectionTest $this) {
        return "Timed out waiting for broker metadata cache updates the info for topic partition:" + $this.topicPartition();
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

