/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kafka.log.BrokerCompressionTest$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0001#\u0011\u0019i\u0003\u0001)A\u0005G!9a\u0006\u0001b\u0001\n\u0003y\u0003BB\u001f\u0001A\u0003%\u0001\u0007C\u0004?\u0001\t\u0007I\u0011A \t\r%\u0003\u0001\u0015!\u0003A\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015Q\u0006\u0001\"\u0001\\\u000f\u0019y\u0018\u0003#\u0001\u0002\u0002\u00191\u0001#\u0005E\u0001\u0003\u0007Aa!H\u0007\u0005\u0002\u0005\u0015\u0001B\u0002@\u000e\t\u0003\t9AA\u000bCe>\\WM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005I\u0019\u0012a\u00017pO*\tA#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002#\u00051A/\u001c9ESJ,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\n!![8\u000b\u0003!\nAA[1wC&\u0011!&\n\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nA\u0001^5nKV\t\u0001\u0007\u0005\u00022w5\t!G\u0003\u00024i\u0005!Q\u000f^5m\u0015\t)d'\u0001\u0004tKJ4XM\u001d\u0006\u0003)]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011AH\r\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005IAn\\4D_:4\u0017nZ\u000b\u0002\u0001B\u0011\u0011iR\u0007\u0002\u0005*\u0011!c\u0011\u0006\u0003\t\u0016\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005\u00193\u0014aB:u_J\fw-Z\u0005\u0003\u0011\n\u0013\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005a\u0005C\u0001\rN\u0013\tq\u0015D\u0001\u0003V]&$\bF\u0001\u0006Q!\t\t\u0006,D\u0001S\u0015\t\u0019F+A\u0002ba&T!!\u0016,\u0002\u000f),\b/\u001b;fe*\u0011q+O\u0001\u0006UVt\u0017\u000e^\u0005\u00033J\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00023Q,7\u000f\u001e\"s_.,'oU5eK\u000e{W\u000e\u001d:fgNLwN\u001c\u000b\u0004\u0019r3\u0007\"B/\f\u0001\u0004q\u0016AF7fgN\fw-Z\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017A\u0002:fG>\u0014HM\u0003\u0002dm\u000511m\\7n_:L!!\u001a1\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016DQaZ\u0006A\u0002!\fQC\u0019:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)f\u0004X\r\u0005\u0002jW6\t!N\u0003\u0002bi%\u0011AN\u001b\u0002\u0016\u0005J|7.\u001a:D_6\u0004(/Z:tS>tG+\u001f9fQ\tYa\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r)\u00061\u0001/\u0019:b[NL!a\u001d9\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\fknd\bC\u0001<z\u001b\u00059(B\u0001=q\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u0001>x\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\u0005i\u0018%\u0001@\u0002\u0015A\f'/Y7fi\u0016\u00148/A\u000bCe>\\WM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u0011\u0005\u0001j1CA\u0007\u0018)\t\t\t!\u0006\u0002\u0002\nA1\u00111BA\n\u0003/i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0007gR\u0014X-Y7\u000b\u0005M:\u0013\u0002BA\u000b\u0003\u001b\u0011aa\u0015;sK\u0006l\u0007c\u0001<\u0002\u001a%\u0019\u00111D<\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class BrokerCompressionTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());
    private final MockTime time = new MockTime(0L, 0L);
    private final LogConfig logConfig = new LogConfig((Map)new Properties());

    public static Stream<Arguments> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testBrokerSideCompression(CompressionType messageCompressionType, BrokerCompressionType brokerCompressionType) {
        void withRecords_records;
        Compression messageCompression = Compression.of((CompressionType)messageCompressionType).build();
        Properties logProps = new Properties();
        logProps.put("compression.type", brokerCompressionType.name);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps);
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        UnifiedLog log = UnifiedLog$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, 600000, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())};
        int withRecords_partitionLeaderEpoch = 0;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)messageCompression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        if (!brokerCompressionType.equals(BrokerCompressionType.PRODUCER)) {
            Assertions.assertEquals((Object)BrokerCompressionType.targetCompression((Optional)log.config().compression, null).type(), (Object)BrokerCompressionTest.readBatch$1(0, log).compressionType(), (String)("Compression at offset 0 should produce " + brokerCompressionType));
            return;
        }
        Assertions.assertEquals((Object)messageCompressionType, (Object)BrokerCompressionTest.readBatch$1(0, log).compressionType(), (String)("Compression at offset 0 should produce " + messageCompressionType));
    }

    private static final RecordBatch readBatch$1(int offset, UnifiedLog log$1) {
        return (RecordBatch)log$1.read((long)((long)offset), (int)4096, (FetchIsolation)FetchIsolation.LOG_END, (boolean)true).records.batches().iterator().next();
    }
}

