/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.UnifiedLog;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\f\u0018\u0001qAQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u0001,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u00031\u0004B\u0002#\u0001A\u0003%q\u0007C\u0004F\u0001\t\u0007I\u0011\u0001$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u001dY\u0005A1A\u0005\u0002-Ba\u0001\u0014\u0001!\u0002\u0013a\u0003bB'\u0001\u0005\u0004%\tA\u0014\u0005\u00071\u0002\u0001\u000b\u0011B(\t\u000be\u0003A\u0011\u0001.\t\u000bq\u0004A\u0011B?\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\u001d9\u0011qH\f\t\u0002\u0005\u0005cA\u0002\f\u0018\u0011\u0003\t\u0019\u0005\u0003\u0004(%\u0011\u0005\u00111\n\u0005\b\u0003\u001b\u0012B\u0011AA(\u0011\u0019Y(\u0003\"\u0001\u0002x\taBj\\4DY\u0016\fg.\u001a:MC\u001eLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\r\u001a\u0003\rawn\u001a\u0006\u00025\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001eCA\u0011adH\u0007\u0002/%\u0011\u0001e\u0006\u0002\"\u0003\n\u001cHO]1di2{wm\u00117fC:,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003E\u0015j\u0011a\t\u0006\u0003Ie\tQ!\u001e;jYNL!AJ\u0012\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003=\u0001\t\u0011\"\\:QKJDu.\u001e:\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u00121!\u00138u\u0003)i7\u000fU3s\u0011>,(\u000fI\u0001\u0011[&t7i\\7qC\u000e$\u0018n\u001c8MC\u001e\f\u0011#\\5o\u0007>l\u0007/Y2uS>tG*Y4!\u0003\u0011!\u0018.\\3\u0016\u0003]\u0002\"\u0001\u000f\"\u000e\u0003eR!AO\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003yu\naa]3sm\u0016\u0014(B\u0001\u000e?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rK$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!\rdW-\u00198fe\n\u000b7m[(gM6\u001bX#A$\u0011\u00055B\u0015BA%/\u0005\u0011auN\\4\u0002#\rdW-\u00198fe\n\u000b7m[(gM6\u001b\b%A\u0006tK\u001elWM\u001c;TSj,\u0017\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003=\u00032!\f)S\u0013\t\tfFA\u0003BeJ\f\u0017\u0010\u0005\u0002T-6\tAK\u0003\u0002V{\u000511m\\7n_:L!a\u0016+\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\fG2,\u0017M\\3s)\u0016\u001cH\u000f\u0006\u0002\\=B\u0011Q\u0006X\u0005\u0003;:\u0012A!\u00168ji\")qL\u0004a\u0001A\u0006y1m\\7qe\u0016\u001c8/[8o)f\u0004X\r\u0005\u0002bI6\t!M\u0003\u0002d)\u00061!/Z2pe\u0012L!!\u001a2\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016D#AD4\u0011\u0005!|W\"A5\u000b\u0005)\\\u0017A\u00029be\u0006l7O\u0003\u0002m[\u00069!.\u001e9ji\u0016\u0014(B\u00018A\u0003\u0015QWO\\5u\u0013\t\u0001\u0018NA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDCA\u0004:ysB\u00111O^\u0007\u0002i*\u0011Q/[\u0001\taJ|g/\u001b3fe&\u0011q\u000f\u001e\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0002u\u0006\n10\u0001\u0006qCJ\fW.\u001a;feN\f1B]3bI\u001a\u0013x.\u001c'pOR\u0019a0a\u0004\u0011\u000b}\f)!!\u0003\u000e\u0005\u0005\u0005!bAA\u0002]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\t\u0013R,'/\u00192mKB)Q&a\u0003-Y%\u0019\u0011Q\u0002\u0018\u0003\rQ+\b\u000f\\33\u0011\u0019Ar\u00021\u0001\u0002\u0012A\u0019a$a\u0005\n\u0007\u0005UqC\u0001\u0006V]&4\u0017.\u001a3M_\u001e\f\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u0019\u0005m\u0011\u0011EA\u0013\u0003S\tY#a\u000f\u0011\u000b}\fi\"!\u0003\n\t\u0005}\u0011\u0011\u0001\u0002\u0004'\u0016\f\bBBA\u0012!\u0001\u0007A&A\u0004ok6\\U-_:\t\r\u0005\u001d\u0002\u00031\u0001-\u0003\u001dqW/\u001c#vaNDa\u0001\u0007\tA\u0002\u0005E\u0001bBA\u0017!\u0001\u0007\u0011qF\u0001\u0006G>$Wm\u0019\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007+\u0002\u0011\r|W\u000e\u001d:fgNLA!!\u000f\u00024\tY1i\\7qe\u0016\u001c8/[8o\u0011\u0019\ti\u0004\u0005a\u0001\u000f\u0006IA/[7fgR\fW\u000e]\u0001\u001d\u0019><7\t\\3b]\u0016\u0014H*Y4J]R,wM]1uS>tG+Z:u!\tq\"cE\u0002\u0013\u0003\u000b\u00022!LA$\u0013\r\tIE\f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0005\u0013\u0001D8oKB\u000b'/Y7fi\u0016\u0014XCAA)!\u0019\t\u0019&a\u0017\u0002`5\u0011\u0011Q\u000b\u0006\u0004u\u0005]#BAA-\u0003\u0011Q\u0017M^1\n\t\u0005u\u0013Q\u000b\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003B\u0017Q\u0003C\u0002B!a\u0019\u0002r9!\u0011QMA7!\r\t9GL\u0007\u0003\u0003SR1!a\u001b\u001c\u0003\u0019a$o\\8u}%\u0019\u0011q\u000e\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(!\u001e\u0003\rM#(/\u001b8h\u0015\r\tyGL\u000b\u0003\u0003s\u0002b!a\u001f\u0002\u0002\u0006\u0015UBAA?\u0015\u0011\ty(!\u0016\u0002\rM$(/Z1n\u0013\u0011\t\u0019)! \u0003\rM#(/Z1n!\r\u0019\u0018qQ\u0005\u0004\u0003\u0013#(!C!sOVlWM\u001c;t\u0001")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final int msPerHour;
    private final int minCompactionLag = 1 * this.msPerHour();
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Stream<Arguments> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int minCompactionLag() {
        return this.minCompactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void cleanerTest(CompressionType compressionType) {
        Compression codec = Compression.of((CompressionType)compressionType).build();
        ArraySeq.ofRef x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$22 = this.cleanerBackOffMs();
        long x$3 = this.minCompactionLag();
        int x$4 = this.segmentSize();
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        int x$7 = this.makeCleaner$default$5();
        int x$8 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$5, x$6, x$22, x$7, x$3, x$8, x$4, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, codec, T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "total log size at T0: " + startSizeBlock0);
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "active segment at T0 has base offset: " + activeSegAtT0.baseOffset());
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "log size up to base offset of active segment at T0: " + sizeUpToActiveSegmentAtT0);
        this.cleaner().startup();
        this.time().sleep((long)(this.minCompactionLag() / 2));
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the compaction lag has passed");
        this.time().sleep((long)(this.minCompactionLag() / 2 + 1));
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, codec, T1));
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$122 = new TopicPartition("log", 0);
        long x$13 = activeSegAtT0.baseOffset();
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$122, x$13, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assertions.assertEquals((Object)appends1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)read1.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)"Contents of the map shouldn't change.");
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "after cleaning the compacted size up to active segment at T0: " + compactedSize);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0, (String)("log cleaner should have processed up to offset " + firstBlock1SegmentBaseOffset + ", but lastCleaned=" + lastCleaned));
        Assertions.assertTrue((sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0, (String)("log should have been compacted: size up to offset of active segment at T0=" + sizeUpToActiveSegmentAtT0 + " compacted size=" + compactedSize));
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)record -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())));
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }));
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, UnifiedLog log, Compression codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$3 -> LogCleanerLagIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, timestamp, BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(LogCleanerLagIntegrationTest $this, UnifiedLog log$1, Compression codec$1, long timestamp$1, int key) {
        int count = $this.counter();
        byte[] x$1 = Integer.toString($this.counter()).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = 2;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        log$1.updateHighWatermark(log$1.logEndOffset());
        $this.incCounter();
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(LogCleanerLagIntegrationTest $this, int numKeys$1, UnifiedLog log$1, Compression codec$1, long timestamp$1, int x$3) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> LogCleanerLagIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, timestamp$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public LogCleanerLagIntegrationTest() {
        this.msPerHour = 3600000;
        Assertions.assertTrue((this.minCompactionLag() % 2 == 0 ? 1 : 0) != 0, (String)"compactionLag must be divisible by 2 for this test");
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};
    }
}

