/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.checkpoint.OffsetCheckpointFile;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dBq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00049\u0001\u0001\u0006Ia\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u00199\u0005\u0001)A\u0005w!)\u0001\n\u0001C\u0001\u0013\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!/\u0001\t\u0003\tY\fC\u0004\u0002D\u0002!I!!2\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011\u0011 \u0001\u0005\n\u0005m\bb\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011%\u0011)\u0005AI\u0001\n\u0013\u00119eB\u0003l9!\u0005ANB\u0003\u001c9!\u0005Q\u000eC\u0003''\u0011\u0005\u0011O\u0002\u0003s'\u0001\u0019\b\"\u0002\u0014\u0016\t\u0003y\bbBA\u0003+\u0011\u0005\u0013q\u0001\u0004\u0007\u0003\u0007\u001a\u0002!!\u0012\t\r\u0019BB\u0011AA$\u0011\u001d\t)\u0001\u0007C!\u0003\u0017\u0012a\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u\u0015\tib$A\u0002m_\u001eT\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0005\u0005\u0002$I5\tA$\u0003\u0002&9\t\t\u0013IY:ue\u0006\u001cG\u000fT8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003G\u0001\tA\u0001^5nKV\t1\u0006\u0005\u0002-m5\tQF\u0003\u0002/_\u0005!Q\u000f^5m\u0015\t\u0001\u0014'\u0001\u0004tKJ4XM\u001d\u0006\u0003?IR!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO&\u0011q'\f\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001<!\rat(Q\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t)\u0011I\u001d:bsB\u0011!)R\u0007\u0002\u0007*\u0011A)M\u0001\u0007G>lWn\u001c8\n\u0005\u0019\u001b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002\n1b\u00197fC:,'\u000fV3tiR\u0011!*\u0014\t\u0003y-K!\u0001T\u001f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001a\u0001\raT\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qKB\u0011\u0001kU\u0007\u0002#*\u0011!kQ\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005Q\u000b&aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3)\u0005\u00191\u0006CA,_\u001b\u0005A&BA-[\u0003\u0019\u0001\u0018M]1ng*\u00111\fX\u0001\bUV\u0004\u0018\u000e^3s\u0015\tiF'A\u0003kk:LG/\u0003\u0002`1\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\t\u0019\tw\r\u001b\t\u0003E\u0016l\u0011a\u0019\u0006\u0003Ib\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0003M\u000e\u0014q\"\u0011:hk6,g\u000e^:T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002SB\u0011!.\u0006\b\u0003GI\ta\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u!\t\u00193c\u0005\u0002\u0014]B\u0011Ah\\\u0005\u0003av\u0012a!\u00118z%\u00164G#\u00017\u0003\u001f\u0005cGnQ8naJ,7o]5p]N\u001c2!\u0006;}!\t)(0D\u0001w\u0015\t9\b0\u0001\u0003mC:<'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014aa\u00142kK\u000e$\bC\u00012~\u0013\tq8MA\tBe\u001e,X.\u001a8ugB\u0013xN^5eKJ$\"!!\u0001\u0011\u0007\u0005\rQ#D\u0001\u0014\u0003A\u0001(o\u001c<jI\u0016\f%oZ;nK:$8\u000f\u0006\u0003\u0002\n\u0005=\u0002\u0007BA\u0006\u0003;\u0001b!!\u0004\u0002\u0016\u0005eQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\rM$(/Z1n\u0015\tq\u00030\u0003\u0003\u0002\u0018\u0005=!AB*ue\u0016\fW\u000e\u0005\u0003\u0002\u001c\u0005uA\u0002\u0001\u0003\f\u0003?9\u0012\u0011!A\u0001\u0006\u0003\t\tCA\u0002`IE\nB!a\t\u0002*A\u0019A(!\n\n\u0007\u0005\u001dRHA\u0004O_RD\u0017N\\4\u0011\u0007\t\fY#C\u0002\u0002.\r\u0014\u0011\"\u0011:hk6,g\u000e^:\t\u000f\u0005Er\u00031\u0001\u00024\u000591m\u001c8uKb$\b\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\nKb$XM\\:j_:T1!!\u0010[\u0003\r\t\u0007/[\u0005\u0005\u0003\u0003\n9D\u0001\tFqR,gn]5p]\u000e{g\u000e^3yi\nYQ\t_2mk\u0012,'l\u001d;e'\rAB\u000f \u000b\u0003\u0003\u0013\u00022!a\u0001\u0019)\u0011\ti%a\u00161\t\u0005=\u00131\u000b\t\u0007\u0003\u001b\t)\"!\u0015\u0011\t\u0005m\u00111\u000b\u0003\f\u0003+R\u0012\u0011!A\u0001\u0006\u0003\t\tCA\u0002`IIBq!!\r\u001b\u0001\u0004\t\u0019$A\u0014uKN$8\t\\3b]N\u001cu.\u001c2j]\u0016$7i\\7qC\u000e$\u0018I\u001c3EK2,G/\u001a+pa&\u001cGc\u0001&\u0002^!)aj\u0002a\u0001\u001f\"\u0012qA\u0016\u0015\u0005\u000f\u0005<\u0007.\u0001\u0012uKN$8\t\\3b]\u0016\u0014x+\u001b;i\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;WaY\u000bdK\r\u000b\u0004\u0015\u0006\u001d\u0004\"\u0002(\t\u0001\u0004y\u0005F\u0001\u0005WQ\u0015A\u0011mZA7G\t\ty\u0007\u0005\u0002k1\u0005\u0011C/Z:u\u00072,\u0017M\\5oO:+7\u000f^3e\u001b\u0016\u001c8/Y4fg^KG\u000f\u001b,1-F\"2ASA;\u0011\u0015q\u0015\u00021\u0001PQ\tIa\u000bK\u0003\nC\u001e\fi'A\u000edQ\u0016\u001c7\u000eT8h\u0003\u001a$XM]\"p]Z,'\u000f^5oOR{gK\r\u000b\n\u0015\u0006}\u0014\u0011QAE\u0003'CQA\u0014\u0006A\u0002=Ca!\b\u0006A\u0002\u0005\r\u0005cA\u0012\u0002\u0006&\u0019\u0011q\u0011\u000f\u0003\u0015Us\u0017NZ5fI2{w\rC\u0004\u0002\f*\u0001\r!!$\u0002\u001bQLW.Z:uC6\u0004H+\u001f9f!\r\u0001\u0016qR\u0005\u0004\u0003#\u000b&!\u0004+j[\u0016\u001cH/Y7q)f\u0004X\rC\u0004\u0002\u0016*\u0001\r!a&\u0002C-,\u0017p\u001d$peZ\u0003$+Z2pe\u0012\u001cx+\u001b;i\u001d>4\u0016G\u0016\u001aVa\u0012\fG/Z:\u0011\r\u0005e\u0015qTAR\u001b\t\tYJC\u0002\u0002\u001ev\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a'\u0003\u0007M+G\u000f\u0005\u0003\u0002&\u0006Mf\u0002BAT\u0003_\u00032!!+>\u001b\t\tYKC\u0002\u0002.\u0002\na\u0001\u0010:p_Rt\u0014bAAY{\u00051\u0001K]3eK\u001aLA!!.\u00028\n11\u000b\u001e:j]\u001eT1!!->\u0003]\u0019G.Z1oKJ\u001cuN\u001c4jOV\u0003H-\u0019;f)\u0016\u001cH\u000fF\u0002K\u0003{CQAT\u0006A\u0002=C#a\u0003,)\t-\tw\r[\u0001\u0011G\",7m\u001b'bgR\u001cE.Z1oK\u0012$rASAd\u0003\u0017\f)\u000eC\u0004\u0002J2\u0001\r!a)\u0002\u000bQ|\u0007/[2\t\u000f\u00055G\u00021\u0001\u0002P\u0006Y\u0001/\u0019:uSRLwN\\%e!\ra\u0014\u0011[\u0005\u0004\u0003'l$aA%oi\"9\u0011q\u001b\u0007A\u0002\u0005e\u0017A\u00034jeN$H)\u001b:usB\u0019A(a7\n\u0007\u0005uWH\u0001\u0003M_:<\u0017AG2iK\u000e\\Gj\\4BMR,'/\u00119qK:$\u0017N\\4EkB\u001cHc\u0002&\u0002d\u0006\u0015\u0018\u0011\u001e\u0005\u0007;5\u0001\r!a!\t\u000f\u0005\u001dX\u00021\u0001\u0002Z\u0006I1\u000f^1siNK'0\u001a\u0005\b\u0003Wl\u0001\u0019AAw\u0003\u001d\t\u0007\u000f]3oIN\u0004b!!'\u0002p\u0006M\u0018\u0002BAy\u00037\u00131aU3r!%a\u0014Q_Ah\u0003G\u000bI.C\u0002\u0002xv\u0012a\u0001V;qY\u0016\u001c\u0014!\u0002;p\u001b\u0006\u0004H\u0003BA\u007f\u0005\u0013\u0001\u0002\"!'\u0002\u0000\u0006='1A\u0005\u0005\u0005\u0003\tYJA\u0002NCB\u0004r\u0001\u0010B\u0003\u0003G\u000bI.C\u0002\u0003\bu\u0012a\u0001V;qY\u0016\u0014\u0004b\u0002B\u0006\u001d\u0001\u0007!QB\u0001\t[\u0016\u001c8/Y4fgB1\u0011\u0011\u0014B\b\u0003gLAA!\u0005\u0002\u001c\nA\u0011\n^3sC\ndW-A\u0006sK\u0006$gI]8n\u0019><G\u0003\u0002B\u0007\u0005/Aa!H\bA\u0002\u0005\r\u0015!G<sSR,G)\u001e9t'&tw\r\\3NKN\u001c\u0018mZ3TKR$b\"!<\u0003\u001e\t\u0005\"Q\u0005B\u0014\u0005o\u0011Y\u0004C\u0004\u0003 A\u0001\r!a4\u0002\u000f9,XnS3zg\"9!1\u0005\tA\u0002\u0005=\u0017a\u00028v[\u0012+\bo\u001d\u0005\u0007;A\u0001\r!a!\t\u000f\t%\u0002\u00031\u0001\u0003,\u0005)1m\u001c3fGB!!Q\u0006B\u001a\u001b\t\u0011yCC\u0002\u00032\r\u000b\u0001bY8naJ,7o]\u0005\u0005\u0005k\u0011yCA\u0006D_6\u0004(/Z:tS>t\u0007\"\u0003B\u001d!A\u0005\t\u0019AAh\u0003!\u0019H/\u0019:u\u0017\u0016L\bb\u0002B\u001f!\u0001\u0007!qH\u0001\u000b[\u0006<\u0017n\u0019,bYV,\u0007c\u0001\u001f\u0003B%\u0019!1I\u001f\u0003\t\tKH/Z\u0001$oJLG/\u001a#vaN\u001c\u0016N\\4mK6+7o]1hKN+G\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011IE\u000b\u0003\u0002P\n-3F\u0001B'!\u0011\u0011yE!\u0017\u000e\u0005\tE#\u0002\u0002B*\u0005+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]S(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0017\u0003R\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)};

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType compressionType) {
        void var5_5;
        void var6_6;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var6_6.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)("log should have been compacted: startSize=" + startSize + " compactedSize=" + compactedSize));
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)var6_6, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        int x$12 = largeMessageKey + 1;
        byte x$17 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(100, 3, log, codec, x$12, x$17);
        Seq appends2 = (Seq)((IterableOps)appends.$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var5_5, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dups);
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), null).read().containsKey(this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType compressionType) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put("retention.ms", retentionMs);
        logProps.put("cleanup.policy", "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, compressionType);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        long endOffset = var5_5.logEndOffset();
        var5_5.logSegments().forEach(x$4 -> x$4.setLastModified(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$3((UnifiedLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for deletion of old segments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cleaner().shutdown();
        this.closeLog((UnifiedLog)var5_5);
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, compressionType);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log2 = (UnifiedLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((UnifiedLog)var9_11);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)var10_12), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0V1V2(CompressionType compressionType) {
        void var5_5;
        void var6_6;
        int largeMessageKey = 20;
        Compression compression = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, compression);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        NoCompression noCompression = Compression.NONE;
        int maxMessageSize = !(noCompression != null ? !noCompression.equals(compression) : compression != null) ? var6_6.sizeInBytes() : var6_6.sizeInBytes() + 6;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$72 = this.makeCleaner$default$7();
        int x$82 = this.makeCleaner$default$8();
        long x$92 = this.makeCleaner$default$9();
        Option<Object> x$102 = this.makeCleaner$default$10();
        Properties x$112 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$72, x$82, x$92, x$102, x$112));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$13 = this.logConfigProperties$default$1();
        float x$14 = this.logConfigProperties$default$3();
        long x$15 = this.logConfigProperties$default$4();
        int x$16 = this.logConfigProperties$default$5();
        int x$17 = this.logConfigProperties$default$6();
        long x$18 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$13, maxMessageSize, x$14, x$15, x$16, x$17, x$18);
        props.put("message.timestamp.type", TimestampType.LOG_APPEND_TIME.name);
        LogConfig logConfig = new LogConfig((java.util.Map)props);
        log.updateConfig(logConfig);
        int x$24 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends1 = this.writeDups(100, 3, log, compression, x$24, (byte)0);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)("log should have been compacted: startSize=" + startSize + " compactedSize=" + compactedSize));
        this.checkLogAfterAppendingDups(log, startSize, appends1);
        int x$30 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(40, 3, log, compression, x$30, (byte)0);
        LogAppendInfo appendInfo = log.appendAsLeaderWithRecordVersion((MemoryRecords)var6_6, 0, RecordVersion.V0);
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = appendInfo.firstOffset();
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(40, 3, log, compression, 30, (byte)1);
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(5, 3, log, compression, 15, (byte)2);
        scala.collection.immutable.Set v0RecordKeysWithNoV1V2Updates = (scala.collection.immutable.Set)((IterableOnceOps)appends1.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)LogCleanerParameterizedIntegrationTest.$anonfun$testCleanerWithMessageFormatV0V1V2$2(x$8)))).toSet().$minus$minus((IterableOnce)dupsV1.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)LogCleanerParameterizedIntegrationTest.$anonfun$testCleanerWithMessageFormatV0V1V2$3(x$9)))).$minus$minus((IterableOnce)dupsV2.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)LogCleanerParameterizedIntegrationTest.$anonfun$testCleanerWithMessageFormatV0V1V2$4(x$10)))).map((Function1 & Serializable)x$11 -> LogCleanerParameterizedIntegrationTest.$anonfun$testCleanerWithMessageFormatV0V1V2$5(BoxesRunTime.unboxToInt((Object)x$11)));
        Seq appends2 = (Seq)((IterableOps)((IterableOps)((IterableOps)appends1.$plus$plus(dupsV0)).$plus$plus((IterableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)var5_5, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$))).$plus$plus(dupsV1)).$plus$plus(dupsV2);
        log.roll(log.roll$default$1());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.checkLogAfterConvertingToV2(compressionType, log, logConfig.messageTimestampType, (Set<String>)v0RecordKeysWithNoV1V2Updates);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0V1(CompressionType compressionType) {
        Compression compression = Compression.of((CompressionType)compressionType).build();
        int maxMessageSize = 192;
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$8, 256, x$9, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$142 = this.logConfigProperties$default$1();
        float x$152 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        long x$18 = this.logConfigProperties$default$7();
        LogConfig logConfig = new LogConfig((java.util.Map)this.logConfigProperties(x$142, maxMessageSize, x$152, x$16, x$17, 256, x$18));
        log.updateConfig(logConfig);
        int x$24 = 0;
        Seq appendsV0 = this.writeDupsSingleMessageSet(2, 3, log, compression, x$24, (byte)0);
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, compression, 3, (byte)0));
        Seq appendsV1 = this.writeDupsSingleMessageSet(2, 2, log, compression, 4, (byte)1);
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, compression, 4, (byte)1));
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(2, 2, log, compression, 6, (byte)1));
        Seq appends = (Seq)appendsV0.$plus$plus((IterableOnce)appendsV1);
        scala.collection.immutable.Set v0RecordKeysWithNoV1V2Updates = (scala.collection.immutable.Set)((IterableOnceOps)appendsV0.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)LogCleanerParameterizedIntegrationTest.$anonfun$testCleaningNestedMessagesWithV0V1$1(x$12)))).toSet().$minus$minus((IterableOnce)appendsV1.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)LogCleanerParameterizedIntegrationTest.$anonfun$testCleaningNestedMessagesWithV0V1$2(x$13)))).map((Function1 & Serializable)x$14 -> LogCleanerParameterizedIntegrationTest.$anonfun$testCleaningNestedMessagesWithV0V1$3(BoxesRunTime.unboxToInt((Object)x$14)));
        log.roll(log.roll$default$1());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty >= (long)appends.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)("log should have been compacted: startSize=" + startSize + " compactedSize=" + compactedSize));
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
        this.checkLogAfterConvertingToV2(compressionType, log, logConfig.messageTimestampType, (Set<String>)v0RecordKeysWithNoV1V2Updates);
    }

    private void checkLogAfterConvertingToV2(CompressionType compressionType, UnifiedLog log, TimestampType timestampType, Set<String> keysForV0RecordsWithNoV1V2Updates) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().foreach((Function1 & Serializable)segment -> {
            LogCleanerParameterizedIntegrationTest.$anonfun$checkLogAfterConvertingToV2$1(compressionType, keysForV0RecordsWithNoV1V2Updates, timestampType, segment);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType compressionType) {
        void var5_5;
        int largeMessageKey = 20;
        Compression codec = Compression.of((CompressionType)compressionType).build();
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var5_5.sizeInBytes();
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, 1L, maxMessageSize, x$7, x$8, x$9, x$10, (Option<Object>)x$4, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerParameterizedIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize, this.cleaner().currentConfig().dedupeBufferLoadFactor, 100000, this.cleaner().currentConfig().maxMessageSize, this.cleaner().currentConfig().maxIoBytesPerSecond, this.cleaner().currentConfig().backoffMs, true));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)("log should have been compacted: startSize=" + startSize + " compactedSize=" + compactedSize));
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)("log cleaner should have processed up to offset " + firstDirty + ", but lastCleaned=" + lastCleaned));
    }

    private void checkLogAfterAppendingDups(UnifiedLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((IterableOnceOps)messages.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
                String value = (String)x0$1._2();
                long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().flatMap((Function1 & Serializable)segment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().records()).asScala().map((Function1 & Serializable)deepLogEntry -> {
            int key = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2())));
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, UnifiedLog log, Compression codec, int startKey, byte magicValue) {
        void withRecords_timestampType;
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$17 -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)x$17)));
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int key = x0$1._1$mcI$sp();
                String payload = (String)x0$1._2();
                return new SimpleRecord(Time.SYSTEM.milliseconds(), Integer.toString(key).getBytes(), payload.getBytes());
            }
            throw new MatchError(null);
        });
        SimpleRecord[] withRecords_records = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var11_9 = null;
        LogAppendInfo appendInfo = log.appendAsLeaderWithRecordVersion(MemoryRecords.withRecords((byte)magicValue, (long)withRecords_initialOffset, (Compression)codec, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 0, RecordVersion.lookup((byte)magicValue));
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((IndexedSeqOps)kvs.zip((IterableOnce)offsets)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Tuple2 kv = (Tuple2)x0$2._1();
                long offset = x0$2._2$mcJ$sp();
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            }
            throw new MatchError(null);
        });
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType compressionType$1) {
        ArraySeq.ofRef x$1 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()), 1));
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, 100L, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, Compression.of((CompressionType)compressionType$1).build(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.logSegments()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)("log should have been compacted: startSize=" + startSize + " compactedSize=" + compactedSize));
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$3(UnifiedLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1 && log$1.numberOfSegments() == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$4() {
        return "Timed out waiting for deletion of old segments";
    }

    public static final /* synthetic */ int $anonfun$testCleanerWithMessageFormatV0V1V2$2(Tuple3 x$8) {
        return BoxesRunTime.unboxToInt((Object)x$8._1());
    }

    public static final /* synthetic */ int $anonfun$testCleanerWithMessageFormatV0V1V2$3(Tuple3 x$9) {
        return BoxesRunTime.unboxToInt((Object)x$9._1());
    }

    public static final /* synthetic */ int $anonfun$testCleanerWithMessageFormatV0V1V2$4(Tuple3 x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10._1());
    }

    public static final /* synthetic */ String $anonfun$testCleanerWithMessageFormatV0V1V2$5(int x$11) {
        return Integer.toString(x$11);
    }

    public static final /* synthetic */ int $anonfun$testCleaningNestedMessagesWithV0V1$1(Tuple3 x$12) {
        return BoxesRunTime.unboxToInt((Object)x$12._1());
    }

    public static final /* synthetic */ int $anonfun$testCleaningNestedMessagesWithV0V1$2(Tuple3 x$13) {
        return BoxesRunTime.unboxToInt((Object)x$13._1());
    }

    public static final /* synthetic */ String $anonfun$testCleaningNestedMessagesWithV0V1$3(int x$14) {
        return Integer.toString(x$14);
    }

    public static final /* synthetic */ void $anonfun$checkLogAfterConvertingToV2$3(Set keysForV0RecordsWithNoV1V2Updates$1, Record record) {
        String recordKey = TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2());
        if (keysForV0RecordsWithNoV1V2Updates$1.contains((Object)recordKey)) {
            Assertions.assertEquals((long)-1L, (long)record.timestamp(), (String)("Record " + recordKey + " with unexpected timestamp "));
            return;
        }
        Assertions.assertNotEquals((long)-1L, (long)record.timestamp(), (String)("Record " + recordKey + " with unexpected timestamp " + -1L));
    }

    public static final /* synthetic */ void $anonfun$checkLogAfterConvertingToV2$2(CompressionType compressionType$2, Set keysForV0RecordsWithNoV1V2Updates$1, TimestampType timestampType$1, FileLogInputStream.FileChannelRecordBatch recordBatch) {
        Assertions.assertEquals((byte)RecordVersion.V2.value, (byte)recordBatch.magic());
        CompressionType compressionType = compressionType$2;
        CompressionType compressionType2 = CompressionType.NONE;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(recordBatch.iterator()).asScala().size());
        } else {
            Assertions.assertTrue((CollectionConverters$.MODULE$.IteratorHasAsScala(recordBatch.iterator()).asScala().size() >= 1 ? 1 : 0) != 0);
        }
        String firstRecordKey = TestUtils$.MODULE$.readString(((Record)recordBatch.iterator().next()).key(), TestUtils$.MODULE$.readString$default$2());
        if (keysForV0RecordsWithNoV1V2Updates$1.contains((Object)firstRecordKey)) {
            Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)recordBatch.timestampType());
        } else {
            Assertions.assertEquals((Object)timestampType$1, (Object)recordBatch.timestampType());
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(recordBatch.iterator()).asScala().foreach((Function1 & Serializable)record -> {
            LogCleanerParameterizedIntegrationTest.$anonfun$checkLogAfterConvertingToV2$3(keysForV0RecordsWithNoV1V2Updates$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkLogAfterConvertingToV2$1(CompressionType compressionType$2, Set keysForV0RecordsWithNoV1V2Updates$1, TimestampType timestampType$1, LogSegment segment) {
        CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().foreach((Function1 & Serializable)recordBatch -> {
            LogCleanerParameterizedIntegrationTest.$anonfun$checkLogAfterConvertingToV2$2(compressionType$2, keysForV0RecordsWithNoV1V2Updates$1, timestampType$1, recordBatch);
            return BoxedUnit.UNIT;
        });
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("log.cleaner.threads", Integer.toString(cleanerConfig.numThreads));
        props.put("log.cleaner.dedupe.buffer.size", Long.toString(cleanerConfig.dedupeBufferSize));
        props.put("log.cleaner.io.buffer.load.factor", Double.toString(cleanerConfig.dedupeBufferLoadFactor));
        props.put("log.cleaner.io.buffer.size", Integer.toString(cleanerConfig.ioBufferSize));
        props.put("message.max.bytes", Integer.toString(cleanerConfig.maxMessageSize));
        props.put("log.cleaner.backoff.ms", Long.toString(cleanerConfig.backoffMs));
        props.put("log.cleaner.io.max.bytes.per.second", Double.toString(cleanerConfig.maxIoBytesPerSecond));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int x$17) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values()), (Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$18)))), (Function1 & Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), ClassTag$.MODULE$.apply(Arguments.class)));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$18) {
            CompressionType compressionType = x$18;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

