/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004Z\u0001\u0001\u0006Ia\u0013\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019\u0011\u0007\u0001)A\u00059\"91\r\u0001b\u0001\n\u0013!\u0007B\u00027\u0001A\u0003%Q\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\r]\u0004\u0001\u0015!\u0003p\u0011\u001dA\bA1A\u0005\n9Da!\u001f\u0001!\u0002\u0013y\u0007\"\u0002>\u0001\t\u0003Y\bBBA\u000b\u0001\u0011\u00051\u0010\u0003\u0004\u0002 \u0001!\ta\u001f\u0005\u0007\u0003S\u0001A\u0011A>\t\u000f\u0005}\u0001\u0001\"\u0001\u0002.\u00191\u0011q\u0007\u0001\u0005\u0003sA\u0011BO\t\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005U\u0013C!A!\u0002\u0013\t9\u0006\u0003\u0004F#\u0011\u0005\u0011Q\f\u0005\n\u0003O\n\"\u0019!C\u0001\u0003SB\u0001B!\r\u0012A\u0003%\u00111\u000e\u0005\u0007\u0005g\tB\u0011I>\u0007\r\tU\u0002\u0001\u0002B\u001c\u0011%Q\u0004D!A!\u0002\u0013\t\t\u0004\u0003\u0006\u0002Va\u0011\t\u0011)A\u0005\u0003GCa!\u0012\r\u0005\u0002\te\u0002B\u0002B\u001a1\u0011\u00053\u0010C\u0004\u0003B\u0001!IAa\u0011\t\u0013\t]\u0003!%A\u0005\n\te\u0003b\u0002B/\u0001\u0011%!q\f\u0004\u0007\u0003{\u0002A)a \t\u0015\u0005}\u0005E!f\u0001\n\u0003\t\t\u000b\u0003\u0006\u0002*\u0002\u0012\t\u0012)A\u0005\u0003GC!\"a+!\u0005+\u0007I\u0011AAW\u0011)\ty\u000b\tB\tB\u0003%\u0011q\u000b\u0005\u0007\u000b\u0002\"\t!!-\t\u000f\u0005]\u0006\u0005\"\u0011\u0002:\"I\u00111\u001a\u0011\u0002\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003'\u0004\u0013\u0013!C\u0001\u0003+D\u0011\"a;!#\u0003%\t!!<\t\u0013\u0005E\b%!A\u0005B\u0005M\b\"CA}A\u0005\u0005I\u0011AAW\u0011%\tY\u0010IA\u0001\n\u0003\ti\u0010C\u0005\u0003\n\u0001\n\t\u0011\"\u0011\u0003\f!I!Q\u0003\u0011\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005C\u0001\u0013\u0011!C!\u0005GA\u0011Ba\n!\u0003\u0003%\tE!\u000b\t\u0013\t-\u0002%!A\u0005B\t5r!\u0003B6\u0001\u0005\u0005\t\u0012\u0002B7\r%\ti\bAA\u0001\u0012\u0013\u0011y\u0007\u0003\u0004Fg\u0011\u0005!\u0011\u0011\u0005\n\u0003o\u001b\u0014\u0011!C#\u0005\u0007C\u0011B!\"4\u0003\u0003%\tIa\"\t\u0013\t55'!A\u0005\u0002\n=%A\u0005'pO\u000e{gnY;se\u0016t7-\u001f+fgRT!AO\u001e\u0002\u00071|wMC\u0001=\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\t\u0005\u0002I\u00015\t\u0011(\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t1\n\u0005\u0002M/6\tQJ\u0003\u0002O\u001f\u00069Q.\u001a;sS\u000e\u001c(B\u0001\u001eQ\u0015\t\t&+A\u0004ti>\u0014\u0018mZ3\u000b\u0005q\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W'\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00051!/\u00198e_6,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0006\u000bA!\u001e;jY&\u0011\u0011M\u0018\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005I1o\u00195fIVdWM]\u000b\u0002KB\u0011aM[\u0007\u0002O*\u0011q\f\u001b\u0006\u0003SJ\u000baa]3sm\u0016\u0014\u0018BA6h\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0019!X\u000e\u001d#jeV\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006\u0011\u0011n\u001c\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018O\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005)1/\u001a;vaR\tA\u0010\u0005\u0002A{&\u0011a0\u0011\u0002\u0005+:LG\u000fK\u0002\r\u0003\u0003\u0001B!a\u0001\u0002\u00125\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0002ba&TA!a\u0003\u0002\u000e\u00059!.\u001e9ji\u0016\u0014(bAA\b+\u0006)!.\u001e8ji&!\u00111CA\u0003\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\tg\",H\u000fZ8x]\"\u001aQ\"!\u0007\u0011\t\u0005\r\u00111D\u0005\u0005\u0003;\t)AA\u0005BMR,'/R1dQ\u0006qB/Z:u+:\u001cw.\\7jiR,G\rR1uC:{GoQ8ogVlW\r\u001a\u0015\u0004\u001d\u0005\r\u0002\u0003BA\u0002\u0003KIA!a\n\u0002\u0006\t!A+Z:u\u0003I\"Xm\u001d;V]\u000e|W.\\5ui\u0016$G)\u0019;b\u001d>$8i\u001c8tk6,GM\u0012:fcV,g\u000e^*fO6,g\u000e\u001e*pY2\u001c\bfA\b\u0002$Q\u0019A0a\f\t\ri\u0002\u0002\u0019AA\u0019!\rA\u00151G\u0005\u0004\u0003kI$AC+oS\u001aLW\r\u001a'pO\na1i\u001c8tk6,'\u000fV1tWN)\u0011#a\u000f\u0002HA!\u0011QHA\"\u001b\t\tyDC\u0002\u0002BM\fA\u0001\\1oO&!\u0011QIA \u0005\u0019y%M[3diB)\u0011\u0011JA)y6\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0006d_:\u001cWO\u001d:f]RT!aX:\n\t\u0005M\u00131\n\u0002\t\u0007\u0006dG.\u00192mK\u0006QA.Y:u\u001f\u001a47/\u001a;\u0011\u0007\u0001\u000bI&C\u0002\u0002\\\u0005\u00131!\u00138u)\u0019\ty&a\u0019\u0002fA\u0019\u0011\u0011M\t\u000e\u0003\u0001AaA\u000f\u000bA\u0002\u0005E\u0002bBA+)\u0001\u0007\u0011qK\u0001\u0010G>t7/^7fI\n\u000bGo\u00195fgV\u0011\u00111\u000e\t\u0007\u0003[\n9(a\u001f\u000e\u0005\u0005=$\u0002BA9\u0003g\nq!\\;uC\ndWMC\u0002\u0002v\u0005\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI(a\u001c\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0002\u0002b\u0001\u0012ABR3uG\",GMQ1uG\"\u001cb\u0001I \u0002\u0002\u0006\u001d\u0005c\u0001!\u0002\u0004&\u0019\u0011QQ!\u0003\u000fA\u0013x\u000eZ;diB!\u0011\u0011RAM\u001d\u0011\tY)!&\u000f\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%>\u0003\u0019a$o\\8u}%\t!)C\u0002\u0002\u0018\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0006u%\u0001D*fe&\fG.\u001b>bE2,'bAAL\u0003\u0006Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0005\u0005\r\u0006c\u0001!\u0002&&\u0019\u0011qU!\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%A\u0003fa>\u001c\u0007.\u0006\u0002\u0002X\u00051Q\r]8dQ\u0002\"b!a\u001f\u00024\u0006U\u0006bBAPK\u0001\u0007\u00111\u0015\u0005\b\u0003W+\u0003\u0019AA,\u0003!!xn\u0015;sS:<GCAA^!\u0011\ti,!2\u000f\t\u0005}\u0016\u0011\u0019\t\u0004\u0003\u001b\u000b\u0015bAAb\u0003\u00061\u0001K]3eK\u001aLA!a2\u0002J\n11\u000b\u001e:j]\u001eT1!a1B\u0003\u0011\u0019w\u000e]=\u0015\r\u0005m\u0014qZAi\u0011%\tyj\nI\u0001\u0002\u0004\t\u0019\u000bC\u0005\u0002,\u001e\u0002\n\u00111\u0001\u0002X\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAlU\u0011\t\u0019+!7,\u0005\u0005m\u0007\u0003BAo\u0003Ol!!a8\u000b\t\u0005\u0005\u00181]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!:B\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\fyNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002p*\"\u0011qKAm\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001f\t\u0005\u0003{\t90\u0003\u0003\u0002H\u0006}\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u007f\u0014)\u0001E\u0002A\u0005\u0003I1Aa\u0001B\u0005\r\te.\u001f\u0005\n\u0005\u000fa\u0013\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0007!\u0019\u0011yA!\u0005\u0002\u00006\u0011\u00111O\u0005\u0005\u0005'\t\u0019H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\r\u0005?\u00012\u0001\u0011B\u000e\u0013\r\u0011i\"\u0011\u0002\b\u0005>|G.Z1o\u0011%\u00119ALA\u0001\u0002\u0004\ty0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA{\u0005KA\u0011Ba\u00020\u0003\u0003\u0005\r!a\u0016\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0016\u0002\r\u0015\fX/\u00197t)\u0011\u0011IBa\f\t\u0013\t\u001d\u0011'!AA\u0002\u0005}\u0018\u0001E2p]N,X.\u001a3CCR\u001c\u0007.Z:!\u0003\u0011\u0019\u0017\r\u001c7\u0003\u001b1{w-\u00119qK:$G+Y:l'\u0015A\u00121HA$)\u0019\u0011YD!\u0010\u0003@A\u0019\u0011\u0011\r\r\t\riZ\u0002\u0019AA\u0019\u0011\u001d\t)f\u0007a\u0001\u0003G\u000b\u0011b\u0019:fCR,Gj\\4\u0015\t\u0005E\"Q\t\u0005\n\u0005\u000fj\u0002\u0013!a\u0001\u0005\u0013\naaY8oM&<\u0007\u0003\u0002B&\u0005'j!A!\u0014\u000b\u0007i\u0012yEC\u0002\u0003RA\u000b\u0011\"\u001b8uKJt\u0017\r\\:\n\t\tU#Q\n\u0002\n\u0019><7i\u001c8gS\u001e\f1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIE*\"Aa\u0017+\t\t%\u0013\u0011\\\u0001\u0015m\u0006d\u0017\u000eZ1uK\u000e{gn];nK\u0012$\u0015\r^1\u0015\u000bq\u0014\tGa\u0019\t\riz\u0002\u0019AA\u0019\u0011\u001d\t9g\ba\u0001\u0005K\u0002b!!#\u0003h\u0005m\u0014\u0002\u0002B5\u0003;\u0013\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\r\r\u0016$8\r[3e\u0005\u0006$8\r\u001b\t\u0004\u0003C\u001a4#B\u001a\u0003r\tu\u0004C\u0003B:\u0005s\n\u0019+a\u0016\u0002|5\u0011!Q\u000f\u0006\u0004\u0005o\n\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005w\u0012)HA\tBEN$(/Y2u\rVt7\r^5p]J\u00022\u0001\u001dB@\u0013\r\tY*\u001d\u000b\u0003\u0005[\"\"!!>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005m$\u0011\u0012BF\u0011\u001d\tyJ\u000ea\u0001\u0003GCq!a+7\u0001\u0004\t9&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE%Q\u0014\t\u0006\u0001\nM%qS\u0005\u0004\u0005+\u000b%AB(qi&|g\u000eE\u0004A\u00053\u000b\u0019+a\u0016\n\u0007\tm\u0015I\u0001\u0004UkBdWM\r\u0005\n\u0005?;\u0014\u0011!a\u0001\u0003w\n1\u0001\u001f\u00131\u0001")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1);
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps);
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(UnifiedLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private UnifiedLog createLog(LogConfig config) {
        File x$1 = this.logDir();
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Time x$7 = Time.SYSTEM;
        ProducerStateManagerConfig x$9 = new ProducerStateManagerConfig(86400000, false);
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        return UnifiedLog$.MODULE$.apply(x$1, config, 0L, 0L, (Scheduler)x$5, x$6, x$7, 300000, x$9, 600000, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties());
    }

    private void validateConsumedData(UnifiedLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.logSegments().forEach(segment -> segment.log().batches().forEach(batch -> {
            if (iter.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError("Consumed batch " + consumedBatch + " does not match next expected batch in log " + batch, t);
                }
            }
        }));
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.read((long)fetchOffset.elem, (int)1, (FetchIsolation)FetchIsolation.HIGH_WATERMARK, (boolean)true).records.batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, UnifiedLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return "FetchedBatch(baseOffset=" + this.baseOffset() + ", epoch=" + this.epoch() + ")";
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "baseOffset";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer())) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (this.baseOffset() != fetchedBatch.baseOffset() || this.epoch() != fetchedBatch.epoch() || !fetchedBatch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final UnifiedLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset;
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)));
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, (Compression)Compression.NONE, -1L, (short)-1, -1, 0L, -1), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = 2;
                        NoCompression x$5 = Compression.NONE;
                        long x$6 = -1L;
                        short x$7 = -1;
                        int x$8 = -1;
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, (Compression)x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, UnifiedLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

