/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005\u0002=BQ\u0001\u0011\u0001\u0005\u0002=BQA\u0011\u0001\u0005\u0002=BQ\u0001\u0012\u0001\u0005\u0002=BQA\u0012\u0001\u0005\u0002=BQ\u0001\u0013\u0001\u0005\u0002=BQA\u0013\u0001\u0005\u0002=BQ\u0001\u0014\u0001\u0005\u0002=BQA\u0014\u0001\u0005\u0002=BQ\u0001\u0015\u0001\u0005\u0002=BQA\u0015\u0001\u0005\u0002=BQ\u0001\u0016\u0001\u0005\nUCQA\u001a\u0001\u0005\n\u001dDQa\u001c\u0001\u0005\u0002=BQ!\u001d\u0001\u0005\u0002=BQa\u001d\u0001\u0005\u0002=BQ!\u001e\u0001\u0005\u0002=BQa\u001e\u0001\u0005\naDa!!\n\u0001\t\u0003y\u0003bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u00033\u0002A\u0011AA.\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001f\u0001\t\u0003\ti\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006BBA\\\u0001\u0011\u0005qFA\u0007M_\u001e\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003?\u0001\n1\u0001\\8h\u0015\u0005\t\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001-!\ti\u0003!D\u0001\u001f\u0003-*gn];sK:{7\u000b^1uS\u000eLe.\u001b;jC2L'0\u0019;j_:|%\u000fZ3s\t\u0016\u0004XM\u001c3f]\u000eLH#\u0001\u0019\u0011\u0005\u0015\n\u0014B\u0001\u001a'\u0005\u0011)f.\u001b;)\u0005\t!\u0004CA\u001b?\u001b\u00051$BA\u001c9\u0003\r\t\u0007/\u001b\u0006\u0003si\nqA[;qSR,'O\u0003\u0002<y\u0005)!.\u001e8ji*\tQ(A\u0002pe\u001eL!a\u0010\u001c\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cHoS1gW\u0006\u001cuN\u001c4jOR{\u0007K]8qg\"\u00121\u0001N\u0001\u0015i\u0016\u001cHO\u0012:p[B\u0013x\u000e]:J]Z\fG.\u001b3)\u0005\u0011!\u0014A\b;fgRLeN^1mS\u0012\u001cu.\u001c9bGRLwN\u001c'bO\u000e{gNZ5hQ\t)A'A\u0013tQ>,H\u000e\u001a,bY&$\u0017\r^3UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCN\u001cuN\u001c4jO\"\u0012a\u0001N\u0001\u0010i\u0016\u001cH\u000fV8Ii6dG+\u00192mK\"\u0012q\u0001N\u0001\u000bi\u0016\u001cH\u000fV8Ii6d\u0007F\u0001\u00055\u0003E!Xm\u001d;U_\u0016s'/[2iK\u0012\u00146\u000f\u001e\u0015\u0003\u0013Q\n\u0011\u0002^3tiR{'k\u001d;)\u0005)!\u0014A\u0005;fgR<U\r^\"p]\u001aLwMV1mk\u0016D#a\u0003\u001b\u0002KQ,7\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\u0006\u001bHj\\4hC\ndWm\u0015;sS:<\u0007F\u0001\u00075\u0003\u001dI7OV1mS\u0012$\"AV-\u0011\u0005\u0015:\u0016B\u0001-'\u0005\u001d\u0011un\u001c7fC:DQAW\u0007A\u0002m\u000b1bY8oM&<g+\u00197vKB\u0011Al\u0019\b\u0003;\u0006\u0004\"A\u0018\u0014\u000e\u0003}S!\u0001\u0019\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0011g%\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012'\u0003U\t7o]3siB\u0013x\u000e]3sifLeN^1mS\u0012$2\u0001\r5k\u0011\u0015Ig\u00021\u0001\\\u0003\u0011q\u0017-\\3\t\u000b-t\u0001\u0019\u00017\u0002\rY\fG.^3t!\r)S\u000eJ\u0005\u0003]\u001a\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003\u0005\"Xm\u001d;M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:$UM]5wK\u0012\u0004&o\u001c9tQ\tyA'\u0001\u0015uKN$Hj\\2bY2{wMU3uK:$\u0018n\u001c8EKJLg/\u001a3EK\u001a\fW\u000f\u001c;Qe>\u00048\u000f\u000b\u0002\u0011i\u0005QB/Z:u\u0019>\u001c\u0017\r\u001c'pOJ+G/\u001a8uS>t\u0007K]8qg\"\u0012\u0011\u0003N\u0001\"i\u0016\u001cH/\u00138wC2LG\rT8dC2dun\u001a*fi\u0016tG/[8o!J|\u0007o\u001d\u0015\u0003%Q\n1\u0005Z8UKN$\u0018J\u001c<bY&$Gj\\2bY2{wMU3uK:$\u0018n\u001c8Qe>\u00048\u000fF\u0005z\u0003\u0013\t\u0019\"!\b\u0002\"A\u0019!0!\u0002\u000e\u0003mT!\u0001`?\u0002\r\r|gNZ5h\u0015\tqx0\u0001\u0004d_6lwN\u001c\u0006\u0004C\u0005\u0005!bAA\u0002y\u00051\u0011\r]1dQ\u0016L1!a\u0002|\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0007bBA\u0006'\u0001\u0007\u0011QB\u0001\u0011Y>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u001bN\u00042!JA\b\u0013\r\t\tB\n\u0002\u0005\u0019>tw\rC\u0004\u0002\u0016M\u0001\r!a\u0006\u0002'1|7-\u00197SKR,g\u000e^5p]\nKH/Z:\u0011\u0007\u0015\nI\"C\u0002\u0002\u001c\u0019\u00121!\u00138u\u0011\u001d\tyb\u0005a\u0001\u0003/\taB]3uK:$\u0018n\u001c8CsR,7\u000fC\u0004\u0002$M\u0001\r!!\u0004\u0002\u0017I,G/\u001a8uS>tWj]\u0001+i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ*u_J\fw-Z(o\u0007>l\u0007/Y2uK\u0012$v\u000e]5dQ\t!B'\u0001\u000euKN$XI\\1cY\u0016\u0014V-\\8uK2{wm\u0015;pe\u0006<W\rF\u00021\u0003[Aa!a\f\u0016\u0001\u00041\u0016aF:zgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eQ\u0019)\u00121G5\u0002@A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:a\na\u0001]1sC6\u001c\u0018\u0002BA\u001f\u0003o\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uC\t\t\t%\u0001\u001fuKN$XI\\1cY\u0016\u0014V-\\8uK2{wm\u0015;pe\u0006<W\rI<ji\"\u00043/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u001e!wBj\bfB\u000b\u0002F\u0005E\u00131\u000b\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)!\u00111JA\u001c\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA(\u0003\u0013\u00121BV1mk\u0016\u001cv.\u001e:dK\u0006A!m\\8mK\u0006t7\u000f\f\u0003\u0002V\u0005]\u0013$A\u0001\u001a\u0003\u0001\t1\u0004^3ti\u0012K7/\u00192mKJ+Wn\u001c;f\u0019><7\u000b^8sC\u001e,Gc\u0001\u0019\u0002^!1\u0011q\f\fA\u0002Y\u000bqc^1t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3)\rY\t\u0019$[A2C\t\t)'A\u001fuKN$H)[:bE2,'+Z7pi\u0016dunZ*u_J\fw-\u001a\u0011xSRD\u0007e^1t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3;Am\u0004T\u0010K\u0004\u0017\u0003\u000b\n\t&!\u001b-\t\u0005U\u0013qK\u0001*i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0013:4\u0018\r\\5e%\u0016$XM\u001c;j_:$\u0016.\\3\u0015\u0007A\ny\u0007\u0003\u0004\u00020]\u0001\rA\u0016\u0015\u0007/\u0005M\u0012.a\u001d\"\u0005\u0005U\u0014a\u0013;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[%om\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rI<ji\"\u00043/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u001e!wBj\bfB\f\u0002F\u0005E\u0013\u0011\u0010\u0017\u0005\u0003+\n9&A\u0015uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5J]Z\fG.\u001b3SKR,g\u000e^5p]NK'0\u001a\u000b\u0004a\u0005}\u0004BBA\u00181\u0001\u0007a\u000b\u000b\u0004\u0019\u0003gI\u00171Q\u0011\u0003\u0003\u000b\u000b1\n^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.\u00138wC2LGMU3uK:$\u0018n\u001c8TSj,\u0007e^5uQ\u0002\u001a\u0018p\u001d*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,GM\u000f\u0011|auDs\u0001GA#\u0003#\nI\t\f\u0003\u0002V\u0005]\u0013\u0001\b;fgR4\u0016\r\\5eCR,'I]8lKJdunZ\"p]\u001aLwm\u001d\u000b\u0004a\u0005=\u0005BBA\u00183\u0001\u0007a\u000b\u000b\u0004\u001a\u0003gI\u00171S\u0011\u0003\u0003+\u000ba\b^3tiZ\u000bG.\u001b3bi\u0016\u0014%o\\6fe2{wmQ8oM&<7\u000fI<ji\"\u00043/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u001e!wBj\bfB\r\u0002F\u0005E\u0013\u0011\u0014\u0017\u0005\u0003+\n9&\u0001\u0010uKN$h+\u00197jIJ+Wn\u001c;f\u0019><7i\u001c9z\t&\u001c\u0018M\u00197fIR\u0019\u0001'a(\t\r\u0005\u0005&\u00041\u0001W\u00031\u0019w\u000e]=ESN\f'\r\\3eQ\rQ\u00121\u0007\u0015\b5\u0005\u0015\u0013\u0011KATY\u0011\t)&a\u0016\u0002CQ,7\u000f\u001e,bY&$'+Z7pi\u0016dun\u001a#fY\u0016$Xm\u00148ESN\f'\r\\3\u0015\u0007A\ni\u000b\u0003\u0004\u00020n\u0001\rAV\u0001\u0010I\u0016dW\r^3P]\u0012K7/\u00192mK\"\u001a1$a\r)\u000fm\t)%!\u0015\u000262\"\u0011QKA,\u0003)\"Xm\u001d;WC2LG-\u0019;f/&$\b.T3uC\u0012\fG/\u0019,feNLwN\u001c&c_\u0012\u001cV\u000f\u001d9peRD#\u0001\b\u001b")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG);
        Assertions.assertTrue((boolean)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(LogConfig.configNames()).asScala().filter((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        long millisInDay = 24L * millisInHour;
        long bytesInGB = 0x40000000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("log.roll.hours", "2");
        kafkaProps.put("log.roll.jitter.hours", "2");
        kafkaProps.put("log.retention.hours", "960");
        kafkaProps.put("log.local.retention.ms", "2592000000");
        kafkaProps.put("log.local.retention.bytes", "4294967296");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(40L * millisInDay)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(30L * millisInDay)), logProps.get("local.retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(4L * bytesInGB)), logProps.get("local.retention.bytes"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            switch (name == null ? 0 : name.hashCode()) {
                case -1924377471: {
                    if (!"remote.log.copy.disable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "remove", "0"}));
                    return;
                }
                case -1339220362: {
                    if (!"retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -924619404: {
                    if (!"compression.lz4.level".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                    return;
                }
                case -772457061: {
                    if (!"retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -537988164: {
                    if (!"cleanup.policy".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                    return;
                }
                case -6022648: {
                    if (!"min.cleanable.dirty.ratio".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case 67637273: {
                    if (!"local.retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 268940301: {
                    if (!"min.insync.replicas".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                    return;
                }
                case 297509630: {
                    if (!"remote.storage.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case 632472856: {
                    if (!"local.retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 1016887921: {
                    if (!"unclean.leader.election.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    return;
                }
                case 1235439480: {
                    if (!"compression.gzip.level".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-2"}));
                    return;
                }
                case 1494864455: {
                    if (!"compression.zstd.level".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1"}));
                    return;
                }
                case 2066335274: {
                    if (!"remote.log.delete.on.disable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "remove", "0"}));
                    return;
                }
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + html));
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> "prefix_" + key, Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + html));
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + rst));
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + rst));
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, configNameWithNoServerMapping + " doc");
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "50");
        kafkaProps.put("ssl.key.password", "somekeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty("ssl.truststore.password", "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props), () -> "Property " + name + " should not allow " + value);
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)-1L, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties props = new Properties();
        props.put("remote.storage.enable", "true");
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)props, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()));
    }

    @Test
    public void testEnableRemoteLogStorageOnCompactedTopic() {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("cleanup.policy", "delete");
        logProps.put("remote.storage.enable", "true");
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        logProps.put("cleanup.policy", "compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()));
        logProps.put("cleanup.policy", "delete,compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()));
        logProps.put("cleanup.policy", "compact,delete");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()));
    }

    @ParameterizedTest(name="testEnableRemoteLogStorage with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testEnableRemoteLogStorage(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "true");
        if (sysRemoteStorageEnabled) {
            LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
            return;
        }
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="testDisableRemoteLogStorage with wasRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testDisableRemoteLogStorage(boolean wasRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "false");
        if (wasRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> LogConfig.validate(Collections.singletonMap("remote.storage.enable", "true"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("It is invalid to disable remote storage without deleting remote data. If you want to keep the remote data and turn to read only, please set `remote.storage.enable=true,remote.log.copy.disable=true`. If you want to disable remote storage and delete all remote data, please set `remote.storage.enable=false,remote.log.delete.on.disable=true`."));
            logProps.put("remote.log.delete.on.disable", "true");
            LogConfig.validate(Collections.singletonMap("remote.storage.enable", "true"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
            return;
        }
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        LogConfig.validate(Collections.singletonMap("remote.storage.enable", "false"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionTime with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionTime(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        kafkaProps.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "1000");
        kafkaProps.put("log.local.retention.ms", "900");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.ms", "500");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.ms"));
            return;
        }
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionSize with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionSize(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "1024");
        props.put("log.local.retention.bytes", "512");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.bytes", "128");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validate(Collections.emptyMap(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest(name="testValidateBrokerLogConfigs with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testValidateBrokerLogConfigs(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "1024");
        props.put("log.local.retention.bytes", "2048");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidRemoteLogCopyDisabled(boolean copyDisabled) {
        Properties logProps = new Properties();
        logProps.put("remote.log.copy.disable", Boolean.toString(copyDisabled));
        LogConfig.validate((Properties)logProps);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidRemoteLogDeleteOnDisable(boolean deleteOnDisable) {
        Properties logProps = new Properties();
        logProps.put("remote.log.delete.on.disable", Boolean.toString(deleteOnDisable));
        LogConfig.validate((Properties)logProps);
    }

    @Test
    public void testValidateWithMetadataVersionJbodSupport() {
        LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, true));
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, true);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }

    private static final void validate$1(MetadataVersion metadataVersion, boolean jbodConfig) {
        int x$2 = jbodConfig ? 2 : 1;
        boolean x$3 = true;
        boolean x$4 = true;
        TestUtils$ createBrokerConfig$default$4_this = TestUtils$.MODULE$;
        Object var21_5 = null;
        int x$5 = createBrokerConfig$default$4_this.RandomPort();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_12 = null;
        int x$11 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_15 = null;
        int x$13 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_18 = null;
        int x$15 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$2, x$17, x$18, x$19, x$20)).validateWithMetadataVersion(metadataVersion);
    }
}

