/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.RemoteIndexCache;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\reg\u0001B'O\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004f\u0001\u0001\u0006IA\u0019\u0005\bM\u0002\u0011\r\u0011\"\u0003h\u0011\u0019\u0001\b\u0001)A\u0005Q\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002@\u0001A\u0003%1\u000f\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\tI\u0001\u0001Q\u0001\n\u0005\r\u0001\u0002CA\u0006\u0001\t\u0007I\u0011B1\t\u000f\u00055\u0001\u0001)A\u0005E\"A\u0011q\u0002\u0001C\u0002\u0013%\u0011\rC\u0004\u0002\u0012\u0001\u0001\u000b\u0011\u00022\t\u0013\u0005M\u0001A1A\u0005\n\u0005\u0005\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0001\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0016\u0001\u0001\u0006I!a\u0007\t\u0017\u00055\u0002\u00011AA\u0002\u0013%\u0011q\u0006\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0005C\u0006\u0002P\u0001\u0001\r\u0011!Q!\n\u0005E\u0002bCA)\u0001\u0001\u0007\t\u0019!C\u0005\u0003'B1\"a\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002^!Y\u0011\u0011\r\u0001A\u0002\u0003\u0005\u000b\u0015BA+\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\t\u0017\u0005]\u0004\u00011AA\u0002\u0013%\u0011\u0011\u0010\u0005\f\u0003{\u0002\u0001\u0019!A!B\u0013\t9\u0007C\u0006\u0002\u0000\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0004bCAA\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007C1\"a\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002h!Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011BAF\u0011-\tI\n\u0001a\u0001\u0002\u0004%I!a'\t\u0017\u0005}\u0005\u00011A\u0001B\u0003&\u0011Q\u0012\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\tY\f\u0001C\u0001\u0003GCq!!2\u0001\t\u0003\t\u0019\u000bC\u0004\u0002P\u0002!\t!a)\t\u000f\u0005M\u0007\u0001\"\u0001\u0002$\"9\u0011q\u001b\u0001\u0005\u0002\u0005\r\u0006bBAn\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003?\u0004A\u0011AAR\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003GCq!a:\u0001\t\u0003\t\u0019\u000bC\u0004\u0002l\u0002!\t!a)\t\u000f\u0005=\b\u0001\"\u0001\u0002$\"9\u00111\u001f\u0001\u0005\u0002\u0005\r\u0006bBA|\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003w\u0004A\u0011AAR\u0011\u001d\ty\u0010\u0001C\u0001\u0003GCqAa\u0001\u0001\t\u0003\t\u0019\u000bC\u0004\u0003\b\u0001!\t!a)\t\u000f\t-\u0001\u0001\"\u0001\u0002$\"9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B<\u0001\u0011\u0005\u00111\u0015\u0005\b\u0005w\u0002A\u0011AAR\u0011\u001d\u0011y\b\u0001C\u0001\u0003GCqAa!\u0001\t\u0003\u0011)\tC\u0004\u0003\u0012\u0002!\t!a)\t\u000f\tU\u0005\u0001\"\u0003\u0003\u0018\"I!\u0011\u0017\u0001\u0012\u0002\u0013%!1\u0017\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u0011\u001d\u0011y\u000e\u0001C\u0005\u0005CDqAa:\u0001\t\u0013\u0011I\u000fC\u0005\u0004\u0006\u0001\t\n\u0011\"\u0003\u0004\b!911\u0002\u0001\u0005\n\r5\u0001bBB\u000f\u0001\u0011%1q\u0004\u0005\b\u0007K\u0001A\u0011BB\u0014\u0011\u001d\u0019\u0019\u0004\u0001C\u0005\u0007kAqa!\u0011\u0001\t\u0013\u0019\u0019\u0005C\u0004\u0004T\u0001!Ia!\u0016\t\u000f\r}\u0003\u0001\"\u0003\u0004b!911\r\u0001\u0005\n\r\u0015\u0004bBB5\u0001\u0011%11\u000e\u0005\b\u0007_\u0002A\u0011BB9\u0011\u001d\u0019)\b\u0001C\u0005\u0007oBqa! \u0001\t\u0013\u0019y\bC\u0004\u0004D\u0002!Ia!2\u0003)I+Wn\u001c;f\u0013:$W\r_\"bG\",G+Z:u\u0015\ty\u0005+\u0001\u0004sK6|G/\u001a\u0006\u0003#J\u000b1\u0001\\8h\u0015\u0005\u0019\u0016!B6bM.\f7\u0001A\n\u0003\u0001Y\u0003\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001_!\ty\u0006!D\u0001O\u0003\u0001\"WMZ1vYR\u0014V-\\8uK&sG-\u001a=DC\u000eDWmU5{K\nKH/Z:\u0016\u0003\t\u0004\"aV2\n\u0005\u0011D&\u0001\u0002'p]\u001e\f\u0011\u0005Z3gCVdGOU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3TSj,')\u001f;fg\u0002\na\u0001\\8hO\u0016\u0014X#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!B:mMRR'\"A7\u0002\u0007=\u0014x-\u0003\u0002pU\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0003uS6,W#A:\u0011\u0005QdX\"A;\u000b\u0005Y<\u0018\u0001B;uS2T!\u0001_=\u0002\rM,'O^3s\u0015\t\u0019&P\u0003\u0002|Y\u00061\u0011\r]1dQ\u0016L!!`;\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0003\u0007\u00012aVA\u0003\u0013\r\t9\u0001\u0017\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%\u0001\u0006mCN$xJ\u001a4tKR\f1\u0002\\1ti>3gm]3uA\u0005Y1/Z4nK:$8+\u001b>f\u00031\u0019XmZ7f]R\u001c\u0016N_3!\u0003\r\u00118/\\\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0004ti>\u0014\u0018mZ3\u000b\u0007=\u000b)C\u0003\u0002Ro&!\u0011\u0011FA\u0010\u0005Q\u0011V-\\8uKN#xN]1hK6\u000bg.Y4fe\u0006!!o]7!\u0003\u0015\u0019\u0017m\u00195f+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\r\t\u0016q\u0007\u0006\u0005\u0003s\tY$A\u0005j]R,'O\\1mg*\u0019\u0011\u0011E=\n\t\u0005}\u0012Q\u0007\u0002\u0011%\u0016lw\u000e^3J]\u0012,\u0007pQ1dQ\u0016\f\u0011bY1dQ\u0016|F%Z9\u0015\t\u0005\u0015\u00131\n\t\u0004/\u0006\u001d\u0013bAA%1\n!QK\\5u\u0011%\tieEA\u0001\u0002\u0004\t\t$A\u0002yIE\naaY1dQ\u0016\u0004\u0013a\u0003:mg6+G/\u00193bi\u0006,\"!!\u0016\u0011\t\u0005u\u0011qK\u0005\u0005\u00033\nyB\u0001\rSK6|G/\u001a'pON+w-\\3oi6+G/\u00193bi\u0006\fqB\u001d7t\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0005\u0003\u000b\ny\u0006C\u0005\u0002NY\t\t\u00111\u0001\u0002V\u0005a!\u000f\\:NKR\fG-\u0019;bA\u00051An\\4ESJ,\"!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005\u0011\u0011n\u001c\u0006\u0003\u0003c\nAA[1wC&!\u0011QOA6\u0005\u00111\u0015\u000e\\3\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0003\u0002F\u0005m\u0004\"CA'3\u0005\u0005\t\u0019AA4\u0003\u001dawn\u001a#je\u0002\nQ\u0001\u001e9ESJ\f\u0011\u0002\u001e9ESJ|F%Z9\u0015\t\u0005\u0015\u0013Q\u0011\u0005\n\u0003\u001bb\u0012\u0011!a\u0001\u0003O\na\u0001\u001e9ESJ\u0004\u0013aC5e!\u0006\u0014H/\u001b;j_:,\"!!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%z\u0003\u0019\u0019w.\\7p]&!\u0011qSAI\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\bjIB\u000b'\u000f^5uS>tw\fJ3r)\u0011\t)%!(\t\u0013\u00055s$!AA\u0002\u00055\u0015\u0001D5e!\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0004HCAA#Q\r\t\u0013q\u0015\t\u0005\u0003S\u000b9,\u0004\u0002\u0002,*!\u0011QVAX\u0003\r\t\u0007/\u001b\u0006\u0005\u0003c\u000b\u0019,A\u0004kkBLG/\u001a:\u000b\u0007\u0005UF.A\u0003kk:LG/\u0003\u0003\u0002:\u0006-&A\u0003\"fM>\u0014X-R1dQ\u000691\r\\3b]V\u0004\bf\u0001\u0012\u0002@B!\u0011\u0011VAa\u0013\u0011\t\u0019-a+\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\t;fgRLe\u000eZ3y\r&dWMT1nK\u0006sG\rT8dCRLwN\\(o\t&\u001c8\u000eK\u0002$\u0003\u0013\u0004B!!+\u0002L&!\u0011QZAV\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f\u001e$fi\u000eD\u0017J\u001c3fq\u001a\u0013x.\u001c*f[>$Xm\u0015;pe\u0006<W\rK\u0002%\u0003\u0013\f\u0001\u0006^3ti\u001a+Go\u00195J]\u0012,\u0007PR8s\u001b&\u001c8/\u001b8h)J\fgn]1di&|g.\u00138eKbD3!JAe\u0003A\"Xm\u001d;Q_NLG/[8o\r>\u0014hj\u001c8Fq&\u001cH/\u001b8h\u0013:$W\r\u001f$s_6\u0014V-\\8uKN#xN]1hK\"\u001aa%!3\u0002)Q,7\u000f^\"bG\",WI\u001c;ss\u0016C\b/\u001b:zQ\r9\u0013\u0011Z\u0001\u001ci\u0016\u001cHoR3u\u0013:$W\r_!gi\u0016\u00148)Y2iK\u000ecwn]3)\u0007!\nI-A\u000buKN$8\t\\8tK&\u001b\u0018\nZ3na>$XM\u001c;)\u0007%\nI-\u0001\u0011uKN$8)Y2iK\u0016sGO]=Jg\u0012+G.\u001a;fI>s'+Z7pm\u0006d\u0007f\u0001\u0016\u0002J\u0006IB/Z:u\u00072,\u0017M\\3s)\"\u0014X-\u00193TQV$Hm\\<oQ\rY\u0013\u0011Z\u0001\ni\u0016\u001cHo\u00117pg\u0016D3\u0001LAe\u0003\u0015\"Xm\u001d;D_:\u001cWO\u001d:f]R\u0014V-\u00193Xe&$X-Q2dKN\u001chi\u001c:DC\u000eDW\rK\u0002.\u0003\u0013\f\u0011\u0004^3tiJ+Gn\\1e\u0007\u0006\u001c\u0007.Z!gi\u0016\u00148\t\\8tK\"\u001aa&!3\u0002\u001dQ,7\u000f\u001e*f[>4X-\u0013;f[\"\u001aq&!3\u00023Q,7\u000f\u001e*f[>4XMT8o\u000bbL7\u000f^3oi&#X-\u001c\u0015\u0004a\u0005%\u0017a\u0006;fgR\u0014V-\\8wK6+H\u000e^5qY\u0016LE/Z7tQ\r\t\u0014\u0011Z\u0001+i\u0016\u001cHo\u00117fCJ\u001c\u0015m\u00195f\u0003:$\u0017J\u001c3fq\u001aKG.Z:XQ\u0016t'+Z:ju\u0016\u001c\u0015m\u00195fQ\r\u0011\u0014\u0011Z\u00014i\u0016\u001cHoQ8se\u0016\u001cGO\\3tg\u001a{'oQ1dQ\u0016\fe\u000eZ%oI\u0016Dh)\u001b7fg^CWM\u001c*fg&TXmQ1dQ\u0016D3aMAe\u00031\"Xm\u001d;D_J\u0014X\u000f\u001d;DC\u000eDW-\u00138eKb4\u0015\u000e\\3Fq&\u001cHo\u001d\"vi:{G/\u00138DC\u000eDW\r\u0006\u0003\u0002F\tM\u0001b\u0002B\u000bi\u0001\u0007!qC\u0001\nS:$W\r\u001f+za\u0016\u0004BA!\u0007\u0003B9!!1\u0004B\u001f\u001d\u0011\u0011iBa\u000f\u000f\t\t}!\u0011\b\b\u0005\u0005C\u00119D\u0004\u0003\u0003$\tUb\u0002\u0002B\u0013\u0005gqAAa\n\u000329!!\u0011\u0006B\u0018\u001b\t\u0011YCC\u0002\u0003.Q\u000ba\u0001\u0010:p_Rt\u0014\"A7\n\u0005md\u0017BA*{\u0013\tA\u00180\u0003\u0002Ro&\u0019q*!\n\n\t\u0005\u0005\u00121E\u0005\u0005\u0005\u007f\ty\"\u0001\u000bSK6|G/Z*u_J\fw-Z'b]\u0006<WM]\u0005\u0005\u0005\u0007\u0012)EA\u0005J]\u0012,\u0007\u0010V=qK*!!qHA\u0010Q\r!$\u0011\n\t\u0005\u0005\u0017\u0012\t&\u0004\u0002\u0003N)!!qJAX\u0003\u0019\u0001\u0018M]1ng&!!1\u000bB'\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\fi\t]#1\rB3\u0005O\u0012I\u0007\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\u0011\u0011iF!\u0014\u0002\u0011A\u0014xN^5eKJLAA!\u0019\u0003\\\tQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0005\t]\u0011!\u00028b[\u0016\u001cHF\u0002B6\u0005_\u0012\u0019(\t\u0002\u0003n\u00051qJ\u0012$T\u000bR\u000b#A!\u001d\u0002\u0013QKU*R*U\u00036\u0003\u0016E\u0001B;\u0003-!&+\u0011(T\u0003\u000e#\u0016j\u0014(\u0002AQ,7\u000f^\"p]\u000e,(O]3oiJ+Wn\u001c<f%\u0016\fGMR8s\u0007\u0006\u001c\u0007.\u001a\u0015\u0004k\u0005%\u0017a\r;fgRlU\u000f\u001c;ja2,\u0017J\u001c3fq\u0016sGO]5fg\u0016CXmY;uS>t\u0017J\\\"peJ,\b\u000f^#yG\u0016\u0004H/[8oQ\r1\u0014\u0011Z\u0001-i\u0016\u001cH/\u00138eKb4\u0015\u000e\\3BYJ,\u0017\rZ=Fq&\u001cHo\u00148ESN\\')\u001e;O_RLenQ1dQ\u0016D3aNAe\u0003}!Xm\u001d;S'6\u0013V\r^;s]\u000e{'O];qi\u0016$\u0017J\u001c3fq\u001aKG.\u001a\u000b\u0005\u0003\u000b\u00129\tC\u0004\u0003\nb\u0002\rAa\u0006\u0002\u001bQ,7\u000f^%oI\u0016DH+\u001f9fQ\rA$\u0011\n\u0015\fq\t]#1\rB3\u0005O\u0012y\t\f\u0004\u0003l\t=$1O\u0001%i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0007\u0006\u001c\u0007.\u001a#fY\u0016$X\r\u001a$jY\u0016,\u00050[:ug\"\u001a\u0011(!3\u0002+\u001d,g.\u001a:bi\u0016\u001c\u0006/_\"bG\",WI\u001c;ssR!!\u0011\u0014BT!\u0011\u0011YJ!)\u000f\t\u0005M\"QT\u0005\u0005\u0005?\u000b)$\u0001\tSK6|G/Z%oI\u0016D8)Y2iK&!!1\u0015BS\u0005\u0015)e\u000e\u001e:z\u0015\u0011\u0011y*!\u000e\t\u0013\t%&\b%AA\u0002\t-\u0016A\u0005:f[>$X\rT8h'\u0016<W.\u001a8u\u0013\u0012\u0004B!!\b\u0003.&!!qVA\u0010\u0005I\u0011V-\\8uK2{wmU3h[\u0016tG/\u00133\u0002?\u001d,g.\u001a:bi\u0016\u001c\u0006/_\"bG\",WI\u001c;ss\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00036*\"!1\u0016B\\W\t\u0011I\f\u0005\u0003\u0003<\n\u0015WB\u0001B_\u0015\u0011\u0011yL!1\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bb1\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d'Q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF1tg\u0016\u0014H/\u0011;MK\u0006\u001cHo\u00148f!J,7/\u001a8u)\u0019\t)E!4\u0003P\"9\u0011Q\u0006\u001fA\u0002\u0005E\u0002b\u0002Biy\u0001\u0007!1[\u0001\u0006kVLGm\u001d\t\u0006/\nU'\u0011\\\u0005\u0004\u0005/D&A\u0003\u001fsKB,\u0017\r^3e}A!\u0011q\u0012Bn\u0013\u0011\u0011i.!%\u0003\tU+\u0018\u000eZ\u0001\u0010CN\u001cXM\u001d;DC\u000eDWmU5{KR!\u0011Q\tBr\u0011\u001d\u0011)/\u0010a\u0001\u0003\u0007\tA\"\u001a=qK\u000e$X\rZ*ju\u0016\f!D^3sS\u001aLh)\u001a;dQ&sG-\u001a=J]Z|7-\u0019;j_:$b!!\u0012\u0003l\n=\bb\u0002Bw}\u0001\u0007\u00111A\u0001\u0006G>,h\u000e\u001e\u0005\n\u0005ct\u0004\u0013!a\u0001\u0005g\f!\"\u001b8eKb$\u0016\u0010]3t!\u0019\u0011)Pa@\u0003\u00189!!q\u001fB~\u001d\u0011\u0011IC!?\n\u0003eK1A!@Y\u0003\u001d\u0001\u0018mY6bO\u0016LAa!\u0001\u0004\u0004\t\u00191+Z9\u000b\u0007\tu\b,\u0001\u0013wKJLg-\u001f$fi\u000eD\u0017J\u001c3fq&sgo\\2bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019IA\u000b\u0003\u0003t\n]\u0016aH2sK\u0006$X\r\u0016=J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR11qBB\u000b\u00073\u0001B!a\r\u0004\u0012%!11CA\u001b\u0005A!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010C\u0004\u0004\u0018\u0001\u0003\r!!\u0016\u0002\u00115,G/\u00193bi\u0006Dqaa\u0007A\u0001\u0004\t9'A\u0002eSJ\fqe\u0019:fCR,7i\u001c:skB$H\u000b\u001f8J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR11qBB\u0011\u0007GAqaa\u0007B\u0001\u0004\t9\u0007C\u0004\u0004\u0018\u0005\u0003\r!!\u0016\u0002C\r\u0014X-\u0019;f)&lW-\u00138eKb4uN]*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0015\r\r%2qFB\u0019!\u0011\t\u0019da\u000b\n\t\r5\u0012Q\u0007\u0002\n)&lW-\u00138eKbDqaa\u0006C\u0001\u0004\t)\u0006C\u0004\u0004\u001c\t\u0003\r!a\u001a\u0002G\r\u0014X-\u0019;f\u001f\u001a47/\u001a;J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR11qGB\u001f\u0007\u007f\u0001B!a\r\u0004:%!11HA\u001b\u0005-yeMZ:fi&sG-\u001a=\t\u000f\r]1\t1\u0001\u0002V!911D\"A\u0002\u0005\u001d\u0014\u0001I4f]\u0016\u0014\u0018\r^3SK6|G/\u001a'pON+w-\\3oi6+G/\u00193bi\u0006$ba!\u0012\u0004L\r=\u0003C\u0002B{\u0007\u000f\n)&\u0003\u0003\u0004J\r\r!\u0001\u0002'jgRDqa!\u0014E\u0001\u0004\t\u0019!\u0001\u0003tSj,\u0007bBB)\t\u0002\u0007\u0011QR\u0001\u0005iBLE-A\fnCf\u0014W-\u00119qK:$\u0017J\u001c3fq\u0016sGO]5fgR1\u0011QIB,\u00077Bqa!\u0017F\u0001\u0004\u00199$A\u0006pM\u001a\u001cX\r^%oI\u0016D\bbBB/\u000b\u0002\u00071\u0011F\u0001\ni&lW-\u00138eKb\f\u0011$Z:uS6\fG/Z(oK\u0016sGO]=CsR,7oU5{KR\t!-A\tn_\u000e\\'k]7GKR\u001c\u0007.\u00138eKb$B!!\u0012\u0004h!9\u0011qC$A\u0002\u0005m\u0011\u0001H2sK\u0006$XmQ8seV\u0004Ho\u00144gg\u0016$\u0018J\u001c3fq\u001aKG.\u001a\u000b\u0005\u0003\u000b\u001ai\u0007C\u0004\u0004\u001c!\u0003\r!a\u001a\u0002A\r\u0014X-\u0019;f\u0007>\u0014(/\u001e9u)&lW-\u00138eKb|eMZ:fi\u001aKG.\u001a\u000b\u0005\u0003\u000b\u001a\u0019\bC\u0004\u0004\u001c%\u0003\r!a\u001a\u00021\r\u0014X-\u0019;f\u0007>\u0014(/\u001e9uK\u0012Le\u000eZ3y\r&dW\r\u0006\u0004\u0002F\re41\u0010\u0005\b\u0005+Q\u0005\u0019\u0001B\f\u0011\u001d\u0019YB\u0013a\u0001\u0003O\nadZ3u\u0013:$W\r\u001f$jY\u00164%o\\7SK6|G/Z\"bG\",G)\u001b:\u0015\r\r\u00055QVBXa\u0011\u0019\u0019i!%\u0011\r\r\u00155\u0011RBG\u001b\t\u00199IC\u0002w\u0003_JAaa#\u0004\b\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0004\u0010\u000eEE\u0002\u0001\u0003\f\u0007'[\u0015\u0011!A\u0001\u0006\u0003\u0019)J\u0001\u0002`cE!1qSBO!\r96\u0011T\u0005\u0004\u00077C&a\u0002(pi\"Lgn\u001a\t\u0005\u0007?\u001bI+\u0004\u0002\u0004\"*!11UBS\u0003\u00111\u0017\u000e\\3\u000b\t\r\u001d\u0016qN\u0001\u0004]&|\u0017\u0002BBV\u0007C\u0013A\u0001U1uQ\"9\u0011QF&A\u0002\u0005E\u0002bBBY\u0017\u0002\u000711W\u0001\u0007gV4g-\u001b=\u0011\t\rU6Q\u0018\b\u0005\u0007o\u001bI\fE\u0002\u0003*aK1aa/Y\u0003\u0019\u0001&/\u001a3fM&!1qXBa\u0005\u0019\u0019FO]5oO*\u001911\u0018-\u0002/\u001d,GOU;o]&twm\u00117fC:,'\u000f\u00165sK\u0006$WCABd!\u0019\u0019)i!3\u0004N&!11ZBD\u0005\r\u0019V\r\u001e\t\u0005\u0007\u001f\u001c).\u0004\u0002\u0004R*!11[A8\u0003\u0011a\u0017M\\4\n\t\r]7\u0011\u001b\u0002\u0007)\"\u0014X-\u00193")
public class RemoteIndexCacheTest {
    private final long defaultRemoteIndexCacheSizeBytes;
    private final Logger logger = LoggerFactory.getLogger(RemoteIndexCacheTest.class);
    private final MockTime time = new MockTime();
    private final int brokerId;
    private final long baseOffset;
    private final long lastOffset = this.baseOffset() + 30L;
    private final int segmentSize;
    private final RemoteStorageManager rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
    private RemoteIndexCache cache;
    private RemoteLogSegmentMetadata rlsMetadata;
    private File logDir;
    private File tpDir;
    private TopicIdPartition idPartition;

    private long defaultRemoteIndexCacheSizeBytes() {
        return this.defaultRemoteIndexCacheSizeBytes;
    }

    private Logger logger() {
        return this.logger;
    }

    private MockTime time() {
        return this.time;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private long baseOffset() {
        return this.baseOffset;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private int segmentSize() {
        return this.segmentSize;
    }

    private RemoteStorageManager rsm() {
        return this.rsm;
    }

    private RemoteIndexCache cache() {
        return this.cache;
    }

    private void cache_$eq(RemoteIndexCache x$1) {
        this.cache = x$1;
    }

    private RemoteLogSegmentMetadata rlsMetadata() {
        return this.rlsMetadata;
    }

    private void rlsMetadata_$eq(RemoteLogSegmentMetadata x$1) {
        this.rlsMetadata = x$1;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private File tpDir() {
        return this.tpDir;
    }

    private void tpDir_$eq(File x$1) {
        this.tpDir = x$1;
    }

    private TopicIdPartition idPartition() {
        return this.idPartition;
    }

    private void idPartition_$eq(TopicIdPartition x$1) {
        this.idPartition = x$1;
    }

    @BeforeEach
    public void setup() {
        this.idPartition_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0)));
        String tempDirectory_prefix = "kafka-" + this.getClass().getSimpleName();
        Object var2_1 = null;
        this.logDir_$eq(TestUtils.tempDirectory(null, (String)tempDirectory_prefix));
        this.tpDir_$eq(new File(this.logDir(), this.idPartition().toString()));
        Files.createDirectory(this.tpDir().toPath(), new FileAttribute[0]);
        RemoteLogSegmentId remoteLogSegmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
        this.rlsMetadata_$eq(new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L))));
        this.cache_$eq(new RemoteIndexCache(this.defaultRemoteIndexCacheSizeBytes(), this.rsm(), this.tpDir().toString()));
        this.mockRsmFetchIndex(this.rsm());
    }

    @AfterEach
    public void cleanup() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        try {
            Utils.delete((File)this.logDir());
        }
        catch (IOException iOException) {}
        TestUtils$.MODULE$.assertNoNonDaemonThreads("remote-log-index-cleaner");
    }

    @Test
    public void testIndexFileNameAndLocationOnDisk() {
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)("offsetIndex=" + offsetIndexFile + " is created under incorrect parent"));
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)("txnIndex=" + txnIndexFile + " is created under incorrect parent"));
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)("timeIndex=" + timeIndexFile + " is created under incorrect parent"));
    }

    @Test
    public void testFetchIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        OffsetPosition offsetPosition1 = offsetIndex.entry(1);
        int resultPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition1.offset);
        Assertions.assertEquals((int)offsetPosition1.position, (int)resultPosition);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        OffsetPosition offsetPosition2 = offsetIndex.entry(2);
        int resultPosition2 = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition2.offset);
        Assertions.assertEquals((int)offsetPosition2.position, (int)resultPosition2);
        Assertions.assertNotNull((Object)this.cache().getIndexEntry(this.rlsMetadata()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.rsm()});
    }

    @Test
    public void testFetchIndexForMissingTransactionIndex() {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                throw new RemoteResourceNotFoundException("txn index not found");
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)entry.txnIndex().file().exists());
        Assertions.assertEquals((long)0L, (long)entry.txnIndex().file().length());
    }

    @Test
    public void testPositionForNonExistingIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        int lastOffsetPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetIndex.lastOffset());
        long greaterOffsetThanLastOffset = offsetIndex.lastOffset() + 1L;
        Assertions.assertEquals((int)lastOffsetPosition, (int)this.cache().lookupOffset(this.rlsMetadata(), greaterOffsetThanLastOffset));
        OffsetPosition nonExistentOffsetPosition = new OffsetPosition(this.baseOffset(), 0);
        long lowerOffsetThanBaseOffset = offsetIndex.baseOffset() - 1L;
        Assertions.assertEquals((int)nonExistentOffsetPosition.position, (int)this.cache().lookupOffset(this.rlsMetadata(), lowerOffsetThanBaseOffset));
    }

    @Test
    public void testCacheEntryExpiry() {
        long estimateEntryBytesSize = this.estimateOneEntryBytesSize();
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2L * estimateEntryBytesSize, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        this.assertAtLeastOnePresent(this.cache(), (Seq<Uuid>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{((RemoteLogSegmentMetadata)metadataList.apply(1)).remoteLogSegmentId().id(), ((RemoteLogSegmentMetadata)metadataList.head()).remoteLogSegmentId().id()}));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        Option missingEntryOpt = metadataList.find((Function1 & Serializable)segmentMetadata -> BoxesRunTime.boxToBoolean((boolean)RemoteIndexCacheTest.$anonfun$testCacheEntryExpiry$1(this, segmentMetadata)));
        Assertions.assertFalse((boolean)missingEntryOpt.isEmpty());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)missingEntryOpt.get());
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(4, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testGetIndexAfterCacheClose() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2L * this.estimateOneEntryBytesSize(), this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
    }

    @Test
    public void testCloseIsIdempotent() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        this.cache().close();
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheEntryIsDeletedOnRemoval() {
        Uuid internalIndexKey = this.rlsMetadata().remoteLogSegmentId().id();
        RemoteIndexCache.Entry cacheEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".index").isPresent(), (String)("Offset index file should be present on disk at " + this.tpDir().toPath()));
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".txnindex").isPresent(), (String)("Txn index file should be present on disk at " + this.tpDir().toPath()));
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".timeindex").isPresent(), (String)("Time index file should be present on disk at " + this.tpDir().toPath()));
        this.cache().internalCache().put((Object)internalIndexKey, (Object)cacheEntry);
        Assertions.assertEquals((int)0, (int)this.cache().expiredIndexes().size(), (String)"expiredIndex queue should be zero at start of test");
        this.cache().remove(internalIndexKey);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup cache entry after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry, (VerificationMode)Mockito.times((int)2))).markForCleanup();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry)).cleanup();
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.timeIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.offsetIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((TransactionIndex)Mockito.verify((Object)cacheEntry.txnIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)("Offset index file should not be present on disk at " + this.tpDir().toPath()));
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)("Txn index file should not be present on disk at " + this.tpDir().toPath()));
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)("Time index file should not be present on disk at " + this.tpDir().toPath()));
        Assertions.assertFalse((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".deleted").isPresent(), (String)("Index file marked for deletion should not be present on disk at " + this.tpDir().toPath()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanerThreadShutdown() {
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().isEmpty());
        this.getRunningCleanerThread();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        spyEntry.cleanup();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("kaboom! I am expected exception in unit test.")});
        Uuid key = Uuid.randomUuid();
        this.cache().internalCache().put((Object)key, (Object)spyEntry);
        this.cache().internalCache().invalidate((Object)key);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed while waiting for clean up to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Thread.sleep(100L);
        Set<Thread> threads = this.getRunningCleanerThread();
        Assertions.assertEquals((int)1, (int)threads.size(), (String)("Found unexpected " + threads.size() + " threads=" + threads.stream().map(t -> t.getName()).collect(Collectors.joining(", "))));
        this.cache().close();
        threads = this.getRunningCleanerThread();
        Assertions.assertTrue((boolean)threads.isEmpty(), (String)("Found unexpected " + threads.size() + " threads=" + threads.stream().map(t -> t.getName()).collect(Collectors.joining(", "))));
        Assertions.assertFalse((boolean)this.cache().cleanerThread().isRunning(), (String)"Unexpected thread state=running. Check error logs.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClose$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cleaner thread should be started");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex())).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        Assertions.assertTrue((boolean)this.cache().cleanerThread().isShutdownComplete());
    }

    @Test
    public void testConcurrentReadWriteAccessForCache() {
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        CountDownLatch latchForCacheHit = new CountDownLatch(1);
        CountDownLatch latchForCacheMiss = new CountDownLatch(1);
        Runnable readerCacheHit = () -> {
            this.logger().debug("Waiting for signal to begin read from " + Thread.currentThread());
            latchForCacheHit.await();
            Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
            this.logger().debug("Signaling CacheMiss to unblock from " + Thread.currentThread());
            latchForCacheMiss.countDown();
        };
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(x$7 -> {
            RemoteIndexCacheTest.$anonfun$testConcurrentReadWriteAccessForCache$2(this, latchForCacheHit, latchForCacheMiss, x$7);
            return BoxedUnit.UNIT;
        });
        Runnable readerCacheMiss = () -> Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            executor.submit(readerCacheMiss);
            executor.submit(readerCacheHit);
            Assertions.assertTrue((boolean)latchForCacheMiss.await(30L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testReloadCacheAfterClose() {
        long estimateEntryBytesSize = this.estimateOneEntryBytesSize();
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2L * estimateEntryBytesSize, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        RemoteIndexCache reloadedCache = new RemoteIndexCache(2L * estimateEntryBytesSize, this.rsm(), this.tpDir().toString());
        Assertions.assertEquals((int)2, (int)reloadedCache.internalCache().asMap().size());
        reloadedCache.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.rsm()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRemoveItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        this.cache().remove(segmentId.id());
        Assertions.assertFalse((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRemoveNonExistentItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        this.cache().remove(Uuid.randomUuid());
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
    }

    @Test
    public void testRemoveMultipleItems() {
        HashMap uuidAndEntryList = new HashMap();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            RemoteLogSegmentId segmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
            Uuid segmentUuid = segmentId.id();
            RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
            uuidAndEntryList.put(segmentUuid, spyEntry);
            this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
            Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
            Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        });
        this.cache().removeAll(uuidAndEntryList.keySet());
        uuidAndEntryList.values().forEach(entry -> {
            long waitUntilTrue_pause = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!entry.isMarkedForCleanup()) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearCacheAndIndexFilesWhenResizeCache() {
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(1, tpId);
        this.assertCacheSize(0);
        RemoteIndexCache.Entry cacheEntry = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent());
        this.cache().resizeCacheSize(1L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after resizing cache.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup cache entry after resizing cache.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$11(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testClearCacheAndIndexFilesWhenResizeCache$12(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        this.assertCacheSize(0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorrectnessForCacheAndIndexFilesWhenResizeCache() {
        long estimateEntryBytesSize = this.estimateOneEntryBytesSize();
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        RemoteIndexCache.Entry cacheEntry = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent());
        this.cache().resizeCacheSize(1L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after resizing cache.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup cache entry after resizing cache.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$17(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$18(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$19(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$20(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$21(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$22(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$23(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$24(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        this.assertCacheSize(0);
        this.cache().resizeCacheSize(2L * estimateEntryBytesSize);
        this.assertCacheSize(0);
        RemoteIndexCache.Entry entry0 = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(0));
        RemoteIndexCache.Entry entry1 = this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.verifyEntryIsEvicted$1((RemoteLogSegmentMetadata)metadataList.apply(0), entry0);
        this.cache().resizeCacheSize(1L * estimateEntryBytesSize);
        this.assertCacheSize(1);
        this.verifyEntryIsEvicted$1((RemoteLogSegmentMetadata)metadataList.apply(1), entry1);
        this.cache().resizeCacheSize(1L * estimateEntryBytesSize);
        this.verifyEntryIsKept$1((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(1);
        this.cache().resizeCacheSize(2L * estimateEntryBytesSize);
        this.verifyEntryIsKept$1((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(1);
    }

    @ParameterizedTest
    @EnumSource(value=RemoteStorageManager.IndexType.class, names={"OFFSET", "TIMESTAMP", "TRANSACTION"})
    public void testCorruptCacheIndexFileExistsButNotInCache(RemoteStorageManager.IndexType indexType) {
        this.createCorruptedIndexFile(indexType, this.cache().cacheDir());
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)("offsetIndex=" + offsetIndexFile + " is created under incorrect parent"));
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)("txnIndex=" + txnIndexFile + " is created under incorrect parent"));
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)("timeIndex=" + timeIndexFile + " is created under incorrect parent"));
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testConcurrentRemoveReadForCache() {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition()), this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata, new File(this.tpDir(), "remote-log-index-cache")));
        RemoteIndexCache.Entry spyEntry = (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
        this.cache().internalCache().put((Object)rlsMetadata.remoteLogSegmentId().id(), (Object)spyEntry);
        this.assertCacheSize(1);
        ObjectRef entry = ObjectRef.create(null);
        CountDownLatch latchForCacheRead = new CountDownLatch(1);
        CountDownLatch latchForCacheRemove = new CountDownLatch(1);
        CountDownLatch latchForTestWait = new CountDownLatch(1);
        ((RemoteIndexCache.Entry)Mockito.doAnswer(arg_0 -> RemoteIndexCacheTest.$anonfun$testConcurrentRemoveReadForCache$1(IntRef.create((int)0), latchForCacheRead, latchForCacheRemove, latchForTestWait, arg_0)).when((Object)spyEntry)).markForCleanup();
        Runnable removeCache = () -> this.cache().remove(rlsMetadata.remoteLogSegmentId().id());
        Runnable readCache = () -> {
            latchForCacheRead.await();
            entry$2.elem = this.cache().getIndexEntry(rlsMetadata);
            latchForCacheRemove.countDown();
        };
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<?> removeCacheFuture = executor.submit(removeCache);
            Future<?> readCacheFuture = executor.submit(readCache);
            removeCacheFuture.get();
            readCacheFuture.get();
            latchForTestWait.await();
            if (this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent()) {
                this.assertCacheSize(1);
            } else {
                this.assertCacheSize(0);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMultipleIndexEntriesExecutionInCorruptException() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            this.createCorruptTimeIndexOffsetFile(this.tpDir());
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        Assertions.assertThrows(CorruptIndexException.class, () -> this.cache().getIndexEntry(this.rlsMetadata()));
        Assertions.assertNull((Object)this.cache().internalCache().getIfPresent((Object)this.rlsMetadata().remoteLogSegmentId().id()));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        this.verifyFetchIndexInvocation(0, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Files.walk(this.tpDir().toPath(), 1, new FileVisitOption[0]).filter(x$9 -> Files.isRegularFile(x$9, new LinkOption[0])).forEach(path -> Files.deleteIfExists(path));
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(0, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)Nil$.MODULE$));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$));
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIndexFileAlreadyExistOnDiskButNotInCache() {
        File remoteIndexCacheDir = this.cache().cacheDir();
        String tempSuffix = ".tmptest";
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        Files.copy(entry.offsetIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.offsetIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        Files.copy(entry.txnIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.txnIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        Files.copy(entry.timeIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.timeIndex().file().getPath(), (String)"", (String)tempSuffix), new String[0]), new CopyOption[0]);
        this.cache().remove(this.rlsMetadata().remoteLogSegmentId().id());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup cache entry after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        RemoteIndexCacheTest.renameRemoteCacheIndexFileFromDisk$1(tempSuffix, remoteIndexCacheDir, tempSuffix);
        Assertions.assertNull((Object)this.cache().internalCache().getIfPresent((Object)this.rlsMetadata().remoteLogSegmentId().id()));
        this.cache().getIndexEntry(this.rlsMetadata());
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)("Offset index file should be present on disk at " + remoteIndexCacheDir.toPath()));
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)("Txn index file should be present on disk at " + remoteIndexCacheDir.toPath()));
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)("Time index file should be present on disk at " + remoteIndexCacheDir.toPath()));
    }

    @ParameterizedTest
    @EnumSource(value=RemoteStorageManager.IndexType.class, names={"OFFSET", "TIMESTAMP", "TRANSACTION"})
    public void testRSMReturnCorruptedIndexFile(RemoteStorageManager.IndexType testIndexType) {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            this.createCorruptedIndexFile(testIndexType, this.tpDir());
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        Assertions.assertThrows(CorruptIndexException.class, () -> this.cache().getIndexEntry(this.rlsMetadata()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentCacheDeletedFileExists() {
        File remoteIndexCacheDir = this.cache().cacheDir();
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".index").isPresent(), (String)("Offset index file should be present on disk at " + remoteIndexCacheDir.toPath()));
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".txnindex").isPresent(), (String)("Txn index file should be present on disk at " + remoteIndexCacheDir.toPath()));
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".timeindex").isPresent(), (String)("Time index file should be present on disk at " + remoteIndexCacheDir.toPath()));
        Files.copy(entry.offsetIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.offsetIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Files.copy(entry.txnIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.txnIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Files.copy(entry.timeIndex().file().toPath(), Paths.get(Utils.replaceSuffix((String)entry.timeIndex().file().getPath(), (String)"", (String)".deleted"), new String[0]), new CopyOption[0]);
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), ".deleted").isPresent(), (String)("Deleted Offset index file should be present on disk at " + remoteIndexCacheDir.toPath()));
        this.cache().remove(this.rlsMetadata().remoteLogSegmentId().id());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup cache entry after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$6(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$7(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$8(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$10(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$11(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testConcurrentCacheDeletedFileExists$12(remoteIndexCacheDir));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
    }

    private RemoteIndexCache.Entry generateSpyCacheEntry(RemoteLogSegmentId remoteLogSegmentId) {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata, this.tpDir()));
        return (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
    }

    private RemoteLogSegmentId generateSpyCacheEntry$default$1() {
        return RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
    }

    private void assertAtLeastOnePresent(RemoteIndexCache cache, Seq<Uuid> uuids) {
        Object object = new Object();
        try {
            uuids.foreach((Function1 & Serializable)uuid -> {
                RemoteIndexCacheTest.$anonfun$assertAtLeastOnePresent$1(cache, object, uuid);
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"all uuids are not present in cache");
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assertCacheSize(int expectedSize) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$assertCacheSize$1(this, expectedSize)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$assertCacheSize$2(expectedSize));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyFetchIndexInvocation(int count, Seq<RemoteStorageManager.IndexType> indexTypes) {
        indexTypes.foreach((Function1 & Serializable)indexType -> ((RemoteStorageManager)Mockito.verify((Object)this.rsm(), (VerificationMode)Mockito.times((int)count))).fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.eq((Object)indexType)));
    }

    private Seq<RemoteStorageManager.IndexType> verifyFetchIndexInvocation$default$2() {
        return new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$)));
    }

    private TransactionIndex createTxIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        return new TransactionIndex(metadata.startOffset(), txnIdxFile);
    }

    private TransactionIndex createCorruptTxnIndexForSegmentMetadata(File dir, RemoteLogSegmentMetadata metadata) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        TransactionIndex txnIndex = new TransactionIndex(metadata.startOffset(), txnIdxFile);
        new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)x$1 -> {
            txnIndex.append(x$1);
            return BoxedUnit.UNIT;
        });
        txnIndex.close();
        return new TransactionIndex(100L, txnIdxFile);
    }

    private TimeIndex createTimeIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new TimeIndex(RemoteIndexCache.remoteTimeIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 12);
    }

    private OffsetIndex createOffsetIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata, File dir) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new OffsetIndex(RemoteIndexCache.remoteOffsetIndexFile((File)dir, (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 8);
    }

    private List<RemoteLogSegmentMetadata> generateRemoteLogSegmentMetadata(int size, TopicIdPartition tpId) {
        Buffer metadataList = (Buffer)Buffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable)i -> metadataList.append((Object)new RemoteLogSegmentMetadata(new RemoteLogSegmentId(tpId, Uuid.randomUuid()), this.baseOffset() * (long)BoxesRunTime.unboxToInt((Object)i), this.baseOffset() * (long)BoxesRunTime.unboxToInt((Object)i) + 10L, this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)))));
        return metadataList.toList();
    }

    private void maybeAppendIndexEntries(OffsetIndex offsetIndex, TimeIndex timeIndex) {
        if (!offsetIndex.isFull()) {
            long curTime = this.time().milliseconds();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), offsetIndex.maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long offset = offsetIndex.baseOffset() + (long)i;
                offsetIndex.append(offset, i);
                timeIndex.maybeAppend(curTime + (long)i, offset, true);
            });
            offsetIndex.flush();
            timeIndex.flush();
            return;
        }
    }

    private long estimateOneEntryBytesSize() {
        TopicPartition tp = new TopicPartition("estimate-entry-bytes-size", 0);
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), tp);
        File tpDir = new File(this.logDir(), tpId.toString());
        Files.createDirectory(tpDir.toPath(), new FileAttribute[0]);
        RemoteStorageManager rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
        this.mockRsmFetchIndex(rsm);
        RemoteIndexCache cache = new RemoteIndexCache(2L, rsm, tpDir.toString());
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(1, tpId);
        long entrySizeInBytes = cache.getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()).entrySizeBytes();
        Utils.closeQuietly((AutoCloseable)cache, (String)"RemoteIndexCache created for estimating entry size");
        return entrySizeInBytes;
    }

    private void mockRsmFetchIndex(RemoteStorageManager rsm) {
        Mockito.when((Object)rsm.fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata, this.tpDir());
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata, this.tpDir());
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata, this.tpDir());
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
    }

    private void createCorruptOffsetIndexFile(File dir) {
        PrintWriter pw = new PrintWriter(RemoteIndexCache.remoteOffsetIndexFile((File)dir, (RemoteLogSegmentMetadata)this.rlsMetadata()));
        pw.write("Hello, world");
        pw.close();
    }

    private void createCorruptTimeIndexOffsetFile(File dir) {
        PrintWriter pw = new PrintWriter(RemoteIndexCache.remoteTimeIndexFile((File)dir, (RemoteLogSegmentMetadata)this.rlsMetadata()));
        pw.write("Hello, world1");
        pw.close();
    }

    private void createCorruptedIndexFile(RemoteStorageManager.IndexType indexType, File dir) {
        block9: {
            block8: {
                RemoteStorageManager.IndexType indexType2;
                RemoteStorageManager.IndexType indexType3;
                block7: {
                    RemoteStorageManager.IndexType indexType4 = indexType;
                    RemoteStorageManager.IndexType indexType5 = RemoteStorageManager.IndexType.OFFSET;
                    if (!(indexType4 != null ? !indexType4.equals(indexType5) : indexType5 != null)) {
                        this.createCorruptOffsetIndexFile(dir);
                        return;
                    }
                    RemoteStorageManager.IndexType indexType6 = indexType;
                    RemoteStorageManager.IndexType indexType7 = RemoteStorageManager.IndexType.TIMESTAMP;
                    if (!(indexType6 != null ? !indexType6.equals(indexType7) : indexType7 != null)) {
                        this.createCorruptTimeIndexOffsetFile(dir);
                        return;
                    }
                    indexType3 = indexType;
                    indexType2 = RemoteStorageManager.IndexType.TRANSACTION;
                    if (indexType3 != null) break block7;
                    if (indexType2 != null) {
                        return;
                    }
                    break block8;
                }
                if (!indexType3.equals(indexType2)) break block9;
            }
            this.createCorruptTxnIndexForSegmentMetadata(dir, this.rlsMetadata());
            return;
        }
    }

    private Optional<? extends Path> getIndexFileFromRemoteCacheDir(RemoteIndexCache cache, String suffix) {
        try {
            return Files.walk(cache.cacheDir().toPath(), new FileVisitOption[0]).filter(x$11 -> Files.isRegularFile(x$11, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFileException ? true : throwable instanceof UncheckedIOException) {
                return Optional.empty();
            }
            throw throwable;
        }
    }

    private Set<Thread> getRunningCleanerThread() {
        return Thread.getAllStackTraces().keySet().stream().filter(t -> t.isAlive() && t.getName().startsWith("remote-log-index-cleaner")).collect(Collectors.toSet());
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryExpiry$1(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata segmentMetadata) {
        Uuid segmentId = segmentMetadata.remoteLogSegmentId().id();
        return !$this.cache().internalCache().asMap().containsKey(segmentId);
    }

    private final Optional getIndexFileFromDisk$1(String suffix) {
        return Files.walk(this.tpDir().toPath(), new FileVisitOption[0]).filter(x$6 -> Files.isRegularFile(x$6, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryIsDeletedOnRemoval$3(RemoteIndexCache.Entry cacheEntry$1) {
        return cacheEntry$1.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnRemoval$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryIsDeletedOnRemoval$5(RemoteIndexCache.Entry cacheEntry$1) {
        return cacheEntry$1.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnRemoval$6() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testCleanerThreadShutdown$1(RemoteIndexCache.Entry spyEntry$1) {
        return spyEntry$1.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testCleanerThreadShutdown$2() {
        return "Failed while waiting for clean up to start";
    }

    public static final /* synthetic */ boolean $anonfun$testClose$1(RemoteIndexCacheTest $this) {
        return $this.cache().cleanerThread().isStarted();
    }

    public static final /* synthetic */ String $anonfun$testClose$2() {
        return "Cleaner thread should be started";
    }

    public static final /* synthetic */ void $anonfun$testConcurrentReadWriteAccessForCache$2(RemoteIndexCacheTest $this, CountDownLatch latchForCacheHit$1, CountDownLatch latchForCacheMiss$1, InvocationOnMock x$7) {
        $this.logger().debug("Signaling CacheHit to begin read from " + Thread.currentThread());
        latchForCacheHit$1.countDown();
        $this.logger().debug("Waiting for signal to complete rsm fetch from " + Thread.currentThread());
        latchForCacheMiss$1.await();
    }

    public static final /* synthetic */ boolean $anonfun$testRemoveItem$1(RemoteIndexCache.Entry spyEntry$2) {
        return spyEntry$2.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testRemoveItem$2() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testRemoveMultipleItems$3(RemoteIndexCache.Entry entry$1) {
        return entry$1.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testRemoveMultipleItems$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$1(RemoteIndexCache.Entry cacheEntry$2) {
        return cacheEntry$2.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$2() {
        return "Failed to mark cache entry for cleanup after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$3(RemoteIndexCache.Entry cacheEntry$2) {
        return cacheEntry$2.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$4() {
        return "Failed to cleanup cache entry after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$5(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".index").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$6(RemoteIndexCacheTest $this) {
        return "Offset index file should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$7(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".txnindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$8(RemoteIndexCacheTest $this) {
        return "Txn index file should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$9(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".timeindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$10(RemoteIndexCacheTest $this) {
        return "Time index file should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testClearCacheAndIndexFilesWhenResizeCache$11(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".deleted").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testClearCacheAndIndexFilesWhenResizeCache$12(RemoteIndexCacheTest $this) {
        return "Index file marked for deletion should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$1(RemoteIndexCache.Entry entryToVerify$1) {
        return entryToVerify$1.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$2() {
        return "Failed to mark evicted cache entry for cleanup after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$3(RemoteIndexCache.Entry entryToVerify$1) {
        return entryToVerify$1.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$4() {
        return "Failed to cleanup evicted cache entry after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$5(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$6(RemoteIndexCacheTest $this) {
        return "Offset index file for evicted entry should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$7(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$8(RemoteIndexCacheTest $this) {
        return "Time index file for evicted entry should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$9(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$10(RemoteIndexCacheTest $this) {
        return "Txn index file for evicted entry should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$11(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata metadataToVerify$1) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), RemoteIndexCache.remoteDeletedSuffixIndexFileName((RemoteLogSegmentMetadata)metadataToVerify$1)).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$12(RemoteIndexCacheTest $this) {
        return "Index file marked for deletion for evicted entry should not be present on disk at " + $this.cache().cacheDir();
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyEntryIsEvicted$1(RemoteLogSegmentMetadata metadataToVerify, RemoteIndexCache.Entry entryToVerify) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!entryToVerify.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark evicted cache entry for cleanup after resizing cache.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!entryToVerify.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup evicted cache entry after resizing cache.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$5(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$6(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$7(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$8(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$9(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$10(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$11(this, metadataToVerify)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$12(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
    }

    private final void verifyEntryIsKept$1(RemoteLogSegmentMetadata metadataToVerify) {
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent());
        Assertions.assertTrue((boolean)this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent());
        Assertions.assertTrue((!this.getIndexFileFromRemoteCacheDir(this.cache(), RemoteIndexCache.remoteDeletedSuffixIndexFileName((RemoteLogSegmentMetadata)metadataToVerify)).isPresent() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$13(RemoteIndexCache.Entry cacheEntry$3) {
        return cacheEntry$3.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$14() {
        return "Failed to mark cache entry for cleanup after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$15(RemoteIndexCache.Entry cacheEntry$3) {
        return cacheEntry$3.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$16() {
        return "Failed to cleanup cache entry after resizing cache.";
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$17(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".index").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$18(RemoteIndexCacheTest $this) {
        return "Offset index file should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$19(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".txnindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$20(RemoteIndexCacheTest $this) {
        return "Txn index file should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$21(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".timeindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$22(RemoteIndexCacheTest $this) {
        return "Time index file should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ boolean $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$23(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".deleted").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCorrectnessForCacheAndIndexFilesWhenResizeCache$24(RemoteIndexCacheTest $this) {
        return "Index file marked for deletion should not be present on disk at " + $this.cache().cacheDir();
    }

    public static final /* synthetic */ Object $anonfun$testConcurrentRemoveReadForCache$1(IntRef markForCleanupCallCount$1, CountDownLatch latchForCacheRead$1, CountDownLatch latchForCacheRemove$1, CountDownLatch latchForTestWait$1, InvocationOnMock invocation) {
        ++markForCleanupCallCount$1.elem;
        if (markForCleanupCallCount$1.elem == 1) {
            latchForCacheRead$1.countDown();
            latchForCacheRemove$1.await();
            invocation.callRealMethod();
            latchForTestWait$1.countDown();
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    private static final void renameRemoteCacheIndexFileFromDisk$1(String suffix, File remoteIndexCacheDir$1, String tempSuffix$1) {
        Files.walk(remoteIndexCacheDir$1.toPath(), new FileVisitOption[0]).filter(x$10 -> Files.isRegularFile(x$10, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).forEach(f -> {
            Path atomicMoveWithFallback_target = f.resolveSibling(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Object)f.getFileName()).toString()), tempSuffix$1));
            Utils.atomicMoveWithFallback((Path)f, (Path)atomicMoveWithFallback_target, (boolean)true);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$4(RemoteIndexCache.Entry entry$3) {
        return entry$3.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$5() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$6(RemoteIndexCache.Entry entry$3) {
        return entry$3.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testIndexFileAlreadyExistOnDiskButNotInCache$7() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$1(RemoteIndexCache.Entry entry$4) {
        return entry$4.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$2() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$3(RemoteIndexCache.Entry entry$4) {
        return entry$4.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$4() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$5(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".index").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$6(File remoteIndexCacheDir$2) {
        return "Offset index file should not be present on disk at " + remoteIndexCacheDir$2.toPath();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$7(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".txnindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$8(File remoteIndexCacheDir$2) {
        return "Txn index file should not be present on disk at " + remoteIndexCacheDir$2.toPath();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$9(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".timeindex").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$10(File remoteIndexCacheDir$2) {
        return "Time index file should not be present on disk at " + remoteIndexCacheDir$2.toPath();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentCacheDeletedFileExists$11(RemoteIndexCacheTest $this) {
        return !$this.getIndexFileFromRemoteCacheDir($this.cache(), ".deleted").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentCacheDeletedFileExists$12(File remoteIndexCacheDir$2) {
        return "Index file marked for deletion should not be present on disk at " + remoteIndexCacheDir$2.toPath();
    }

    public static final /* synthetic */ void $anonfun$assertAtLeastOnePresent$1(RemoteIndexCache cache$1, Object nonLocalReturnKey1$1, Uuid uuid) {
        if (cache$1.internalCache().asMap().containsKey(uuid)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertCacheSize$1(RemoteIndexCacheTest $this, int expectedSize$1) {
        return $this.cache().internalCache().asMap().size() == expectedSize$1;
    }

    public static final /* synthetic */ String $anonfun$assertCacheSize$2(int expectedSize$1) {
        return "cache did not adhere to expected size of " + expectedSize$1;
    }

    public RemoteIndexCacheTest() {
        this.defaultRemoteIndexCacheSizeBytes = 0x100000L;
        this.brokerId = 1;
        this.baseOffset = 2147584984L;
        this.segmentSize = 1024;
    }
}

