/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.LinuxIoMetricsCollector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001\u0002\u000f\u001e\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\by\u0001\u0011\r\u0011\"\u00015\u0011\u0019i\u0004\u0001)A\u0005k!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002%\u0001A\u0003%\u0001\tC\u0004J\u0001\t\u0007I\u0011\u0001&\t\rE\u0003\u0001\u0015!\u0003L\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001d\u0001\u0007A1A\u0005\u0002QBa!\u0019\u0001!\u0002\u0013)\u0004\"\u00022\u0001\t\u0003\u0019\u0007bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003o\u0002A\u0011AA=\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!*\u0001\t\u0003\t9\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\"9\u00111\u001a\u0001\u0005\n\u00055'aC'fiJL7m\u001d+fgRT!AH\u0010\u0002\u000f5,GO]5dg*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQE\u0003\u0002'?\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\tASE\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tQS&D\u0001,\u0015\tas$A\u0003vi&d7/\u0003\u0002/W\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001\u001e\u0003!qW/\u001c(pI\u0016\u001cX#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u0007%sG/A\u0005ok6tu\u000eZ3tA\u0005Aa.^7QCJ$8/A\u0005ok6\u0004\u0016M\u001d;tA\u0005I\"/Z9vSJ,GmS1gW\u0006\u001cVM\u001d<feB\u0013XMZ5y+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007'R\u0014\u0018N\\4\u00025I,\u0017/^5sK\u0012\\\u0015MZ6b'\u0016\u0014h/\u001a:Qe\u00164\u0017\u000e\u001f\u0011\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0012\u000bA!\u001e;jY&\u0011\u0001+\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001+\u0011\u0007UC&,D\u0001W\u0015\t9v'\u0001\u0006d_2dWm\u0019;j_:L!!\u0017,\u0003\u0007M+\u0017\u000f\u0005\u0002\\=6\tAL\u0003\u0002^?\u000511/\u001a:wKJL!a\u0018/\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\n]6+7o]1hKN\f!B\\'fgN\fw-Z:!\u0003\u0015\"Xm\u001d;NKR\u0014\u0018nY:SKB|'\u000f^3s\u0003\u001a$XM\u001d#fY\u0016$\u0018N\\4U_BL7\r\u0006\u0002eOB\u0011a'Z\u0005\u0003M^\u0012A!\u00168ji\")\u0001.\u0004a\u0001S\u00061\u0011/^8sk6\u0004\"A[9\u000f\u0005-|\u0007C\u000178\u001b\u0005i'B\u00018\"\u0003\u0019a$o\\8u}%\u0011\u0001oN\u0001\u0007!J,G-\u001a4\n\u0005\u001d\u0013(B\u000198Q\tiA\u000f\u0005\u0002v}6\taO\u0003\u0002xq\u00061\u0001/\u0019:b[NT!!\u001f>\u0002\u000f),\b/\u001b;fe*\u00111\u0010`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002{\u0006\u0019qN]4\n\u0005}4(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":Q\"a\u0001\u0002\u0010\u0005E\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%a/\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\ti!a\u0002\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\t\t\u0019\"\t\u0002\u0002\u0016\u0005)1N]1gi\u0006!D/Z:u\u0005J|7.\u001a:U_BL7-T3ue&\u001c7/\u00168sK\u001eL7\u000f^3sK\u0012\fe\r^3s\t\u0016dW\r^5oOR{\u0007/[2\u0015\u0007\u0011\fY\u0002C\u0003i\u001d\u0001\u0007\u0011\u000e\u000b\u0002\u000fi\":a\"a\u0001\u0002\u0010\u0005\u0005BFAA\n\u0003M!Xm\u001d;DYV\u001cH/\u001a:JI6+GO]5d)\r!\u0017q\u0005\u0005\u0006Q>\u0001\r!\u001b\u0015\u0003\u001fQDsaDA\u0002\u0003\u001f\ti\u0003\f\u0002\u0002\u0014\u0005)B/Z:u\u0005J|7.\u001a:Ti\u0006$X-T3ue&\u001cGc\u00013\u00024!)\u0001\u000e\u0005a\u0001S\"\u0012\u0001\u0003\u001e\u0015\b!\u0005\r\u0011qBA\u001dY\t\t\u0019\"\u0001\u000fuKN$\u0018,Y7nKJlU\r\u001e:jGN\u001cu.\u001e8u\u001b\u0016$(/[2\u0015\u0007\u0011\fy\u0004C\u0003i#\u0001\u0007\u0011\u000e\u000b\u0002\u0012i\":\u0011#a\u0001\u0002\u0010\u0005\u0015CFAA\n\u0003I!Xm\u001d;MS:,\b0S8NKR\u0014\u0018nY:\u0015\u0007\u0011\fY\u0005C\u0003i%\u0001\u0007\u0011\u000e\u000b\u0002\u0013i\":!#a\u0001\u0002\u0010\u0005ECFAA\n\u00035!Xm\u001d;K\u001bb3\u0015\u000e\u001c;feR\u0019A-a\u0016\t\u000b!\u001c\u0002\u0019A5)\u0005M!\bfB\n\u0002\u0004\u0005=\u0011Q\f\u0017\u0003\u0003'\t1\u0003^3tiV\u0003H-\u0019;f\u00156Cf)\u001b7uKJ$2\u0001ZA2\u0011\u0015AG\u00031\u0001jQ\t!B\u000fK\u0004\u0015\u0003\u0007\ty!!\u001b-\u0005\u0005M\u0011A\r;fgR<UM\\3sC2\u0014%o\\6feR{\u0007/[2NKR\u0014\u0018nY:Be\u0016<%/Z3eS2L(+Z4jgR,'/\u001a3\u0015\u0007\u0011\fy\u0007C\u0003i+\u0001\u0007\u0011\u000e\u000b\u0002\u0016i\":Q#a\u0001\u0002\u0010\u0005UDFAA\n\u0003a!Xm\u001d;XS:$wn^:TifdW\rV1h\u001d\u0006lWm\u001d\u000b\u0004I\u0006m\u0004\"\u00025\u0017\u0001\u0004I\u0007F\u0001\fuQ\u001d1\u00121AA\b\u0003\u0003c#!a\u0005\u0002AQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\u0014\u0015\u0010^3t\u0013:|U\u000f\u001e\u000b\u0006I\u0006\u001d\u0015\u0011\u0012\u0005\u0006Q^\u0001\r!\u001b\u0005\u0007\u0003\u0017;\u0002\u0019A5\u0002\u001b\u001d\u0014x.\u001e9Qe>$xnY8mQ\u00199B/a$\u0002\u0012\u0006!a.Y7fC\t\t\u0019*\u0001\u0016|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|autsM]8vaB\u0013x\u000e^8d_2l40M?)\u000f]\t9*!(\u0002 B!\u0011QAAM\u0013\u0011\tY*a\u0002\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005\u0005\u0016EAAR\u0003):W\r\u001e+fgR\fVo\u001c:v[\u0006sGm\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f!\u0004^3ti.\u0013\u0016M\u001a;D_:$(o\u001c7mKJlU\r\u001e:jGN$2\u0001ZAU\u0011\u0015A\u0007\u00041\u0001jQ\tAB\u000fK\u0004\u0019\u0003\u0007\ty!a,-\u0005\u0005M\u0011\u0001\u0004;pa&\u001cW*\u001a;sS\u000e\u001cH\u0003BA[\u0003w\u0003B!VA\\S&\u0019\u0011\u0011\u0018,\u0003\u0007M+G\u000fC\u0004\u0002>f\u0001\r!a0\u0002\u000bQ|\u0007/[2\u0011\tY\n\t-[\u0005\u0004\u0003\u0007<$AB(qi&|g.A\tu_BL7-T3ue&\u001cwI]8vaN$B!!.\u0002J\"1\u0011Q\u0018\u000eA\u0002%\f\u0001DZ5mi\u0016\u0014()\u001f+pa&\u001cW*\u001a;sS\u000e\u0014VmZ3y)\u0019\t),a4\u0002R\"1ad\u0007a\u0001\u0003kCq!!0\u001c\u0001\u0004\ty\fK\u0004\u0001\u0003+\fi*!9\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7y\u0003\r\t\u0007/[\u0005\u0005\u0003?\fINA\u0004US6,w.\u001e;\u001f\u0003a\u0004")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testMetricsReporterAfterDeletingTopic(String quorum) {
        String topic = "test-topic-metric";
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testClusterIdMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testBrokerStateMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testYammerMetricsCountMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testLinuxIoMetrics(String quorum) {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testJMXFilter(String quorum) {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(this.requiredKafkaServerPrefix() + "=ClusterId")));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateJMXFilter(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(this.requiredKafkaServerPrefix() + "=ClusterId")));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMapKeySet().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertEquals((int)0, (int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricGaugeMap().size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testWindowsStyleTagNames(String quorum) {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = new KafkaMetricsGroup(this.getClass()).metricName("test-metric", CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testBrokerTopicMetricsBytesInOut(String quorum, String groupProtocol) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = "ReplicationBytesInPerSec";
        String replicationBytesOut = "ReplicationBytesOutPerSec";
        String bytesIn = "BytesInPerSec,topic=" + topic;
        String bytesOut = "BytesOutPerSec,topic=" + topic;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), GroupProtocol.of((String)groupProtocol), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), GroupProtocol.of((String)groupProtocol), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testKRaftControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount"}))).foreach((Function1 & Serializable)expected -> {
            MetricsTest.$anonfun$testKRaftControllerMetrics$1(metrics, expected);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$9 -> x$9.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*BrokerTopicMetrics.*" + topic.map((Function1 & Serializable)t -> "(" + t + ")$").getOrElse((Function0 & Serializable)() -> ""))).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$10)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=ClusterId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=BrokerState";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=yammer-metrics-count";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=" + name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 > 0L), (String)("Expected broker " + brokerId + " to have a Log for " + topicPartition$1 + " with positive size, actual: " + logSize));
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$2(String expected$1, MetricName x$8) {
        return x$8.getMBeanName().equals(expected$1);
    }

    public static final /* synthetic */ void $anonfun$testKRaftControllerMetrics$1(java.util.Map metrics$2, String expected) {
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$2.keySet()).asScala().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$2(expected, x$8))), (String)("Unable to find " + expected));
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$10) {
        return pattern$1.matcher(x$10).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put("num.partitions", Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", this.requiredKafkaServerPrefix() + "=ClusterId");
        this.nMessages = 2;
    }
}

