/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.EnvelopeUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.network.RequestConvertToJson;
import org.apache.kafka.network.metrics.RequestChannelMetrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00044\u0001\u0001\u0006Ia\n\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019I\u0004\u0001)A\u0005m!)A\n\u0001C\u0001\u001b\")A\f\u0001C\u0001\u001b\")a\f\u0001C\u0001\u001b\")\u0001\r\u0001C\u0001\u001b\")!\r\u0001C\u0001G\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!!\u0016\u0001\t\u0003\tY\u0007C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u00111\u0012\u0001\u0005\n\u0005\u0005\u0007bBAm\u0001\u0011%\u00111\u001c\u0002\u0013%\u0016\fX/Z:u\u0007\"\fgN\\3m)\u0016\u001cHO\u0003\u0002\u0017/\u00059a.\u001a;x_J\\'\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005)\u0012!\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m]\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011!fK\u0001\b[\u0016$(/[2t\u0015\t1BF\u0003\u0002\u0019[)\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u0011\u0014FA\u000bSKF,Xm\u001d;DQ\u0006tg.\u001a7NKR\u0014\u0018nY:\u0002-I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u0002\na\u0002\u001d:j]\u000eL\u0007/\u00197TKJ$W-F\u00017%\r9$H\u0011\u0004\u0005q\u0015\u0001aG\u0001\u0007=e\u00164\u0017N\\3nK:$h(A\bqe&t7-\u001b9bYN+'\u000fZ3!!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003mC:<'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012aa\u00142kK\u000e$\bCA\"K\u001b\u0005!%BA#G\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u001dC\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005%c\u0013AB2p[6|g.\u0003\u0002L\t\n\u00192*\u00194lCB\u0013\u0018N\\2ja\u0006d7+\u001a:eK\u0006\tB/Z:u\u00032$XM\u001d*fcV,7\u000f^:\u0015\u00039\u0003\"\u0001H(\n\u0005Ak\"\u0001B+oSRD#A\u0002*\u0011\u0005MSV\"\u0001+\u000b\u0005U3\u0016aA1qS*\u0011q\u000bW\u0001\bUV\u0004\u0018\u000e^3s\u0015\tIv&A\u0003kk:LG/\u0003\u0002\\)\n!A+Z:u\u0003q!Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;feJ+\u0017/^3tiND#a\u0002*\u0002EQ,7\u000f\u001e(p]\u0006cG/\u001a:SKF,Xm\u001d;t\u001d>$HK]1og\u001a|'/\\3eQ\tA!+\u0001\tuKN$(j]8o%\u0016\fX/Z:ug\"\u0012\u0011BU\u0001\u001ai\u0016\u001cHOQ;jY\u0012,eN^3m_B,'+Z:q_:\u001cX\r\u0006\u0002OI\")QM\u0003a\u0001M\u0006)QM\u001d:peB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eS\u0001\taJ|Go\\2pY&\u00111\u000e\u001b\u0002\u0007\u000bJ\u0014xN]:)\u0005)i\u0007C\u00018r\u001b\u0005y'B\u00019W\u0003\u0019\u0001\u0018M]1ng&\u0011!o\u001c\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bF\u0002\u0006uundX\u0010\u0005\u0002vq6\taO\u0003\u0002x_\u0006A\u0001O]8wS\u0012,'/\u0003\u0002zm\nQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0003\u0019\fQA\\1nKNdSA`A\u0001\u0003\u000b\t\u0013a`\u0001\u0005\u001d>sU)\t\u0002\u0002\u0004\u0005a2\tT+T)\u0016\u0013v,Q+U\u0011>\u0013\u0016JW!U\u0013>suLR!J\u0019\u0016#\u0015EAA\u0004\u00039qu\nV0D\u001f:#&k\u0014'M\u000bJ\u000bqCY;jY\u0012\u001c%/Z1uKR{\u0007/[2SKF,Xm\u001d;\u0015\t\u00055\u0011\u0011\u0004\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003%\u0002\u0011I,\u0017/^3tiNLA!a\u0006\u0002\u0012\t\u00192I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\"9\u00111D\u0006A\u0002\u0005u\u0011!\u0002;pa&\u001c\u0007\u0003BA\u0010\u0003[qA!!\t\u0002*A\u0019\u00111E\u000f\u000e\u0005\u0005\u0015\"bAA\u00143\u00051AH]8pizJ1!a\u000b\u001e\u0003\u0019\u0001&/\u001a3fM&!\u0011qFA\u0019\u0005\u0019\u0019FO]5oO*\u0019\u00111F\u000f\u00021\t,\u0018\u000e\u001c3De\u0016\fG/\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0004\u00028\u0005u\u0012q\b\t\u0005\u0003\u001f\tI$\u0003\u0003\u0002<\u0005E!\u0001F\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rC\u0004\u0002\u001c1\u0001\r!!\b\t\u000b\u0015d\u0001\u0019\u00014\u0002;\t,\u0018\u000e\u001c3V]^\u0014\u0018\r\u001d9fI\u0016sg/\u001a7pa\u0016\u0014V-];fgR$B!!\u0012\u0002TA!\u0011qIA'\u001d\r!\u0013\u0011J\u0005\u0004\u0003\u0017*\u0012A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003\u001f\n\tFA\u0004SKF,Xm\u001d;\u000b\u0007\u0005-S\u0003C\u0004\u0002V5\u0001\r!a\u0016\u0002\u000fI,\u0017/^3tiB!\u0011qBA-\u0013\u0011\tY&!\u0005\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgR\f1\"[:WC2LGMS:p]R!\u0011\u0011MA4!\ra\u00121M\u0005\u0004\u0003Kj\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003Sr\u0001\u0019AA\u000f\u0003\r\u0019HO\u001d\u000b\u0005\u0003\u000b\ni\u0007C\u0004\u0002p=\u0001\r!a\u0016\u0002\u0007I,\u0017/A\toK^\u0014V-];fgR\u001cuN\u001c;fqR$B!!\u001e\u0002|A!\u0011qBA<\u0013\u0011\tI(!\u0005\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\"9\u0011Q\u0010\tA\u0002\u0005}\u0014A\u00022vM\u001a,'\u000f\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t)IP\u0001\u0004]&|\u0017\u0002BAE\u0003\u0007\u0013!BQ=uK\n+hMZ3s\u0003\u0015!x.T1q)\u0011\ty)a'\u0011\u0011\u0005E\u0015qSA\u000f\u0003;i!!a%\u000b\u0007\u0005UU$\u0001\u0006d_2dWm\u0019;j_:LA!!'\u0002\u0014\n\u0019Q*\u00199\t\u000f\u0005u\u0015\u00031\u0001\u0002 \u000611m\u001c8gS\u001e\u0004B!!)\u0002<:!\u00111UA\\\u001d\u0011\t)+!.\u000f\t\u0005\u001d\u00161\u0017\b\u0005\u0003S\u000b\tL\u0004\u0003\u0002,\u0006=f\u0002BA\u0012\u0003[K\u0011\u0001M\u0005\u0003]=J!\u0001G\u0017\n\u0005%c\u0013bAA\n\u0011&!\u0011\u0011XA\t\u0003M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0013\u0011\ti,a0\u0003\r\r{gNZ5h\u0015\u0011\tI,!\u0005\u0015\t\u0005=\u00151\u0019\u0005\b\u0003;\u0013\u0002\u0019AAc!\u0011\t9-a5\u000f\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017T1!!4I\u0003\u001diWm]:bO\u0016LA!!5\u0002L\u0006\u0011\u0013J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f\u001e#bi\u0006LA!!6\u0002X\nI\u0012\t\u001c;fe\u0006\u0014G.Z\"p]\u001aLwmQ8mY\u0016\u001cG/[8o\u0015\u0011\t\t.a3\u0002+\t,\u0018\u000e\u001c3F]Z,Gn\u001c9f%\u0016\u001c\bo\u001c8tKR1\u0011Q\\Ar\u0003O\u0004B!a\u0004\u0002`&!\u0011\u0011]A\t\u0005A)eN^3m_B,'+Z:q_:\u001cX\rC\u0004\u0002fN\u0001\r!!\u0012\u0002\u0013UtwO]1qa\u0016$\u0007bBAu'\u0001\u0007\u00111^\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011qBAw\u0013\u0011\ty/!\u0005\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007")
public class RequestChannelTest {
    private final RequestChannelMetrics requestChannelMetrics = (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class);
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return principal.toString().getBytes(StandardCharsets.UTF_8);
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
        }
    };

    private RequestChannelMetrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry("listener.name.internal.ssl.key.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry("listener.name.internal.ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry("listener.name.internal.plain.sasl.jaas.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry("listener.name.internal.plain.sasl.login.callback.handler.class", "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, (Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.key.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.key.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.plain.sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.plain.sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.plain.sasl.login.callback.handler.class"), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class)), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson.request((AbstractRequest)alterConfigs.loggableRequest()).toString()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED", "NOT_CONTROLLER"})
    public void testBuildEnvelopeResponse(Errors error) {
        String topic = "foo";
        CreateTopicsRequest createTopicRequest = this.buildCreateTopicRequest(topic);
        RequestChannel.Request unwrapped = this.buildUnwrappedEnvelopeRequest((AbstractRequest)createTopicRequest);
        CreateTopicsResponse createTopicResponse = this.buildCreateTopicResponse(topic, error);
        EnvelopeResponse envelopeResponse = this.buildEnvelopeResponse(unwrapped, (AbstractResponse)createTopicResponse);
        if (Errors.NOT_CONTROLLER.equals(error)) {
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)envelopeResponse.error());
            Assertions.assertNull((Object)envelopeResponse.responseData());
            return;
        }
        Assertions.assertEquals((Object)Errors.NONE, (Object)envelopeResponse.error());
        AbstractResponse unwrappedResponse = AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)unwrapped.header());
        Assertions.assertEquals((Object)createTopicResponse.data(), (Object)unwrappedResponse.data());
    }

    private CreateTopicsRequest buildCreateTopicRequest(String topic) {
        CreateTopicsRequestData requestData = new CreateTopicsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)-1).setNumPartitions(-1));
        return (CreateTopicsRequest)new CreateTopicsRequest.Builder(requestData).build();
    }

    private CreateTopicsResponse buildCreateTopicResponse(String topic, Errors error) {
        CreateTopicsResponseData responseData = new CreateTopicsResponseData();
        responseData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorCode(error.code()));
        return new CreateTopicsResponse(responseData);
    }

    private RequestChannel.Request buildUnwrappedEnvelopeRequest(AbstractRequest request2) {
        RequestChannel.Request wrappedRequest = TestUtils$.MODULE$.buildEnvelopeRequest(request2, this.principalSerde(), this.requestChannelMetrics(), System.nanoTime(), -1L, true);
        AtomicReference unwrappedRequest = new AtomicReference();
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(wrappedRequest, this.requestChannelMetrics(), (Function1 & Serializable)request -> {
            unwrappedRequest.set(request);
            return BoxedUnit.UNIT;
        });
        return (RequestChannel.Request)unwrappedRequest.get();
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannelMetrics)Mockito.mock(RequestChannelMetrics.class), (Option)None$.MODULE$);
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)config).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private EnvelopeResponse buildEnvelopeResponse(RequestChannel.Request unwrapped, AbstractResponse response) {
        Assertions.assertTrue((boolean)unwrapped.envelope().isDefined());
        RequestChannel.Request envelope = (RequestChannel.Request)unwrapped.envelope().get();
        ByteBuffer sendBytes = TestUtils.toBuffer((Send)unwrapped.buildResponseSend(response));
        Assertions.assertEquals((int)sendBytes.getInt(), (int)sendBytes.remaining());
        AbstractResponse envelopeResponse = AbstractResponse.parseResponse((ByteBuffer)sendBytes, (RequestHeader)envelope.header());
        Assertions.assertTrue((boolean)(envelopeResponse instanceof EnvelopeResponse));
        return (EnvelopeResponse)envelopeResponse;
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson.requestDesc((RequestHeader)alterConfigs.header(), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(alterConfigs.requestLog())), (boolean)alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)("Sensitive config logged " + alterConfigsDesc));
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            return alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        }
        throw new MatchError(null);
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op));
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson.requestDesc((RequestHeader)alterConfigs.header(), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(alterConfigs.requestLog())), (boolean)alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)("Sensitive config logged " + alterConfigsDesc));
    }
}

