/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogManager$;
import kafka.raft.DefaultExternalKRaftMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.tools.TestRaftServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\u0006\f\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005\nqAQ!\u0017\u0001\u0005\niCQA\u001c\u0001\u0005\u0002=Dq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA6\u0001\u0011%\u0011Q\u000e\u0002\u0010%\u00064G/T1oC\u001e,'\u000fV3ti*\u0011A\"D\u0001\u0005e\u00064GOC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\"\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\rF\u0003\u001eGizD\u000b\u0005\u0002\u001fC5\tqD\u0003\u0002!\u001b\u000511/\u001a:wKJL!AI\u0010\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0006I\t\u0001\r!J\u0001\raJ|7-Z:t%>dWm\u001d\t\u0004M5\u0002dBA\u0014,!\tA3#D\u0001*\u0015\tQs\"\u0001\u0004=e>|GOP\u0005\u0003YM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\r\u0019V\r\u001e\u0006\u0003YM\u0001\"!\r\u001d\u000e\u0003IR!\u0001I\u001a\u000b\u00059!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u001a\u0003\u0017A\u0013xnY3tgJ{G.\u001a\u0005\u0006w\t\u0001\r\u0001P\u0001\u0007]>$W-\u00133\u0011\u0005Ii\u0014B\u0001 \u0014\u0005\rIe\u000e\u001e\u0005\u0006\u0001\n\u0001\r!Q\u0001\u0007Y><G)\u001b:\u0011\u0007\t;%J\u0004\u0002D\u000b:\u0011\u0001\u0006R\u0005\u0002)%\u0011aiE\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015JA\u0002TKFT!AR\n\u0011\u0005-\u0013V\"\u0001'\u000b\u00055s\u0015\u0001\u00024jY\u0016T!a\u0014)\u0002\u00079LwNC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Mc%\u0001\u0002)bi\"DQ!\u0016\u0002A\u0002Y\u000b1\"\\3uC\u0012\fG/\u0019#jeB\u0019!c\u0016&\n\u0005a\u001b\"AB(qi&|g.A\tde\u0016\fG/\u001a*bMRl\u0015M\\1hKJ$2a\u00173m!\rQBLX\u0005\u0003;.\u0011\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u0011\u0007Iy\u0016-\u0003\u0002a'\t)\u0011I\u001d:bsB\u0011!CY\u0005\u0003GN\u0011AAQ=uK\")Qm\u0001a\u0001M\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007CA4k\u001b\u0005A'BA54\u0003\u0019\u0019w.\\7p]&\u00111\u000e\u001b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015i7\u00011\u0001\u001e\u0003\u0019\u0019wN\u001c4jO\u0006\tB/Z:u\u001d>$W-\u00133Qe\u0016\u001cXM\u001c;\u0015\u0005A\u001c\bC\u0001\nr\u0013\t\u00118C\u0001\u0003V]&$\b\"\u0002\u0013\u0005\u0001\u0004!\bC\u0001\u0014v\u0013\t1xF\u0001\u0004TiJLgn\u001a\u0015\u0003\ta\u00042!_A\u0001\u001b\u0005Q(BA>}\u0003\u0019\u0001\u0018M]1ng*\u0011QP`\u0001\bUV\u0004\u0018\u000e^3s\u0015\tyh'A\u0003kk:LG/C\u0002\u0002\u0004i\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d!\u0011qAA\n\u0003+\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bQ\u0018\u0001\u00039s_ZLG-\u001a:\n\t\u0005E\u00111\u0002\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\r\u0005]\u00111DA\u0010C\t\tI\"\u0001\u0004ce>\\WM]\u0011\u0003\u0003;\t!bY8oiJ|G\u000e\\3sC\t\t\t#A\tce>\\WM\u001d\u0017d_:$(o\u001c7mKJ\f\u0001\u0005^3ti2{w\rR5s\u0019>\u001c7n\u00165f]\u000e{g\u000e\u001e:pY2,'o\u00148msR\u0019\u0001/a\n\t\r\u0005%R\u00011\u0001u\u0003\u001d!\u0017N\u001d+za\u0016D#!\u0002=)\u000f\u0015\t9!a\u0005\u0002012\u0011\u0011GA\u001b\u0003s\t#!a\r\u0002\u001b5,G/\u00193bi\u0006lsN\u001c7zC\t\t9$\u0001\u0005m_\u001elsN\u001c7zC\t\tY$\u0001\u0003c_RD\u0017a\r;fgRdun\u001a#je2{7m[,iK:\u0014%o\\6fe>sG._,ji\"\u001cV\r]1sCR,W*\u001a;bI\u0006$\u0018\rR5s)\u0005\u0001\bf\u0001\u0004\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002Jq\f1!\u00199j\u0013\u0011\ti%a\u0012\u0003\tQ+7\u000f^\u0001\u0012GJ,\u0017\r^3NKR\fG-\u0019;b\u0019><Gc\u00019\u0002T!)Qn\u0002a\u0001;\u0005\u0011\u0012m]:feRdun\u001a#jeN,\u00050[:u)\u001d\u0001\u0018\u0011LA/\u0003CBa!a\u0017\t\u0001\u0004\t\u0015a\u00027pO\u0012K'o\u001d\u0005\u0007\u0003?B\u0001\u0019\u0001,\u0002\u001d5,G/\u00193bi\u0006dun\u001a#je\"9\u00111\r\u0005A\u0002\u0005\u0015\u0014!E3ya\u0016\u001cG/T3uC\u0012\fG/\u0019'pOB\u0019!#a\u001a\n\u0007\u0005%4CA\u0004C_>dW-\u00198\u0002\u0015\u0019LG.\u001a'pG.,G\r\u0006\u0003\u0002f\u0005=\u0004BBA9\u0013\u0001\u0007!*\u0001\u0003qCRD\u0007")
public class RaftManagerTest {
    private KafkaConfig createConfig(Set<ProcessRole> processRoles, int nodeId, Seq<Path> logDir, Option<Path> metadataDir) {
        Properties props = new Properties();
        logDir.foreach((Function1 & Serializable)value -> props.setProperty("log.dir", ((Object)value).toString()));
        metadataDir.foreach((Function1 & Serializable)value -> props.setProperty("metadata.log.dir", ((Object)value).toString()));
        props.setProperty("process.roles", processRoles.mkString(","));
        props.setProperty("node.id", Integer.toString(nodeId));
        props.setProperty("controller.listener.names", "SSL");
        if (processRoles.contains((Object)ProcessRole.BrokerRole)) {
            props.setProperty("inter.broker.listener.name", "PLAINTEXT");
            if (processRoles.contains((Object)ProcessRole.ControllerRole)) {
                props.setProperty("listeners", "PLAINTEXT://localhost:9092,SSL://localhost:9093");
                props.setProperty("controller.quorum.voters", nodeId + "@localhost:9093");
            } else {
                int voterId = nodeId + 1;
                props.setProperty("controller.quorum.voters", voterId + "@localhost:9093");
            }
        } else if (processRoles.contains((Object)ProcessRole.ControllerRole)) {
            props.setProperty("listeners", "SSL://localhost:9093");
            props.setProperty("controller.quorum.voters", nodeId + "@localhost:9093");
        }
        return new KafkaConfig((java.util.Map)props);
    }

    private KafkaRaftManager<byte[]> createRaftManager(TopicPartition topicPartition, KafkaConfig config) {
        Uuid topicId = new Uuid(0L, 2L);
        Endpoints endpoints = Endpoints.fromInetSocketAddresses((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)config.effectiveAdvertisedControllerListeners().map((Function1 & Serializable)endpoint -> new Tuple2((Object)endpoint.listenerName(), (Object)InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
        return new KafkaRaftManager(Uuid.randomUuid().toString(), config, Uuid.randomUuid(), (RecordSerde)new TestRaftServer.ByteArraySerde(), topicPartition, topicId, Time.SYSTEM, new Metrics(Time.SYSTEM), (ExternalKRaftMetrics)new DefaultExternalKRaftMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), Option$.MODULE$.empty(), CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections((java.util.List)config.quorumConfig().voters())), (Collection)QuorumConfig.parseBootstrapServers((java.util.List)config.quorumConfig().bootstrapServers()), endpoints, (FaultHandler)Mockito.mock(FaultHandler.class));
    }

    @ParameterizedTest
    @ValueSource(strings={"broker", "controller", "broker,controller"})
    public void testNodeIdPresent(String processRoles) {
        Set processRolesSet = Predef$.MODULE$.Set().empty();
        if (processRoles.contains("broker")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.BrokerRole})));
        }
        if (processRoles.contains("controller")) {
            processRolesSet = (Set)processRolesSet.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole})));
        }
        File logDir = TestUtils.tempDirectory(null, null);
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<ProcessRole>)processRolesSet, nodeId, (Seq<Path>)new .colon.colon((Object)logDir.toPath(), (List)Nil$.MODULE$), (Option<Path>)None$.MODULE$));
        Assertions.assertEquals((int)nodeId, (int)raftManager.client().nodeId().getAsInt());
        raftManager.shutdown();
    }

    @ParameterizedTest
    @ValueSource(strings={"metadata-only", "log-only", "both"})
    public void testLogDirLockWhenControllerOnly(String dirType) {
        .colon.colon logDir;
        Object object = dirType.equals("metadata-only") ? (Seq)package$.MODULE$.Seq().empty() : (logDir = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$));
        None$ metadataDir = dirType.equals("log-only") ? None$.MODULE$ : new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}))), nodeId, (Seq<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenControllerOnly$1((Seq)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    @Test
    public void testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir() {
        .colon.colon logDir = new .colon.colon((Object)TestUtils.tempDirectory(null, null).toPath(), (List)Nil$.MODULE$);
        Some metadataDir = new Some((Object)TestUtils.tempDirectory(null, null).toPath());
        int nodeId = 1;
        KafkaRaftManager<byte[]> raftManager = this.createRaftManager(new TopicPartition("__raft_id_test", 0), this.createConfig((Set<ProcessRole>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.BrokerRole}))), nodeId, (Seq<Path>)logDir, (Option<Path>)metadataDir));
        Path lockPath = ((Path)metadataDir.getOrElse(() -> RaftManagerTest.$anonfun$testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir$1((Seq)logDir))).resolve(LogManager$.MODULE$.LockFileName());
        Assertions.assertTrue((boolean)this.fileLocked(lockPath));
        raftManager.shutdown();
        Assertions.assertFalse((boolean)this.fileLocked(lockPath));
    }

    public void createMetadataLog(KafkaConfig config) {
        this.createRaftManager(new TopicPartition("__cluster_metadata", 0), config).shutdown();
    }

    public void assertLogDirsExist(Seq<Path> logDirs, Option<Path> metadataLogDir, boolean expectMetadataLog) {
        Assertions.assertTrue((boolean)Files.exists((Path)metadataLogDir.get(), new LinkOption[0]));
        logDirs.foreach((Function1 & Serializable)logDir -> {
            RaftManagerTest.$anonfun$assertLogDirsExist$1(logDir);
            return BoxedUnit.UNIT;
        });
        if (expectMetadataLog) {
            Assertions.assertTrue((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
            return;
        }
        Assertions.assertFalse((boolean)Files.exists(((Path)metadataLogDir.get()).resolve("__cluster_metadata-0"), new LinkOption[0]));
    }

    private boolean fileLocked(Path path) {
        return BoxesRunTime.unboxToBoolean((Object)Using$.MODULE$.resource((Object)FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE), (Function1 & Serializable)channel -> BoxesRunTime.boxToBoolean((boolean)RaftManagerTest.$anonfun$fileLocked$1(channel)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenControllerOnly$1(Seq logDir$1) {
        return (Path)logDir$1.head();
    }

    public static final /* synthetic */ Path $anonfun$testLogDirLockWhenBrokerOnlyWithSeparateMetadataDir$1(Seq logDir$2) {
        return (Path)logDir$2.head();
    }

    public static final /* synthetic */ void $anonfun$assertLogDirsExist$1(Path logDir) {
        Assertions.assertTrue((boolean)Files.exists(logDir, new LinkOption[0]), (String)"Should not delete log dir");
    }

    public static final /* synthetic */ boolean $anonfun$fileLocked$1(FileChannel channel) {
        try {
            Option$.MODULE$.apply((Object)channel.tryLock()).foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            return false;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
    }
}

