/*
 * Decompiled with CFR 0.152.
 */
package kafka.security;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.security.JaasModule;
import kafka.utils.TestUtils;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.test.TestSslUtils;

public class JaasTestUtils {
    private static final boolean IS_IBM_SECURITY = Java.isIbmJdk() && !Java.isIbmJdkSemeru();
    public static final String KAFKA_SERVER_CONTEXT_NAME = "KafkaServer";
    public static final String KAFKA_SERVER_PRINCIPAL_UNQUALIFIED_NAME = "kafka";
    private static final String KAFKA_SERVER_PRINCIPAL = "kafka/localhost@EXAMPLE.COM";
    public static final String KAFKA_CLIENT_CONTEXT_NAME = "KafkaClient";
    public static final String KAFKA_CLIENT_PRINCIPAL_UNQUALIFIED_NAME = "client";
    private static final String KAFKA_CLIENT_PRINCIPAL = "client@EXAMPLE.COM";
    public static final String KAFKA_CLIENT_PRINCIPAL_UNQUALIFIED_NAME_2 = "client2";
    private static final String KAFKA_CLIENT_PRINCIPAL_2 = "client2@EXAMPLE.COM";
    public static final String KAFKA_PLAIN_USER = "plain-user";
    private static final String KAFKA_PLAIN_PASSWORD = "plain-user-secret";
    public static final String KAFKA_PLAIN_USER_2 = "plain-user2";
    public static final String KAFKA_PLAIN_PASSWORD_2 = "plain-user2-secret";
    public static final String KAFKA_PLAIN_ADMIN = "plain-admin";
    private static final String KAFKA_PLAIN_ADMIN_PASSWORD = "plain-admin-secret";
    public static final String KAFKA_SCRAM_USER = "scram-user";
    public static final String KAFKA_SCRAM_PASSWORD = "scram-user-secret";
    public static final String KAFKA_SCRAM_USER_2 = "scram-user2";
    public static final String KAFKA_SCRAM_PASSWORD_2 = "scram-user2-secret";
    public static final String KAFKA_SCRAM_ADMIN = "scram-admin";
    public static final String KAFKA_SCRAM_ADMIN_PASSWORD = "scram-admin-secret";
    public static final String KAFKA_OAUTH_BEARER_USER = "oauthbearer-user";
    public static final String KAFKA_OAUTH_BEARER_USER_2 = "oauthbearer-user2";
    public static final String KAFKA_OAUTH_BEARER_ADMIN = "oauthbearer-admin";
    public static final String SERVICE_NAME = "kafka";
    public static final String SSL_CERTIFICATE_CN = "localhost";

    public static Properties saslConfigs(Optional<Properties> saslProperties) {
        Properties result = saslProperties.orElse(new Properties());
        if (IS_IBM_SECURITY && !result.containsKey("sasl.kerberos.service.name")) {
            result.put("sasl.kerberos.service.name", "kafka");
        }
        return result;
    }

    public static File writeJaasContextsToFile(List<JaasSection> jaasSections) throws IOException {
        File jaasFile = TestUtils.tempFile();
        JaasTestUtils.writeToFile(jaasFile, jaasSections);
        return jaasFile;
    }

    public static String scramClientLoginModule(String mechanism, String scramUser, String scramPassword) {
        if (ScramMechanism.fromMechanismName((String)mechanism) == ScramMechanism.UNKNOWN) {
            throw new IllegalArgumentException("Unsupported SCRAM mechanism " + mechanism);
        }
        return JaasModule.scramLoginModule(scramUser, scramPassword, false, new HashMap<String, String>()).toString();
    }

    public static String clientLoginModule(String mechanism, Optional<File> keytabLocation, String serviceName) {
        return JaasTestUtils.kafkaClientModule(mechanism, keytabLocation, KAFKA_CLIENT_PRINCIPAL, KAFKA_PLAIN_USER, KAFKA_PLAIN_PASSWORD, KAFKA_SCRAM_USER, KAFKA_SCRAM_PASSWORD, KAFKA_OAUTH_BEARER_USER, serviceName).toString();
    }

    public static String clientLoginModule(String mechanism, Optional<File> keytabLocation) {
        return JaasTestUtils.clientLoginModule(mechanism, keytabLocation, "kafka");
    }

    public static String adminLoginModule(String mechanism, Optional<File> keytabLocation, String serviceName) {
        return JaasTestUtils.kafkaClientModule(mechanism, keytabLocation, KAFKA_SERVER_PRINCIPAL, KAFKA_PLAIN_ADMIN, KAFKA_PLAIN_ADMIN_PASSWORD, KAFKA_SCRAM_ADMIN, KAFKA_SCRAM_ADMIN_PASSWORD, KAFKA_OAUTH_BEARER_ADMIN, serviceName).toString();
    }

    public static String adminLoginModule(String mechanism, Optional<File> keytabLocation) {
        return JaasTestUtils.adminLoginModule(mechanism, keytabLocation, "kafka");
    }

    public static String tokenClientLoginModule(String tokenId, String password) {
        HashMap<String, String> tokenProps = new HashMap<String, String>();
        tokenProps.put("tokenauth", "true");
        return JaasModule.scramLoginModule(tokenId, password, false, tokenProps).toString();
    }

    public static JaasSection kafkaServerSection(String contextName, List<String> mechanisms, Optional<File> keytabLocation) {
        ArrayList<JaasModule> modules = new ArrayList<JaasModule>();
        Iterator<String> iterator = mechanisms.iterator();
        block10: while (iterator.hasNext()) {
            String mechanism;
            switch (mechanism = iterator.next()) {
                case "GSSAPI": {
                    modules.add(JaasModule.krb5LoginModule(true, true, keytabLocation.orElseThrow(() -> new IllegalArgumentException("Keytab location not specified for GSSAPI")).getAbsolutePath(), KAFKA_SERVER_PRINCIPAL, true, Optional.of("kafka"), IS_IBM_SECURITY));
                    continue block10;
                }
                case "PLAIN": {
                    HashMap<String, String> validUsers = new HashMap<String, String>();
                    validUsers.put(KAFKA_PLAIN_ADMIN, KAFKA_PLAIN_ADMIN_PASSWORD);
                    validUsers.put(KAFKA_PLAIN_USER, KAFKA_PLAIN_PASSWORD);
                    validUsers.put(KAFKA_PLAIN_USER_2, KAFKA_PLAIN_PASSWORD_2);
                    modules.add(JaasModule.plainLoginModule(KAFKA_PLAIN_ADMIN, KAFKA_PLAIN_ADMIN_PASSWORD, false, validUsers));
                    continue block10;
                }
                case "OAUTHBEARER": {
                    modules.add(JaasModule.oAuthBearerLoginModule(KAFKA_OAUTH_BEARER_ADMIN, false));
                    continue block10;
                }
            }
            if (ScramMechanism.fromMechanismName((String)mechanism) != ScramMechanism.UNKNOWN) {
                modules.add(JaasModule.scramLoginModule(KAFKA_SCRAM_ADMIN, KAFKA_SCRAM_ADMIN_PASSWORD, false, new HashMap<String, String>()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported server mechanism " + mechanism);
        }
        return new JaasSection(contextName, modules);
    }

    private static JaasModule kafkaClientModule(String mechanism, Optional<File> keytabLocation, String clientPrincipal, String plainUser, String plainPassword, String scramUser, String scramPassword, String oauthBearerUser, String serviceName) {
        switch (mechanism) {
            case "GSSAPI": {
                return JaasModule.krb5LoginModule(true, true, keytabLocation.orElseThrow(() -> new IllegalArgumentException("Keytab location not specified for GSSAPI")).getAbsolutePath(), clientPrincipal, true, Optional.of(serviceName), IS_IBM_SECURITY);
            }
            case "PLAIN": {
                return JaasModule.plainLoginModule(plainUser, plainPassword, false, new HashMap<String, String>());
            }
            case "OAUTHBEARER": {
                return JaasModule.oAuthBearerLoginModule(oauthBearerUser, false);
            }
        }
        if (ScramMechanism.fromMechanismName((String)mechanism) != ScramMechanism.UNKNOWN) {
            return JaasModule.scramLoginModule(scramUser, scramPassword, false, new HashMap<String, String>());
        }
        throw new IllegalArgumentException("Unsupported client mechanism " + mechanism);
    }

    public static JaasSection kafkaClientSection(Optional<String> mechanism, Optional<File> keytabLocation) {
        return new JaasSection(KAFKA_CLIENT_CONTEXT_NAME, mechanism.map(m -> JaasTestUtils.kafkaClientModule(m, keytabLocation, KAFKA_CLIENT_PRINCIPAL_2, KAFKA_PLAIN_USER_2, KAFKA_PLAIN_PASSWORD_2, KAFKA_SCRAM_USER_2, KAFKA_SCRAM_PASSWORD_2, KAFKA_OAUTH_BEARER_USER_2, "kafka")).map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private static void writeToFile(File file, List<JaasSection> jaasSections) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(String.join((CharSequence)"", (CharSequence[])jaasSections.stream().map(Object::toString).toArray(String[]::new)));
        }
    }

    public static boolean usesSslTransportLayer(SecurityProtocol securityProtocol) {
        switch (securityProtocol) {
            case SSL: 
            case SASL_SSL: {
                return true;
            }
        }
        return false;
    }

    public static boolean usesSaslAuthentication(SecurityProtocol securityProtocol) {
        switch (securityProtocol) {
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                return true;
            }
        }
        return false;
    }

    public static Properties sslConfigs(ConnectionMode mode, boolean clientCert, Optional<File> trustStoreFile, String certAlias) throws Exception {
        return JaasTestUtils.sslConfigs(mode, clientCert, trustStoreFile, certAlias, SSL_CERTIFICATE_CN, "TLSv1.3");
    }

    public static Properties sslConfigs(ConnectionMode mode, boolean clientCert, Optional<File> trustStoreFile, String certAlias, String certCn, String tlsProtocol) throws Exception {
        File trustStore = trustStoreFile.orElseThrow(() -> new Exception("SSL enabled but no trustStoreFile provided"));
        Properties sslProps = new Properties();
        sslProps.putAll((Map<?, ?>)new TestSslUtils.SslConfigsBuilder(mode).useClientCert(clientCert).createNewTrustStore(trustStore).certAlias(certAlias).cn(certCn).tlsProtocol(tlsProtocol).build());
        return sslProps;
    }

    public static Properties producerSecurityConfigs(SecurityProtocol securityProtocol, Optional<File> trustStoreFile, Optional<Properties> saslProperties) throws Exception {
        return JaasTestUtils.securityConfigs(ConnectionMode.CLIENT, securityProtocol, trustStoreFile, "producer", SSL_CERTIFICATE_CN, saslProperties);
    }

    public static Properties consumerSecurityConfigs(SecurityProtocol securityProtocol, Optional<File> trustStoreFile, Optional<Properties> saslProperties) throws Exception {
        return JaasTestUtils.securityConfigs(ConnectionMode.CLIENT, securityProtocol, trustStoreFile, "consumer", SSL_CERTIFICATE_CN, saslProperties);
    }

    public static Properties adminClientSecurityConfigs(SecurityProtocol securityProtocol, Optional<File> trustStoreFile, Optional<Properties> saslProperties) throws Exception {
        return JaasTestUtils.securityConfigs(ConnectionMode.CLIENT, securityProtocol, trustStoreFile, "admin-client", SSL_CERTIFICATE_CN, saslProperties);
    }

    public static Properties securityConfigs(ConnectionMode connectionMode, SecurityProtocol securityProtocol, Optional<File> trustStoreFile, String certAlias, String certCn, Optional<Properties> saslProperties) throws Exception {
        return JaasTestUtils.securityConfigs(connectionMode, securityProtocol, trustStoreFile, certAlias, certCn, saslProperties, "TLSv1.3", Optional.empty());
    }

    public static Properties securityConfigs(ConnectionMode connectionMode, SecurityProtocol securityProtocol, Optional<File> trustStoreFile, String certAlias, String certCn, Optional<Properties> saslProperties, String tlsProtocol, Optional<Boolean> needsClientCert) throws Exception {
        Properties props = new Properties();
        if (JaasTestUtils.usesSslTransportLayer(securityProtocol)) {
            boolean addClientCert = needsClientCert.orElse(securityProtocol == SecurityProtocol.SSL);
            props.putAll((Map<?, ?>)JaasTestUtils.sslConfigs(connectionMode, addClientCert, trustStoreFile, certAlias, certCn, tlsProtocol));
        }
        if (JaasTestUtils.usesSaslAuthentication(securityProtocol)) {
            props.putAll((Map<?, ?>)JaasTestUtils.saslConfigs(saslProperties));
        }
        props.put("security.protocol", securityProtocol.name());
        return props;
    }

    public static class JaasSection {
        private final String contextName;
        private final List<JaasModule> modules;

        public JaasSection(String contextName, List<JaasModule> modules) {
            this.contextName = contextName;
            this.modules = modules;
        }

        public List<JaasModule> getModules() {
            return this.modules;
        }

        public String getContextName() {
            return this.contextName;
        }

        public String toString() {
            return String.format("%s {\n  %s\n};\n", this.contextName, this.modules.stream().map(Object::toString).collect(Collectors.joining("\n  ")));
        }
    }
}

