/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.AlterPartitionManager;
import kafka.server.DefaultAlterPartitionManager;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tuf\u0001B\u001a5\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004R\u0001\u0001\u0006IA\u0012\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019Y\u0006\u0001)A\u0005)\"9A\f\u0001b\u0001\n\u0003i\u0006BB2\u0001A\u0003%a\fC\u0004e\u0001\t\u0007I\u0011A3\t\r%\u0004\u0001\u0015!\u0003g\u0011%Q\u0007\u00011AA\u0002\u0013\u00051\u000eC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"I\u0001\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0011\u0019q\b\u0001)A\u0005w\"9q\u0010\u0001b\u0001\n\u0003Q\bbBA\u0001\u0001\u0001\u0006Ia\u001f\u0005\t\u0003\u0007\u0001!\u0019!C\u0001u\"9\u0011Q\u0001\u0001!\u0002\u0013Y\bbBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003C\u0001A\u0011AA\u0005\u0011\u001d\tY\u0003\u0001C\u0001\u0003\u0013Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002d\u0001!\t!!\u0003\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002\n!9\u00111\u000e\u0001\u0005\u0002\u0005%\u0001bBA8\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003g\u0002A\u0011AA\u0005\u0011\u001d\t9\b\u0001C\u0001\u0003\u0013Aq!a\u001f\u0001\t\u0003\tI\u0001C\u0004\u0002\u0000\u0001!\t!!\u0003\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAV\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003_\u0003A\u0011AA\u0005\u0011\u001d\t\u0019\f\u0001C\u0001\u0003\u0013Aq!a.\u0001\t\u0003\tI\u0001C\u0004\u0002<\u0002!I!!0\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005%\u0001bBAk\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003f\u0001!IAa\u001a\t\u0013\t=\u0005!%A\u0005\n\tE\u0005\"\u0003BT\u0001E\u0005I\u0011\u0002BU\u0011%\u0011i\u000bAI\u0001\n\u0013\u0011y\u000bC\u0005\u00034\u0002\t\n\u0011\"\u0003\u00030\"I!Q\u0017\u0001\u0012\u0002\u0013%!q\u0016\u0005\n\u0005o\u0003\u0011\u0013!C\u0005\u0005s\u0013\u0011$\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'\u000fV3ti*\u0011QGN\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\"\u0011\u0005\r\u0003Q\"\u0001\u001b\u0002\u000fQ|\u0007/[2JIV\ta\t\u0005\u0002H\u001f6\t\u0001J\u0003\u0002J\u0015\u000611m\\7n_:T!aN&\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0005\u0003!\"\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%\u0001\u0003uS6,W#\u0001+\u0011\u0005UKV\"\u0001,\u000b\u0005]C\u0016\u0001B;uS2T!!\u000e&\n\u0005i3&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\ta\f\u0005\u0002`C6\t\u0001M\u0003\u0002]\u0011&\u0011!\r\u0019\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u00032s_.,'/\u00133\u0016\u0003\u0019\u0004\"aO4\n\u0005!d$aA%oi\u0006I!M]8lKJLE\rI\u0001\u0013EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'/F\u0001m!\tiw.D\u0001o\u0015\tI\u0005,\u0003\u0002q]\nqbj\u001c3f)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0017EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR\u00111O\u001e\t\u0003wQL!!\u001e\u001f\u0003\tUs\u0017\u000e\u001e\u0005\bo.\t\t\u00111\u0001m\u0003\rAH%M\u0001\u0014EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000fI\u0001\u0004iB\u0004T#A>\u0011\u00055d\u0018BA?o\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\u0003uaB\u0002\u0013a\u0001;qc\u0005!A\u000f]\u0019!\u0003\r!\bOM\u0001\u0005iB\u0014\u0004%A\u0003tKR,\b\u000fF\u0001tQ\r\u0019\u0012Q\u0002\t\u0005\u0003\u001f\ti\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\r\t\u0007/\u001b\u0006\u0005\u0003/\tI\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005mQ*A\u0003kk:LG/\u0003\u0003\u0002 \u0005E!A\u0003\"fM>\u0014X-R1dQ\u0006IA/Z:u\u0005\u0006\u001c\u0018n\u0019\u0015\u0004)\u0005\u0015\u0002\u0003BA\b\u0003OIA!!\u000b\u0002\u0012\t!A+Z:u\u0003a!Xm\u001d;CCNL7mV5uQ\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0004+\u0005\u0015\u0012\u0001\t;fgR\u0014\u0015m]5d'\u0016tG\u000fT3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016$2a]A\u001a\u0011\u001d\t)D\u0006a\u0001\u0003o\t1\u0003\\3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016\u0004B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{Q\u0015\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\u0005\u00131\b\u0002\u0014\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/\u001a\u0015\u0004-\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\t\u0005-\u0013QC\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005=\u0013\u0011\n\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\f\u0002T\u0005}\u0013\u0011\r\t\u0005\u0003+\nY&\u0004\u0002\u0002X)!\u0011\u0011LA%\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA/\u0003/\u0012!\"\u00128v[N{WO]2f\u0003\u00151\u0018\r\\;fG\t\t9$\u0001\ruKN$xJ^3soJLG/Z,ji\"LgNQ1uG\"D3aFA\u0013\u0003=!Xm\u001d;TS:<G.\u001a\"bi\u000eD\u0007f\u0001\r\u0002&\u00051B/Z:u'V\u0014W.\u001b;Ge>l7)\u00197mE\u0006\u001c7\u000eK\u0002\u001a\u0003K\tq\u0003^3ti\u0006+H\u000f[8sSj\fG/[8o\r\u0006LG.\u001a3)\u0007i\t)#\u0001\u000buKN$8\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u00047\u0005\u0015\u0012!\u0005;fgR,fn\u001b8po:\u001cVM\u001d<fe\"\u001aA$!\n\u0002AQ,7\u000f\u001e*fiJLxJ\\!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004;\u0005\u0015\u0012A\t;fgR\u0014V\r\u001e:z\u001f:,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8FeJ|'\u000fK\u0002\u001f\u0003K\t\u0001\u0004^3tiJ+GO]=P]R{\u0007\u000fT3wK2,%O]8s)\r\u0019\u0018q\u0011\u0005\b\u0003\u0013{\u0002\u0019AAF\u0003\u0015)'O]8s!\u0011\ti)a%\u000e\u0005\u0005=%bAAI\u0011\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u0016\u0006=%AB#se>\u00148/\u0001\ruKN$(+\u001a;ss>sWI\u001d:peJ+7\u000f]8og\u0016$2a]AN\u0011\u001d\ti\n\ta\u0001\u0003?\u000b\u0001B]3ta>t7/\u001a\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*\u0019\u0011Q\u0015&\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011VAR\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f\u0001\u0004^3ti&sg/\u00197jIV\u0003H-\u0019;f-\u0016\u00148/[8oQ\r\t\u0013QE\u0001\u001ai\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eK\u0002#\u0003K\tq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0007\r\n)#\u0001\nuKN$\u0018J\u001c<bY&$'+Z9vKN$\bf\u0001\u0013\u0002&\u0005\u00192\r[3dWB\u000b'\u000f^5uS>tWI\u001d:peR\u00191/a0\t\u000f\u0005%U\u00051\u0001\u0002\f\u0006\u0011B/Z:u!\u0006\u0014H/\u001b;j_:,%O]8s)\u0019\t)-a3\u0002PB\u00191)a2\n\u0007\u0005%GGA\u000bBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\t\r\u00055g\u00051\u0001|\u0003\t!\b\u000fC\u0004\u0002\n\u001a\u0002\r!a#\u0002\u001fQ,7\u000f^(oK&sg\t\\5hQRD3aJA\u0013\u0003y!Xm\u001d;QCJ$\u0018\u000e^5p]6K7o]5oO&s'+Z:q_:\u001cX\rK\u0002)\u0003K\t\u0011C^3sS\u001aL8+\u001a8e%\u0016\fX/Z:u)\u0019\ti.a9\u0002fB\u0019Q.a8\n\u0007\u0005\u0005hN\u0001\u0012D_:$(o\u001c7mKJ\u0014V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u0005\u0006U&\u0002\r\u0001\u001c\u0005\b\u0003OL\u0003\u0019AAu\u0003=)\u0007\u0010]3di\u0016$'+Z9vKN$\bCBAv\u0003c\f)0\u0004\u0002\u0002n*\u0019\u0011q^'\u0002\u000f5|7m[5u_&!\u00111_Aw\u0005=\t%oZ;nK:$X*\u0019;dQ\u0016\u0014\b\u0007BA|\u0005\u001f\u0001b!!?\u0003\u0006\t-a\u0002BA~\u0005\u0003i!!!@\u000b\u0007\u0005}\b*\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\u0019!!@\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLAAa\u0002\u0003\n\t9!)^5mI\u0016\u0014(\u0002\u0002B\u0002\u0003{\u0004BA!\u0004\u0003\u00101\u0001A\u0001\u0004B\t\u0003K\f\t\u0011!A\u0003\u0002\tM!aA0%eE!!Q\u0003B\u000e!\rY$qC\u0005\u0004\u00053a$a\u0002(pi\"Lgn\u001a\t\u0005\u0003w\u0014i\"\u0003\u0003\u0003 \u0005u(aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u00029\u0005dG/\u001a:QCJ$\u0018\u000e^5p]J+\u0017/^3ti6\u000bGo\u00195feR1!Q\u0005B\u0019\u0005\u0017\u0002b!a;\u0002r\n\u001d\u0002\u0007\u0002B\u0015\u0005[\u0001b!!?\u0003\u0006\t-\u0002\u0003\u0002B\u0007\u0005[!1Ba\f+\u0003\u0003\u0005\tQ!\u0001\u0003\u0014\t\u0019q\fJ\u001a\t\u000f\tM\"\u00061\u0001\u00036\u00059R\r\u001f9fGR,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006\u0005o\u0011)e\u001f\b\u0005\u0005s\u0011\t\u0005E\u0002\u0003<qj!A!\u0010\u000b\u0007\t}\u0002(\u0001\u0004=e>|GOP\u0005\u0004\u0005\u0007b\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003H\t%#aA*fi*\u0019!1\t\u001f\t\u000f\t5#\u00061\u0001\u0003P\u0005yQ\r\u001f9fGR,GMV3sg&|g\u000eE\u0002<\u0005#J1Aa\u0015=\u0005\u0015\u0019\u0006n\u001c:u\u0003Ii\u0017m[3DY&,g\u000e\u001e*fgB|gn]3\u0015\r\u0005}%\u0011\fB1\u0011\u001d\tij\u000ba\u0001\u00057\u0002B!a?\u0003^%!!qLA\u007f\u0005Y\tE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,\u0007b\u0002B2W\u0001\u0007!qJ\u0001\bm\u0016\u00148/[8o\u0003E\u0001\u0018M\u001d;ji&|gNU3ta>t7/\u001a\u000b\u000f\u00057\u0012IGa\u001b\u0003n\tE$Q\u000fB=\u0011!\ti\r\fI\u0001\u0002\u0004Y\b\"CAEYA\u0005\t\u0019AAF\u0011!\u0011y\u0007\fI\u0001\u0002\u00041\u0017A\u00049beRLG/[8o\u000bB|7\r\u001b\u0005\t\u0005gb\u0003\u0013!a\u0001M\u0006AA.Z1eKJLE\r\u0003\u0005\u0003x1\u0002\n\u00111\u0001g\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u0013\tmD\u0006%AA\u0002\tu\u0014aA5teB)!q\u0010BEM:!!\u0011\u0011BC\u001d\u0011\u0011YDa!\n\u0003uJ1Aa\"=\u0003\u001d\u0001\u0018mY6bO\u0016LAAa#\u0003\u000e\n!A*[:u\u0015\r\u00119\tP\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tM%fA>\u0003\u0016.\u0012!q\u0013\t\u0005\u00053\u0013\u0019+\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003%)hn\u00195fG.,GMC\u0002\u0003\"r\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ka'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005WSC!a#\u0003\u0016\u0006Y\u0002/\u0019:uSRLwN\u001c*fgB|gn]3%I\u00164\u0017-\u001e7uIM*\"A!-+\u0007\u0019\u0014)*A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$H\u0005N\u0001\u001ca\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000fJ\u001b\u00027A\f'\u000f^5uS>t'+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011YL\u000b\u0003\u0003~\tU\u0005")
public class AlterPartitionManagerTest {
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private NodeToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0);
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1);
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2);

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(NodeToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class));
    }

    @Test
    public void testBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testBasic$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @Test
    public void testBasicWithBrokerEpoch() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 101L);
        alterPartitionManager.start();
        ListBuffer isrWithBrokerEpoch = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable)ii -> AlterPartitionManagerTest.$anonfun$testBasicWithBrokerEpoch$2(isrWithBrokerEpoch, BoxesRunTime.unboxToInt((Object)ii)));
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, LeaderRecoveryState.RECOVERED, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isrWithBrokerEpoch.toList()).asJava(), 10));
        AlterPartitionRequestData expectedAlterPartitionData = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(101L);
        AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicId(this.topicId());
        ListBuffer newIsrWithBrokerEpoch = new ListBuffer();
        newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(1).setBrokerEpoch(101L));
        newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(2).setBrokerEpoch(102L));
        newIsrWithBrokerEpoch.append((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(3).setBrokerEpoch(103L));
        topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsrWithEpochs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newIsrWithBrokerEpoch.toList()).asJava()));
        expectedAlterPartitionData.topics().add(topicData);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)captor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedAlterPartitionData, (Object)((AlterPartitionRequest)((AlterPartitionRequest.Builder)captor.getValue()).build()).data());
    }

    @ParameterizedTest
    @EnumSource(value=LeaderRecoveryState.class)
    public void testBasicSentLeaderRecoveryState(LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testBasicSentLeaderRecoveryState$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), leaderRecoveryState, 10));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        Assertions.assertEquals((byte)leaderRecoveryState.value(), (byte)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).leaderRecoveryState());
    }

    @Test
    public void testOverwriteWithinBatch() {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testOverwriteWithinBatch$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10)).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testOverwriteWithinBatch$3(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testOverwriteWithinBatch$4(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10)).isDone());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    @Test
    public void testSingleBatch() {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testSingleBatch$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i)), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testSingleBatch$4(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10)));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderId, leaderEpoch, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testSubmitFromCallback$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, partitionEpoch);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$2, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testRetryOnErrorResponse$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0()));
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$checkPartitionError$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10)).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testPartitionError$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, 0, 0, 0, this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @Test
    public void testOneInFlight() {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testOneInFlight$2(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        alterPartitionManager.submit(this.tp1(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testOneInFlight$3(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        alterPartitionManager.submit(this.tp2(), new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testOneInFlight$4(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @Test
    public void testPartitionMissingInResponse() {
        short expectedVersion = ApiKeys.ALTER_PARTITION.latestVersion();
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x -> AlterPartitionManagerTest.$anonfun$testPartitionMissingInResponse$1(BoxesRunTime.unboxToInt((Object)x)))).asJava(), LeaderRecoveryState.RECOVERED, 10);
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> brokerEpoch);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, 0, 0, 0, this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    private ControllerRequestCompletionHandler verifySendRequest(NodeToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new NodeToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicIdPartitions = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(alterPartitionRequest.data().topics()).asScala().flatMap((Function1 & Serializable)topicData -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(topicData.partitions()).asScala().map((Function1 & Serializable)partitionData -> new Tuple2((Object)topicData.topicId(), (Object)BoxesRunTime.boxToInteger((int)partitionData.partitionIndex()))))).toSet();
            Object object = expectedTopicPartitions.map((Function1 & Serializable)tp -> new Tuple2((Object)tp.topicId(), (Object)BoxesRunTime.boxToInteger((int)tp.partitionId())));
            return !(object != null ? !object.equals(requestTopicIdPartitions) : requestTopicIdPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version));
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partitionId()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)isr.map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return package$.MODULE$.List().empty();
    }

    public static final /* synthetic */ Integer $anonfun$testBasic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testBasicWithBrokerEpoch$2(ListBuffer isrWithBrokerEpoch$1, int ii) {
        return (ListBuffer)isrWithBrokerEpoch$1.$plus$eq((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(ii).setBrokerEpoch((long)(100 + ii)));
    }

    public static final /* synthetic */ Integer $anonfun$testBasicSentLeaderRecoveryState$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testOverwriteWithinBatch$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testOverwriteWithinBatch$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testOverwriteWithinBatch$4(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testSingleBatch$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testSingleBatch$4(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testSubmitFromCallback$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testRetryOnErrorResponse$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$checkPartitionError$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testPartitionError$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testOneInFlight$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testOneInFlight$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testOneInFlight$4(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testPartitionMissingInResponse$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public AlterPartitionManagerTest() {
        this.brokerId = 1;
    }
}

