/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Supplier;
import kafka.server.DefaultApiVersionManager;
import kafka.server.ForwardingManager;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.server.BrokerFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Q4AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002BB\u0014\u0001A\u0003%Q\u0004C\u0004)\u0001\t\u0007I\u0011B\u0015\t\rA\u0002\u0001\u0015!\u0003+\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015\u0011\b\u0001\"\u0001k\u0005U\t\u0005/\u001b,feNLwN\\'b]\u0006<WM\u001d+fgRT!\u0001D\u0007\u0002\rM,'O^3s\u0015\u0005q\u0011!B6bM.\f7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\f\u00039\u0011'o\\6fe\u001a+\u0017\r^;sKN,\u0012!\b\t\u0003=\u0015j\u0011a\b\u0006\u0003\u0019\u0001R!AD\u0011\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0005\u0003M}\u0011aB\u0011:pW\u0016\u0014h)Z1ukJ,7/A\bce>\\WM\u001d$fCR,(/Z:!\u00035iW\r^1eCR\f7)Y2iKV\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002.\u0017\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u00020Y\t\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\nA\u0002^3ti\u0006\u0003\u0018nU2pa\u0016$\"a\r\u001c\u0011\u0005I!\u0014BA\u001b\u0014\u0005\u0011)f.\u001b;\t\u000b]2\u0001\u0019\u0001\u001d\u0002\u0011\u0005\u0004\u0018nU2pa\u0016\u0004\"!O'\u000f\u0005iReBA\u001eH\u001d\taTI\u0004\u0002>\t:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003>\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013B\u0001\b\"\u0013\t1\u0005%\u0001\u0004d_6lwN\\\u0005\u0003\u0011&\u000bq!\\3tg\u0006<WM\u0003\u0002GA%\u00111\nT\u0001\u000f\u0003BLW*Z:tC\u001e,G+\u001f9f\u0015\tA\u0015*\u0003\u0002O\u001f\naA*[:uK:,'\u000fV=qK*\u00111\n\u0014\u0015\u0003\rE\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\rA\f'/Y7t\u0015\t1v+A\u0004kkBLG/\u001a:\u000b\u0005a\u001b\u0013!\u00026v]&$\u0018B\u0001.T\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\u0005\rq\u00137\r\u0005\u0002^A6\taL\u0003\u0002`'\u0006A\u0001O]8wS\u0012,'/\u0003\u0002b=\nQQI\\;n'>,(oY3\u0002\u000bY\fG.^3$\u0003a\n\u0001\u0003^3ti\u0012K7/\u00192mK\u0012\f\u0005/[:\u0015\u0005M2\u0007\"B\u001c\b\u0001\u0004A\u0004FA\u0004RQ\u00119ALY2\u0002;Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018.\u00138uKJ\u001cXm\u0019;j_:$\u0012a\r\u0015\u0003\u00111\u0004\"!\u001c9\u000e\u00039T!a\\+\u0002\u0007\u0005\u0004\u0018.\u0003\u0002r]\n!A+Z:u\u0003\t\"Xm\u001d;F]Z,Gn\u001c9f\t&\u001c\u0018M\u00197fI\u001a{'o\u0013*bMR\u0014%o\\6fe\"\u0012\u0011\u0002\u001c")
public class ApiVersionManagerTest {
    private final BrokerFeatures brokerFeatures = BrokerFeatures.createDefault((boolean)true);
    private final KRaftMetadataCache metadataCache;

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testApiScope(ApiMessageType.ListenerType apiScope) {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, forwardingManager, this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala(), (Object)versionManager.enabledApis());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala().forall((Function1 & Serializable)apiKey -> BoxesRunTime.boxToBoolean((boolean)ApiVersionManagerTest.$anonfun$testApiScope$1(versionManager, apiKey))));
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testDisabledApis(ApiMessageType.ListenerType apiScope) {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, forwardingManager, this.brokerFeatures(), (MetadataCache)this.metadataCache(), false, (Option)None$.MODULE$);
        ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope).forEach(apiKey -> {
            if (apiKey.messageType.latestVersionUnstable()) {
                Assertions.assertFalse((boolean)versionManager.isApiEnabled(apiKey, apiKey.latestVersion()), (String)(apiKey + " version " + apiKey.latestVersion() + " should be disabled."));
                return;
            }
        });
    }

    @Test
    public void testControllerApiIntersection() {
        short controllerMinVersion = 3;
        short controllerMaxVersion = 5;
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create((short)ApiKeys.CREATE_TOPICS.id, (short)controllerMinVersion, (short)controllerMaxVersion)));
        ApiVersionsResponseData.ApiVersion alterConfigVersion = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, forwardingManager, this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, (Option)None$.MODULE$).apiVersionResponse(0, false).data().apiKeys().find(ApiKeys.CREATE_TOPICS.id);
        Assertions.assertNotNull((Object)alterConfigVersion);
        Assertions.assertEquals((short)controllerMinVersion, (short)alterConfigVersion.minVersion());
        Assertions.assertEquals((short)controllerMaxVersion, (short)alterConfigVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledForKRaftBroker() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, forwardingManager, this.brokerFeatures(), (MetadataCache)this.metadataCache(), true, (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE, ApiKeys.ENVELOPE.latestVersion()));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0, false).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }

    public static final /* synthetic */ boolean $anonfun$testApiScope$1(DefaultApiVersionManager versionManager$1, ApiKeys apiKey) {
        return CollectionConverters$.MODULE$.ListHasAsScala(apiKey.allVersions()).asScala().forall((Function1 & Serializable)version -> BoxesRunTime.boxToBoolean((boolean)versionManager$1.isApiEnabled(apiKey, Predef$.MODULE$.Short2short(version))));
    }

    /*
     * WARNING - void declaration
     */
    public ApiVersionManagerTest() {
        void var1_3;
        void kRaftMetadataCache_kraftVersionSupplier;
        Supplier<KRaftVersion> supplier = () -> KRaftVersion.LATEST_PRODUCTION;
        int kRaftMetadataCache_brokerId = 1;
        supplier = null;
        KRaftMetadataCache cache = new KRaftMetadataCache(kRaftMetadataCache_brokerId, (Supplier)kRaftMetadataCache_kraftVersionSupplier);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.latestProduction().featureLevel()));
        cache.setImage(delta.apply(MetadataProvenance.EMPTY));
        this.metadataCache = var1_3;
    }
}

