/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005=4AAC\u0006\u0001!!AQ\u0003\u0001B\u0001B\u0003%a\u0003C\u0003$\u0001\u0011\u0005A\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003R\u0001\u0011\u0005\u0001\u0006C\u0003W\u0001\u0011\u0005\u0001\u0006C\u0003Z\u0001\u0011\u0005\u0001\u0006C\u0003]\u0001\u0011\u0005\u0001\u0006C\u0003j\u0001\u0011\u0005\u0001\u0006C\u0003m\u0001\u0011\u0005\u0001F\u0001\fBa&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\f\u0013\t!2B\u0001\u0010BEN$(/Y2u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bCA\f\"\u001b\u0005A\"BA\r\u001b\u0003\u0011!Xm\u001d;\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u000f;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011QE\n\t\u0003%\u0001AQ!\u0006\u0002A\u0002Y\ta\u0003^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5uQ\u0019\u0019\u0001GN\u001cA\u0003B\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007G\u0001\u0004CBL\u0017BA\u001b3\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002\u000bQL\b/Z:-\u0005ajD%A\u001d\n\u0005iZ\u0014!B&S\u0003\u001a#&B\u0001\u001f3\u0003\u0011!\u0016\u0010]3%\u0003yJ!aP\u001e\u0002\u0011\r{ul\u0013*B\rR\u000b\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\u0005\tc5&B\"G\u000f&S\u0005CA\u0019E\u0013\t)%GA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170I\u0001I\u0003q)hn\u001d;bE2,g&\u00199j]Y,'o]5p]NtSM\\1cY\u0016\fQA^1mk\u0016\f\u0013aS\u0001\u0006M\u0006d7/Z\u0016\u0006\u0007\u001ak\u0015jT\u0011\u0002\u001d\u0006\u0001SO\\:uC\ndWM\f4fCR,(/\u001a\u0018wKJ\u001c\u0018n\u001c8t]\u0015t\u0017M\u00197fC\u0005\u0001\u0016\u0001\u0002;sk\u0016\fA\u0006^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f^%oG2,H-Z:V]J,G.Z1tK\u0012\f\u0005/[:)\r\u0011\u0001dg\u0015!UY\tAT\b\f\u0002V\u0019.*1IR$J\u001f\u0006yC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8fe\"\"Q\u0001\r\u001cYY\u0005A\u0014\u0001\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;XSRDWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ\u00111\u0001GN.-\u0005aj\u0014A\t;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;WC2LG-\u0019;j_:4\u0006\u0007\u000b\u0005\baYrv\f\u0019!hY\tAT(A\bnKR\fG-\u0019;b-\u0016\u00148/[8oI\u0005\t\u0017B\u00012d\u0003-I%\tU04?bz\u0016J\u0016\u0019\u000b\u0005\u0011,\u0017aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u000b\u0005m1'B\u0001\u0007\u001dY\t\u0011\u0005nK\u0003D\r6K%*A\u001euKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tg\u000b\r+ie>,x\r[\"p]R\u0014x\u000e\u001c7fe2K7\u000f^3oKJDC\u0001\u0003\u00197W2\n\u0001(\u0001\u0012uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tgk\r\u0015\u0005\u0013A2d\u000e\f\u00029{\u0001")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="true")})
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3(), this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="true")})
    public void testApiVersionsRequestIncludesUnreleasedApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        boolean x$4 = this.validateApiVersionsResponse$default$4();
        short x$5 = this.validateApiVersionsResponse$default$5();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, true, x$4, x$5);
    }

    @ClusterTest(types={Type.KRAFT})
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, (ListenerName)this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, (ListenerName)this.cluster.controllerListenerName().get(), true, this.validateApiVersionsResponse$default$4(), this.validateApiVersionsResponse$default$5());
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT}, metadataVersion=MetadataVersion.IBP_3_8_IV0, serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="false"), @ClusterConfigProperty(key="unstable.feature.versions.enable", value="false")})
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        boolean x$3 = !"false".equals(this.cluster.config().serverProperties().get("unstable.api.versions.enable"));
        ListenerName x$4 = this.validateApiVersionsResponse$default$2();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$4, x$3, x$5, (short)0);
    }

    @ClusterTest(types={Type.KRAFT})
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (ListenerName)this.cluster.controllerListenerName().get());
        ListenerName x$2 = (ListenerName)this.cluster.controllerListenerName().get();
        boolean x$5 = this.validateApiVersionsResponse$default$4();
        this.validateApiVersionsResponse(apiVersionsResponse, x$2, true, x$5, (short)0);
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

