/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.server.BrokerLifecycleManager;
import kafka.server.BrokerLifecycleManager$;
import kafka.server.RegistrationTestContext;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@Timeout(value=12L)
@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001A\u0002\u0013%1\u0005C\u0004(\u0001\u0001\u0007I\u0011\u0002\u0015\t\r9\u0002\u0001\u0015)\u0003%\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015A\u0005\u0001\"\u00011\u0011\u0015i\u0005\u0001\"\u00011\u0011\u0015y\u0005\u0001\"\u00011\u0011\u0015\t\u0006\u0001\"\u00011\u0011\u0015\u0019\u0006\u0001\"\u00011\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0019\t\u0019\u0002\u0001C\u0001a!1\u0011q\u0003\u0001\u0005\u0002ABa!a\u0007\u0001\t\u0003\u0001$A\u0007\"s_.,'\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:UKN$(BA\n\u0015\u0003\u0019\u0019XM\u001d<fe*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002%\u00059Q.\u00198bO\u0016\u0014X#\u0001\u0013\u0011\u0005\u0005*\u0013B\u0001\u0014\u0013\u0005Y\u0011%o\\6fe2Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018aC7b]\u0006<WM]0%KF$\"!\u000b\u0017\u0011\u0005eQ\u0013BA\u0016\u001b\u0005\u0011)f.\u001b;\t\u000f5\u001a\u0011\u0011!a\u0001I\u0005\u0019\u0001\u0010J\u0019\u0002\u00115\fg.Y4fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002S!\u0012QA\r\t\u0003gqj\u0011\u0001\u000e\u0006\u0003kY\n1!\u00199j\u0015\t9\u0004(A\u0004kkBLG/\u001a:\u000b\u0005eR\u0014!\u00026v]&$(\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>i\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0011G>tg-[4Qe>\u0004XM\u001d;jKN,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA!\u001e;jY*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005)\u0001&o\u001c9feRLWm]\u0001\u0013i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3DY>\u001cX\r\u000b\u0002\b\u0015B\u00111gS\u0005\u0003\u0019R\u0012A\u0001V3ti\u00069B/Z:u\u0007J,\u0017\r^3Ti\u0006\u0014H/\u00118e\u00072|7/\u001a\u0015\u0003\u0011)\u000b!\u0004^3tiN+8mY3tg\u001a,HNU3hSN$(/\u0019;j_:D#!\u0003&\u0002/Q,7\u000f\u001e*fO&\u001cHO]1uS>tG+[7f_V$\bF\u0001\u0006K\u0003Y!Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007FA\u0006K\u0003=\u0001(/\u001a9be\u0016\u0014Vm\u001d9p]N,WCA,a)\rA\u0016O\u001e\t\u00043rsV\"\u0001.\u000b\u0005m\u0013\u0015AC2p]\u000e,(O]3oi&\u0011QL\u0017\u0002\u0007\rV$XO]3\u0011\u0005}\u0003G\u0002\u0001\u0003\u0006C2\u0011\rA\u0019\u0002\u0002)F\u00111M\u001a\t\u00033\u0011L!!\u001a\u000e\u0003\u000f9{G\u000f[5oOB\u0011qm\\\u0007\u0002Q*\u0011\u0011N[\u0001\te\u0016\fX/Z:ug*\u00111\u000e\\\u0001\u0007G>lWn\u001c8\u000b\u0005Ui'B\u00018;\u0003\u0019\t\u0007/Y2iK&\u0011\u0001\u000f\u001b\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\")!\u000f\u0004a\u0001g\u0006\u00191\r\u001e=\u0011\u0005\u0005\"\u0018BA;\u0013\u0005]\u0011VmZ5tiJ\fG/[8o)\u0016\u001cHoQ8oi\u0016DH\u000fC\u0003x\u0019\u0001\u0007\u00010\u0001\u0005sKN\u0004xN\\:f!\t9\u00170\u0003\u0002{Q\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0005a>dG.\u0006\u0002~\u007fR9a0!\u0003\u0002\f\u00055\u0001CA0\u0000\t\u0019\tWB1\u0001\u0002\u0002E\u00191-a\u0001\u0011\u0007e\t)!C\u0002\u0002\bi\u00111!\u00118z\u0011\u0015\u0011X\u00021\u0001t\u0011\u0015\u0011S\u00021\u0001%\u0011\u001d\ty!\u0004a\u0001\u0003#\taAZ;ukJ,\u0007cA-]}\u0006)C/Z:u\u00032<\u0018-_:TK:$7/Q2dk6,H.\u0019;fI>3g\r\\5oK\u0012K'o\u001d\u0015\u0003\u001d)\u000bA\u0004^3tiJ+w-[:ue\u0006$\u0018n\u001c8J]\u000edW\u000fZ3t\t&\u00148\u000f\u000b\u0002\u0010\u0015\u00069C/Z:u\u0017J\fg\r\u001e&C\u001f\u0012kU\r^1eCR\fg+\u001a:tS>tW\u000b\u001d3bi\u0016,e/\u001a8uQ\t\u0001\"\nK\u0004\u0001\u0003C\t9#!\u000b\u0011\u0007M\n\u0019#C\u0002\u0002&Q\u0012q\u0001V5nK>,H/A\u0003wC2,XMH\u0001\r\u0001")
public class BrokerLifecycleManagerTest {
    private BrokerLifecycleManager manager = null;

    private BrokerLifecycleManager manager() {
        return this.manager;
    }

    private void manager_$eq(BrokerLifecycleManager x$1) {
        this.manager = x$1;
    }

    @AfterEach
    public void tearDown() {
        if (this.manager() != null) {
            this.manager().close();
            return;
        }
    }

    public Properties configProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("node.id", "1");
        properties.setProperty("controller.quorum.voters", "2@localhost:9093");
        properties.setProperty("controller.listener.names", "SSL");
        properties.setProperty("initial.broker.registration.timeout.ms", "300000");
        properties.setProperty("broker.heartbeat.interval.ms", "100");
        return properties;
    }

    @Test
    public void testCreateAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"oFoTeS9QT0aAyCyH41v45A")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        this.manager().close();
    }

    @Test
    public void testCreateStartAndClose() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "create-start-and-close-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"uiUADXZWTPixVvp6UWFWnw")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Assertions.assertEquals((Object)BrokerState.NOT_RUNNING, (Object)this.manager().state());
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testCreateStartAndClose$2(this);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var9_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var2_3 = null;
        Object var5_4 = null;
        Object var8_7 = null;
        this.manager().close();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)this.manager().state());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulRegistration() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "successful-registration-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var17_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var6_5 = null;
        Object var9_9 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        long l2 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testSuccessfulRegistration$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var18_15 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegistrationTimeout() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        Node controllerNode = new Node(3000, "localhost", 8021);
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "registration-timeout-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"9XBOAtr4T0Wbx2sbiWh6xg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        context.controllerNodeProvider().node().set(controllerNode);
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        Assertions.assertEquals((int)1, (int)context.mockClient().futureResponses().size());
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$2(context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var24_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var6_5 = null;
        Object var9_9 = null;
        BrokerLifecycleManagerTest.newDuplicateRegistrationResponse$1(context, controllerNode);
        long l2 = 60000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var25_16 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        Object var10_11 = null;
        Object var13_12 = null;
        Object var16_15 = null;
        context.time().sleep(300000L);
        long l3 = 60000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testRegistrationTimeout$4(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait3);
                    Object var26_22 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        RegistrationTestContext context = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(context.config(), (Time)context.time(), "controlled-shutdown-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"B4RtUz1ySGip3A7ZFYB2dg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        context.controllerNodeProvider().node().set(controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)), controllerNode);
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsCaughtUp(true)), controllerNode);
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> context.highestMetadataOffset().get(), (NodeToControllerChannelManager)context.mockChannelManager(), context.clusterId(), context.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$2(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var31_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var3_4 = null;
        Object var6_5 = null;
        Object var9_8 = null;
        context.mockClient().prepareResponseFrom((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setIsFenced(false)), controllerNode);
        context.time().sleep(20L);
        long l2 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$3(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var32_14 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        Object var10_11 = null;
        Object var13_12 = null;
        Object var16_16 = null;
        this.manager().beginControlledShutdown();
        long l3 = 10000L;
        TestUtils$ retry_this3 = TestUtils$.MODULE$;
        LongRef retry_wait3 = LongRef.create((long)1L);
        long retry_startTime3 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$4(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this3.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait3);
                    Object var33_21 = null;
                    retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait3.elem);
                retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                continue;
            }
            break;
        }
        Object var17_18 = null;
        Object var20_19 = null;
        Object var23_23 = null;
        context.mockClient().respond(body -> {
            if (body instanceof BrokerHeartbeatRequest) {
                Assertions.assertTrue((boolean)((BrokerHeartbeatRequest)body).data().wantShutDown());
                return true;
            }
            return false;
        }, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setShouldShutDown(true)));
        long l4 = 10000L;
        TestUtils$ retry_this4 = TestUtils$.MODULE$;
        LongRef retry_wait4 = LongRef.create((long)1L);
        long retry_startTime4 = System.currentTimeMillis();
        while (true) {
            try {
                BrokerLifecycleManagerTest.$anonfun$testControlledShutdown$6(this, context);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime4 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this4.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait4);
                    Object var34_30 = null;
                    retry_this4.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this4, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait4.elem);
                retry_wait4.elem += package$.MODULE$.min(retry_wait4.elem, 1000L);
                continue;
            }
            break;
        }
        Object var24_25 = null;
        Object var27_26 = null;
        Object var30_29 = null;
        this.manager().controlledShutdownFuture().get();
    }

    public <T extends AbstractRequest> Future<T> prepareResponse(RegistrationTestContext ctx, AbstractResponse response) {
        CompletableFuture result = new CompletableFuture();
        ctx.mockClient().prepareResponseFrom(body -> result.complete(body), response, ctx.controllerNodeProvider().node().get());
        return result;
    }

    public <T> T poll(RegistrationTestContext ctx, BrokerLifecycleManager manager, Future<T> future) {
        while (ctx.mockChannelManager().unsentQueue().isEmpty()) {
            manager.eventQueue().cancelDeferred("initialRegistrationTimeout");
            if (manager.eventQueue().firstDeferredIfIdling().isPresent()) {
                ctx.time().sleep(5L);
            }
            manager.eventQueue().wakeup();
        }
        while (!future.isDone()) {
            ctx.poll();
        }
        return future.get();
    }

    @Test
    public void testAlwaysSendsAccumulatedOfflineDirs() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "offline-dirs-sent-in-heartbeat-", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"0IbF1sjhSGG6FNvnrPbqQg")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        this.poll(ctx, this.manager(), registration);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)this.nextHeartbeatDirs$1(ctx));
        this.manager().propagateDirectoryFailure(Uuid.fromString((String)"h3sC4Yk-Q9-fd0ntJTocCA"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA"})), (Object)this.nextHeartbeatDirs$1(ctx));
        this.manager().propagateDirectoryFailure(Uuid.fromString((String)"ej8Q9_d2Ri6FXNiTxKFiow"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow"})), (Object)this.nextHeartbeatDirs$1(ctx));
        this.manager().propagateDirectoryFailure(Uuid.fromString((String)"1iF76HVNRPqC7Y4r6647eg"), Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h3sC4Yk-Q9-fd0ntJTocCA", "ej8Q9_d2Ri6FXNiTxKFiow", "1iF76HVNRPqC7Y4r6647eg"})), (Object)this.nextHeartbeatDirs$1(ctx));
    }

    @Test
    public void testRegistrationIncludesDirs() {
        Set logDirs = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ad5FLIeCTnaQdai5vOjeng", "ybdzUKmYSLK6oiIpI6CPlw"}))).map((Function1 & Serializable)x$1 -> Uuid.fromString((String)x$1));
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "registration-includes-dirs-", false, logDirs, BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        Future registration = this.prepareResponse(ctx, (AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(1000L)));
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.empty());
        BrokerRegistrationRequest request = (BrokerRegistrationRequest)this.poll(ctx, this.manager(), registration);
        Assertions.assertEquals((Object)logDirs, (Object)CollectionConverters$.MODULE$.ListHasAsScala(request.data().logDirs()).asScala().toSet());
    }

    @Test
    public void testKraftJBODMetadataVersionUpdateEvent() {
        RegistrationTestContext ctx = new RegistrationTestContext(this.configProperties());
        this.manager_$eq(new BrokerLifecycleManager(ctx.config(), (Time)ctx.time(), "jbod-metadata-version-update", false, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.fromString((String)"gCpDJgRlS2CBCpxoP2VMsQ")})), BrokerLifecycleManager$.MODULE$.$lessinit$greater$default$6()));
        Node controllerNode = new Node(3000, "localhost", 8021);
        ctx.controllerNodeProvider().node().set(controllerNode);
        this.manager().start((Function0)(JFunction0.mcJ.sp & Serializable)() -> ctx.highestMetadataOffset().get(), (NodeToControllerChannelManager)ctx.mockChannelManager(), ctx.clusterId(), ctx.advertisedListeners(), Collections.emptyMap(), OptionalLong.of(10L));
        Assertions.assertEquals((long)10L, (long)this.nextRegistrationRequest$1(1000L, ctx).data().previousBrokerEpoch());
        this.nextHeartbeatRequest$1(ctx);
        Assertions.assertEquals((long)1000L, (long)this.manager().brokerEpoch());
        this.manager().resendBrokerRegistrationUnlessZkMode();
        this.nextRegistrationRequest$1(1200L, ctx);
        this.nextHeartbeatRequest$1(ctx);
        Assertions.assertEquals((long)1200L, (long)this.manager().brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testCreateStartAndClose$2(BrokerLifecycleManagerTest $this) {
        Assertions.assertEquals((Object)BrokerState.STARTING, (Object)$this.manager().state());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$2(RegistrationTestContext context$2) {
        Assertions.assertEquals((int)1, (int)context$2.mockChannelManager().unsentQueue().size());
        Assertions.assertEquals((long)10L, (long)((BrokerRegistrationRequest)context$2.mockChannelManager().unsentQueue().getFirst().request().build()).data().previousBrokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulRegistration$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$2) {
        context$2.poll();
        Assertions.assertEquals((long)1000L, (long)$this.manager().brokerEpoch());
    }

    private static final void newDuplicateRegistrationResponse$1(RegistrationTestContext context$3, Node controllerNode$1) {
        context$3.mockClient().prepareResponseFrom((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setErrorCode(Errors.DUPLICATE_BROKER_REGISTRATION.code())), controllerNode$1);
        context$3.mockChannelManager().poll();
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$2(RegistrationTestContext context$3) {
        context$3.poll();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$3) {
        context$3.time().sleep(100L);
        context$3.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((int)0, (int)context$3.mockClient().futureResponses().size());
    }

    public static final /* synthetic */ void $anonfun$testRegistrationTimeout$4(BrokerLifecycleManagerTest $this, RegistrationTestContext context$3) {
        context$3.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)$this.manager().state());
        Assertions.assertTrue((boolean)$this.manager().initialCatchUpFuture().isCompletedExceptionally());
        Assertions.assertEquals((long)-1L, (long)$this.manager().brokerEpoch());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$2(BrokerLifecycleManagerTest $this, RegistrationTestContext context$4) {
        context$4.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RECOVERY, (Object)$this.manager().state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$3(BrokerLifecycleManagerTest $this, RegistrationTestContext context$4) {
        context$4.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.manager().state());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$4(BrokerLifecycleManagerTest $this, RegistrationTestContext context$4) {
        context$4.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.PENDING_CONTROLLED_SHUTDOWN, (Object)$this.manager().state());
        Assertions.assertTrue((boolean)context$4.mockClient().hasInFlightRequests());
    }

    public static final /* synthetic */ void $anonfun$testControlledShutdown$6(BrokerLifecycleManagerTest $this, RegistrationTestContext context$4) {
        context$4.poll();
        $this.manager().eventQueue().wakeup();
        Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)$this.manager().state());
    }

    private final Set nextHeartbeatDirs$1(RegistrationTestContext ctx$1) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((BrokerHeartbeatRequest)this.poll(ctx$1, this.manager(), this.prepareResponse(ctx$1, (AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData())))).data().offlineLogDirs()).asScala().map((Function1 & Serializable)x$1 -> x$1.toString())).toSet();
    }

    private final AbstractRequest doPoll$1(AbstractResponse response, RegistrationTestContext ctx$3) {
        return (AbstractRequest)this.poll(ctx$3, this.manager(), this.prepareResponse(ctx$3, response));
    }

    private final AbstractRequest nextHeartbeatRequest$1(RegistrationTestContext ctx$3) {
        return this.doPoll$1((AbstractResponse)new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData()), ctx$3);
    }

    private final BrokerRegistrationRequest nextRegistrationRequest$1(long epoch, RegistrationTestContext ctx$3) {
        return (BrokerRegistrationRequest)this.doPoll$1((AbstractResponse)new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setBrokerEpoch(epoch)), ctx$3);
    }
}

